/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.api.sql.execute;

import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteLogger;
import org.netbeans.modules.db.api.sql.execute.SQLExecutor;
import org.netbeans.modules.db.api.sql.execute.StatementExecutionInfo;
import org.netbeans.modules.db.sql.loader.SQLEditorSupport;
import org.openide.util.NbBundle;

public class LogFileLogger
implements SQLExecuteLogger {
    private static Logger LOGGER = Logger.getLogger(LogFileLogger.class.getName());
    private int errorCount;

    public void log(StatementExecutionInfo statementExecutionInfo) {
        if (statementExecutionInfo.hasExceptions()) {
            this.logException(statementExecutionInfo);
        }
    }

    public void finish(long l) {
        LOGGER.log(Level.INFO, NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionFinished", (Object)String.valueOf(this.millisecondsToSeconds(l)), (Object)String.valueOf(this.errorCount)));
    }

    public void cancel() {
        LOGGER.log(Level.INFO, NbBundle.getMessage(SQLEditorSupport.class, (String)"LBL_ExecutionCancelled"));
    }

    private void logException(StatementExecutionInfo statementExecutionInfo) {
        ++this.errorCount;
        for (Throwable throwable : statementExecutionInfo.getExceptions()) {
            if (throwable instanceof SQLException) {
                this.logSQLException((SQLException)throwable, statementExecutionInfo);
                continue;
            }
            LOGGER.log(Level.INFO, NbBundle.getMessage(SQLExecutor.class, (String)"MSG_SQLExecutionException", (Object)statementExecutionInfo.getSQL()), throwable);
        }
    }

    private void logSQLException(SQLException sQLException, StatementExecutionInfo statementExecutionInfo) {
        while (sQLException != null) {
            LOGGER.log(Level.INFO, NbBundle.getMessage(SQLExecutor.class, (String)"MSG_SQLExecutionException", (Object)statementExecutionInfo.getSQL()), sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    private String millisecondsToSeconds(long l) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        return numberFormat.format((double)l / 1000.0);
    }
}

