/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf.embedding;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.gsf.api.CssEmbeddingModelUtils;
import org.netbeans.modules.css.parser.CssParserAccess;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.html.editor.gsf.embedding.CssModel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssTemplatedModel
extends CssModel {
    private static final Logger LOGGER = Logger.getLogger(CssTemplatedModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private CssParserAccess.CssParserResult cachedParserResult = null;

    public static CssTemplatedModel get(Document document) {
        CssTemplatedModel cssTemplatedModel = (CssTemplatedModel)document.getProperty(CssTemplatedModel.class);
        if (cssTemplatedModel == null) {
            cssTemplatedModel = new CssTemplatedModel(document);
            document.putProperty(CssTemplatedModel.class, cssTemplatedModel);
        }
        return cssTemplatedModel;
    }

    private CssTemplatedModel(Document document) {
        super(document);
    }

    public CssParserAccess.CssParserResult getCachedParserResult() {
        if (!this.documentDirty) {
            return this.cachedParserResult;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCode() {
        if (this.documentDirty) {
            this.cachedParserResult = null;
            long l = System.currentTimeMillis();
            this.documentDirty = false;
            this.codeBlocks.clear();
            StringBuilder stringBuilder = new StringBuilder();
            BaseDocument baseDocument = (BaseDocument)this.doc;
            try {
                baseDocument.readLock();
                ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
                this.extractCssFromTemplatedHTML(this.doc, stringBuilder, arrayList);
                if (arrayList.isEmpty()) {
                    this.code = stringBuilder.toString();
                    LOGGER.log(Level.FINE, "NO REPLACED TEMPLATING!");
                    String string = this.code;
                    return string;
                }
                Boolean bl = (Boolean)this.doc.getProperty("sanitize_source");
                if (bl != null && !bl.booleanValue()) {
                    this.code = stringBuilder.toString();
                    LOGGER.log(Level.FINE, "SANITIZING DISABLED!");
                    LOGGER.log(Level.FINE, this.dumpCode());
                    String string = this.code;
                    return string;
                }
                if (LOG) {
                    this.code = stringBuilder.toString();
                    LOGGER.log(Level.FINE, "BEFORE SANITIZING");
                    LOGGER.log(Level.FINE, this.dumpCode());
                }
                long l2 = System.currentTimeMillis();
                this.sanitizeCode(stringBuilder, arrayList);
                this.code = stringBuilder.toString();
                if (LOG) {
                    LOGGER.log(Level.FINE, "AFTER SANITIZING");
                    LOGGER.log(Level.FINE, this.dumpCode());
                }
                if (LOG) {
                    LOGGER.log(Level.FINE, "CSS source generation took " + (l2 - l) + " ms.");
                    LOGGER.log(Level.FINE, "CSS source validation took " + (System.currentTimeMillis() - l2) + " ms.");
                }
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        return this.code;
    }

    private void sanitizeCode(final StringBuilder stringBuilder, final List<OffsetRange> list) {
        DataObject dataObject;
        int n;
        final boolean[] blArray = new boolean[1];
        final boolean[] blArray2 = new boolean[1];
        NodeVisitor nodeVisitor = new NodeVisitor(){

            public void visit(SimpleNode simpleNode) {
                if (simpleNode.kind() == 38 || simpleNode.kind() == 39) {
                    int n;
                    int n2;
                    SimpleNode simpleNode2 = (SimpleNode)simpleNode.jjtGetParent();
                    LOGGER.log(Level.FINE, "Tree Error  on " + simpleNode + "; parent: " + simpleNode2);
                    if (simpleNode2.kind() == 28) {
                        int n3;
                        boolean bl = false;
                        SimpleNode simpleNode3 = SimpleNodeUtil.getSibling((SimpleNode)simpleNode2, (boolean)true);
                        if (simpleNode3 != null && simpleNode3.kind() == 28) {
                            bl = CssTemplatedModel.this.containsGeneratedCode(simpleNode3, stringBuilder);
                            n2 = stringBuilder.substring(simpleNode3.endOffset(), simpleNode2.startOffset()).lastIndexOf(59);
                            n3 = 1;
                            if (n2 > -1) {
                                n3 = 0;
                                if (stringBuilder.substring(simpleNode3.endOffset() + n2 - CssEmbeddingModelUtils.getGeneratedCodeIdentifier().length() + 1, simpleNode3.endOffset() + n2 + 1).equals(CssEmbeddingModelUtils.getGeneratedCodeIdentifier())) {
                                    n3 = 1;
                                }
                            }
                            if (n3 != 0 && bl && simpleNode3.image().contains(":") && simpleNode2.image().contains(";")) {
                                CssTemplatedModel.this.clear(stringBuilder, simpleNode3.endOffset(), simpleNode3.endOffset() + 1);
                                blArray[0] = true;
                                return;
                            }
                        }
                        n2 = 0;
                        n3 = simpleNode2.endOffset();
                        while (n3 < stringBuilder.length()) {
                            if ((n = stringBuilder.charAt(n3++)) == 58) {
                                n2 = 1;
                                break;
                            }
                            if (Character.isWhitespace((char)n)) continue;
                        }
                        if (n2 != 0) {
                            CssTemplatedModel.this.clear(stringBuilder, simpleNode2.endOffset() - 1, simpleNode2.endOffset());
                            blArray[0] = true;
                            blArray2[0] = true;
                        } else if (CssTemplatedModel.this.clearNode(simpleNode2, stringBuilder, 0, 0, list, bl, false)) {
                            blArray[0] = true;
                        }
                    }
                    if (simpleNode2.kind() == 18) {
                        if (blArray2[0]) {
                            blArray2[0] = false;
                            return;
                        }
                        SimpleNode simpleNode4 = SimpleNodeUtil.getSibling((SimpleNode)simpleNode, (boolean)true);
                        if (simpleNode4.kind() == 35) {
                            if ((simpleNode4 = SimpleNodeUtil.getSibling((SimpleNode)simpleNode4, (boolean)true)).kind() == 28) {
                                boolean bl = CssTemplatedModel.this.clearNode(simpleNode4, stringBuilder, 0, 0, list, false, false);
                                if (bl) {
                                    CssTemplatedModel.this.clearNode(simpleNode, stringBuilder, 0, -1, list, true, false);
                                    blArray[0] = true;
                                }
                            } else if (simpleNode4.kind() == 19) {
                                int n4 = simpleNode4.startOffset();
                                n2 = stringBuilder.indexOf("{", n4);
                                if (n2 == -1) {
                                    return;
                                }
                                String string = stringBuilder.substring(n4, n2);
                                n = string.indexOf(CssEmbeddingModelUtils.getGeneratedCodeIdentifier());
                                if (n >= 0) {
                                    StringBuilder stringBuilder2 = new StringBuilder(string);
                                    String string2 = stringBuilder2.toString().replace(';', 'E');
                                    CssTemplatedModel.this.clearAndWrite(stringBuilder, n4, n2, string2);
                                    blArray[0] = true;
                                }
                            }
                        }
                    }
                }
            }
        };
        long l = System.currentTimeMillis();
        for (n = 0; n < 4; ++n) {
            blArray[0] = false;
            CssParserAccess cssParserAccess = CssParserAccess.getDefault();
            CssParserAccess.CssParserResult cssParserResult = cssParserAccess.parse((Reader)new StringReader(stringBuilder.toString()));
            dataObject = cssParserResult.root();
            if (dataObject == null) {
                return;
            }
            if (LOG) {
                LOGGER.fine("> SANITIZING LEVEL #" + n + " >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                LOGGER.fine(stringBuilder.toString());
                LOGGER.fine("------------------------");
                LOGGER.fine(dataObject.dump(""));
                LOGGER.fine("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            }
            dataObject.visitChildren(nodeVisitor);
            if (blArray[0]) continue;
            this.cachedParserResult = cssParserResult;
            break;
        }
        if (blArray[0]) {
            LOGGER.warning("CSS source sanitization didn't success even after four passes!");
        }
        long l2 = System.currentTimeMillis();
        dataObject = (DataObject)this.doc.getProperty("stream");
        FileObject fileObject = null;
        if (dataObject != null) {
            fileObject = dataObject.getPrimaryFile();
        }
        Logger.getLogger("TIMER").log(Level.FINE, "CSS Sanitizing [" + n + "]", new Object[]{fileObject, l2 - l});
    }

    private boolean clearNode(SimpleNode simpleNode, StringBuilder stringBuilder, int n, int n2, List<OffsetRange> list, boolean bl, boolean bl2) {
        int n3;
        int n4 = simpleNode.startOffset();
        if (n4 >= (n3 = simpleNode.endOffset())) {
            System.err.println("clearNode from >= to! node: " + simpleNode);
            return false;
        }
        if (bl2) {
            char c;
            int n5;
            int n6;
            for (n6 = n4; n6 >= 0 && (n5 = (int)stringBuilder.charAt(n6)) != 10; --n6) {
            }
            for (n5 = n3; n5 < stringBuilder.length() && (c = stringBuilder.charAt(n5)) != '\n'; ++n5) {
            }
            n4 = n6;
            n3 = n5;
        }
        if ((n4 += n) >= (n3 += n2)) {
            System.err.println("clearNode from+startDelta >= to+endDelta! node: " + simpleNode);
            return false;
        }
        if (bl || this.containsGeneratedCode(simpleNode, stringBuilder)) {
            LOGGER.log(Level.FINE, "CLEARING NODE " + simpleNode + " [" + stringBuilder.substring(n4, n3) + "]");
            this.clear(stringBuilder, n4, n3);
            return true;
        }
        return false;
    }

    private boolean containsGeneratedCode(SimpleNode simpleNode, StringBuilder stringBuilder) {
        int n = simpleNode.startOffset();
        int n2 = simpleNode.endOffset();
        return CssEmbeddingModelUtils.containsGeneratedCode((String)stringBuilder.substring(n, n2));
    }

    private void clear(StringBuilder stringBuilder, int n, int n2) {
        assert (n < n2);
        for (int i = n; i < n2; ++i) {
            stringBuilder.setCharAt(i, ' ');
        }
    }

    private void clearAndWrite(StringBuilder stringBuilder, int n, int n2, String string) {
        LOGGER.log(Level.FINE, "CLEARING&&REPLACING [" + stringBuilder.substring(n, n2) + "]: " + string);
        this.clear(stringBuilder, n, n2);
        stringBuilder.replace(n, n + string.length(), string);
    }

    private LanguagePath findHtmlPath(TokenHierarchy tokenHierarchy) {
        Set set = tokenHierarchy.languagePaths();
        for (LanguagePath languagePath : set) {
            if (languagePath.innerLanguage() != HTMLTokenId.language()) continue;
            return languagePath;
        }
        return null;
    }

    private void extractCssFromTemplatedHTML(Document document, StringBuilder stringBuilder, List<OffsetRange> list) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(6);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        LanguagePath languagePath = this.findHtmlPath(tokenHierarchy);
        if (languagePath == null) {
            return;
        }
        List list2 = tokenHierarchy.tokenSequenceList(languagePath, 0, Integer.MAX_VALUE);
        TokenSequence tokenSequence = null;
        for (TokenSequence tokenSequence2 : list2) {
            tokenSequence2.moveStart();
            if (!tokenSequence2.moveNext()) continue;
            if (tokenSequence != null && (hashMap.get("in_style") != null || hashMap.get("in_inlined_style") != null)) {
                int n = tokenSequence.offset() + tokenSequence.token().length();
                int n2 = tokenSequence2.offset();
                int n3 = stringBuilder.length();
                stringBuilder.append(CssEmbeddingModelUtils.getGeneratedCodeIdentifier());
                int n4 = stringBuilder.length();
                list.add(new OffsetRange(n3, n4));
                CssModel.CodeBlockData codeBlockData = new CssModel.CodeBlockData(n, n2, n3, n4);
                this.codeBlocks.add(codeBlockData);
            }
            tokenSequence2.moveStart();
            this.extractCssFromHTML((TokenSequence<HTMLTokenId>)tokenSequence2, stringBuilder, hashMap);
            tokenSequence = tokenSequence2;
        }
    }
}

