/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.html.editor.gsf.HtmlParserResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlSemanticAnalyzer
implements SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        this.cancelled = false;
        if (this.cancelled) {
            return;
        }
        HashMap<OffsetRange, Set<ColoringAttributes>> hashMap = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        Iterator iterator = compilationInfo.getEmbeddedResults("text/html").iterator();
        if (!iterator.hasNext()) {
            return;
        }
        ParserResult parserResult = (ParserResult)iterator.next();
        TranslatedSource translatedSource = parserResult.getTranslatedSource();
        HtmlParserResult htmlParserResult = (HtmlParserResult)parserResult;
        if (this.cancelled) {
            return;
        }
        Set<SyntaxElement.TagAttribute> set = htmlParserResult.elementsIds();
        for (SyntaxElement.TagAttribute tagAttribute : set) {
            int n = tagAttribute.getValueOffset();
            if (translatedSource != null && (n = translatedSource.getLexicalOffset(n)) == -1) {
                n = 0;
            }
            int n2 = n + tagAttribute.getValueLength();
            OffsetRange offsetRange = new OffsetRange(n, n2);
            hashMap.put(offsetRange, ColoringAttributes.METHOD_SET);
        }
        this.semanticHighlights = hashMap;
    }
}

