/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.SyntaxParser;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.PositionManager;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.spi.DefaultError;
import org.netbeans.modules.html.editor.NbReaderProvider;
import org.netbeans.modules.html.editor.gsf.AstUtils;
import org.netbeans.modules.html.editor.gsf.HtmlElementHandle;
import org.netbeans.modules.html.editor.gsf.HtmlParserResult;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HtmlGSFParser
implements Parser,
PositionManager {
    private static final Logger TIMERS = Logger.getLogger("TIMER.j2ee.parser");
    private static final Logger LOGGER = Logger.getLogger(HtmlGSFParser.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);

    public HtmlGSFParser() {
        NbReaderProvider.setupReaders();
    }

    public void parseFiles(Parser.Job job) {
        for (ParserFile parserFile : job.files) {
            HtmlParserResult htmlParserResult;
            try {
                Object object;
                SyntaxElement syntaxElement2;
                ParseEvent parseEvent = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, null);
                job.listener.started(parseEvent);
                htmlParserResult = null;
                CharSequence charSequence = job.reader.read(parserFile);
                if (charSequence == null) {
                    LOGGER.info("Job.reader.read(file) returned null for file " + parserFile.getFile().getAbsolutePath());
                    charSequence = "";
                }
                List list = SyntaxParser.parseImmutableSource((CharSequence)charSequence);
                if (LOG) {
                    for (SyntaxElement syntaxElement2 : list) {
                        LOGGER.log(Level.FINE, syntaxElement2.toString());
                    }
                }
                htmlParserResult = new HtmlParserResult(this, parserFile, list);
                if (TIMERS.isLoggable(Level.FINE)) {
                    object = new LogRecord(Level.FINE, "HTML parse result");
                    ((LogRecord)object).setParameters(new Object[]{htmlParserResult});
                    TIMERS.log((LogRecord)object);
                }
                object = htmlParserResult.dtd();
                AstNodeUtils.visitChildren((AstNode)htmlParserResult.root(), (AstNodeVisitor)new AstNodeVisitor((DTD)object, parserFile, job){
                    final /* synthetic */ DTD val$dtd;
                    final /* synthetic */ ParserFile val$file;
                    final /* synthetic */ Parser.Job val$job;
                    {
                        this.val$dtd = dTD;
                        this.val$file = parserFile;
                        this.val$job = job;
                    }

                    public void visit(AstNode astNode) {
                        if (astNode.type() == AstNode.NodeType.UNMATCHED_TAG) {
                            DTD.Element element;
                            AstNode astNode2 = (AstNode)astNode.children().get(0);
                            if (this.val$dtd != null && (element = this.val$dtd.getElement(astNode.name().toUpperCase())) != null && (astNode2.type() == AstNode.NodeType.OPEN_TAG && element.hasOptionalEnd() || astNode2.type() == AstNode.NodeType.ENDTAG && element.hasOptionalStart())) {
                                return;
                            }
                            element = new DefaultError("unmatched_tag", NbBundle.getMessage(this.getClass(), (String)"MSG_Unmatched_Tag"), null, this.val$file.getFileObject(), astNode.startOffset(), astNode.endOffset(), Severity.WARNING);
                            this.val$job.listener.error((Error)element);
                        }
                    }
                });
                syntaxElement2 = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, (ParserResult)htmlParserResult);
                job.listener.finished((ParseEvent)syntaxElement2);
            }
            catch (IOException iOException) {
                job.listener.exception((Exception)iOException);
                htmlParserResult = new HtmlParserResult(this, parserFile, Collections.<SyntaxElement>emptyList());
                job.listener.finished(new ParseEvent(ParseEvent.Kind.PARSE, parserFile, (ParserResult)htmlParserResult));
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public PositionManager getPositionManager() {
        return this;
    }

    public OffsetRange getOffsetRange(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        ElementHandle elementHandle2 = HtmlGSFParser.resolveHandle(compilationInfo, elementHandle);
        if (elementHandle2 instanceof HtmlElementHandle) {
            ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/html").iterator().next();
            TranslatedSource translatedSource = parserResult.getTranslatedSource();
            AstNode astNode = ((HtmlElementHandle)elementHandle2).node();
            return new OffsetRange(AstUtils.documentPosition(astNode.startOffset(), translatedSource), AstUtils.documentPosition(astNode.endOffset(), translatedSource));
        }
        throw new IllegalArgumentException("Foreign element: " + elementHandle2 + " of type " + (elementHandle2 != null ? elementHandle2.getClass().getName() : "null"));
    }

    public static ElementHandle resolveHandle(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        if (elementHandle instanceof HtmlElementHandle) {
            HtmlElementHandle htmlElementHandle = (HtmlElementHandle)elementHandle;
            AstNode astNode = htmlElementHandle.node();
            AstNode astNode2 = AstNodeUtils.getRoot((AstNode)astNode);
            HtmlParserResult htmlParserResult = (HtmlParserResult)compilationInfo.getEmbeddedResult("text/html", 0);
            AstNode astNode3 = htmlParserResult.root();
            if (astNode3 == null) {
                return null;
            }
            AstNode astNode4 = HtmlGSFParser.find(astNode2, astNode, astNode3);
            if (astNode4 != null) {
                return new HtmlElementHandle(astNode4, compilationInfo.getFileObject());
            }
        }
        return null;
    }

    private static AstNode find(AstNode astNode, AstNode astNode2, AstNode astNode3) {
        if (astNode == astNode2) {
            return astNode3;
        }
        List list = astNode.children();
        List list2 = astNode3.children();
        for (int i = 0; i < list.size(); ++i) {
            AstNode astNode4 = (AstNode)list.get(i);
            if (i == list2.size()) {
                return null;
            }
            AstNode astNode5 = (AstNode)list2.get(i);
            if (astNode4 == astNode2) {
                return astNode5;
            }
            AstNode astNode6 = HtmlGSFParser.find(astNode4, astNode2, astNode5);
            if (astNode6 == null) continue;
            return astNode6;
        }
        return null;
    }
}

