/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.dbmodel;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class IndexColumn
implements Comparable {
    private static final String RS_INDEX_NAME = "INDEX_NAME";
    private static final String RS_COLUMN_NAME = "COLUMN_NAME";
    private static final String RS_NON_UNIQUE = "NON_UNIQUE";
    private static final String RS_TYPE = "TYPE";
    private static final String RS_ORDINAL = "ORDINAL_POSITION";
    private static final String RS_ASC_OR_DESC = "ASC_OR_DESC";
    private static final String RS_CARDINALITY = "CARDINALITY";
    private String name;
    private String columnName;
    private int type;
    private int ordinalPosition;
    private boolean unique = false;
    private String sortSequence;
    private int cardinality;

    public static List createIndexList(ResultSet resultSet) throws SQLException {
        ArrayList<IndexColumn> arrayList = Collections.EMPTY_LIST;
        if (resultSet != null && resultSet.next()) {
            arrayList = new ArrayList<IndexColumn>();
            do {
                IndexColumn indexColumn;
                if ((indexColumn = new IndexColumn(resultSet)).getType() == 0) continue;
                arrayList.add(indexColumn);
            } while (resultSet.next());
        }
        return arrayList;
    }

    IndexColumn(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            Locale locale = Locale.getDefault();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com/stc/oracle/builder/Bundle", locale);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_VALID_RS") + "(ERROR_VALID_RS)");
        }
        this.name = resultSet.getString(RS_INDEX_NAME);
        this.columnName = resultSet.getString(RS_COLUMN_NAME);
        this.unique = !resultSet.getBoolean(RS_NON_UNIQUE);
        this.type = resultSet.getShort(RS_TYPE);
        this.ordinalPosition = resultSet.getShort(RS_ORDINAL);
        this.sortSequence = resultSet.getString(RS_ASC_OR_DESC);
        this.cardinality = resultSet.getInt(RS_CARDINALITY);
    }

    public IndexColumn(String string, String string2, short s, short s2, boolean bl, String string3, int n) {
        Locale locale = Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/stc/oracle/builder/Bundle", locale);
        if (string == null) {
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_PARAMETER_NAME") + "(ERROR_PARAMETER_NAME)");
        }
        if (s != 1 && s != 2 && s != 3) {
            throw new IllegalArgumentException(MessageFormat.format(resourceBundle.getString("ERROR_INDEX_TYPE"), new Integer(this.type)) + "(ERROR_INDEX_TYPE)");
        }
        this.name = string2;
        this.columnName = string;
        this.type = s;
        this.ordinalPosition = s2;
        this.unique = bl;
        this.sortSequence = string3;
        this.cardinality = n;
    }

    public IndexColumn(IndexColumn indexColumn) {
        Locale locale = Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com/stc/oracle/builder/Bundle", locale);
        if (indexColumn.getColumnName() == null) {
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_PARAMETER_NAME") + "(ERROR_PARAMETER_NAME)");
        }
        if (indexColumn.getType() != 1 && indexColumn.getType() != 2 && indexColumn.getType() != 3) {
            throw new IllegalArgumentException(MessageFormat.format(resourceBundle.getString("ERROR_INDEX_TYPE"), new Integer(this.type)) + "(ERROR_INDEX_TYPE)");
        }
        this.name = indexColumn.getIndexName();
        this.columnName = indexColumn.getColumnName();
        this.type = indexColumn.getType();
        this.ordinalPosition = indexColumn.getOrdinalPosition();
        this.unique = indexColumn.isUnique();
        this.sortSequence = indexColumn.getSortOrder();
        this.cardinality = indexColumn.getCardinality();
    }

    private IndexColumn() {
    }

    public String getIndexName() {
        return this.name;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getType() {
        return this.type;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getSortOrder() {
        return this.sortSequence;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        IndexColumn indexColumn = (IndexColumn)object;
        if (indexColumn != null) {
            if (this.name != null) {
                return indexColumn.name != null ? this.name.compareTo(indexColumn.name) : -1;
            }
            if (this.columnName != null) {
                return indexColumn.columnName != null ? this.columnName.compareTo(indexColumn.columnName) : -1;
            }
            return 0;
        }
        return -1;
    }
}

