/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSParameter;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapClientOperationInfo {
    private WsdlSaasMethod method;
    private String categoryName;
    private String serviceName;
    private String portName;
    private String operationName;
    private String wsdlUrl;
    private Project project;
    private WsdlData webServiceData;
    private WSService service;
    private WSOperation operation;
    private WSPort port;
    private List<ParameterInfo> headerParams = Collections.emptyList();

    public SoapClientOperationInfo(WsdlSaasMethod wsdlSaasMethod, Project project) {
        this.method = wsdlSaasMethod;
        this.categoryName = wsdlSaasMethod.getSaas().getParentGroup().getName();
        this.serviceName = wsdlSaasMethod.getSaas().getDefaultServiceName();
        this.project = project;
        this.method.getSaas().toStateReady(true);
        this.webServiceData = this.method.getSaas().getWsdlData();
        this.portName = this.method.getWsdlPort().getName();
        this.operationName = this.method.getWsdlOperation().getName();
        this.wsdlUrl = this.method.getSaas().getUrl();
        this.service = this.method.getSaas().getWsdlModel();
        this.port = this.method.getWsdlPort();
        this.operation = this.method.getWsdlOperation();
    }

    public Project getProject() {
        return this.project;
    }

    public WsdlSaasMethod getMethod() {
        return this.method;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getWsdlURL() {
        return this.wsdlUrl;
    }

    public String getWsdlLocation() {
        this.initWsdlModelInfo();
        return this.webServiceData.getWsdlFile();
    }

    public void initWsdlModelInfo() {
    }

    public static WSOperation findOperationByName(WSPort wSPort, String string) {
        for (WSOperation wSOperation : wSPort.getOperations()) {
            if (!string.equals(wSOperation.getName())) continue;
            return wSOperation;
        }
        return null;
    }

    public WSPort getPort() {
        this.initWsdlModelInfo();
        return this.port;
    }

    public WSOperation getOperation() {
        this.initWsdlModelInfo();
        return this.operation;
    }

    public WSService getService() {
        this.initWsdlModelInfo();
        return this.service;
    }

    public List<WSParameter> getOutputParameters() {
        ArrayList<WSParameter> arrayList = new ArrayList<WSParameter>();
        for (WSParameter wSParameter : this.getOperation().getParameters()) {
            if (!wSParameter.isHolder()) continue;
            arrayList.add(wSParameter);
        }
        return arrayList;
    }

    public static String getParamType(WSParameter wSParameter) {
        if (wSParameter.isHolder()) {
            String string = wSParameter.getTypeName();
            int n = string.indexOf(60);
            int n2 = string.indexOf(62);
            if (n > 0 || n2 > 0) {
                string = string.substring(n + 1, n2).trim();
            }
            return string;
        }
        return wSParameter.getTypeName();
    }

    public String getOutputType() {
        String string = this.getOperation().getReturnTypeName();
        if ("void".equals(string)) {
            for (WSParameter wSParameter : this.getOperation().getParameters()) {
                if (!wSParameter.isHolder()) continue;
                string = SoapClientOperationInfo.getParamType(wSParameter);
                break;
            }
        }
        return string;
    }

    public String[] getInputParameterNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WSParameter wSParameter : this.getOperation().getParameters()) {
            if (wSParameter.isHolder()) continue;
            arrayList.add(wSParameter.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getInputParameterTypes() {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (WSParameter wSParameter : this.getOperation().getParameters()) {
            if (wSParameter.isHolder()) continue;
            Class clazz = null;
            SoapClientOperationInfo soapClientOperationInfo = this;
            synchronized (soapClientOperationInfo) {
                try {
                    for (int i = 0; i < 60 && (clazz = this.getType(this.project, wSParameter.getTypeName())) == null; ++i) {
                        this.wait(2000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = Object.class;
            }
            arrayList.add(clazz);
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public Class getType(Project project, String string) {
        return Util.getType(project, string);
    }

    public boolean needsSoapHandler() {
        return this.getSoapHeaderParameters().size() > 0;
    }

    public List<ParameterInfo> getSoapHeaderParameters() {
        return this.headerParams;
    }

    public WSDLModel getXamWsdlModel() {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)new File(this.webServiceData.getWsdlFile()));
            return WSDLModelFactory.getDefault().getModel(Utilities.createModelSource((FileObject)fileObject, (boolean)true));
        }
        catch (CatalogModelException catalogModelException) {
            Logger.global.log(Level.INFO, "", catalogModelException);
            return null;
        }
    }

    public boolean isRPCEncoded() {
        WSDLModel wSDLModel = this.getXamWsdlModel();
        return Util.isRPCEncoded(wSDLModel);
    }
}

