/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.Location;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeanProperty;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringXMLConfigEditorUtils {
    public static final String BEAN_NAME_DELIMITERS = ",; ";

    private SpringXMLConfigEditorUtils() {
    }

    public static String getPNamespacePrefix(Document document, int n) {
        DocumentContext documentContext = DocumentContext.create(document, n);
        if (documentContext == null) {
            return null;
        }
        return documentContext.getNamespacePrefix("http://www.springframework.org/schema/p");
    }

    public static Map<String, String> getTagAttributes(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            hashMap.put(node2.getNodeName(), node2.getNodeValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static String getBeanPropertySetterName(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return "set" + String.valueOf(cArray);
    }

    public static String getBeanFactoryMethod(Tag tag) {
        NamedNodeMap namedNodeMap;
        Node node = SpringXMLConfigEditorUtils.getBean((Node)tag);
        if (node != null && (namedNodeMap = node.getAttributes()) != null && namedNodeMap.getNamedItem("factory-method") != null) {
            return namedNodeMap.getNamedItem("factory-method").getNodeValue();
        }
        return null;
    }

    public static Node getBean(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeName().equals("bean")) {
            return node;
        }
        if (node.getNodeName().equals("lookup-method") || node.getNodeName().equals("replaced-method") || node.getNodeName().equals("property")) {
            Node node2 = node.getParentNode();
            if (node2.getNodeName().equals("bean")) {
                return node2;
            }
            return null;
        }
        return null;
    }

    public static String getBeanClassName(Node node) {
        NamedNodeMap namedNodeMap;
        Node node2 = SpringXMLConfigEditorUtils.getBean(node);
        if (node2 != null && (namedNodeMap = node2.getAttributes()) != null && namedNodeMap.getNamedItem("class") != null) {
            return namedNodeMap.getNamedItem("class").getNodeValue();
        }
        return null;
    }

    public static final Tag getDocumentRoot(Document document) {
        Tag tag = null;
        try {
            XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)((BaseDocument)document).getSyntaxSupport();
            TokenItem tokenItem = xMLSyntaxSupport.getTokenChain(0, 1);
            if (tokenItem != null) {
                Tag tag2;
                while (!ContextUtilities.isTagToken(tokenItem)) {
                    tokenItem = tokenItem.getNext();
                }
                SyntaxElement syntaxElement = xMLSyntaxSupport.getElementChain(tokenItem.getOffset() + tokenItem.getImage().length());
                if ((syntaxElement instanceof StartTag || syntaxElement instanceof EmptyTag) && (tag2 = (Tag)syntaxElement).getParentNode() instanceof org.w3c.dom.Document) {
                    return tag2;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return tag;
    }

    public static final boolean hasAttribute(Node node, String string) {
        return node != null && node.getAttributes() != null && node.getAttributes().getNamedItem(string) != null;
    }

    public static final String getAttribute(Node node, String string) {
        if (SpringXMLConfigEditorUtils.hasAttribute(node, string)) {
            return node.getAttributes().getNamedItem(string).getNodeValue();
        }
        return null;
    }

    public static boolean openFile(File file, int n) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            return SpringXMLConfigEditorUtils.openFile(fileObject, n);
        }
        return false;
    }

    public static boolean openFile(FileObject fileObject, int n) {
        DataObject dataObject;
        boolean bl = false;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            if (n > 0) {
                bl = SpringXMLConfigEditorUtils.openFileAtOffset(dataObject, n);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
        if (bl) {
            return true;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }

    private static boolean openFileAtOffset(DataObject dataObject, int n) throws IOException {
        Line line;
        int n2;
        StyledDocument styledDocument;
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (editorCookie != null && lineCookie != null && (styledDocument = editorCookie.openDocument()) != null && (n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n)) != -1 && (line = lineCookie.getLineSet().getCurrent(n2)) != null) {
            int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2);
            int n4 = n - n3;
            line.show(2, n4);
            return true;
        }
        return false;
    }

    public static SpringBean getMergedBean(SpringBean springBean, FileObject fileObject) {
        if (springBean == null) {
            return null;
        }
        if (springBean.getParent() == null) {
            return springBean;
        }
        ModelBasedSpringBean modelBasedSpringBean = new ModelBasedSpringBean(springBean, fileObject);
        return SpringXMLConfigEditorUtils.getMergedBean(modelBasedSpringBean, fileObject);
    }

    public static SpringBean getMergedBean(Map<String, String> map, FileObject fileObject) {
        NodeBasedSpringBean nodeBasedSpringBean = new NodeBasedSpringBean(map);
        if (!StringUtils.hasText(nodeBasedSpringBean.getParent())) {
            return nodeBasedSpringBean;
        }
        return SpringXMLConfigEditorUtils.getMergedBean(nodeBasedSpringBean, fileObject);
    }

    private static SpringBean getMergedBean(MutableSpringBean mutableSpringBean, FileObject fileObject) {
        final MutableSpringBean[] mutableSpringBeanArray = new MutableSpringBean[]{mutableSpringBean};
        SpringConfigModel springConfigModel = SpringConfigModel.forFileObject(fileObject);
        if (springConfigModel == null) {
            return null;
        }
        try {
            springConfigModel.runReadAction(new Action<SpringBeans>(){

                @Override
                public void run(SpringBeans springBeans) {
                    String string = mutableSpringBeanArray[0].getParent();
                    HashSet<SpringBean> hashSet = new HashSet<SpringBean>();
                    while (string != null && (mutableSpringBeanArray[0].getClassName() == null || mutableSpringBeanArray[0].getFactoryBean() == null || mutableSpringBeanArray[0].getFactoryMethod() == null)) {
                        SpringBean springBean = springBeans.findBean(string);
                        if (springBean == null || hashSet.contains(springBean)) {
                            mutableSpringBeanArray[0] = null;
                            break;
                        }
                        if (mutableSpringBeanArray[0].getClassName() == null) {
                            mutableSpringBeanArray[0].setClassName(springBean.getClassName());
                        }
                        if (mutableSpringBeanArray[0].getFactoryBean() == null) {
                            mutableSpringBeanArray[0].setFactoryBean(springBean.getFactoryBean());
                        }
                        if (mutableSpringBeanArray[0].getFactoryMethod() == null) {
                            mutableSpringBeanArray[0].setFactoryMethod(springBean.getFactoryMethod());
                        }
                        hashSet.add(springBean);
                        string = springBean.getParent();
                    }
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            mutableSpringBeanArray[0] = null;
        }
        return mutableSpringBeanArray[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeBasedSpringBean
    implements MutableSpringBean {
        private String className;
        private String factoryBean;
        private String factoryMethod;
        private String parent;
        private String id;
        private List<String> names;

        public NodeBasedSpringBean(Map<String, String> map) {
            this.className = map.get("class");
            this.factoryBean = map.get("factory-bean");
            this.factoryMethod = map.get("factory-method");
            this.parent = map.get("parent");
            this.id = map.get("id");
            if (map.get("name") == null) {
                this.names = Collections.emptyList();
            }
            this.names = StringUtils.tokenize(map.get("name"), SpringXMLConfigEditorUtils.BEAN_NAME_DELIMITERS);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public void setClassName(String string) {
            this.className = string;
        }

        @Override
        public String getParent() {
            return this.parent;
        }

        @Override
        public String getFactoryBean() {
            return this.factoryBean;
        }

        @Override
        public void setFactoryBean(String string) {
            this.factoryBean = string;
        }

        @Override
        public String getFactoryMethod() {
            return this.factoryMethod;
        }

        @Override
        public void setFactoryMethod(String string) {
            this.factoryMethod = string;
        }

        @Override
        public Location getLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<SpringBeanProperty> getProperties() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelBasedSpringBean
    implements MutableSpringBean {
        private String className;
        private String factoryBean;
        private String factoryMethod;
        private String parent;
        private String id;
        private List<String> names;
        private Location location;

        public ModelBasedSpringBean(SpringBean springBean, FileObject fileObject) {
            this.className = springBean.getClassName();
            this.factoryBean = springBean.getFactoryBean();
            this.factoryMethod = springBean.getFactoryMethod();
            this.parent = springBean.getParent();
            this.id = springBean.getId();
            this.location = springBean.getLocation();
            this.names = springBean.getNames();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public void setClassName(String string) {
            this.className = string;
        }

        @Override
        public String getParent() {
            return this.parent;
        }

        @Override
        public String getFactoryBean() {
            return this.factoryBean;
        }

        @Override
        public void setFactoryBean(String string) {
            this.factoryBean = string;
        }

        @Override
        public String getFactoryMethod() {
            return this.factoryMethod;
        }

        @Override
        public void setFactoryMethod(String string) {
            this.factoryMethod = string;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public Set<SpringBeanProperty> getProperties() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static interface MutableSpringBean
    extends SpringBean {
        public void setClassName(String var1);

        public void setFactoryBean(String var1);

        public void setFactoryMethod(String var1);
    }
}

