/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ComboBoxWithTree
extends JComboBox {
    private Window popup;
    private JTree tree;
    private JScrollPane scrollPane;
    private Converter converter;
    private boolean issue112997Hack = false;

    public ComboBoxWithTree(TreeModel treeModel, TreeCellRenderer treeCellRenderer, Converter converter) {
        this.converter = converter;
        this.initCombo();
        this.initTree(treeModel, treeCellRenderer);
    }

    private void initCombo() {
        this.setEditable(true);
        this.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                if (ComboBoxWithTree.this.issue112997Hack) {
                    ComboBoxWithTree.this.setPopupVisible(true);
                    return;
                }
                ComboBoxWithTree.this.getPopup().setVisible(false);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (ComboBoxWithTree.this.issue112997Hack) {
                    ComboBoxWithTree.this.issue112997Hack = false;
                    ComboBoxWithTree.this.setPopupVisible(true);
                    return;
                }
                ComboBoxWithTree.this.getPopup().setVisible(false);
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ComboBoxWithTree.this.updateTreeSelection();
                Dimension dimension = ComboBoxWithTree.this.getSize();
                Point point = ComboBoxWithTree.this.getLocationOnScreen();
                Window window = ComboBoxWithTree.this.getPopup();
                window.setLocation(point.x, point.y + dimension.height);
                window.setSize(new Dimension(dimension.width, ((ComboBoxWithTree)ComboBoxWithTree.this).scrollPane.getPreferredSize().height));
                window.setVisible(true);
            }
        });
        this.setModel(new DefaultComboBoxModel<Object>(new Object[]{""}));
        this.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (n == -1) {
                    return super.getListCellRendererComponent((JList<?>)jList, "null", n, bl, bl2);
                }
                JLabel jLabel = new JLabel();
                jLabel.setPreferredSize(new Dimension(0, -10000));
                return jLabel;
            }
        });
    }

    private void initTree(TreeModel treeModel, TreeCellRenderer treeCellRenderer) {
        this.tree = new JTree();
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setSelectionModel(defaultTreeSelectionModel);
        this.tree.setVisibleRowCount(10);
        this.tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if (!ComboBoxWithTree.this.isPopupVisible()) {
                    ComboBoxWithTree.this.setPopupVisible(true);
                }
                if ((n = keyEvent.getKeyCode()) == 10 || n == 27) {
                    ComboBoxWithTree.this.setPopupVisible(false);
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!ComboBoxWithTree.this.isPopupVisible()) {
                    ComboBoxWithTree.this.setPopupVisible(true);
                }
                if (mouseEvent.getClickCount() > 1) {
                    ComboBoxWithTree.this.setPopupVisible(false);
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                String string = ComboBoxWithTree.this.converter.pathToString(treeSelectionEvent.getPath());
                ComboBoxWithTree.this.setSelectedItem(string);
            }
        });
        this.tree.setModel(treeModel);
        this.tree.setCellRenderer(treeCellRenderer);
    }

    private Window getPopup() {
        if (this.popup == null) {
            this.popup = new Window(SwingUtilities.getWindowAncestor(this));
            this.scrollPane = new JScrollPane(this.tree);
            this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            JPopupMenu jPopupMenu = new JPopupMenu(){

                public boolean isVisible() {
                    return true;
                }
            };
            jPopupMenu.setBorder(new EmptyBorder(0, 0, 0, 0));
            jPopupMenu.setLayout(new BorderLayout());
            jPopupMenu.add(this.scrollPane);
            this.popup.add(jPopupMenu);
        }
        return this.popup;
    }

    private void updateTreeSelection() {
        final TreePath treePath = this.getSelectedTreePath();
        if (treePath == null) {
            this.tree.clearSelection();
        } else {
            this.tree.setSelectionPath(treePath);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ComboBoxWithTree.this.tree.scrollPathToVisible(treePath);
                }
            });
        }
    }

    public TreePath getSelectedTreePath() {
        String string = this.getEditor().getItem().toString();
        TreePath treePath = this.converter.stringToPath(string);
        return treePath;
    }

    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        while (!(container instanceof Window) && container.getParent() != null) {
            container = container.getParent();
        }
        if (container instanceof Window) {
            ((Window)container).addWindowListener(new WindowAdapter(){

                public void windowDeactivated(WindowEvent windowEvent) {
                    if (ComboBoxWithTree.this.isPopupVisible()) {
                        ComboBoxWithTree.this.issue112997Hack = true;
                    }
                }
            });
        }
    }

    public static interface Converter {
        public String pathToString(TreePath var1);

        public TreePath stringToPath(String var1);
    }
}

