/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.etable;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ColumnSelectionPanel;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.etable.ETableTransferHandler;
import org.netbeans.swing.etable.QuickFilter;
import org.netbeans.swing.etable.TableColumnSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETable
extends JTable {
    private static final String ACTION_FOCUS_NEXT = "focusNext";
    private static final int FULLY_EDITABLE = 1;
    private static final int FULLY_NONEDITABLE = 2;
    private static final int DEFAULT = 3;
    private static final String SEARCH_COLUMN = "SearchColumn";
    private static final String DEFAULT_COLUMNS_ICON = "columns.gif";
    private int editing = 3;
    protected transient int[] sortingPermutation;
    protected transient int[] inverseSortingPermutation;
    private transient int filteredRowCount;
    private Object quickFilterObject;
    private int quickFilterColumn = -1;
    private String maxPrefix;
    int SEARCH_FIELD_PREFERRED_SIZE = 160;
    int SEARCH_FIELD_SPACE = 3;
    private final JTextField searchTextField = new SearchTextField();
    private final int heightOfTextField;
    private JPanel searchPanel;
    private JComboBox searchCombo;
    private ETableColumn searchColumn;
    String selectVisibleColumnsLabel;
    private boolean inEditRequest;
    private boolean inEditorChangeRequest;
    private boolean inRemoveRequest;
    private static String COMPUTING_TOOLTIP = "ComputingTooltip";
    private String[] quickFilterFormatStrings;
    private MouseListener headerMouseListener;
    private MouseListener columnSelectionMouseListener;
    private TableColumnSelector columnSelector;
    private static TableColumnSelector defaultColumnSelector;
    private boolean popupUsedFromTheCorner;
    private boolean columnHidingAllowed;

    public ETable() {
        this.heightOfTextField = this.searchTextField.getPreferredSize().height;
        this.searchPanel = null;
        this.searchCombo = null;
        this.searchColumn = null;
        this.selectVisibleColumnsLabel = "Select Visible Columns";
        this.inEditRequest = false;
        this.inEditorChangeRequest = false;
        this.inRemoveRequest = false;
        this.quickFilterFormatStrings = new String[]{"{0} == {1}", "{0} <> {1}", "{0} > {1}", "{0} < {1}", "{0} >= {1}", "{0} <= {1}", "No Filter"};
        this.headerMouseListener = new HeaderMouseListener();
        this.columnSelectionMouseListener = new ColumnSelectionMouseListener();
        this.columnHidingAllowed = true;
        this.updateMouseListener();
    }

    public ETable(TableModel tableModel) {
        super(tableModel);
        this.heightOfTextField = this.searchTextField.getPreferredSize().height;
        this.searchPanel = null;
        this.searchCombo = null;
        this.searchColumn = null;
        this.selectVisibleColumnsLabel = "Select Visible Columns";
        this.inEditRequest = false;
        this.inEditorChangeRequest = false;
        this.inRemoveRequest = false;
        this.quickFilterFormatStrings = new String[]{"{0} == {1}", "{0} <> {1}", "{0} > {1}", "{0} < {1}", "{0} >= {1}", "{0} <= {1}", "No Filter"};
        this.headerMouseListener = new HeaderMouseListener();
        this.columnSelectionMouseListener = new ColumnSelectionMouseListener();
        this.columnHidingAllowed = true;
        this.updateMouseListener();
    }

    public ETable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.heightOfTextField = this.searchTextField.getPreferredSize().height;
        this.searchPanel = null;
        this.searchCombo = null;
        this.searchColumn = null;
        this.selectVisibleColumnsLabel = "Select Visible Columns";
        this.inEditRequest = false;
        this.inEditorChangeRequest = false;
        this.inRemoveRequest = false;
        this.quickFilterFormatStrings = new String[]{"{0} == {1}", "{0} <> {1}", "{0} > {1}", "{0} < {1}", "{0} >= {1}", "{0} <= {1}", "No Filter"};
        this.headerMouseListener = new HeaderMouseListener();
        this.columnSelectionMouseListener = new ColumnSelectionMouseListener();
        this.columnHidingAllowed = true;
        this.updateMouseListener();
    }

    public ETable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.heightOfTextField = this.searchTextField.getPreferredSize().height;
        this.searchPanel = null;
        this.searchCombo = null;
        this.searchColumn = null;
        this.selectVisibleColumnsLabel = "Select Visible Columns";
        this.inEditRequest = false;
        this.inEditorChangeRequest = false;
        this.inRemoveRequest = false;
        this.quickFilterFormatStrings = new String[]{"{0} == {1}", "{0} <> {1}", "{0} > {1}", "{0} < {1}", "{0} >= {1}", "{0} <= {1}", "No Filter"};
        this.headerMouseListener = new HeaderMouseListener();
        this.columnSelectionMouseListener = new ColumnSelectionMouseListener();
        this.columnHidingAllowed = true;
        this.updateMouseListener();
    }

    public ETable(int n, int n2) {
        super(n, n2);
        this.heightOfTextField = this.searchTextField.getPreferredSize().height;
        this.searchPanel = null;
        this.searchCombo = null;
        this.searchColumn = null;
        this.selectVisibleColumnsLabel = "Select Visible Columns";
        this.inEditRequest = false;
        this.inEditorChangeRequest = false;
        this.inRemoveRequest = false;
        this.quickFilterFormatStrings = new String[]{"{0} == {1}", "{0} <> {1}", "{0} > {1}", "{0} < {1}", "{0} >= {1}", "{0} <= {1}", "No Filter"};
        this.headerMouseListener = new HeaderMouseListener();
        this.columnSelectionMouseListener = new ColumnSelectionMouseListener();
        this.columnHidingAllowed = true;
        this.updateMouseListener();
    }

    public ETable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.heightOfTextField = this.searchTextField.getPreferredSize().height;
        this.searchPanel = null;
        this.searchCombo = null;
        this.searchColumn = null;
        this.selectVisibleColumnsLabel = "Select Visible Columns";
        this.inEditRequest = false;
        this.inEditorChangeRequest = false;
        this.inRemoveRequest = false;
        this.quickFilterFormatStrings = new String[]{"{0} == {1}", "{0} <> {1}", "{0} > {1}", "{0} < {1}", "{0} >= {1}", "{0} <= {1}", "No Filter"};
        this.headerMouseListener = new HeaderMouseListener();
        this.columnSelectionMouseListener = new ColumnSelectionMouseListener();
        this.columnHidingAllowed = true;
        this.updateMouseListener();
    }

    public ETable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.heightOfTextField = this.searchTextField.getPreferredSize().height;
        this.searchPanel = null;
        this.searchCombo = null;
        this.searchColumn = null;
        this.selectVisibleColumnsLabel = "Select Visible Columns";
        this.inEditRequest = false;
        this.inEditorChangeRequest = false;
        this.inRemoveRequest = false;
        this.quickFilterFormatStrings = new String[]{"{0} == {1}", "{0} <> {1}", "{0} > {1}", "{0} < {1}", "{0} >= {1}", "{0} <= {1}", "No Filter"};
        this.headerMouseListener = new HeaderMouseListener();
        this.columnSelectionMouseListener = new ColumnSelectionMouseListener();
        this.columnHidingAllowed = true;
        this.updateMouseListener();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.editing == 1) {
            return true;
        }
        if (this.editing == 2) {
            return false;
        }
        int n3 = this.convertRowIndexToModel(n);
        return super.isCellEditable(n3, n2);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.convertRowIndexToModel(n);
        return super.getCellRenderer(n3, n2);
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        int n3 = this.convertRowIndexToModel(n);
        return super.getCellEditor(n3, n2);
    }

    public void setFullyEditable(boolean bl) {
        Color color;
        if (bl) {
            this.editing = 1;
            if (!this.getShowHorizontalLines()) {
                this.setShowHorizontalLines(true);
            }
            color = UIManager.getColor("Table.borderAllEditable");
            Border border = null;
            border = color != null ? BorderFactory.createLineBorder(color) : BorderFactory.createLineBorder(Color.GRAY);
            Border border2 = BorderFactory.createLineBorder(this.getBackground());
            CompoundBorder compoundBorder = new CompoundBorder(border, border2);
            this.setBorder(new CompoundBorder(compoundBorder, border));
        } else {
            this.editing = 3;
            this.setBorder(null);
        }
        color = UIManager.getColor("Table.defaultGrid");
        if (color != null) {
            this.setGridColor(color);
        }
        if (this.isFullyNonEditable()) {
            this.setupSearch();
        }
    }

    public void setFullyNonEditable(boolean bl) {
        if (bl) {
            Color color;
            this.editing = 2;
            if (this.getShowHorizontalLines()) {
                this.setShowHorizontalLines(false);
            }
            if ((color = UIManager.getColor("Table.border")) == null) {
                color = Color.GRAY;
            }
            this.setBorder(BorderFactory.createLineBorder(color));
            Color color2 = UIManager.getColor("Table.noneditableGrid");
            if (color2 != null) {
                this.setGridColor(color2);
            }
        } else {
            Color color;
            this.editing = 3;
            this.setBorder(null);
            if (!this.getShowHorizontalLines()) {
                this.setShowHorizontalLines(true);
            }
            if ((color = UIManager.getColor("Table.defaultGrid")) != null) {
                this.setGridColor(color);
            }
        }
        if (this.isFullyNonEditable()) {
            this.setupSearch();
        }
    }

    public boolean isFullyEditable() {
        return this.editing == 1;
    }

    public boolean isFullyNonEditable() {
        return this.editing == 2;
    }

    public void setCellBackground(Component component, boolean bl, int n, int n2) {
        Color color = null;
        color = n % 2 == 0 ? (bl ? UIManager.getColor("Table.selectionBackground2") : UIManager.getColor("Table.background2")) : (bl ? UIManager.getColor("Table.selectionBackground1") : UIManager.getColor("Table.background1"));
        if (color != null) {
            component.setBackground(color);
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            int n = tableModel.getColumnCount();
            TableColumn[] tableColumnArray = new TableColumn[n];
            for (int i = 0; i < tableColumnArray.length; ++i) {
                tableColumnArray[i] = this.createColumn(i);
            }
            TableColumnModel tableColumnModel = this.getColumnModel();
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            if (tableColumnModel instanceof ETableColumnModel) {
                ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
                eTableColumnModel.hiddenColumns = new ArrayList<TableColumn>();
            }
            for (int i = 0; i < tableColumnArray.length; ++i) {
                this.addColumn(tableColumnArray[i]);
            }
        }
    }

    public String getTransferDelimiter(boolean bl) {
        if (bl) {
            return "\n";
        }
        return "\t";
    }

    public String convertValueToString(Object object) {
        if ((object = this.transformValue(object)) == null) {
            return "";
        }
        return object.toString();
    }

    protected TableColumn createColumn(int n) {
        return new ETableColumn(n, this);
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new ETableColumnModel();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = n;
        if (System.getProperty("java.version").startsWith("1.5")) {
            n3 = this.convertRowIndexToModel(n);
        }
        return super.getValueAt(n3, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3 = this.convertRowIndexToModel(n);
        super.setValueAt(object, n3, n2);
    }

    @Override
    public int getRowCount() {
        if (this.quickFilterColumn != -1 && this.quickFilterObject != null) {
            if (this.filteredRowCount == -1) {
                this.computeFilteredRowCount();
            }
            return this.filteredRowCount;
        }
        return super.getRowCount();
    }

    public void setQuickFilter(int n, Object object) {
        this.quickFilterColumn = n;
        this.quickFilterObject = object;
        this.sortingPermutation = null;
        this.inverseSortingPermutation = null;
        this.filteredRowCount = -1;
        super.tableChanged(new TableModelEvent(this.getModel()));
    }

    public void unsetQuickFilter() {
        this.quickFilterObject = null;
        this.quickFilterColumn = -1;
        this.filteredRowCount = -1;
        this.sortingPermutation = null;
        this.inverseSortingPermutation = null;
        super.tableChanged(new TableModelEvent(this.getModel()));
    }

    @Override
    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        this.filteredRowCount = -1;
        this.sortingPermutation = null;
        this.inverseSortingPermutation = null;
        this.quickFilterColumn = -1;
        this.quickFilterObject = null;
        this.updateMouseListener();
        if (this.defaultRenderersByColumnClass != null) {
            this.updatePreferredWidths();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        try {
            this.putClientProperty(COMPUTING_TOOLTIP, Boolean.TRUE);
            String string = super.getToolTipText(mouseEvent);
            return string;
        }
        finally {
            this.putClientProperty(COMPUTING_TOOLTIP, Boolean.FALSE);
        }
    }

    public boolean isColumnHidingAllowed() {
        return this.columnHidingAllowed;
    }

    public void setColumnHidingAllowed(boolean bl) {
        if (bl != this.columnHidingAllowed) {
            this.columnHidingAllowed = bl;
            this.configureEnclosingScrollPane();
        }
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.updatePreferredWidths();
        this.setSurrendersFocusOnKeystroke(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new STPolicy());
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        Set set = Collections.emptySet();
        this.setFocusTraversalKeys(0, set);
        this.setFocusTraversalKeys(1, set);
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 1));
        InputMap inputMap = this.getInputMap(0);
        InputMap inputMap2 = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(9, 3, false), ACTION_FOCUS_NEXT);
        inputMap.put(KeyStroke.getKeyStroke(9, 2, false), ACTION_FOCUS_NEXT);
        CTRLTabAction cTRLTabAction = new CTRLTabAction();
        actionMap.put(ACTION_FOCUS_NEXT, cTRLTabAction);
        inputMap.put(KeyStroke.getKeyStroke(32, 0, false), "beginEdit");
        this.getActionMap().put("beginEdit", new EditAction());
        inputMap.put(KeyStroke.getKeyStroke(27, 0, false), "cancelEdit");
        this.getActionMap().put("cancelEdit", new CancelEditAction());
        inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "enter");
        this.getActionMap().put("enter", new EnterAction());
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "next");
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "previous");
        actionMap.put("next", new NavigationAction(true));
        actionMap.put("previous", new NavigationAction(false));
        this.setTransferHandler(new ETableTransferHandler());
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (bl) {
            if (keyEvent.getKeyChar() == '+' && (keyEvent.getModifiers() & 2) == 2) {
                this.updatePreferredWidths();
                keyEvent.consume();
                return true;
            }
            if (keyEvent.getKeyChar() == '-' && (keyEvent.getModifiers() & 2) == 2) {
                this.unsetQuickFilter();
                keyEvent.consume();
                return true;
            }
            if (keyEvent.getKeyChar() == '*' && (keyEvent.getModifiers() & 2) == 2) {
                ColumnSelectionPanel.showColumnSelectionDialog(this);
                keyEvent.consume();
                return true;
            }
        }
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        return bl2;
    }

    public void setColumnSorted(int n, boolean bl, int n2) {
        int n3 = this.convertColumnIndexToView(n);
        if (n3 < 0) {
            return;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel instanceof ETableColumnModel) {
            ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
            TableColumn tableColumn = tableColumnModel.getColumn(n3);
            if (tableColumn instanceof ETableColumn) {
                ETableColumn eTableColumn = (ETableColumn)tableColumn;
                if (!eTableColumn.isSortingAllowed()) {
                    return;
                }
                int[] nArray = this.getSelectedRowsInModel();
                int n4 = this.getSelectedColumn();
                eTableColumnModel.setColumnSorted(eTableColumn, bl, n2);
                this.sortingPermutation = null;
                this.inverseSortingPermutation = null;
                ETable.super.tableChanged(new TableModelEvent(this.getModel(), 0, this.getRowCount()));
                if (nArray.length > 0) {
                    this.changeSelectionInModel(nArray, n4);
                }
            }
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container container;
        Container container2;
        super.configureEnclosingScrollPane();
        if (this.isFullyNonEditable()) {
            this.setupSearch();
        }
        if ((container2 = this.getParent()) instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            if (this.isColumnHidingAllowed()) {
                Icon icon = UIManager.getIcon("Table.columnSelection");
                if (icon == null) {
                    icon = new ImageIcon(ETable.class.getResource(DEFAULT_COLUMNS_ICON));
                }
                final JButton jButton = new JButton(icon);
                jButton.setToolTipText(this.selectVisibleColumnsLabel);
                jButton.getAccessibleContext().setAccessibleName(this.selectVisibleColumnsLabel);
                jButton.getAccessibleContext().setAccessibleDescription(this.selectVisibleColumnsLabel);
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ColumnSelectionPanel.showColumnSelectionPopup(jButton, ETable.this);
                    }
                });
                jButton.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getButton() == 3) {
                            ColumnSelectionPanel.showColumnSelectionDialog(ETable.this);
                        }
                    }
                });
                jButton.setFocusable(false);
                jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
            } else {
                jScrollPane.setCorner("UPPER_RIGHT_CORNER", null);
            }
        }
        this.updateColumnSelectionMouseListener();
    }

    private int[] getSelectedRowsInModel() {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.convertRowIndexToModel(nArray[i]);
        }
        return nArray2;
    }

    private void changeSelectionInModel(int[] nArray, int n) {
        boolean bl = this.getAutoscrolls();
        this.setAutoscrolls(false);
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        listSelectionModel2.setValueIsAdjusting(true);
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            if (nArray[i] < 0 || nArray[i] >= this.getModel().getRowCount() || (n2 = this.convertRowIndexToView(nArray[i])) < 0 || n2 >= this.getRowCount()) continue;
            this.changeSelection(n2, n, true, false);
        }
        listSelectionModel.setValueIsAdjusting(false);
        listSelectionModel2.setValueIsAdjusting(false);
        if (bl) {
            this.setAutoscrolls(true);
        }
    }

    void updateColumnSelectionMouseListener() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.removeMouseListener(this.columnSelectionMouseListener);
            if (this.getColumnModel().getColumnCount() == 0) {
                jScrollPane.addMouseListener(this.columnSelectionMouseListener);
            }
        }
        if (this.searchCombo != null) {
            this.searchCombo.setModel(this.getSearchComboModel());
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object;
        boolean bl = true;
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            this.sortingPermutation = null;
            this.inverseSortingPermutation = null;
            this.filteredRowCount = -1;
            super.tableChanged(tableModelEvent);
            return;
        }
        if (tableModelEvent.getType() == 1) {
            int[] nArray = this.getSelectedRowsInModel();
            int n = this.getSelectedColumn();
            this.clearSelection();
            this.sortingPermutation = null;
            this.inverseSortingPermutation = null;
            this.filteredRowCount = -1;
            super.tableChanged(tableModelEvent);
            if (nArray.length > 0) {
                int n2 = tableModelEvent.getFirstRow();
                int n3 = tableModelEvent.getLastRow() - tableModelEvent.getFirstRow() + 1;
                if (n3 >= 0) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] < n2) continue;
                        int n4 = i;
                        nArray[n4] = nArray[n4] + n3;
                    }
                }
                this.changeSelectionInModel(nArray, n);
            }
            return;
        }
        if (tableModelEvent.getType() == -1) {
            int[] nArray = this.getSelectedRowsInModel();
            int n = this.getSelectedColumn();
            this.clearSelection();
            this.sortingPermutation = null;
            this.inverseSortingPermutation = null;
            this.filteredRowCount = -1;
            super.tableChanged(tableModelEvent);
            if (nArray.length > 0) {
                int n5 = tableModelEvent.getFirstRow();
                int n6 = tableModelEvent.getLastRow() - tableModelEvent.getFirstRow() + 1;
                int n7 = tableModelEvent.getLastRow();
                if (n6 >= 0) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] < n5) continue;
                        if (nArray[i] <= n7) {
                            nArray[i] = -1;
                            continue;
                        }
                        int n8 = i;
                        nArray[n8] = nArray[n8] - n6;
                    }
                }
                this.changeSelectionInModel(nArray, n);
            }
            return;
        }
        int n = tableModelEvent.getColumn();
        int n9 = tableModelEvent.getFirstRow();
        int n10 = tableModelEvent.getLastRow();
        if (n != -1) {
            object = this.getColumnModel().getColumns();
            boolean bl2 = false;
            while (object.hasMoreElements()) {
                ETableColumn eTableColumn;
                TableColumn tableColumn = (TableColumn)object.nextElement();
                if (tableColumn.getModelIndex() != n || (eTableColumn = (ETableColumn)tableColumn).isSorted() || this.quickFilterColumn == n) continue;
                bl = false;
            }
        }
        if (bl) {
            object = this.getSelectedRowsInModel();
            int n11 = this.getSelectedColumn();
            this.sortingPermutation = null;
            this.inverseSortingPermutation = null;
            this.filteredRowCount = -1;
            super.tableChanged(new TableModelEvent(this.getModel()));
            if (((Object)object).length > 0) {
                this.changeSelectionInModel((int[])object, n11);
            }
        } else {
            object = new TableModelEvent((TableModel)tableModelEvent.getSource(), 0, this.getModel().getRowCount(), n);
            super.tableChanged((TableModelEvent)object);
        }
    }

    private TableColumn getResizingColumn(Point point) {
        int n;
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader == null) {
            return null;
        }
        int n2 = jTableHeader.columnAtPoint(point);
        if (n2 == -1) {
            return null;
        }
        Rectangle rectangle = jTableHeader.getHeaderRect(n2);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n3 = rectangle.x + rectangle.width / 2;
        if (jTableHeader.getComponentOrientation().isLeftToRight()) {
            n = point.x < n3 ? n2 - 1 : n2;
        } else {
            int n4 = n = point.x < n3 ? n2 : n2 - 1;
        }
        if (n == -1) {
            return null;
        }
        return jTableHeader.getColumnModel().getColumn(n);
    }

    private void updateMouseListener() {
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.removeMouseListener(this.headerMouseListener);
            jTableHeader.addMouseListener(this.headerMouseListener);
        }
    }

    private void computeFilteredRowCount() {
        if (this.quickFilterColumn == -1 || this.quickFilterObject == null) {
            this.filteredRowCount = -1;
            return;
        }
        if (this.sortingPermutation != null) {
            this.filteredRowCount = this.sortingPermutation.length;
            return;
        }
        this.sortAndFilter();
        if (this.sortingPermutation != null) {
            this.filteredRowCount = this.sortingPermutation.length;
        }
    }

    @Override
    public int convertRowIndexToModel(int n) {
        if (this.sortingPermutation == null) {
            this.sortAndFilter();
        }
        if (this.sortingPermutation != null) {
            if (n >= 0 && n < this.sortingPermutation.length) {
                return this.sortingPermutation[n];
            }
            return -1;
        }
        return n;
    }

    @Override
    public int convertRowIndexToView(int n) {
        if (this.inverseSortingPermutation == null) {
            this.sortAndFilter();
        }
        if (this.inverseSortingPermutation != null) {
            if (n >= 0 && n < this.inverseSortingPermutation.length) {
                return this.inverseSortingPermutation[n];
            }
            return -1;
        }
        return n;
    }

    public void setSelectVisibleColumnsLabel(String string) {
        this.selectVisibleColumnsLabel = string;
    }

    public void setQuickFilterFormatStrings(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.quickFilterFormatStrings.length) {
            return;
        }
        this.quickFilterFormatStrings = stringArray;
    }

    public String getColumnDisplayName(String string) {
        return string;
    }

    public Object transformValue(Object object) {
        return object;
    }

    public JMenuItem getQuickFilterPopup(int n, Object object, String string) {
        JMenu jMenu = new JMenu(string);
        String string2 = this.getColumnDisplayName(this.getColumnName(n));
        JMenuItem jMenuItem = this.getQuickFilterEqualsItem(n, object, string2, this.quickFilterFormatStrings[0], true);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = this.getQuickFilterEqualsItem(n, object, string2, this.quickFilterFormatStrings[1], false);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = this.getQuickFilterCompareItem(n, object, string2, this.quickFilterFormatStrings[2], true, false);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = this.getQuickFilterCompareItem(n, object, string2, this.quickFilterFormatStrings[3], false, false);
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = this.getQuickFilterCompareItem(n, object, string2, this.quickFilterFormatStrings[4], true, true);
        jMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = this.getQuickFilterCompareItem(n, object, string2, this.quickFilterFormatStrings[5], false, true);
        jMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = this.getQuickFilterNoFilterItem(this.quickFilterFormatStrings[6]);
        jMenu.add(jMenuItem7);
        return jMenu;
    }

    public JMenuItem getQuickFilterEqualsItem(int n, Object object, String string, String string2, boolean bl) {
        String string3 = MessageFormat.format(string2, string, object);
        JMenuItem jMenuItem = new JMenuItem(string3);
        jMenuItem.addActionListener(new EqualsQuickFilter(n, object, bl));
        return jMenuItem;
    }

    public JMenuItem getQuickFilterNoFilterItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ETable.this.unsetQuickFilter();
            }
        });
        return jMenuItem;
    }

    public JMenuItem getQuickFilterCompareItem(int n, Object object, String string, String string2, boolean bl, boolean bl2) {
        String string3 = MessageFormat.format(string2, string, object);
        JMenuItem jMenuItem = new JMenuItem(string3);
        jMenuItem.addActionListener(new CompareQuickFilter(n, object, bl, bl2));
        return jMenuItem;
    }

    protected void sortAndFilter() {
        ETableColumnModel eTableColumnModel;
        Comparator<RowMapping> comparator;
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel instanceof ETableColumnModel && (comparator = (eTableColumnModel = (ETableColumnModel)tableColumnModel).getComparator()) != null) {
            TableModel tableModel = this.getModel();
            int n = tableModel.getRowCount();
            ArrayList<RowMapping> arrayList = new ArrayList<RowMapping>();
            for (int i = 0; i < n; ++i) {
                if (!this.acceptByQuickFilter(tableModel, i)) continue;
                arrayList.add(new RowMapping(i, tableModel));
            }
            Collections.sort(arrayList, comparator);
            int[] nArray = new int[arrayList.size()];
            int[] nArray2 = new int[n];
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3;
                RowMapping rowMapping = (RowMapping)arrayList.get(n2);
                nArray[n2] = n3 = rowMapping.getModelRowIndex();
                nArray2[n3] = n2++;
            }
            this.sortingPermutation = nArray;
            this.inverseSortingPermutation = nArray2;
        }
    }

    protected boolean acceptByQuickFilter(TableModel tableModel, int n) {
        if (this.quickFilterColumn == -1 || this.quickFilterObject == null) {
            return true;
        }
        Object object = tableModel.getValueAt(n, this.quickFilterColumn);
        object = this.transformValue(object);
        if (this.quickFilterObject instanceof QuickFilter) {
            QuickFilter quickFilter = (QuickFilter)this.quickFilterObject;
            return quickFilter.accept(object);
        }
        if (object == null) {
            return false;
        }
        return object.equals(this.quickFilterObject);
    }

    void updatePreferredWidths() {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (!(tableColumn instanceof ETableColumn)) continue;
            ETableColumn eTableColumn = (ETableColumn)tableColumn;
            eTableColumn.updatePreferredWidth(this, false);
        }
    }

    public void readSettings(Properties properties, String string) {
        ETableColumnModel eTableColumnModel = (ETableColumnModel)this.createDefaultColumnModel();
        eTableColumnModel.readSettings(properties, string, this);
        this.setColumnModel(eTableColumnModel);
        String string2 = properties.getProperty(string + SEARCH_COLUMN);
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                for (int i = 0; i < eTableColumnModel.getColumnCount(); ++i) {
                    TableColumn tableColumn = eTableColumnModel.getColumn(i);
                    if (tableColumn.getModelIndex() != n) continue;
                    this.searchColumn = (ETableColumn)tableColumn;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        this.filteredRowCount = -1;
        this.sortingPermutation = null;
        this.inverseSortingPermutation = null;
        super.tableChanged(new TableModelEvent(this.getModel()));
    }

    public void writeSettings(Properties properties, String string) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel instanceof ETableColumnModel) {
            ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
            eTableColumnModel.writeSettings(properties, string);
        }
        if (this.searchColumn != null) {
            properties.setProperty(string + SEARCH_COLUMN, Integer.toString(this.searchColumn.getModelIndex()));
        }
    }

    private List<Integer> doSearch(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        int n2 = this.getRowCount();
        if (n2 == 0 || this.getColumnCount() == 0) {
            return arrayList;
        }
        int n3 = 0;
        if (this.searchColumn != null) {
            n3 = this.convertColumnIndexToView(this.searchColumn.getModelIndex());
        }
        if (n3 < 0) {
            return arrayList;
        }
        while (n < n2) {
            Object object = this.getValueAt(n, n3);
            String string2 = null;
            if (object != null) {
                string2 = this.convertValueToString(object);
            }
            if (string2 != null && string2.toUpperCase().indexOf(string.toUpperCase()) != -1) {
                arrayList.add(new Integer(n));
                if (this.maxPrefix == null) {
                    this.maxPrefix = string2;
                }
                this.maxPrefix = ETable.findMaxPrefix(this.maxPrefix, string2);
            }
            ++n;
        }
        return arrayList;
    }

    private static String findMaxPrefix(String string, String string2) {
        int n = 0;
        while (string.regionMatches(true, 0, string2, 0, n)) {
            ++n;
        }
        if (--n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    private void setupSearch() {
        KeyListener[] keyListenerArray = (KeyListener[])this.getListeners(KeyListener.class);
        for (int i = 0; i < keyListenerArray.length; ++i) {
            this.removeKeyListener(keyListenerArray[i]);
        }
        this.addKeyListener(new KeyAdapter(){
            private boolean armed = false;

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getModifiers();
                int n2 = keyEvent.getKeyCode();
                if (n > 0 && n != 1 || keyEvent.isActionKey()) {
                    return;
                }
                char c = keyEvent.getKeyChar();
                if (!Character.isISOControl(c) && n2 != 16 && n2 != 27) {
                    this.armed = true;
                    keyEvent.consume();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (this.armed) {
                    KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                    ETable.this.searchTextField.setText(String.valueOf(keyStroke.getKeyChar()));
                    ETable.this.displaySearchField();
                    keyEvent.consume();
                    this.armed = false;
                }
            }
        });
        SearchFieldListener searchFieldListener = new SearchFieldListener();
        this.searchTextField.addKeyListener(searchFieldListener);
        this.searchTextField.addFocusListener(searchFieldListener);
        this.searchTextField.getDocument().addDocumentListener(searchFieldListener);
    }

    private void prepareSearchPanel() {
        if (this.searchPanel == null) {
            Object object;
            this.searchPanel = new JPanel();
            String string = UIManager.getString("LBL_QUICKSEARCH");
            if (string == null) {
                string = "Quick search in";
            }
            JLabel jLabel = new JLabel(string);
            this.searchPanel.setLayout(new BoxLayout(this.searchPanel, 0));
            this.searchPanel.add(jLabel);
            this.searchCombo = new JComboBox(this.getSearchComboModel());
            if (this.searchColumn != null) {
                object = this.searchColumn.getHeaderValue();
                String string2 = "";
                if (object != null) {
                    string2 = object.toString();
                }
                string2 = this.getColumnDisplayName(string2);
                this.searchCombo.setSelectedItem(string2);
            }
            object = new SearchComboListener();
            this.searchCombo.addItemListener((ItemListener)object);
            this.searchCombo.addFocusListener((FocusListener)object);
            this.searchCombo.addKeyListener((KeyListener)object);
            this.searchPanel.add(this.searchCombo);
            this.searchPanel.add(this.searchTextField);
            jLabel.setLabelFor(this.searchTextField);
            this.searchPanel.setBorder(BorderFactory.createRaisedBevelBorder());
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        }
    }

    private ComboBoxModel getSearchComboModel() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (!(tableColumn instanceof ETableColumn)) continue;
            ETableColumn eTableColumn = (ETableColumn)tableColumn;
            Object object = eTableColumn.getHeaderValue();
            String string = "";
            if (object != null) {
                string = object.toString();
            }
            string = this.getColumnDisplayName(string);
            defaultComboBoxModel.addElement(string);
        }
        return defaultComboBoxModel;
    }

    public void displaySearchField() {
        if (!this.searchTextField.isDisplayable()) {
            this.searchTextField.setFont(this.getFont());
            this.prepareSearchPanel();
            this.add(this.searchPanel);
        }
        this.doLayout();
        this.invalidate();
        this.validate();
        this.repaint();
        this.searchTextField.requestFocus();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Rectangle rectangle = this.getVisibleRect();
        if (this.searchPanel != null && this.searchPanel.isDisplayable()) {
            int n = Math.min(rectangle.width - this.SEARCH_FIELD_SPACE * 2, this.searchPanel.getPreferredSize().width - this.searchTextField.getPreferredSize().width + this.SEARCH_FIELD_PREFERRED_SIZE - this.SEARCH_FIELD_SPACE);
            this.searchPanel.setBounds(Math.max(this.SEARCH_FIELD_SPACE, rectangle.x + rectangle.width - n), rectangle.y + this.SEARCH_FIELD_SPACE, Math.min(rectangle.width, n) - this.SEARCH_FIELD_SPACE, this.heightOfTextField);
        }
    }

    private void removeSearchField() {
        if (this.searchPanel.isDisplayable()) {
            this.remove(this.searchPanel);
            Rectangle rectangle = this.searchPanel.getBounds();
            this.repaint(rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        this.inEditRequest = true;
        if (this.editingRow == n && this.editingColumn == n2 && this.isEditing()) {
            this.inEditRequest = false;
            return false;
        }
        if (this.isEditing()) {
            this.inEditorChangeRequest = true;
            try {
                this.removeEditor();
                this.changeSelection(n, n2, false, false);
            }
            finally {
                this.inEditorChangeRequest = false;
            }
        }
        try {
            boolean bl = super.editCellAt(n, n2, eventObject);
            if (bl) {
                this.editorComp.requestFocus();
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.inEditRequest = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEditor() {
        this.inRemoveRequest = true;
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                super.removeEditor();
            }
        }
        finally {
            this.inRemoveRequest = false;
        }
    }

    private boolean isKnownComponent(Component component) {
        if (component == null) {
            return false;
        }
        if (this.isAncestorOf(component)) {
            return true;
        }
        if (component == this.editorComp) {
            return true;
        }
        return this.editorComp != null && this.editorComp instanceof Container && ((Container)this.editorComp).isAncestorOf(component);
    }

    public TableColumnSelector getColumnSelector() {
        return this.columnSelector != null ? this.columnSelector : defaultColumnSelector;
    }

    public void setColumnSelector(TableColumnSelector tableColumnSelector) {
        this.columnSelector = tableColumnSelector;
    }

    public boolean isPopupUsedFromTheCorner() {
        return this.popupUsedFromTheCorner;
    }

    public void setPopupUsedFromTheCorner(boolean bl) {
        this.popupUsedFromTheCorner = bl;
    }

    public static TableColumnSelector getDefaultColumnSelector() {
        return defaultColumnSelector;
    }

    public static void setDefaultColumnSelector(TableColumnSelector tableColumnSelector) {
        defaultColumnSelector = tableColumnSelector;
    }

    private class CTRLTabAction
    extends AbstractAction {
        private CTRLTabAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            ETable.this.setFocusCycleRoot(false);
            try {
                Container container = ETable.this.getFocusCycleRootAncestor();
                if (container != null) {
                    Component component;
                    Container container2 = ETable.this;
                    if (ETable.this.getParent() instanceof JViewport && (container2 = ETable.this.getParent().getParent()) == container) {
                        container2 = ETable.this;
                    }
                    AWTEvent aWTEvent = EventQueue.getCurrentEvent();
                    boolean bl = false;
                    if (aWTEvent instanceof KeyEvent) {
                        bl = (((KeyEvent)aWTEvent).getModifiers() & 1) != 0 && (((KeyEvent)aWTEvent).getModifiersEx() & 0x40) != 0;
                    }
                    Component component2 = component = bl ? container.getFocusTraversalPolicy().getComponentAfter(container, ETable.this) : container.getFocusTraversalPolicy().getComponentAfter(container, ETable.this);
                    if (component == ETable.this) {
                        component = bl ? container.getFocusTraversalPolicy().getFirstComponent(container) : container.getFocusTraversalPolicy().getLastComponent(container);
                    }
                    component.requestFocus();
                }
            }
            finally {
                ETable.this.setFocusCycleRoot(true);
            }
        }
    }

    private class EnterAction
    extends AbstractAction {
        private EnterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton;
            JRootPane jRootPane = ETable.this.getRootPane();
            if (jRootPane != null && (jButton = ETable.this.getRootPane().getDefaultButton()) != null && jButton.isEnabled()) {
                jButton.doClick();
            }
        }

        public boolean isEnabled() {
            return !ETable.this.isEditing() && !ETable.this.inRemoveRequest;
        }
    }

    private class CancelEditAction
    extends AbstractAction {
        private CancelEditAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            if (ETable.this.isEditing() || ETable.this.editorComp != null) {
                ETable.this.removeEditor();
                return;
            }
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            InputMap inputMap = ETable.this.getRootPane().getInputMap(1);
            ActionMap actionMap = ETable.this.getRootPane().getActionMap();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
            Object object = inputMap.get(keyStroke);
            if (object == null) {
                object = "Cancel";
            }
            if (object != null && (action = actionMap.get(object)) != null) {
                String string = (String)action.getValue("ActionCommandKey");
                if (string == null) {
                    string = object.toString();
                }
                action.actionPerformed(new ActionEvent(this, 1001, string));
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ETable.this.getSelectedRow();
            int n2 = ETable.this.getSelectedColumn();
            ETable.this.editCellAt(n, n2, null);
        }

        public boolean isEnabled() {
            return ETable.this.getSelectedRow() != -1 && ETable.this.getSelectedColumn() != -1 && !ETable.this.isEditing();
        }
    }

    private final class NavigationAction
    extends AbstractAction {
        private boolean direction;

        public NavigationAction(boolean bl) {
            this.direction = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2;
            if (ETable.this.isEditing()) {
                ETable.this.removeEditor();
            }
            if (this.direction) {
                if (ETable.this.getSelectedColumn() == ETable.this.getColumnCount() - 1) {
                    n2 = 0;
                    n = ETable.this.getSelectedRow() + 1;
                } else {
                    n2 = ETable.this.getSelectedColumn() + 1;
                    n = ETable.this.getSelectedRow();
                }
            } else if (ETable.this.getSelectedColumn() == 0) {
                n2 = ETable.this.getColumnCount() - 1;
                n = ETable.this.getSelectedRow() - 1;
            } else {
                n = ETable.this.getSelectedRow();
                n2 = ETable.this.getSelectedColumn() - 1;
            }
            if (n >= ETable.this.getRowCount() || n < 0) {
                JButton jButton;
                Container container;
                Component component;
                Container container2 = ETable.this.getFocusCycleRootAncestor();
                Component component2 = component = this.direction ? container2.getFocusTraversalPolicy().getComponentAfter(container2, ETable.this.getParent()) : container2.getFocusTraversalPolicy().getComponentBefore(container2, ETable.this);
                if (component == ETable.this && (container = container2.getFocusCycleRootAncestor()) != null) {
                    component = this.direction ? container.getFocusTraversalPolicy().getComponentAfter(container, container2) : container.getFocusTraversalPolicy().getComponentBefore(container, container2);
                    container2 = container;
                }
                if (component == ETable.this && container2.getFocusTraversalPolicy().getFirstComponent(container2) != null) {
                    component = container2.getFocusTraversalPolicy().getFirstComponent(container2);
                }
                if (component == ETable.this && (jButton = ((JRootPane)(container = ETable.this.getRootPane())).getDefaultButton()) != null) {
                    component = jButton;
                }
                if (component != null) {
                    if (component == ETable.this) {
                        ETable.this.changeSelection(this.direction ? 0 : ETable.this.getRowCount() - 1, this.direction ? 0 : ETable.this.getColumnCount() - 1, false, false);
                    } else {
                        component.requestFocus();
                    }
                    return;
                }
            }
            ETable.this.changeSelection(n, n2, false, false);
        }
    }

    private class STPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private STPolicy() {
        }

        public Component getComponentAfter(Container container, Component component) {
            if (ETable.this.inRemoveRequest) {
                return ETable.this;
            }
            Component component2 = super.getComponentAfter(container, component);
            return component2;
        }

        public Component getComponentBefore(Container container, Component component) {
            if (ETable.this.inRemoveRequest) {
                return ETable.this;
            }
            return super.getComponentBefore(container, component);
        }

        public Component getFirstComponent(Container container) {
            if (!ETable.this.inRemoveRequest && ETable.this.isEditing()) {
                return ETable.this.editorComp;
            }
            return ETable.this;
        }

        public Component getDefaultComponent(Container container) {
            if (ETable.this.inRemoveRequest && ETable.this.isEditing() && ETable.this.editorComp.isShowing()) {
                return ETable.this.editorComp;
            }
            return ETable.this;
        }

        protected boolean accept(Component component) {
            if (ETable.this.isEditing() && ETable.this.inEditRequest) {
                return ETable.this.isKnownComponent(component);
            }
            return super.accept(component) && component.isShowing();
        }
    }

    private class HeaderMouseListener
    extends MouseAdapter {
        private HeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                ColumnSelectionPanel.showColumnSelectionDialog(ETable.this);
                return;
            }
            TableColumn tableColumn = ETable.this.getResizingColumn(mouseEvent.getPoint());
            if (tableColumn == null && mouseEvent.getClickCount() == 1) {
                int n = ETable.this.columnAtPoint(mouseEvent.getPoint());
                TableColumnModel tableColumnModel = ETable.this.getColumnModel();
                if (tableColumnModel instanceof ETableColumnModel) {
                    ETableColumnModel eTableColumnModel = (ETableColumnModel)tableColumnModel;
                    TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                    if (tableColumn2 instanceof ETableColumn) {
                        ETableColumn eTableColumn = (ETableColumn)tableColumn2;
                        if (!eTableColumn.isSortingAllowed()) {
                            return;
                        }
                        int[] nArray = ETable.this.getSelectedRowsInModel();
                        int n2 = ETable.this.getSelectedColumn();
                        ETable.this.clearSelection();
                        boolean bl = (mouseEvent.getModifiers() & 1) != 1;
                        eTableColumnModel.toggleSortedColumn(eTableColumn, bl);
                        ETable.this.sortingPermutation = null;
                        ETable.this.inverseSortingPermutation = null;
                        ETable.super.tableChanged(new TableModelEvent(ETable.this.getModel(), 0, ETable.this.getRowCount()));
                        if (nArray.length > 0) {
                            ETable.this.changeSelectionInModel(nArray, n2);
                        }
                        ETable.this.getTableHeader().resizeAndRepaint();
                    }
                }
            }
            if (tableColumn != null && mouseEvent.getClickCount() == 2 && tableColumn instanceof ETableColumn) {
                ETableColumn eTableColumn = (ETableColumn)tableColumn;
                eTableColumn.updatePreferredWidth(ETable.this, true);
            }
        }
    }

    private class ColumnSelectionMouseListener
    extends MouseAdapter {
        private ColumnSelectionMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                ColumnSelectionPanel.showColumnSelectionDialog(ETable.this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OriginalRowComparator
    implements Comparator<RowMapping> {
        @Override
        public int compare(RowMapping rowMapping, RowMapping rowMapping2) {
            int n;
            int n2 = rowMapping.getModelRowIndex();
            return n2 < (n = rowMapping2.getModelRowIndex()) ? -1 : (n2 == n ? 0 : 1);
        }
    }

    public static final class RowMapping {
        private int originalIndex;
        private TableModel model;

        public RowMapping(int n, TableModel tableModel) {
            this.originalIndex = n;
            this.model = tableModel;
        }

        public int getModelRowIndex() {
            return this.originalIndex;
        }

        public Object getModelObject(int n) {
            return this.model.getValueAt(this.originalIndex, n);
        }
    }

    private class SearchComboListener
    extends KeyAdapter
    implements FocusListener,
    ItemListener {
        SearchComboListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = ETable.this.searchCombo.getSelectedItem();
            Object object2 = ETable.this.getColumnModel().getColumns();
            while (object2.hasMoreElements()) {
                TableColumn tableColumn = object2.nextElement();
                if (!(tableColumn instanceof ETableColumn)) continue;
                ETableColumn eTableColumn = (ETableColumn)tableColumn;
                Object object3 = eTableColumn.getHeaderValue();
                String string = "";
                if (object3 != null) {
                    string = object3.toString();
                }
                if (!(string = ETable.this.getColumnDisplayName(string)).equals(object)) continue;
                ETable.this.searchColumn = eTableColumn;
            }
            object2 = ETable.this.searchTextField.getText();
            ETable.this.searchTextField.setText("");
            ETable.this.searchTextField.setText((String)object2);
            ETable.this.searchTextField.requestFocus();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                ETable.this.removeSearchField();
                ETable.this.requestFocus();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (component != ETable.this.searchTextField) {
                ETable.this.removeSearchField();
            }
        }
    }

    private class SearchFieldListener
    extends KeyAdapter
    implements DocumentListener,
    FocusListener {
        private List results = new ArrayList();
        private int currentSelectionIndex;

        SearchFieldListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.searchForRow();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.searchForRow();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.searchForRow();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                ETable.this.removeSearchField();
                ETable.this.requestFocus();
            } else if (n == 38) {
                --this.currentSelectionIndex;
                this.displaySearchResult();
                keyEvent.consume();
            } else if (n == 40) {
                ++this.currentSelectionIndex;
                this.displaySearchResult();
                keyEvent.consume();
            } else if (n == 9) {
                if (ETable.this.maxPrefix != null) {
                    ETable.this.searchTextField.setText(ETable.this.maxPrefix);
                }
                keyEvent.consume();
            } else if (n == 10) {
                ETable.this.removeSearchField();
                keyEvent.consume();
                ETable.this.requestFocus();
            }
        }

        private void searchForRow() {
            this.currentSelectionIndex = 0;
            this.results.clear();
            ETable.this.maxPrefix = null;
            String string = ETable.this.searchTextField.getText().toUpperCase();
            if (string.length() > 0) {
                this.results = ETable.this.doSearch(string);
                int[] nArray = ETable.this.getSelectedRows();
                int n = nArray == null || nArray.length == 0 ? 0 : nArray[0];
                int n2 = 0;
                Iterator iterator = this.results.iterator();
                while (iterator.hasNext()) {
                    int n3 = (Integer)iterator.next();
                    if (n <= n3) {
                        this.currentSelectionIndex = n2;
                        break;
                    }
                    ++n2;
                }
                this.displaySearchResult();
            }
        }

        private void displaySearchResult() {
            int n = this.results.size();
            if (n > 0) {
                if (this.currentSelectionIndex < 0) {
                    this.currentSelectionIndex = 0;
                }
                if (this.currentSelectionIndex >= n) {
                    this.currentSelectionIndex = n - 1;
                }
                int n2 = (Integer)this.results.get(this.currentSelectionIndex);
                ETable.this.setRowSelectionInterval(n2, n2);
                Rectangle rectangle = ETable.this.getCellRect(n2, 0, true);
                ETable.this.scrollRectToVisible(rectangle);
                ETable.this.displaySearchField();
            } else {
                ETable.this.clearSelection();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (component != ETable.this.searchCombo) {
                ETable.this.removeSearchField();
            }
        }
    }

    private class SearchTextField
    extends JTextField {
        private SearchTextField() {
        }

        public boolean isManagingFocus() {
            return true;
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                ETable.this.removeSearchField();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ETable.this.requestFocus();
                    }
                });
            } else {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    private class CompareQuickFilter
    implements ActionListener,
    QuickFilter {
        private int column;
        private Object value;
        private boolean greater;
        private boolean equalsCounts;

        public CompareQuickFilter(int n, Object object, boolean bl, boolean bl2) {
            this.column = n;
            this.value = object;
            this.greater = bl;
            this.equalsCounts = bl2;
        }

        public boolean accept(Object object) {
            if (this.equalsCounts) {
                if (this.greater) {
                    return this.doCompare(this.value, object) <= 0;
                }
                return this.doCompare(this.value, object) >= 0;
            }
            if (this.greater) {
                return this.doCompare(this.value, object) < 0;
            }
            return this.doCompare(this.value, object) > 0;
        }

        private int doCompare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof Comparable && object.getClass().isAssignableFrom(object2.getClass())) {
                Comparable comparable = (Comparable)object;
                return comparable.compareTo(object2);
            }
            return object.toString().compareTo(object2.toString());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ETable.this.setQuickFilter(this.column, this);
        }
    }

    private class EqualsQuickFilter
    implements ActionListener,
    QuickFilter {
        private int column;
        private Object value;
        private boolean equals;

        public EqualsQuickFilter(int n, Object object, boolean bl) {
            this.column = n;
            this.value = object;
            this.equals = bl;
        }

        public boolean accept(Object object) {
            if (this.value == null && object == null) {
                return this.equals;
            }
            if (this.value == null || object == null) {
                return !this.equals;
            }
            if (this.equals) {
                return this.value.equals(object);
            }
            return !this.value.equals(object);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ETable.this.setQuickFilter(this.column, this);
        }
    }
}

