/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.netbeans.modules.cnd.api.remote.CommandProvider;
import org.netbeans.modules.cnd.api.remote.InteractiveCommandProvider;
import org.netbeans.modules.cnd.api.remote.InteractiveCommandProviderFactory;
import org.netbeans.modules.cnd.api.utils.CppUtils;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public abstract class IOProxy {
    private static final String FILENAME_PREFIX = "gdbFifo";
    private static final String FILENAME_EXTENSION = ".fifo";
    private InputWriterThread irt = null;
    private final Reader ioReader;
    private OutputReaderThread ort = null;
    private final Writer ioWriter;

    public static IOProxy create(String string, InputOutput inputOutput) {
        IOProxy iOProxy = string == null || "localhost".equals(string) ? new LocalIOProxy(inputOutput.getIn(), (Writer)inputOutput.getOut()) : new RemoteIOProxy(string, inputOutput.getIn(), (Writer)inputOutput.getOut());
        super.start();
        return iOProxy;
    }

    private IOProxy(Reader reader, Writer writer) {
        this.ioReader = reader;
        this.ioWriter = writer;
    }

    private void start() {
        this.irt = new InputWriterThread();
        this.irt.start();
        this.ort = new OutputReaderThread();
        this.ort.start();
    }

    public void stop() {
        if (this.irt != null) {
            this.irt.cancel();
            try {
                this.ioReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.ort != null) {
            this.ort.cancel();
            try {
                this.ioWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
    }

    public abstract String getInFilename();

    protected abstract OutputStream createInStream() throws IOException;

    public abstract String getOutFilename();

    protected abstract InputStream createOutStream() throws IOException;

    private static class RemoteIOProxy
    extends IOProxy {
        private final String inFilename;
        private final String outFilename;
        private final String hkey;
        private InteractiveCommandProvider inProvider = null;
        private InteractiveCommandProvider outProvider = null;

        public RemoteIOProxy(String string, Reader reader, Writer writer) {
            super(reader, writer);
            this.hkey = string;
            this.inFilename = RemoteIOProxy.createNewFifo(string);
            this.outFilename = RemoteIOProxy.createNewFifo(string);
        }

        public String getInFilename() {
            return this.inFilename;
        }

        protected OutputStream createInStream() throws IOException {
            this.inProvider = InteractiveCommandProviderFactory.create((String)this.hkey);
            if (this.inProvider != null && this.inProvider.run(this.hkey, "cat > " + this.inFilename, null)) {
                return this.inProvider.getOutputStream();
            }
            return null;
        }

        public String getOutFilename() {
            return this.outFilename;
        }

        protected InputStream createOutStream() throws IOException {
            this.outProvider = InteractiveCommandProviderFactory.create((String)this.hkey);
            if (this.outProvider != null && this.outProvider.run(this.hkey, "cat " + this.outFilename, null)) {
                return this.outProvider.getInputStream();
            }
            return null;
        }

        private static String createNewFifo(String string) {
            String string2 = "/tmp/gdbFifo$$.fifo";
            CommandProvider commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
            if (commandProvider.run(string, "mkfifo " + string2 + ";echo " + string2, null) == 0) {
                return commandProvider.getOutput().trim();
            }
            return null;
        }

        public void stop() {
            CommandProvider commandProvider;
            super.stop();
            if (this.inProvider != null) {
                this.inProvider.disconnect();
            }
            if (this.outProvider != null) {
                this.outProvider.disconnect();
            }
            if ((commandProvider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class)) != null) {
                commandProvider.run(this.hkey, "rm -f " + this.inFilename + " " + this.outFilename, null);
            }
        }
    }

    private static class LocalIOProxy
    extends IOProxy {
        private final File inFile = LocalIOProxy.createNewFifo();
        private final File outFile;

        public LocalIOProxy(Reader reader, Writer writer) {
            super(reader, writer);
            this.inFile.deleteOnExit();
            this.outFile = LocalIOProxy.createNewFifo();
            this.outFile.deleteOnExit();
        }

        private static File createNewFifo() {
            try {
                Object object;
                File file = File.createTempFile(IOProxy.FILENAME_PREFIX, IOProxy.FILENAME_EXTENSION);
                file.delete();
                String string = "mkfifo";
                if (Utilities.isWindows()) {
                    string = string + ".exe";
                    object = new File(CppUtils.getCygwinBase() + "/bin", string);
                    if (((File)object).exists()) {
                        string = ((File)object).getAbsolutePath();
                    } else {
                        object = new File(CppUtils.getMSysBase() + "/bin", string);
                        if (((File)object).exists()) {
                            string = ((File)object).getAbsolutePath();
                        }
                    }
                }
                object = new ProcessBuilder(string, file.getAbsolutePath());
                try {
                    Process process = ((ProcessBuilder)object).start();
                    process.waitFor();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                return file;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        }

        protected OutputStream createInStream() throws IOException {
            return new FileOutputStream(this.inFile);
        }

        public String getInFilename() {
            return this.inFile.getAbsolutePath();
        }

        protected InputStream createOutStream() throws IOException {
            return new FileInputStream(this.outFile);
        }

        public String getOutFilename() {
            return this.outFile.getAbsolutePath();
        }

        public void stop() {
            super.stop();
            this.inFile.delete();
            this.outFile.delete();
        }
    }

    private class OutputReaderThread
    extends Thread {
        private boolean cancel = false;

        public OutputReaderThread() {
            this.setName("TTY OutputReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStream inputStream = null;
            try {
                int n;
                inputStream = IOProxy.this.createOutStream();
                while ((n = inputStream.read()) != -1) {
                    if (this.cancel) {
                        return;
                    }
                    if (n == 10) {
                        IOProxy.this.ioWriter.write("\n");
                        continue;
                    }
                    IOProxy.this.ioWriter.write((char)n);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    IOProxy.this.ioWriter.flush();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        public void cancel() {
            this.cancel = true;
        }
    }

    private class InputWriterThread
    extends Thread {
        private boolean cancel = false;

        public InputWriterThread() {
            this.setName("TTY InputWriterThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            OutputStream outputStream = null;
            try {
                int n;
                outputStream = IOProxy.this.createInStream();
                while ((n = IOProxy.this.ioReader.read()) != -1) {
                    if (this.cancel) {
                        return;
                    }
                    outputStream.write((char)n);
                    outputStream.flush();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        public void cancel() {
            this.cancel = true;
        }
    }
}

