/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.remote.InteractiveCommandProvider;
import org.netbeans.modules.cnd.api.remote.InteractiveCommandProviderFactory;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.ExternalTerminal;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbLogger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.utils.CommandBuffer;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbProxyEngine {
    private static final int MIN_TOKEN = 100;
    private PrintStream toGdb;
    private final GdbDebugger debugger;
    private final GdbProxy gdbProxy;
    private final LinkedList<CommandInfo> tokenList = new LinkedList();
    private int nextToken = 100;
    private int currentToken = 100;
    private boolean active;
    private InteractiveCommandProvider provider = null;
    private RequestProcessor.Task gdbReader = null;
    private final boolean timerOn = Boolean.getBoolean("gdb.proxy.timer");
    private final Logger log = Logger.getLogger("gdb.gdbproxy.logger");

    public GdbProxyEngine(GdbDebugger gdbDebugger, GdbProxy gdbProxy, List<String> list, String[] stringArray, String string, String string2, String string3) throws IOException {
        ExternalTerminal externalTerminal;
        String string4;
        if (gdbDebugger.getPlatform() != 3 && string2 != null && (string4 = (externalTerminal = new ExternalTerminal(gdbDebugger, string2, stringArray)).getTty()) != null) {
            list.add("-tty");
            list.add(string4);
        }
        this.debugger = gdbDebugger;
        this.gdbProxy = gdbProxy;
        this.active = true;
        this.getLogger().logMessage("Debugger Command: " + list);
        this.getLogger().logMessage("Env[" + stringArray.length + "]: " + Arrays.asList(stringArray));
        this.getLogger().logMessage("workingDirectory: " + string);
        this.getLogger().logMessage("================================================");
        if (gdbDebugger.getHostKey().equals("localhost")) {
            this.localDebugger(list, stringArray, string, string3);
        } else {
            this.remoteDebugger(gdbDebugger, list, stringArray, string, string3);
        }
    }

    private void localDebugger(List<String> list, String[] stringArray, String string, String string2) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        Map<String, String> map = processBuilder.environment();
        String string3 = Path.getPathName();
        for (String string4 : stringArray) {
            int n = string4.indexOf(61);
            if (n == -1) continue;
            String string5 = string4.substring(0, n);
            String string6 = string4.substring(n + 1);
            if (string5.equals(string3)) {
                map.put(string5, string6 + File.pathSeparator + string2);
                continue;
            }
            map.put(string5, string6);
        }
        if (!map.containsKey(string3)) {
            map.put(string3, Path.getPathAsString() + File.pathSeparator + string2);
        }
        processBuilder.directory(new File(string));
        processBuilder.redirectErrorStream(true);
        final Process process = processBuilder.start();
        this.toGdb = this.gdbReader(process.getInputStream(), process.getOutputStream());
        new RequestProcessor("GdbReaperThread").post(new Runnable(){

            public void run() {
                try {
                    int n = process.waitFor();
                    if (n == 0) {
                        GdbProxyEngine.this.debugger.finish(false);
                    } else {
                        GdbProxyEngine.this.debugger.unexpectedGdbExit(n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        });
    }

    private void remoteDebugger(GdbDebugger gdbDebugger, List<String> list, String[] stringArray, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : list) {
            stringBuilder.append(string3);
            stringBuilder.append(' ');
        }
        this.provider = InteractiveCommandProviderFactory.create((String)gdbDebugger.getHostKey());
        if (this.provider != null && this.provider.run(gdbDebugger.getHostKey(), stringBuilder.toString(), null)) {
            try {
                this.toGdb = this.gdbReader(this.provider.getInputStream(), this.provider.getOutputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private PrintStream gdbReader(InputStream inputStream, OutputStream outputStream) {
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        PrintStream printStream = new PrintStream(outputStream, true);
        this.gdbReader = new RequestProcessor("GdbReaderRP").post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        if ((string = string.trim()).length() <= 0) continue;
                        GdbProxyEngine.this.processMessage(string);
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (GdbProxyEngine.this.provider != null) {
                        GdbProxyEngine.this.provider.disconnect();
                        GdbProxyEngine.this.provider = null;
                    }
                }
            }
        });
        return printStream;
    }

    public void finish() {
        if (this.provider != null) {
            this.provider.disconnect();
        }
        if (this.gdbReader != null) {
            this.gdbReader.cancel();
        }
    }

    private int nextToken() {
        return this.nextToken++;
    }

    public int sendCommand(String string) {
        return this.sendCommand(null, string, false);
    }

    public int sendCommand(CommandBuffer commandBuffer, String string) {
        return this.sendCommand(commandBuffer, string, false);
    }

    public int sendCommand(CommandBuffer commandBuffer, String string, boolean bl) {
        if (this.active) {
            String string2 = this.timerOn ? Long.toString(System.currentTimeMillis()) + ':' : "";
            int n = this.nextToken();
            if (commandBuffer != null) {
                commandBuffer.setID(n);
            }
            if (bl) {
                n += 10000;
            } else if (string.charAt(0) != '-') {
                this.tokenList.add(new CommandInfo(n, string));
            }
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(n));
            stringBuilder.append(string);
            stringBuilder.append('\n');
            this.gdbProxy.getLogger().logMessage(string2 + stringBuilder.toString());
            this.toGdb.print(stringBuilder.toString());
            return n;
        }
        return -1;
    }

    public int sendConsoleCommand(String string) {
        return this.sendCommand(null, string, true);
    }

    void stopSending() {
        this.active = false;
    }

    private void processMessage(String string) {
        String string2 = this.timerOn ? Long.toString(System.currentTimeMillis()) + ':' : "";
        if (string.equals("(gdb)")) {
            return;
        }
        int n = GdbProxyEngine.getToken(string);
        if (n < 0) {
            n = this.getCurrentToken(string);
            if (n != -1) {
                this.gdbProxy.getLogger().logMessage(string2 + n + string);
            } else {
                this.gdbProxy.getLogger().logMessage(string2 + string);
            }
        } else {
            this.gdbProxy.getLogger().logMessage(string2 + string);
        }
        string = GdbProxyEngine.stripToken(string);
        string = GdbProxyEngine.stripTiming(string);
        if (string.length() == 0) {
            this.log.warning("Empty message received from gdb");
            return;
        }
        switch (string.charAt(0)) {
            case '^': {
                if (n == this.currentToken && string.equals("^done")) {
                    this.currentToken = -1;
                }
                this.debugger.resultRecord(n, string);
                break;
            }
            case '*': {
                this.debugger.execAsyncOutput(n, string);
                break;
            }
            case '+': {
                this.debugger.statusAsyncOutput(n, string);
                break;
            }
            case '=': {
                this.debugger.notifyAsyncOutput(n, string);
                break;
            }
            case '~': {
                this.debugger.consoleStreamOutput(n, string.substring(2, string.length() - 1));
                break;
            }
            case '@': {
                this.debugger.targetStreamOutput(string);
                break;
            }
            case '&': {
                this.debugger.logStreamOutput(string);
                break;
            }
            default: {
                this.debugger.output(string);
            }
        }
    }

    private int getCurrentToken(String string) {
        CommandInfo commandInfo;
        char c = string.charAt(0);
        if (c == '&' && (commandInfo = this.getCommandInfo(string)) != null) {
            this.tokenList.remove(commandInfo);
            this.currentToken = commandInfo.getToken();
        }
        return this.currentToken;
    }

    private CommandInfo getCommandInfo(String string) {
        string = string.substring(2, string.length() - 1).replace("\\n", "");
        for (CommandInfo commandInfo : this.tokenList) {
            if (!commandInfo.getCommand().equals(string)) continue;
            return commandInfo;
        }
        return null;
    }

    private static int getFirstNonDigit(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return i;
        }
        return 0;
    }

    private static int getToken(String string) {
        int n = GdbProxyEngine.getFirstNonDigit(string);
        if (n > 0) {
            return Integer.parseInt(string.substring(0, n));
        }
        return -1;
    }

    private static String stripToken(String string) {
        char c;
        int n = GdbProxyEngine.getFirstNonDigit(string);
        char c2 = c = n < string.length() ? string.charAt(n) : (char)'\u0000';
        if ((c == '^' || c == '*' || c == '+' || c == '=') && c != '\u0000') {
            return string.substring(n);
        }
        return string;
    }

    private static String stripTiming(String string) {
        int n = string.indexOf(",time=");
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private GdbLogger getLogger() {
        return this.gdbProxy.getLogger();
    }

    private static class CommandInfo {
        private final int token;
        private final String cmd;

        public CommandInfo(int n, String string) {
            this.token = n;
            this.cmd = string;
        }

        private String getCommand() {
            return this.cmd;
        }

        public int getToken() {
            return this.token;
        }

        public boolean equals(Object object) {
            if (object instanceof CommandInfo) {
                CommandInfo commandInfo = (CommandInfo)object;
                return this.cmd.equals(commandInfo.getCommand());
            }
            if (object instanceof String) {
                return this.cmd.equals(object.toString());
            }
            return false;
        }

        public int hashCode() {
            return this.token;
        }
    }
}

