/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.util.Vector;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.cnd.debugger.gdb.models.BreakpointsTreeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    public static final String LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpoint";
    public static final String DISABLED_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledConditionalBreakpoint";
    private Vector listeners = new Vector();
    private static final String ZEROS = "            ";
    private GdbBreakpoint currentBreakpoint;

    static int log10(int n) {
        int n2 = 1;
        while ((n /= 10) > 0) {
            ++n2;
        }
        return n2;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        String string = ZEROS;
        while (string.length() < n) {
            string = string + " ";
        }
        return string;
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            int n;
            int n2;
            LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
            int n3 = lineBreakpoint.getLineNumber();
            String string = Integer.toString(n3);
            Integer n4 = (Integer)BreakpointsTreeModelFilter.MAX_LINES.get((Object)lineBreakpoint);
            if (n4 != null && (n2 = BreakpointsNodeModel.log10(n = n4.intValue()) - BreakpointsNodeModel.log10(n3)) > 0) {
                string = BreakpointsNodeModel.zeros(n2) + string;
            }
            return this.bold(lineBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName(lineBreakpoint), (Object)string));
        }
        if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
            String string = "";
            if (functionBreakpoint.getFunctionName().equals("")) {
                return this.bold(functionBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Functions_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
            }
            String string2 = BreakpointsNodeModel.getShort(string);
            if (string2 != null && string2.length() > 0) {
                return this.bold(functionBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint_With_Class", (Object)BreakpointsNodeModel.getShort(string), (Object)functionBreakpoint.getFunctionName()));
            }
            return this.bold(functionBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint", (Object)functionBreakpoint.getFunctionName()));
        }
        if (object instanceof AddressBreakpoint) {
            AddressBreakpoint addressBreakpoint = (AddressBreakpoint)object;
            return this.bold(addressBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Address_Breakpoint", (Object)addressBreakpoint.getAddress()));
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName((LineBreakpoint)((Object)object)), (Object)("" + ((LineBreakpoint)((Object)object)).getLineNumber()));
        }
        if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
            String string = "";
            if (functionBreakpoint.getFunctionName().equals("")) {
                return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Functions_Breakpoint", (Object)string);
            }
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint", (Object)string, (Object)functionBreakpoint.getFunctionName());
        }
        if (object instanceof AddressBreakpoint) {
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Address_Breakpoint", (Object)EditorContextBridge.getFileName((AddressBreakpoint)object), (Object)((AddressBreakpoint)object).getAddress());
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        boolean bl;
        boolean bl2 = bl = !((Breakpoint)object).isEnabled();
        if (object instanceof LineBreakpoint || object instanceof AddressBreakpoint) {
            boolean bl3;
            String string = ((GdbBreakpoint)((Object)object)).getCondition();
            boolean bl4 = bl3 = string != null && string.trim().length() > 0;
            if (bl) {
                if (bl3) {
                    return DISABLED_LINE_CONDITIONAL_BREAKPOINT;
                }
                return DISABLED_LINE_BREAKPOINT;
            }
            if (bl3) {
                return LINE_CONDITIONAL_BREAKPOINT;
            }
            return LINE_BREAKPOINT;
        }
        if (object instanceof FunctionBreakpoint) {
            if (bl) {
                return DISABLED_BREAKPOINT;
            }
            return BREAKPOINT;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    void fireNodeChanged(GdbBreakpoint gdbBreakpoint) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)gdbBreakpoint));
        }
    }

    static String getShort(String string) {
        if (string.indexOf(42) >= 0) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private String bold(GdbBreakpoint gdbBreakpoint, String string) {
        return gdbBreakpoint == this.currentBreakpoint ? BoldVariablesTableModelFilterFirst.toHTML(string, true, false, null) : string;
    }

    public void setCurrentBreakpoint(GdbBreakpoint gdbBreakpoint) {
        if (this.currentBreakpoint != null) {
            this.fireNodeChanged(this.currentBreakpoint);
        }
        this.currentBreakpoint = gdbBreakpoint;
        if (gdbBreakpoint != null) {
            this.fireNodeChanged(gdbBreakpoint);
        }
    }
}

