/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.disassembly;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.gdb.CallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.RegisterValue;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Disassembly
implements PropertyChangeListener,
DocumentListener {
    private final GdbDebugger debugger;
    private final List<Line> lines = new ArrayList<Line>();
    private static String functionName = "";
    private boolean withSource = true;
    private boolean opened = false;
    private boolean opening = false;
    private int disLength = 0;
    private final Map<Integer, String> regNames = new HashMap<Integer, String>();
    private final Map<Integer, String> regValues = new HashMap<Integer, String>();
    private final Set<Integer> regModified = new HashSet<Integer>();
    private static final String ADDRESS_HEADER = "address";
    private static final String FUNCTION_HEADER = "func-name";
    private static final String OFFSET_HEADER = "offset";
    private static final String INSTR_HEADER = "inst";
    private static final String LINE_HEADER = "line";
    private static final String FILE_HEADER = "file";
    private static final String NUMBER_HEADER = "number";
    private static final String VALUE_HEADER = "value";
    public static final String REGISTER_NAMES_HEADER = "^done,register-names=";
    public static final String REGISTER_VALUES_HEADER = "^done,register-values=";
    public static final String REGISTER_MODIFIED_HEADER = "^done,changed-registers=";
    public static final String RESPONSE_HEADER = "^done,asm_insns=";
    private static final String COMBINED_HEADER = "src_and_asm_line={";
    private static FileObject fo = null;
    private static Logger LOG = Logger.getLogger("gdb.logger");

    public Disassembly(GdbDebugger gdbDebugger) {
        this.debugger = gdbDebugger;
        gdbDebugger.addPropertyChangeListener("currentCallStackFrame", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String string) {
        assert (string.startsWith(RESPONSE_HEADER)) : "Invalid asm response message";
        List<Line> list = this.lines;
        synchronized (list) {
            DataObject dataObject;
            this.lines.clear();
            this.disLength = 0;
            try {
                dataObject = DataObject.find((FileObject)Disassembly.getFileObject());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
                return;
            }
            StyledDocument styledDocument = ((DataEditorSupport)dataObject.getCookie(OpenCookie.class)).getDocument();
            if (styledDocument != null) {
                styledDocument.removeDocumentListener(this);
                styledDocument.addDocumentListener(this);
            }
            DisText disText = new DisText();
            int n = RESPONSE_HEADER.length();
            boolean bl = false;
            while (true) {
                Object object;
                int n2;
                int n3 = string.indexOf(COMBINED_HEADER, n);
                int n4 = string.indexOf(ADDRESS_HEADER, n);
                if (n4 == -1) break;
                if (n3 != -1 && n3 < n4) {
                    String string2;
                    n2 = Integer.valueOf(Disassembly.readValue(LINE_HEADER, string, n3));
                    object = this.debugger.getRunDirectory();
                    File file = new File((String)object, string2 = Disassembly.readValue(FILE_HEADER, string, n3));
                    FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                    if (fileObject != null) {
                        try {
                            disText.addLine("!" + ((LineCookie)DataObject.find((FileObject)fileObject).getCookie(LineCookie.class)).getLineSet().getCurrent(n2 - 1).getText());
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {}
                    } else {
                        disText.addLine("!" + NbBundle.getMessage(Disassembly.class, (String)"MSG_Source_Not_Found", (Object)string2, (Object)n2));
                    }
                    n = n3 + 1;
                    continue;
                }
                n2 = disText.getLineNo();
                object = new Line(string, n4, bl ? n2 : n2 + 1);
                if (!bl) {
                    functionName = ((Line)object).function;
                    dataObject.getNodeDelegate().setDisplayName(Disassembly.getHeader());
                    disText.addLine(functionName + "()\n");
                    bl = true;
                }
                if (functionName.equals(((Line)object).function)) {
                    this.lines.add((Line)object);
                    disText.addLine(object + "\n");
                }
                n = n4 + 1;
            }
            this.disLength = disText.getLength();
            try {
                disText.save(Disassembly.getFileObject().getOutputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.lines.isEmpty() && this.withSource) {
            this.reloadDis(false, true);
        }
    }

    public void updateRegNames(String string) {
        int n;
        assert (string.startsWith(REGISTER_NAMES_HEADER)) : "Invalid asm response message";
        this.regNames.clear();
        int n2 = 0;
        int n3 = string.indexOf("\"", REGISTER_NAMES_HEADER.length());
        while (n3 != -1 && (n = string.indexOf("\"", n3 + 1)) != -1) {
            String string2 = string.substring(n3 + 1, n);
            this.regNames.put(n2++, string2);
            n3 = string.indexOf("\"", n + 1);
        }
    }

    public void updateRegModified(String string) {
        int n;
        assert (string.startsWith(REGISTER_MODIFIED_HEADER)) : "Invalid asm response message";
        this.regModified.clear();
        int n2 = string.indexOf("\"", REGISTER_MODIFIED_HEADER.length());
        while (n2 != -1 && (n = string.indexOf("\"", n2 + 1)) != -1) {
            String string2 = string.substring(n2 + 1, n);
            try {
                this.regModified.add(Integer.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            n2 = string.indexOf("\"", n + 1);
        }
    }

    public void updateRegValues(String string) {
        assert (string.startsWith(REGISTER_VALUES_HEADER)) : "Invalid asm response message";
        this.regValues.clear();
        int n = string.indexOf(NUMBER_HEADER);
        while (n != -1) {
            String string2 = Disassembly.readValue(NUMBER_HEADER, string, n);
            String string3 = Disassembly.readValue(VALUE_HEADER, string, n);
            try {
                this.regValues.put(Integer.valueOf(string2), string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            n = string.indexOf(NUMBER_HEADER, n + 1);
        }
    }

    public Collection<RegisterValue> getRegisterValues() {
        ArrayList<RegisterValue> arrayList = new ArrayList<RegisterValue>();
        for (Integer n : this.regValues.keySet()) {
            String string = this.regNames.get(n);
            if (string == null) {
                LOG.severe("Unknown register: " + n);
                string = String.valueOf(n);
            }
            arrayList.add(new RegisterValue(string, this.regValues.get(n), this.regModified.contains(n)));
        }
        return arrayList;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getOffset() + documentEvent.getLength() >= this.disLength) {
            final boolean bl = this.opening;
            this.opening = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Disassembly.this.updateAnnotations(bl);
                }
            });
        }
    }

    private void updateAnnotations(boolean bl) {
        this.debugger.fireDisUpdate(bl);
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            if (!(breakpointArray[i] instanceof AddressBreakpoint)) continue;
            ((AddressBreakpoint)breakpointArray[i]).refresh();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("currentCallStackFrame".equals(propertyChangeEvent.getPropertyName())) {
            this.reloadDis(true, false);
        }
    }

    private void reloadDis(boolean bl, boolean bl2) {
        this.withSource = bl;
        if (!this.opened) {
            return;
        }
        CallStackFrame callStackFrame = this.debugger.getCurrentCallStackFrame();
        if (callStackFrame == null) {
            return;
        }
        if (bl2 || this.getAddressLine(callStackFrame.getAddr()) == -1) {
            String string = callStackFrame.getFileName();
            if (string != null && string.length() > 0) {
                this.debugger.getGdbProxy().data_disassemble(string, callStackFrame.getLineNumber(), bl);
            } else {
                this.debugger.getGdbProxy().data_disassemble(1000, bl);
            }
        }
    }

    public static FileObject getFileObject() {
        if (fo == null) {
            try {
                fo = FileUtil.createMemoryFileSystem().getRoot().createData("disasm", "s");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLineAddress(int n) {
        List<Line> list = this.lines;
        synchronized (list) {
            for (Line line : this.lines) {
                if (line.idx != n) continue;
                return line.address;
            }
            return "";
        }
    }

    public static Disassembly getCurrent() {
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            return null;
        }
        GdbDebugger gdbDebugger = (GdbDebugger)debuggerEngine.lookupFirst(null, GdbDebugger.class);
        if (gdbDebugger == null) {
            return null;
        }
        return gdbDebugger.getDisassembly();
    }

    public static String getLineAddress(Disassembly disassembly, int n) {
        if (disassembly != null) {
            return disassembly.getLineAddress(n);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAddressLine(String string) {
        List<Line> list = this.lines;
        synchronized (list) {
            for (Line line : this.lines) {
                if (!line.address.equals(string)) continue;
                return line.idx;
            }
            return -1;
        }
    }

    public static int getAddressLine(Disassembly disassembly, String string) {
        if (disassembly != null) {
            return disassembly.getAddressLine(string);
        }
        return -1;
    }

    private static String readValue(String string, String string2, int n) {
        int n2;
        String string3 = string + "=\"";
        int n3 = string2.indexOf(string3, n);
        if (n3 != -1 && (n2 = string2.indexOf("\"", (n3 += string3.length()) + 1)) != -1) {
            return string2.substring(n3, n2);
        }
        return "";
    }

    public static boolean isInDisasm() {
        DataObject dataObject = EditorContextBridge.getContext().getCurrentDataObject();
        if (dataObject == null) {
            return false;
        }
        try {
            return dataObject.equals(DataObject.find((FileObject)Disassembly.getFileObject()));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
            return false;
        }
    }

    public static boolean isDisasm(String string) {
        try {
            return Disassembly.getFileObject().getURL().toString().equals(string);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            fileStateInvalidException.printStackTrace();
            return false;
        }
    }

    public static void open() {
        try {
            DataObject dataObject = DataObject.find((FileObject)Disassembly.getFileObject());
            dataObject.getNodeDelegate().setDisplayName(NbBundle.getMessage(Disassembly.class, (String)"LBL_Disassembly_Window"));
            final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie instanceof EditorCookie.Observable) {
                ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("openedPanes".equals(propertyChangeEvent.getPropertyName()) && editorCookie.getOpenedPanes() == null) {
                            Disassembly disassembly = Disassembly.getCurrent();
                            if (disassembly != null) {
                                disassembly.opened = false;
                            }
                            ((EditorCookie.Observable)editorCookie).removePropertyChangeListener((PropertyChangeListener)this);
                        }
                    }
                });
            }
            ((OpenCookie)dataObject.getCookie(OpenCookie.class)).open();
            Disassembly disassembly = Disassembly.getCurrent();
            if (disassembly != null) {
                disassembly.opening = true;
                disassembly.opened = true;
                disassembly.reloadDis(true, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String getHeader() {
        String string = NbBundle.getMessage(Disassembly.class, (String)"LBL_Disassembly_Window");
        if (functionName.length() > 0) {
            string = string + "(" + functionName + ")";
        }
        return string;
    }

    public static void close() {
        try {
            DataObject dataObject = DataObject.find((FileObject)Disassembly.getFileObject());
            ((CloseCookie)dataObject.getCookie(CloseCookie.class)).close();
            Disassembly disassembly = Disassembly.getCurrent();
            if (disassembly != null) {
                disassembly.opened = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class DisText {
        private int lineNo = 1;
        private int length = 0;
        private final StringBuffer data = new StringBuffer();

        private DisText() {
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public int getLength() {
            return this.length;
        }

        public void addLine(String string) {
            this.data.append(string);
            ++this.lineNo;
            this.length += string.length();
        }

        public void save(OutputStream outputStream) throws IOException {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write(this.data.toString());
            ((Writer)outputStreamWriter).close();
        }
    }

    private static class Line {
        private final String address;
        private final String function;
        private final int offset;
        private final String instruction;
        private final int idx;

        public Line(String string, int n, int n2) {
            this.address = Disassembly.readValue(Disassembly.ADDRESS_HEADER, string, n);
            this.function = Disassembly.readValue(Disassembly.FUNCTION_HEADER, string, n);
            int n3 = 0;
            try {
                n3 = Integer.valueOf(Disassembly.readValue(Disassembly.OFFSET_HEADER, string, n));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.offset = n3;
            this.instruction = Disassembly.readValue(Disassembly.INSTR_HEADER, string, n);
            this.idx = n2;
        }

        public String toString() {
            return this.function + "+" + this.offset + ": " + this.instruction;
        }
    }
}

