/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.debugger.gdb.profiles.GdbProfile;
import org.netbeans.modules.cnd.makeproject.api.CustomProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class GdbActionHandler
implements CustomProjectActionHandler {
    private ArrayList<ExecutionListener> listeners = new ArrayList();

    public void execute(final ProjectActionEvent projectActionEvent, final InputOutput inputOutput) {
        GdbProfile gdbProfile = (GdbProfile)projectActionEvent.getConfiguration().getAuxObject("gdbdebugger");
        if (gdbProfile != null) {
            String string = gdbProfile.getGdbPath((MakeConfiguration)projectActionEvent.getConfiguration(), true);
            if (string != null) {
                this.executionStarted();
                if (projectActionEvent.getID() == 3 || projectActionEvent.getID() == 4) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-cnd-GdbSessionProvider", (Object[])new Object[]{projectActionEvent, inputOutput, GdbActionHandler.this}));
                        }
                    });
                }
            } else {
                this.executionFinished(-1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbActionHandler.class, (String)"Err_NoGdbFound")));
            }
        }
    }

    public void addExecutionListener(ExecutionListener executionListener) {
        this.listeners.add(executionListener);
    }

    public void removeExecutionListener(ExecutionListener executionListener) {
        this.listeners.remove(this.listeners.indexOf(executionListener));
    }

    public void cancel() {
    }

    public void executionStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ExecutionListener executionListener = this.listeners.get(i);
            executionListener.executionStarted();
        }
    }

    public void executionFinished(int n) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ExecutionListener executionListener = this.listeners.get(i);
            executionListener.executionFinished(n);
        }
    }
}

