/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedList;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.openide.awt.StatusDisplayer;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class IOManager {
    private final InputOutput debuggerIO;
    private final OutputWriter debuggerOut;
    private boolean closed = false;
    private Hashtable lines = new Hashtable();
    private final Listener listener = new Listener();
    private final LinkedList buffer = new LinkedList();
    private RequestProcessor.Task task;

    public IOManager(String string) {
        this.debuggerIO = IOProvider.getDefault().getIO(string, true);
        this.debuggerIO.setFocusTaken(false);
        this.debuggerOut = this.debuggerIO.getOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string, Line line) {
        if (string == null) {
            throw new NullPointerException();
        }
        LinkedList linkedList = this.buffer;
        synchronized (linkedList) {
            this.buffer.addLast(new Text(string, line));
        }
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    LinkedList linkedList = IOManager.this.buffer;
                    synchronized (linkedList) {
                        int n = IOManager.this.buffer.size();
                        for (int i = 0; i < n; ++i) {
                            Text text = (Text)IOManager.this.buffer.removeFirst();
                            try {
                                if (text.line != null) {
                                    IOManager.this.debuggerOut.println(text.text, (OutputListener)IOManager.this.listener);
                                    IOManager.this.lines.put(text.text, text.line);
                                } else {
                                    IOManager.this.debuggerOut.println(text.text);
                                }
                                IOManager.this.debuggerOut.flush();
                                if (IOManager.this.closed) {
                                    IOManager.this.debuggerOut.close();
                                }
                                StatusDisplayer.getDefault().setStatusText(text.text);
                                continue;
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                }
            }, 500, 1);
        } else {
            this.task.schedule(500);
        }
    }

    void closeStream() {
        this.debuggerOut.close();
        this.closed = true;
    }

    void close() {
        this.debuggerIO.closeInputOutput();
    }

    public static class Line {
        private final String url;
        private final int lineNumber;
        private final GdbDebugger debugger;

        Line(String string, int n, GdbDebugger gdbDebugger) {
            this.url = string;
            this.lineNumber = n;
            this.debugger = gdbDebugger;
        }

        void show() {
            EditorContextBridge.getContext().showSource(this.url, this.lineNumber, (Object)this.debugger);
        }
    }

    private static class Text {
        private final String text;
        private final Line line;

        private Text(String string, Line line) {
            this.text = string;
            this.line = line;
        }
    }

    private class Listener
    implements OutputListener {
        private Listener() {
        }

        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
            String string = outputEvent.getLine();
            Line line = (Line)IOManager.this.lines.get(string);
            if (line == null) {
                return;
            }
            line.show();
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            IOManager.this.lines = new Hashtable();
        }
    }
}

