/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ricoh;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import ricoh.util.dom.DalpDOMHandler;

public class RicohApplicationUIDCustomizer
extends JPanel {
    boolean uidValid = true;
    private String uidString;
    private File sdkInstallation;
    private JLabel errorLabel;
    private JTextField idTextField;
    private JLabel jLabel1;

    public RicohApplicationUIDCustomizer(String string, File file) {
        this.sdkInstallation = file;
        this.uidString = string;
        this.initComponents();
        this.idTextField.setInputVerifier(new UIDVerifier());
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = new Color(255, 0, 0);
        }
        this.errorLabel.setForeground(color);
        this.idTextField.setText(string);
        this.idTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                RicohApplicationUIDCustomizer.this.computeUID();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                RicohApplicationUIDCustomizer.this.computeUID();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                RicohApplicationUIDCustomizer.this.computeUID();
            }
        });
        this.computeUID();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.idTextField = new JTextField();
        this.errorLabel = new JLabel();
        this.jLabel1.setLabelFor(this.idTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2me/cdc/project/ricoh/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)resourceBundle.getString("LBL_ApplicationUID"));
        this.idTextField.setColumns(7);
        this.idTextField.setInputVerifier(this.idTextField.getInputVerifier());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).add(17, 17, 17).add((Component)this.idTextField, -1, 318, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1, -2, 14, -2).add((Component)this.idTextField, -2, -1, -2)).addPreferredGap(0, 29, Short.MAX_VALUE).add((Component)this.errorLabel).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RicohApplicationUIDCustomizer.class, (String)"ACSN_ApplicationUID"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RicohApplicationUIDCustomizer.class, (String)"ACSD_ApplicationUID"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RicohApplicationUIDCustomizer.class, (String)"ACSD_UIDCustomizerPanel"));
    }

    private void computeUID() {
        String string = this.idTextField.getText();
        int n = string.length();
        if (n == 0) {
            this.errorLabel.setText(NbBundle.getMessage(RicohApplicationUIDCustomizer.class, (String)"ERR_CustomizerMissingUID"));
            this.uidValid = false;
        } else {
            this.uidValid = true;
            for (int i = 0; i < n; ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                this.uidValid = false;
                this.errorLabel.setText(NbBundle.getMessage(RicohApplicationUIDCustomizer.class, (String)"ERR_CustomizerWrongUID"));
                break;
            }
        }
        if (this.uidValid) {
            File file;
            String string2 = this.idTextField.getText().toUpperCase();
            boolean bl = false;
            if (this.sdkInstallation != null && (file = new File(this.sdkInstallation, "/mnt/sd3/sdk/dsdk/dist/".replace('/', File.pathSeparatorChar))).exists() && !string2.equals(this.uidString)) {
                this.uidValid = false;
                this.errorLabel.setText(NbBundle.getMessage(RicohApplicationUIDCustomizer.class, (String)"ERR_CustomiserAlreadyUsedUID", (Object)string2));
            }
        }
        if (!this.uidValid) {
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        } else {
            this.errorLabel.setText(" ");
            this.firePropertyChange("valid", Boolean.FALSE, Boolean.TRUE);
        }
    }

    String getUID() {
        return this.idTextField.getText();
    }

    public class UIDVerifier
    extends InputVerifier {
        public boolean verify(JComponent jComponent) {
            if (jComponent instanceof JTextField) {
                return DalpDOMHandler.isValidUid(((JTextField)jComponent).getText());
            }
            return true;
        }
    }
}

