/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.monitor;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.profiler.results.DataManagerListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.charts.AbstractSynchronousXYChartModel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModelDataResetListener;

public abstract class VMTelemetryXYChartModel
extends AbstractSynchronousXYChartModel
implements DataManagerListener {
    protected VMTelemetryDataManager vmTelemetryDataManager;
    protected long[] maxYValues;
    protected long[] minYValues;
    protected Color[] seriesColors;
    protected String[] seriesNames;
    protected int itemCount = 0;
    protected int seriesCount = 0;
    protected long maxXValue = 0L;
    protected long minXValue = 0L;
    private final Set dataResetListeners = new HashSet();
    private long lastXValue = Long.MIN_VALUE;

    public VMTelemetryXYChartModel(VMTelemetryDataManager vMTelemetryDataManager) {
        this.vmTelemetryDataManager = vMTelemetryDataManager;
        vMTelemetryDataManager.addDataListener((DataManagerListener)this);
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public long getMaxDisplayYValue(int n) {
        return this.getMaxYValue(n);
    }

    public long getMaxXValue() {
        return this.maxXValue;
    }

    public long getMaxYValue(int n) {
        return this.maxYValues[n];
    }

    public long getMinDisplayYValue(int n) {
        return 0L;
    }

    public long getMinXValue() {
        return this.minXValue;
    }

    public long getMinYValue(int n) {
        return this.minYValues[n];
    }

    public Color getSeriesColor(int n) {
        return this.seriesColors[n];
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public String getSeriesName(int n) {
        return this.seriesNames[n];
    }

    public long getXValue(int n) {
        return this.vmTelemetryDataManager.timeStamps[n];
    }

    public long getYValue(int n, int n2) {
        return this.getYValues(n2)[n];
    }

    public void addDataResetListener(VMTelemetryXYChartModelDataResetListener vMTelemetryXYChartModelDataResetListener) {
        this.dataResetListeners.add(vMTelemetryXYChartModelDataResetListener);
    }

    public void dataChanged() {
        int n = this.vmTelemetryDataManager.getItemCount();
        if (this.itemCount == 0) {
            if (n > 0) {
                this.minXValue = this.vmTelemetryDataManager.timeStamps[0];
                this.maxXValue = this.vmTelemetryDataManager.timeStamps[0];
                for (int i = 0; i < this.seriesCount; ++i) {
                    this.minYValues[i] = this.getYValues(i)[0];
                    this.maxYValues[i] = this.getYValues(i)[0];
                }
                if (n > 1) {
                    this.processNewData(1, n - 1);
                }
            }
        } else if (n > this.itemCount) {
            this.processNewData(this.itemCount, n - 1);
        }
        this.itemCount = n;
        this.fireChartDataChanged();
    }

    public void dataReset() {
        this.itemCount = 0;
        this.minXValue = 0L;
        this.maxXValue = 0L;
        this.minYValues = new long[this.seriesCount];
        this.maxYValues = new long[this.seriesCount];
        this.lastXValue = Long.MIN_VALUE;
        this.fireChartDataReset();
    }

    public void removeDataResetListener(VMTelemetryXYChartModelDataResetListener vMTelemetryXYChartModelDataResetListener) {
        this.dataResetListeners.remove(vMTelemetryXYChartModelDataResetListener);
    }

    public void setupModel(String[] stringArray, Color[] colorArray) {
        this.seriesNames = stringArray;
        this.seriesColors = colorArray;
        if (stringArray.length != colorArray.length) {
            this.seriesCount = 0;
            throw new RuntimeException("Counts of series names and series colors don't match.");
        }
        this.seriesCount = stringArray.length;
        this.itemCount = 0;
        this.minXValue = 0L;
        this.maxXValue = 0L;
        this.minYValues = new long[this.seriesCount];
        this.maxYValues = new long[this.seriesCount];
    }

    protected abstract long[] getYValues(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChartDataReset() {
        HashSet hashSet;
        if (this.dataResetListeners == null) {
            return;
        }
        Object object = this.dataResetListeners;
        synchronized (object) {
            hashSet = new HashSet(this.dataResetListeners);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            ((VMTelemetryXYChartModelDataResetListener)object.next()).chartDataReset();
        }
    }

    private void processNewData(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            long l = this.vmTelemetryDataManager.timeStamps[i];
            if (this.lastXValue >= l) {
                System.err.println("Profiler Graphs Warning: New x-value not greater than previous x-value. Graphs may not be displayed correctly.");
            } else {
                this.maxXValue = l;
            }
            this.lastXValue = l;
            for (int j = 0; j < this.seriesCount; ++j) {
                long l2 = this.getYValues(j)[i];
                this.minYValues[j] = Math.min(this.minYValues[j], l2);
                this.maxYValues[j] = Math.max(this.maxYValues[j], l2);
            }
        }
    }
}

