/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;

public class CustomBarCellRenderer
extends EnhancedTableCellRenderer {
    public static final Color BAR_FOREGROUND_COLOR = new Color(195, 41, 41);
    protected double relValue;
    protected long max;
    protected long min;

    public CustomBarCellRenderer(long l, long l2) {
        this.setMinimum(l);
        this.setMaximum(l2);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public void setMaximum(long l) {
        this.max = l;
    }

    public void setMinimum(long l) {
        this.min = l;
    }

    public void setRelValue(double d) {
        this.relValue = d;
    }

    public Component getTableCellRendererComponentPersistent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return null;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        graphics.setColor(BAR_FOREGROUND_COLOR);
        graphics.fillRect(insets.left, insets.top, (int)Math.round(this.relValue * (double)(this.getWidth() - insets.right - insets.left)), this.getHeight() - insets.bottom - insets.top);
    }

    protected void setValue(JTable jTable, Object object, int n, int n2) {
        if (object instanceof Long) {
            this.setRelValue(this.calculateViewValue((Long)object));
        } else if (object instanceof Number) {
            this.setRelValue(this.calculateViewValue(((Number)object).doubleValue()));
        } else if (object instanceof String) {
            this.setRelValue(this.calculateViewValue(Double.parseDouble((String)object)));
        } else {
            this.setRelValue(this.min);
        }
    }

    protected double calculateViewValue(long l) {
        return (double)(l - this.min) / (double)(this.max - this.min);
    }

    protected double calculateViewValue(double d) {
        return (d - (double)this.min) / (double)(this.max - this.min);
    }
}

