/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectUtil {
    public static Project getProject(String string) throws IOException {
        Project project = null;
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        try {
            project = ProjectManager.getDefault().findProject(fileObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return project;
    }

    public static Set<String> getSubprojectsBaseDirs(String string) throws IOException {
        Project project = ProjectUtil.getProject(string);
        if (project != null) {
            return ProjectUtil.getSubprojectsBaseDirs(project);
        }
        return new HashSet<String>();
    }

    public static Set<String> getSubprojectsBaseDirs(Project project) throws IOException {
        SubprojectProvider subprojectProvider;
        HashSet<String> hashSet = new HashSet<String>();
        if (project != null && (subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
            Set set = subprojectProvider.getSubprojects();
            for (Project project2 : set) {
                String string = project2.getProjectDirectory().getPath();
                hashSet.add(string);
                hashSet.addAll(ProjectUtil.getSubprojectsBaseDirs(project2));
            }
        }
        return hashSet;
    }

    public static String getProjectDisplayName(String string) throws IOException {
        Project project = ProjectUtil.getProject(string);
        if (project != null) {
            ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
            return projectInformation.getDisplayName();
        }
        return null;
    }
}

