/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.storage.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.CodeTemplateDescription;
import org.netbeans.lib.editor.codetemplates.storage.CodeTemplateSettingsImpl;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CodeTemplatesModel {
    private final List<String> languages = new ArrayList<String>();
    private final Map<String, String> languageToMimeType = new HashMap<String, String>();
    private final Map<String, TM> languageToModel = new HashMap<String, TM>();
    private final Map<TM, String> modelToLanguage = new HashMap<TM, String>();
    private KeyStroke expander;

    CodeTemplatesModel() {
        Vector<String> vector = new Vector<String>();
        vector.add(CodeTemplatesModel.loc("Abbreviation_Title"));
        vector.add(CodeTemplatesModel.loc("Expanded_Text_Title"));
        vector.add(CodeTemplatesModel.loc("Description_Title"));
        Set set = EditorSettings.getDefault().getAllMimeTypes();
        for (String string : set) {
            String string2;
            MimePath mimePath = MimePath.parse((String)string);
            Map<String, CodeTemplateDescription> map = CodeTemplateSettingsImpl.get(mimePath).getCodeTemplates();
            if (map.isEmpty() && this.isCompoundMimeType(string) || (string2 = EditorSettings.getDefault().getLanguageName(string)).equals(string)) continue;
            this.languages.add(string2);
            Collections.sort(this.languages);
            this.languageToMimeType.put(string2, string);
            ArrayList<Vector<String>> arrayList = new ArrayList<Vector<String>>();
            for (String string3 : map.keySet()) {
                CodeTemplateDescription codeTemplateDescription = map.get(string3);
                Vector<String> vector2 = new Vector<String>(2);
                vector2.add(string3);
                vector2.add(codeTemplateDescription.getParametrizedText());
                vector2.add(codeTemplateDescription.getDescription());
                arrayList.add(vector2);
            }
            Collections.sort(arrayList, new MComparator());
            TM tM = new TM(map, vector, arrayList);
            this.modelToLanguage.put(tM, string2);
            this.languageToModel.put(string2, tM);
        }
        this.expander = CodeTemplateSettingsImpl.get(MimePath.EMPTY).getExpandKey();
    }

    private boolean isCompoundMimeType(String string) {
        int n = string.lastIndexOf(43);
        return n != -1 && n < string.length() - 1;
    }

    List<String> getLanguages() {
        return Collections.unmodifiableList(this.languages);
    }

    String findLanguage(String string) {
        for (String string2 : this.languageToMimeType.keySet()) {
            String string3 = this.languageToMimeType.get(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    String getMimeType(String string) {
        return this.languageToMimeType.get(string);
    }

    TM getTableModel(String string) {
        return this.languageToModel.get(string);
    }

    void saveChanges() {
        for (String string : this.languageToModel.keySet()) {
            TM tM = this.languageToModel.get(string);
            if (!tM.isModified()) continue;
            String string2 = this.languageToMimeType.get(string);
            HashMap<String, CodeTemplateDescription> hashMap = new HashMap<String, CodeTemplateDescription>();
            for (int i = 0; i < tM.getRowCount(); ++i) {
                String string3 = tM.getAbbreviation(i);
                CodeTemplateDescription codeTemplateDescription = new CodeTemplateDescription(string3, tM.getDescription(i), tM.getText(i), tM.getContexts(i), tM.getUniqueId(i), string2);
                hashMap.put(string3, codeTemplateDescription);
            }
            MimePath mimePath = MimePath.parse((String)string2);
            CodeTemplateSettingsImpl.get(mimePath).setCodeTemplates(hashMap);
        }
        if (this.expander != null) {
            CodeTemplateSettingsImpl.get(MimePath.EMPTY).setExpandKey(this.expander);
        }
    }

    boolean isChanged() {
        if (!CodeTemplateSettingsImpl.get(MimePath.EMPTY).getExpandKey().equals(this.expander)) {
            return true;
        }
        for (String string : this.languageToModel.keySet()) {
            TM tM = this.languageToModel.get(string);
            if (!tM.isModified()) continue;
            return true;
        }
        return false;
    }

    private static String loc(String string) {
        return NbBundle.getMessage(CodeTemplatesModel.class, (String)string);
    }

    KeyStroke getExpander() {
        return this.expander;
    }

    void setExpander(KeyStroke keyStroke) {
        this.expander = keyStroke;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TM
    extends DefaultTableModel {
        private final Map<String, CodeTemplateDescription> codeTemplatesMap;
        private boolean modified = false;

        public TM(Map<String, CodeTemplateDescription> map, Vector<String> vector, List<Vector<String>> list) {
            super(new Vector<Vector<String>>(list), vector);
            this.codeTemplatesMap = map;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public String getAbbreviation(int n) {
            return (String)this.getValueAt(n, 0);
        }

        public String getDescription(int n) {
            return (String)this.getValueAt(n, 2);
        }

        public void setDescription(int n, String string) {
            if (TM.compareTexts(string, this.getDescription(n))) {
                return;
            }
            this.setValueAt(string, n, 2);
            this.modified = true;
        }

        public String getText(int n) {
            return (String)this.getValueAt(n, 1);
        }

        public void setText(int n, String string) {
            if (TM.compareTexts(string, this.getText(n))) {
                return;
            }
            this.setValueAt(string, n, 1);
            this.modified = true;
        }

        public List<String> getContexts(int n) {
            CodeTemplateDescription codeTemplateDescription = this.codeTemplatesMap.get(this.getAbbreviation(n));
            return codeTemplateDescription == null ? null : codeTemplateDescription.getContexts();
        }

        public String getUniqueId(int n) {
            CodeTemplateDescription codeTemplateDescription = this.codeTemplatesMap.get(this.getAbbreviation(n));
            return codeTemplateDescription == null ? null : codeTemplateDescription.getUniqueId();
        }

        public int addCodeTemplate(String string) {
            this.addRow(new Object[]{string, "", null});
            this.modified = true;
            return this.getRowCount() - 1;
        }

        public void removeCodeTemplate(int n) {
            this.removeRow(n);
            this.modified = true;
        }

        public boolean isModified() {
            return this.modified;
        }

        private static boolean compareTexts(String string, String string2) {
            if (string == null || string.length() == 0) {
                string = null;
            }
            if (string2 == null || string2.length() == 0) {
                string2 = null;
            }
            if (string != null && string2 != null) {
                return string.equals(string2);
            }
            return string == null && string2 == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MComparator
    implements Comparator<Vector<String>> {
        private MComparator() {
        }

        @Override
        public int compare(Vector<String> vector, Vector<String> vector2) {
            String string = vector.get(0);
            String string2 = vector2.get(0);
            return string.compareTo(string2);
        }
    }
}

