/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates.api;

import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.ParametrizedTextParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeTemplate {
    private final CodeTemplateManagerOperation managerOperation;
    private final String abbreviation;
    private final String description;
    private final String parametrizedText;
    private final List<String> contexts;
    private final String mimePath;
    private String singleLineText = null;

    CodeTemplate(CodeTemplateManagerOperation codeTemplateManagerOperation, String string, String string2, String string3, List<String> list, String string4) {
        assert (codeTemplateManagerOperation != null);
        if (string == null) {
            throw new NullPointerException("abbreviation cannot be null");
        }
        if (string3 == null) {
            throw new NullPointerException("parametrizedText cannot be null");
        }
        this.managerOperation = codeTemplateManagerOperation;
        this.abbreviation = string;
        this.description = string2;
        this.parametrizedText = string3;
        this.contexts = list;
        this.mimePath = string4;
    }

    public void insert(JTextComponent jTextComponent) {
        CodeTemplateManagerOperation.insert(this, jTextComponent);
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getDescription() {
        return this.description;
    }

    public String getParametrizedText() {
        return this.parametrizedText;
    }

    public List<String> getContexts() {
        return this.contexts;
    }

    CodeTemplateManagerOperation getOperation() {
        return this.managerOperation;
    }

    String getSingleLineText() {
        if (this.singleLineText == null) {
            int n = this.parametrizedText.indexOf(10);
            String string = n != -1 ? this.parametrizedText.substring(0, n) + "..." : this.parametrizedText;
            this.singleLineText = ParametrizedTextParser.parseToHtml(new StringBuffer(), string).toString();
        }
        return this.singleLineText;
    }

    String getMimePath() {
        return this.mimePath;
    }

    public String toString() {
        return "abbrev='" + this.getAbbreviation() + "', parametrizedText='" + this.getParametrizedText() + "'";
    }
}

