/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.codetemplates.CodeTemplateParameterImpl;
import org.netbeans.lib.editor.codetemplates.CodeTemplateSpiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.ParametrizedTextParser;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegion;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegionEditing;
import org.netbeans.lib.editor.codetemplates.textsync.TextRegionManager;
import org.netbeans.lib.editor.codetemplates.textsync.TextSync;
import org.netbeans.lib.editor.codetemplates.textsync.TextSyncGroup;
import org.netbeans.lib.editor.codetemplates.textsync.TextSyncGroupEditingNotify;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.CharacterConversions;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeTemplateInsertHandler
implements TextSyncGroupEditingNotify,
Runnable {
    private static final Logger LOG = Logger.getLogger(CodeTemplateInsertHandler.class.getName());
    private static final Logger TIMERS = Logger.getLogger("TIMER");
    private static final Object CT_HANDLER_DOC_PROPERTY = "code-template-insert-handler";
    private final CodeTemplate codeTemplate;
    private final JTextComponent component;
    private final List<CodeTemplateProcessor> processors;
    private String parametrizedText;
    private ParametrizedTextParser parametrizedTextParser;
    private String insertText;
    private List<CodeTemplateParameter> allParameters;
    private List<CodeTemplateParameter> masterParameters;
    private CodeTemplateInsertRequest request;
    private boolean inserted;
    private boolean released;
    private boolean completionInvoke;
    private TextRegion completeTextRegion;
    private String completeInsertString;
    private Formatter formatter;
    private TextSyncGroup textSyncGroup;
    private CodeTemplateParameterImpl lastActiveMasterImpl;
    private CodeTemplateInsertHandler outerHandler;

    public CodeTemplateInsertHandler(CodeTemplate codeTemplate, JTextComponent jTextComponent, Collection<? extends CodeTemplateProcessorFactory> collection) {
        this.codeTemplate = codeTemplate;
        this.component = jTextComponent;
        this.completeTextRegion = new TextRegion();
        TextSync textSync = new TextSync(this.completeTextRegion);
        this.textSyncGroup = new TextSyncGroup(textSync);
        this.request = CodeTemplateSpiPackageAccessor.get().createInsertRequest(this);
        this.processors = new ArrayList<CodeTemplateProcessor>();
        for (CodeTemplateProcessorFactory codeTemplateProcessorFactory : collection) {
            this.processors.add(codeTemplateProcessorFactory.createProcessor(this.request));
        }
        this.setParametrizedText(codeTemplate.getParametrizedText());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Created " + super.toString() + "\n");
        }
        if (TIMERS.isLoggable(Level.FINE)) {
            LogRecord logRecord = new LogRecord(Level.FINE, "CodeTemplateInsertHandler");
            logRecord.setParameters(new Object[]{this});
            TIMERS.log(logRecord);
        }
    }

    public CodeTemplate getCodeTemplate() {
        return this.codeTemplate;
    }

    public JTextComponent getComponent() {
        return this.component;
    }

    public CodeTemplateInsertRequest getRequest() {
        return this.request;
    }

    public synchronized boolean isInserted() {
        return this.inserted;
    }

    public synchronized boolean isReleased() {
        return this.released;
    }

    public boolean isSuspended() {
        return this.textRegionEditing().activeTextSyncGroup() == this.textSyncGroup;
    }

    public String getParametrizedText() {
        return this.parametrizedText;
    }

    public void setParametrizedText(String string) {
        this.parametrizedText = CharacterConversions.lineSeparatorToLineFeed((CharSequence)string);
        this.parseParametrizedText();
    }

    public int getInsertOffset() {
        return this.completeTextRegion.startOffset();
    }

    public String getInsertText() {
        if (this.inserted) {
            try {
                int n = this.getInsertOffset();
                Document document = this.component.getDocument();
                return document.getText(n, this.completeTextRegion.endOffset() - n);
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.WARNING, "Invalid offset", badLocationException);
                return "";
            }
        }
        this.checkInsertTextBuilt();
        return this.insertText;
    }

    public List<? extends CodeTemplateParameter> getAllParameters() {
        return Collections.unmodifiableList(this.allParameters);
    }

    public List<? extends CodeTemplateParameter> getMasterParameters() {
        return Collections.unmodifiableList(this.masterParameters);
    }

    public void processTemplate() {
        for (CodeTemplateProcessor codeTemplateProcessor : this.processors) {
            codeTemplateProcessor.updateDefaultValues();
        }
        this.insertTemplate();
        this.textRegionEditing().startGroupEditing(this.textSyncGroup, this);
        this.checkInvokeCompletion();
    }

    void checkInsertTextBuilt() {
        if (this.insertText == null) {
            this.insertText = this.buildInsertText();
        }
    }

    void resetCachedInsertText() {
        this.insertText = null;
    }

    CodeTemplateParameterImpl lastActiveMasterImpl() {
        return this.lastActiveMasterImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTemplate() {
        Document document = this.component.getDocument();
        this.outerHandler = (CodeTemplateInsertHandler)document.getProperty(CT_HANDLER_DOC_PROPERTY);
        document.putProperty(CT_HANDLER_DOC_PROPERTY, this);
        this.completeInsertString = this.getInsertText();
        BaseDocument baseDocument = document instanceof BaseDocument ? (BaseDocument)document : null;
        this.formatter = null;
        if (baseDocument != null) {
            this.formatter = baseDocument.getFormatter();
            if (this.formatter != null) {
                this.formatter.reformatLock();
            }
        }
        try {
            if (baseDocument != null) {
                baseDocument.runAtomicAsUser((Runnable)this);
            } else {
                this.run();
            }
        }
        finally {
            if (baseDocument != null) {
                if (this.formatter != null) {
                    this.formatter.reformatUnlock();
                }
                this.formatter = null;
            }
            this.completeInsertString = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int n;
            Document document = this.component.getDocument();
            BaseDocument baseDocument = document instanceof BaseDocument ? (BaseDocument)document : null;
            Caret caret = this.component.getCaret();
            if (Utilities.isSelectionShowing((Caret)caret)) {
                n = this.component.getSelectionStart();
                int n2 = this.component.getSelectionEnd() - n;
                document.remove(n, n2);
            }
            n = this.component.getCaretPosition();
            this.completeTextRegion.updateBounds(null, TextRegion.createFixedPosition(this.completeInsertString.length()));
            document.insertString(n, this.completeInsertString, null);
            if (baseDocument != null) {
                baseDocument.addUndoableEdit((UndoableEdit)new TemplateInsertUndoEdit(document));
            }
            TextRegion textRegion = null;
            for (CodeTemplateParameter object : this.masterParameters) {
                CodeTemplateParameterImpl codeTemplateParameterImpl = CodeTemplateParameterImpl.get(object);
                if ("cursor".equals(object.getName())) {
                    textRegion = codeTemplateParameterImpl.textRegion();
                    this.completionInvoke = object.getHints().get("completionInvoke") != null;
                }
                this.textSyncGroup.addTextSync(codeTemplateParameterImpl.textRegion().textSync());
            }
            if (textRegion == null) {
                Position position = TextRegion.createFixedPosition(this.completeInsertString.length());
                TextSync textSync = new TextSync(new TextRegion(position, position));
                textSync.setCaretMarker(true);
                this.textSyncGroup.addTextSync(textSync);
            }
            this.textRegionManager().addTextSyncGroup(this.textSyncGroup, n);
            if (baseDocument != null) {
                this.formatter.reformat(baseDocument, n, n + this.completeInsertString.length());
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, "Invalid offset", badLocationException);
        }
        finally {
            this.inserted = true;
            this.resetCachedInsertText();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("CodeTemplateInsertHandler.insertTemplate()\n");
            LOG.fine(this.toString());
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this.textRegionManager().toString() + "\n");
            }
        }
    }

    private TextRegionEditing textRegionEditing() {
        return TextRegionEditing.get(this.component);
    }

    private TextRegionManager textRegionManager() {
        return TextRegionManager.get(this.component.getDocument());
    }

    public String getDocParameterValue(CodeTemplateParameterImpl codeTemplateParameterImpl) {
        String string;
        TextRegion textRegion = codeTemplateParameterImpl.textRegion();
        int n = textRegion.startOffset();
        int n2 = textRegion.endOffset() - n;
        try {
            string = this.component.getDocument().getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, "Invalid offset", badLocationException);
            string = "";
        }
        return string;
    }

    public void setDocMasterParameterValue(CodeTemplateParameterImpl codeTemplateParameterImpl, String string) {
        assert (!codeTemplateParameterImpl.isSlave());
        TextRegion textRegion = codeTemplateParameterImpl.textRegion();
        int n = textRegion.startOffset();
        int n2 = textRegion.endOffset() - n;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("CodeTemplateInsertHandler.setMasterParameterValue(): parameter-name=" + codeTemplateParameterImpl.getName() + ", offset=" + n + ", length=" + n2 + ", newValue=\"" + string + "\"\n");
        }
        try {
            Document document = this.component.getDocument();
            CharSequence charSequence = DocumentUtilities.getText((Document)document, (int)n, (int)n2);
            if (!CharSequenceUtilities.textEquals((CharSequence)charSequence, (CharSequence)string)) {
                textRegion.textSync().setText(string);
                this.notifyParameterUpdate(codeTemplateParameterImpl.getParameter(), false);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, "Invalid offset", badLocationException);
        }
    }

    private void notifyParameterUpdate(CodeTemplateParameter codeTemplateParameter, boolean bl) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(super.toString() + "notifyParameterUpdate() CALLED for " + codeTemplateParameter.getName() + "\n");
            LOG.fine(this.toString());
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(this.textRegionManager().toString() + "\n");
            }
        }
        for (CodeTemplateProcessor codeTemplateProcessor : this.processors) {
            codeTemplateProcessor.parameterValueChanged(codeTemplateParameter, bl);
        }
    }

    private void parseParametrizedText() {
        this.allParameters = new ArrayList<CodeTemplateParameter>(2);
        this.masterParameters = new ArrayList<CodeTemplateParameter>(2);
        this.parametrizedTextParser = new ParametrizedTextParser(this, this.parametrizedText);
        this.parametrizedTextParser.parse();
    }

    void notifyParameterParsed(CodeTemplateParameterImpl codeTemplateParameterImpl) {
        this.allParameters.add(codeTemplateParameterImpl.getParameter());
        for (CodeTemplateParameter codeTemplateParameter : this.masterParameters) {
            if (!codeTemplateParameter.getName().equals(codeTemplateParameterImpl.getName())) continue;
            codeTemplateParameterImpl.markSlave(codeTemplateParameter);
            CodeTemplateParameterImpl codeTemplateParameterImpl2 = CodeTemplateParameterImpl.get(codeTemplateParameter);
            TextSync textSync = codeTemplateParameterImpl2.textRegion().textSync();
            textSync.addRegion(codeTemplateParameterImpl.textRegion());
            return;
        }
        this.masterParameters.add(codeTemplateParameterImpl.getParameter());
        TextSync textSync = new TextSync(codeTemplateParameterImpl.textRegion());
        if (codeTemplateParameterImpl.isEditable()) {
            textSync.setEditable(true);
        }
        if ("cursor".equals(codeTemplateParameterImpl.getName())) {
            textSync.setCaretMarker(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Object object = this;
        synchronized (object) {
            if (this.released) {
                return;
            }
            this.released = true;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(super.toString() + "release() CALLED\n");
            LOG.fine(this.toString());
        }
        if (this.outerHandler != null) {
            object = this.outerHandler.lastActiveMasterImpl();
            TextSync textSync = ((CodeTemplateParameterImpl)object).textRegion().textSync();
            textSync.syncByMaster();
            ((CodeTemplateParameterImpl)object).markUserModified();
            this.outerHandler.notifyParameterUpdate(((CodeTemplateParameterImpl)object).getParameter(), true);
        }
        object = this.component.getDocument();
        object.putProperty(CT_HANDLER_DOC_PROPERTY, this.outerHandler);
        for (CodeTemplateProcessor codeTemplateProcessor : this.processors) {
            codeTemplateProcessor.release();
        }
        this.textRegionEditing().stopGroupEditing(this.textSyncGroup);
        this.textRegionManager().removeTextSyncGroup(this.textSyncGroup);
    }

    private String buildInsertText() {
        return this.parametrizedTextParser.buildInsertText(this.allParameters);
    }

    @Override
    public void deactivated(TextRegionEditing textRegionEditing, TextSync textSync) {
        if (textSync != null) {
            this.lastActiveMasterImpl = (CodeTemplateParameterImpl)textSync.masterRegion().clientInfo();
        }
    }

    @Override
    public void released(TextRegionEditing textRegionEditing) {
        this.release();
        this.checkInvokeCompletion();
    }

    @Override
    public void textSyncActivated(TextRegionEditing textRegionEditing, int n) {
    }

    @Override
    public void textSyncModified(TextRegionEditing textRegionEditing) {
        TextSync textSync = textRegionEditing.activeTextSync();
        CodeTemplateParameterImpl codeTemplateParameterImpl = (CodeTemplateParameterImpl)textSync.masterRegion().clientInfo();
        if (codeTemplateParameterImpl != null) {
            codeTemplateParameterImpl.markUserModified();
            this.notifyParameterUpdate(codeTemplateParameterImpl.getParameter(), true);
        }
    }

    private void checkInvokeCompletion() {
        if (this.completionInvoke) {
            this.completionInvoke = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Completion.get().showCompletion();
                }
            });
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CodeTemplateParameter codeTemplateParameter : this.allParameters) {
            CodeTemplateParameterImpl codeTemplateParameterImpl = CodeTemplateParameterImpl.get(codeTemplateParameter);
            stringBuilder.append("  ").append(codeTemplateParameterImpl.getName()).append(":");
            stringBuilder.append(codeTemplateParameterImpl.textRegion());
            if (!codeTemplateParameterImpl.isSlave()) {
                stringBuilder.append(" Master");
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static final class TemplateInsertUndoEdit
    extends AbstractUndoableEdit {
        private Document doc;

        TemplateInsertUndoEdit(Document document) {
            assert (document != null);
            this.doc = document;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            CodeTemplateInsertHandler codeTemplateInsertHandler = (CodeTemplateInsertHandler)this.doc.getProperty(CT_HANDLER_DOC_PROPERTY);
            if (codeTemplateInsertHandler != null) {
                codeTemplateInsertHandler.release();
            }
        }
    }
}

