/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.CodeTemplateApiPackageAccessor;
import org.netbeans.lib.editor.codetemplates.CodeTemplateManagerOperation;
import org.netbeans.lib.editor.codetemplates.ParametrizedTextParser;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class CodeTemplateCompletionItem
implements CompletionItem {
    private static ImageIcon icon;
    private final CodeTemplate codeTemplate;
    private String rightText;

    public CodeTemplateCompletionItem(CodeTemplate codeTemplate) {
        this.codeTemplate = codeTemplate;
    }

    private String getLeftText() {
        return CodeTemplateApiPackageAccessor.get().getSingleLineText(this.codeTemplate);
    }

    private String getRightText() {
        if (this.rightText == null) {
            this.rightText = ParametrizedTextParser.toHtmlText(this.codeTemplate.getAbbreviation());
        }
        return this.rightText;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftText(), (String)this.getRightText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        if (icon == null) {
            icon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/lib/editor/codetemplates/resources/code_template.png"));
        }
        CompletionUtilities.renderHtml((ImageIcon)icon, (String)this.getLeftText(), (String)this.getRightText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public void defaultAction(JTextComponent jTextComponent) {
        Completion.get().hideAll();
        Document document = jTextComponent.getDocument();
        int n = jTextComponent.getSelectionStart();
        int n2 = CodeTemplateCompletionItem.getInitialMatchLength(document, n, this.codeTemplate.getParametrizedText());
        if (n2 > 0) {
            try {
                document.remove(n - n2, n2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.codeTemplate.insert(jTextComponent);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        return false;
    }

    public static int getInitialMatchLength(Document document, int n, String string) {
        int n2;
        CharSequence charSequence = DocumentUtilities.getText((Document)((BaseDocument)document));
        for (n2 = Math.min(string.length(), n); n2 > 0; --n2) {
            int n3;
            for (n3 = 1; n3 < n2 && charSequence.charAt(n - n3) == string.charAt(n2 - n3); ++n3) {
            }
            if (n3 == n2) break;
        }
        return n2;
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(this.codeTemplate));
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getSortPriority() {
        return 650;
    }

    public CharSequence getSortText() {
        return "";
    }

    public CharSequence getInsertPrefix() {
        String string = this.codeTemplate.getParametrizedText();
        int n = string.indexOf("${");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static final class DocItem
    implements CompletionDocumentation {
        private String text;

        DocItem(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }

        public CompletionDocumentation resolveLink(String string) {
            return null;
        }

        public URL getURL() {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static final class DocQuery
    extends AsyncCompletionQuery {
        private CodeTemplate codeTemplate;

        DocQuery(CodeTemplate codeTemplate) {
            this.codeTemplate = codeTemplate;
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><pre>");
            ParametrizedTextParser.parseToHtml(stringBuffer, this.codeTemplate.getParametrizedText());
            stringBuffer.append("</pre>");
            String string = this.codeTemplate.getDescription();
            if (string != null && string.length() > 0) {
                stringBuffer.append("<p>").append(string).append("</p>");
            }
            CodeTemplateManagerOperation codeTemplateManagerOperation = CodeTemplateApiPackageAccessor.get().getOperation(this.codeTemplate);
            stringBuffer.append("<p>");
            stringBuffer.append(NbBundle.getMessage(CodeTemplateCompletionItem.class, (String)"DOC_ITEM_Abbreviation", (Object)ParametrizedTextParser.toHtmlText(this.codeTemplate.getAbbreviation()), (Object)codeTemplateManagerOperation.getExpandKeyStrokeText()));
            stringBuffer.append("<p>");
            completionResultSet.setDocumentation((CompletionDocumentation)new DocItem(stringBuffer.toString()));
            completionResultSet.finish();
        }
    }
}

