/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.text.completion.support.grammar;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.netbeans.modules.xslt.core.text.completion.support.grammar.XSLGrammarConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLGrammarUtil
implements XSLGrammarConstants {
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private static final Set<String> setSupportedXslVersions = new HashSet<String>(Arrays.asList("1.0", "1.1", "2.0"));

    public static boolean isSupportedXslVersion(String string) {
        return setSupportedXslVersions.contains(string);
    }

    public static Tag getStylesheet(Tag tag) {
        if (tag == null) {
            return null;
        }
        String string = tag.getTagName();
        if (string != null && string.contains("stylesheet")) {
            return tag;
        }
        return XSLGrammarUtil.getParentTagByName(tag, "stylesheet");
    }

    public static Tag getStylesheet(Document document) {
        if (document == null) {
            return null;
        }
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (!string.contains("stylesheet") || !(node instanceof Tag)) continue;
            return (Tag)node;
        }
        return null;
    }

    public static Tag getParentTagByName(Tag tag, String string) {
        if (tag == null || string == null) {
            return null;
        }
        Object object = tag;
        while (object != null) {
            String string2;
            if (!((object = object.getParentNode()) instanceof Tag) || !(string2 = object.getTagName()).contains(string)) continue;
            return object;
        }
        return null;
    }

    public static String getCurrentXslVersion(Object object, XSLGrammarConstants.COMPLETION_QUERY_TYPE cOMPLETION_QUERY_TYPE) {
        if (object == null || cOMPLETION_QUERY_TYPE == null) {
            return null;
        }
        String string = null;
        Tag tag = null;
        try {
            Node node;
            if (cOMPLETION_QUERY_TYPE.equals((Object)XSLGrammarConstants.COMPLETION_QUERY_TYPE.QueryTagName)) {
                tag = (Tag)((Node)object).getParentNode();
            } else if (cOMPLETION_QUERY_TYPE.equals((Object)XSLGrammarConstants.COMPLETION_QUERY_TYPE.QueryAttributeName)) {
                node = ((Node)object).getParentNode();
                if (node instanceof Document) {
                    string = XSLGrammarUtil.getCurrentXslVersion((Node)object);
                } else if (node instanceof Tag) {
                    tag = (Tag)node;
                }
            } else if (cOMPLETION_QUERY_TYPE.equals((Object)XSLGrammarConstants.COMPLETION_QUERY_TYPE.QueryAttributeValue)) {
                tag = (Tag)((Attr)object).getOwnerElement();
            }
            if (string == null) {
                node = XSLGrammarUtil.getStylesheet(tag);
                string = node.getAttribute(ATTRIBUTE_NAME_VERSION);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(XSLGrammarUtil.class.getName()).log(Level.INFO, exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage(), exception);
            return null;
        }
        return XSLGrammarUtil.isSupportedXslVersion(string) ? string : null;
    }

    private static String getCurrentXslVersion(Node node) {
        if (node == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem(ATTRIBUTE_NAME_VERSION);
        if (node2 == null) {
            return null;
        }
        String string = node2.getNodeValue();
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }
}

