/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.text.completion.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.xslt.core.text.completion.IllegalXsltVersionException;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionConstants;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionResultItem;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionUtil;
import org.netbeans.modules.xslt.core.text.completion.XSLTEditorComponentHolder;
import org.netbeans.modules.xslt.core.text.completion.handler.AttributeValueHolderImpl_1_0;
import org.netbeans.modules.xslt.core.text.completion.handler.AttributeValueHolderImpl_1_1;
import org.netbeans.modules.xslt.core.text.completion.handler.AttributeValueHolderImpl_2_0;
import org.netbeans.modules.xslt.core.text.completion.handler.AttributeValuesHolder;
import org.netbeans.modules.xslt.core.text.completion.handler.BaseCompletionHandler;
import org.netbeans.modules.xslt.model.InvalidAttributeValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerAttributeEnumValues
extends BaseCompletionHandler
implements XSLTCompletionConstants {
    private static Map<String, AttributeValuesHolder> mapAttributeValuesHolders = new HashMap<String, AttributeValuesHolder>(3);

    @Override
    public List<XSLTCompletionResultItem> getResultItemList(XSLTEditorComponentHolder xSLTEditorComponentHolder) {
        this.initHandler(xSLTEditorComponentHolder);
        return this.getAttributeEnumValueList();
    }

    private List<XSLTCompletionResultItem> getAttributeEnumValueList() {
        if (this.surroundTag == null || this.attributeName == null || this.xslModel == null) {
            return Collections.emptyList();
        }
        try {
            String string = this.xslModel.getStylesheet().getVersion().toString().trim();
            if (!setSupportedXsltVersions.contains(string)) {
                throw new IllegalXsltVersionException(string);
            }
            AttributeValuesHolder attributeValuesHolder = mapAttributeValuesHolders.get(string);
            if (attributeValuesHolder != null) {
                String string2 = XSLTCompletionUtil.ignoreNamespace(this.surroundTag.getTagName());
                List<String> list = attributeValuesHolder.getAttributeValues(string2, this.attributeName);
                ArrayList<XSLTCompletionResultItem> arrayList = new ArrayList<XSLTCompletionResultItem>();
                for (String string3 : list) {
                    arrayList.add(new XSLTCompletionResultItem(string3, this.document, this.caretOffset));
                }
                return arrayList;
            }
        }
        catch (IllegalXsltVersionException illegalXsltVersionException) {
            Logger.getLogger(HandlerAttributeEnumValues.class.getName()).log(Level.WARNING, illegalXsltVersionException.getMessage(), illegalXsltVersionException);
            return Collections.emptyList();
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            Logger.getLogger(HandlerAttributeEnumValues.class.getName()).log(Level.WARNING, invalidAttributeValueException.getMessage(), invalidAttributeValueException);
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    static {
        mapAttributeValuesHolders.put("1.0", new AttributeValueHolderImpl_1_0());
        mapAttributeValuesHolders.put("1.1", new AttributeValueHolderImpl_1_1());
        mapAttributeValuesHolders.put("2.0", new AttributeValueHolderImpl_2_0());
    }
}

