/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.text.completion.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionModelProvider;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionResultItem;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionUtil;
import org.netbeans.modules.xslt.core.text.completion.XSLTEditorComponentHolder;
import org.netbeans.modules.xslt.core.text.completion.handler.XSLTCompletionHandler;
import org.netbeans.modules.xslt.model.XslModel;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCompletionHandler
implements XSLTCompletionHandler {
    protected JEditorPane srcEditorPane;
    protected Document document;
    protected int caretOffset;
    protected XslModel xslModel;
    protected Tag surroundTag;
    protected String attributeName;
    protected SchemaModel schemaModel;

    @Override
    public List<XSLTCompletionResultItem> getResultItemList(XSLTEditorComponentHolder xSLTEditorComponentHolder) {
        return Collections.emptyList();
    }

    protected void initHandler(XSLTEditorComponentHolder xSLTEditorComponentHolder) {
        this.srcEditorPane = null;
        if (xSLTEditorComponentHolder == null) {
            return;
        }
        this.srcEditorPane = xSLTEditorComponentHolder.getSourceEditorComponent();
        if (this.srcEditorPane == null) {
            return;
        }
        this.document = null;
        this.document = this.srcEditorPane.getDocument();
        if (this.document == null) {
            return;
        }
        this.caretOffset = 0;
        this.caretOffset = this.srcEditorPane.getCaretPosition();
        this.xslModel = null;
        this.xslModel = XSLTCompletionUtil.getXslModel();
        if (this.xslModel == null) {
            return;
        }
        this.surroundTag = null;
        this.surroundTag = this.findSurroundTag(this.srcEditorPane);
        if (this.surroundTag == null) {
            return;
        }
        this.attributeName = XSLTCompletionUtil.getAttributeNameBeforeCaret(this.document, this.caretOffset, (SyntaxElement)this.surroundTag);
        if (this.attributeName == null) {
            return;
        }
        CompletionModelProvider.CompletionModel completionModel = new XSLTCompletionModelProvider().getCompletionModel();
        if (completionModel == null || completionModel.getSchemaModel() == null) {
            return;
        }
        this.schemaModel = null;
        this.schemaModel = completionModel.getSchemaModel();
    }

    protected Tag findSurroundTag(JEditorPane jEditorPane) {
        if (jEditorPane == null) {
            return null;
        }
        XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)((BaseDocument)this.document).getSyntaxSupport();
        if (xMLSyntaxSupport == null) {
            return null;
        }
        SyntaxElement syntaxElement = null;
        try {
            syntaxElement = xMLSyntaxSupport.getElementChain(this.caretOffset);
            if (!(syntaxElement instanceof Tag)) {
                return null;
            }
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(BaseCompletionHandler.class.getName());
            logger.log(Level.INFO, exception.getMessage(), exception);
            return null;
        }
        return (Tag)syntaxElement;
    }

    protected List<XSLTCompletionResultItem> getIncorrectDocumentResultItem() {
        XSLTCompletionResultItem xSLTCompletionResultItem = new XSLTCompletionResultItem(NbBundle.getMessage(XSLTCompletionResultItem.class, (String)"DOCUMENT_IS_NOT_CORRECT"), this.document, this.caretOffset, false);
        return new ArrayList<XSLTCompletionResultItem>(Arrays.asList(xSLTCompletionResultItem));
    }
}

