/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core.text.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xslt.core.XSLTDataEditorSupport;
import org.netbeans.modules.xslt.core.text.completion.XSLTCompletionConstants;
import org.netbeans.modules.xslt.model.XslModel;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTCompletionUtil
implements XSLTCompletionConstants {
    public static String getAttributeNameBeforeCaret(Document document, int n, SyntaxElement syntaxElement) {
        if (document == null || syntaxElement == null || n < 0) {
            return null;
        }
        int n2 = syntaxElement.getElementOffset();
        if (n2 < 0) {
            return null;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            XSLTCompletionUtil.getAttributeNameBeforeCaret(stringBuffer, document, n2, n, AttributeNameParsingState.START_PARSING);
            return stringBuffer.length() < 1 ? null : stringBuffer.toString();
        }
        catch (Exception exception) {
            Logger.getLogger(XSLTCompletionUtil.class.getName()).log(Level.INFO, exception.getMessage(), exception);
            return null;
        }
    }

    private static void getAttributeNameBeforeCaret(StringBuffer stringBuffer, Document document, int n, int n2, AttributeNameParsingState attributeNameParsingState) throws Exception {
        while (n2 > n && --n2 > n) {
            String string = document.getText(n2, 1);
            char c = string.charAt(0);
            if (attributeNameParsingState.equals((Object)AttributeNameParsingState.START_PARSING)) {
                if (c != '\"') continue;
                attributeNameParsingState = AttributeNameParsingState.LEFT_QUOTE_FOUND;
                continue;
            }
            if (attributeNameParsingState.equals((Object)AttributeNameParsingState.LEFT_QUOTE_FOUND)) {
                if (c == '=') {
                    attributeNameParsingState = AttributeNameParsingState.EQUAL_SIGN_FOUND;
                    continue;
                }
                if (Character.isSpaceChar(c)) continue;
                break;
            }
            if (attributeNameParsingState.equals((Object)AttributeNameParsingState.EQUAL_SIGN_FOUND)) {
                if (Character.isSpaceChar(c)) continue;
                attributeNameParsingState = AttributeNameParsingState.CHAR_OF_NAME_FOUND;
                stringBuffer.insert(0, string);
                continue;
            }
            if (!attributeNameParsingState.equals((Object)AttributeNameParsingState.CHAR_OF_NAME_FOUND)) continue;
            if (Character.isSpaceChar(c)) break;
            stringBuffer.insert(0, string);
        }
    }

    public static <T extends SchemaComponent> List<T> collectChildrenOfType(List<SchemaComponent> list, Class<T> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (SchemaComponent schemaComponent : list) {
            if (schemaComponent == null) continue;
            if (clazz.isAssignableFrom(schemaComponent.getClass())) {
                arrayList.add(schemaComponent);
                continue;
            }
            List list2 = schemaComponent.getChildren();
            List<T> list3 = XSLTCompletionUtil.collectChildrenOfType(list2, clazz);
            if (list3 == null || list3.isEmpty()) continue;
            arrayList.addAll(list3);
        }
        return arrayList;
    }

    public static String getAttributeType(List<Attribute> list, String string) {
        for (Attribute attribute : list) {
            String string2 = attribute.getPeer().getAttribute("name");
            if (string2 == null || !string2.equals(string)) continue;
            String string3 = attribute.getPeer().getAttribute("type");
            return string3;
        }
        return null;
    }

    public static String ignoreNamespace(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        if (n > -1 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static XSLTDataEditorSupport getXsltDataEditorSupport() {
        try {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            XSLTDataEditorSupport xSLTDataEditorSupport = (XSLTDataEditorSupport)((Object)topComponent.getLookup().lookup(XSLTDataEditorSupport.class));
            return xSLTDataEditorSupport;
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(XSLTCompletionUtil.class.getName());
            logger.log(Level.INFO, null, exception);
            return null;
        }
    }

    public static XslModel getXslModel() {
        XSLTDataEditorSupport xSLTDataEditorSupport = XSLTCompletionUtil.getXsltDataEditorSupport();
        if (xSLTDataEditorSupport == null) {
            return null;
        }
        XslModel xslModel = xSLTDataEditorSupport.getXslModel();
        return xslModel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AttributeNameParsingState {
        START_PARSING,
        LEFT_QUOTE_FOUND,
        EQUAL_SIGN_FOUND,
        CHAR_OF_NAME_FOUND;

    }
}

