/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeleteSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class DeleteAction
extends SystemAction {
    public void actionPerformed(ActionEvent actionEvent) {
        final DesignDocument designDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (designDocument == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                designDocument.getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        DeleteSupport.invokeDirectUserDeletion(designDocument, designDocument.getSelectedComponents(), true);
                    }
                });
            }
        });
    }

    public boolean isEnabled() {
        final DesignDocument designDocument = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (designDocument == null) {
            return false;
        }
        final boolean[] blArray = new boolean[1];
        designDocument.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                blArray[0] = DeleteSupport.canDeleteAsUser(designDocument, designDocument.getSelectedComponents());
            }
        });
        return blArray[0];
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public String getName() {
        return NbBundle.getMessage(DeleteAction.class, (String)"NAME_DeleteAction");
    }
}

