/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastTargetExecuted {
    private static File buildScript;
    private static String[] targets;
    private static Map<String, String> properties;
    private static String displayName;
    private static final ChangeSupport cs;

    private LastTargetExecuted() {
    }

    static void record(File file, String[] stringArray, Map<String, String> map, String string) {
        buildScript = file;
        targets = stringArray;
        properties = map;
        displayName = string;
        cs.fireChange();
    }

    public static AntProjectCookie getLastBuildScript() {
        if (buildScript != null && buildScript.isFile()) {
            FileObject fileObject = FileUtil.toFileObject((File)buildScript);
            assert (fileObject != null);
            return AntScriptUtils.antProjectCookieFor(fileObject);
        }
        return null;
    }

    public static String[] getLastTargets() {
        return targets;
    }

    public static String getProcessDisplayName() {
        return displayName;
    }

    public static ExecutorTask rerun() throws IOException {
        AntProjectCookie antProjectCookie = LastTargetExecuted.getLastBuildScript();
        if (antProjectCookie == null) {
            cs.fireChange();
            return null;
        }
        TargetExecutor targetExecutor = new TargetExecutor(antProjectCookie, targets);
        targetExecutor.setProperties(properties);
        targetExecutor.setDisplayName(displayName);
        return targetExecutor.execute();
    }

    public static void addChangeListener(ChangeListener changeListener) {
        cs.addChangeListener(changeListener);
    }

    public static void removeChangeListener(ChangeListener changeListener) {
        cs.removeChangeListener(changeListener);
    }

    static {
        cs = new ChangeSupport(LastTargetExecuted.class);
    }
}

