/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.impl.ScanMonitor;
import org.netbeans.modules.tasklist.impl.ScannerList;
import org.netbeans.modules.tasklist.impl.TaskCache;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileScanningWorker
implements Runnable {
    private TaskCache cache;
    private TaskList taskList;
    private boolean isCancel = false;
    private TaskManagerImpl.FileScannerProgress progress;
    private Set<FileTaskScanner> preparedScanners = new HashSet<FileTaskScanner>();
    private Iterator<FileObject> resourceIterator;
    private Queue<FileObject> priorityResourceIterator = new LinkedList<FileObject>();
    private Map<FileObject, Collection<FileTaskScanner>> priorityResource2scanner = new HashMap<FileObject, Collection<FileTaskScanner>>();
    private TaskFilter filter;
    private final Object SCAN_LOCK = new Object();
    private final Object SLEEP_LOCK = new Object();
    private boolean killed = false;
    private List<Task> scannedTasks = new LinkedList<Task>();

    public FileScanningWorker(TaskCache taskCache, TaskList taskList, TaskFilter taskFilter, TaskManagerImpl.FileScannerProgress fileScannerProgress) {
        this.cache = taskCache;
        this.taskList = taskList;
        this.filter = taskFilter;
        this.progress = fileScannerProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Iterator<FileObject> iterator, TaskFilter taskFilter) {
        this.abort();
        Object object = this.SLEEP_LOCK;
        synchronized (object) {
            this.filter = taskFilter;
            List<FileTaskScanner> list = ScannerList.getFileScannerList().getScanners();
            for (FileTaskScanner fileTaskScanner : list) {
                if (!taskFilter.isEnabled(fileTaskScanner) || this.preparedScanners.contains(fileTaskScanner)) continue;
                fileTaskScanner.notifyPrepare();
                this.preparedScanners.add(fileTaskScanner);
            }
            this.resourceIterator = iterator;
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void priorityScan(FileTaskScanner fileTaskScanner, FileObject ... fileObjectArray) {
        boolean bl = false;
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            boolean bl2 = bl = this.isCancel || !this.hasNext();
            if (this.filter.isEnabled(fileTaskScanner)) {
                if (!this.preparedScanners.contains(fileTaskScanner)) {
                    fileTaskScanner.notifyPrepare();
                    this.preparedScanners.add(fileTaskScanner);
                }
                for (FileObject fileObject : fileObjectArray) {
                    Collection<FileTaskScanner> collection = this.priorityResource2scanner.get(fileObject);
                    if (null == collection) {
                        collection = new ArrayList<FileTaskScanner>(10);
                        this.priorityResource2scanner.put(fileObject, collection);
                    }
                    if (this.priorityResourceIterator.contains(fileObject)) continue;
                    this.priorityResourceIterator.offer(fileObject);
                }
            }
        }
        if (bl) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void priorityScan(FileObject ... fileObjectArray) {
        boolean bl = false;
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            bl = this.isCancel || !this.hasNext();
            List<FileTaskScanner> list = ScannerList.getFileScannerList().getScanners();
            for (FileTaskScanner fileTaskScanner : list) {
                if (!this.filter.isEnabled(fileTaskScanner) || this.preparedScanners.contains(fileTaskScanner)) continue;
                fileTaskScanner.notifyPrepare();
                this.preparedScanners.add(fileTaskScanner);
            }
            for (FileObject fileObject : fileObjectArray) {
                this.priorityResource2scanner.remove(fileObject);
                if (this.priorityResourceIterator.contains(fileObject)) continue;
                this.priorityResourceIterator.offer(fileObject);
            }
        }
        if (bl) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.SLEEP_LOCK;
        synchronized (object) {
            block8: while (true) {
                while (true) {
                    if (this.killed) {
                        return;
                    }
                    this.progress.started();
                    HashSet<FileTaskScanner> hashSet = null;
                    ScanItem scanItem = new ScanItem();
                    ScanMonitor scanMonitor = ScanMonitor.getDefault();
                    do {
                        scanMonitor.waitEnabled();
                        Object object2 = this.SCAN_LOCK;
                        synchronized (object2) {
                            if (this.getNext(scanItem)) {
                                if (!this.scan(scanItem)) {
                                    this.isCancel = true;
                                }
                            } else {
                                this.isCancel = true;
                            }
                            if (this.isCancel) {
                                hashSet = new HashSet<FileTaskScanner>(this.preparedScanners);
                            }
                        }
                    } while (!this.isCancel);
                    this.cleanUp(hashSet);
                    try {
                        this.SLEEP_LOCK.wait();
                        continue block8;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup() {
        Object object = this.SLEEP_LOCK;
        synchronized (object) {
            this.isCancel = false;
            this.SLEEP_LOCK.notifyAll();
        }
    }

    void abort() {
        this.isCancel = true;
    }

    void kill() {
        this.abort();
        this.killed = true;
        this.wakeup();
    }

    private boolean scan(ScanItem scanItem) {
        if (this.isCancel) {
            return false;
        }
        boolean bl = false;
        for (FileTaskScanner fileTaskScanner : scanItem.scanners) {
            if (!this.filter.isEnabled(fileTaskScanner) || this.filter.isTaskCountLimitReached(this.taskList.countTasks(fileTaskScanner))) continue;
            bl = true;
            this.scannedTasks.clear();
            if (this.cache.isUpToDate(scanItem.resource, fileTaskScanner)) {
                this.cache.getTasks(scanItem.resource, fileTaskScanner, this.scannedTasks);
            } else {
                List list = null;
                try {
                    if (scanItem.resource.isValid()) {
                        list = fileTaskScanner.scan(scanItem.resource);
                    }
                }
                catch (Throwable throwable) {
                    Exceptions.printStackTrace((Throwable)throwable);
                }
                if (null == list) {
                    this.cache.getTasks(scanItem.resource, fileTaskScanner, this.scannedTasks);
                } else {
                    this.scannedTasks.addAll(list);
                    this.cache.scanned(scanItem.resource, fileTaskScanner, this.scannedTasks);
                }
            }
            if (this.isCancel) {
                return false;
            }
            this.taskList.update(fileTaskScanner, scanItem.resource, this.scannedTasks, this.filter);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(Set<FileTaskScanner> set) {
        this.progress.finished();
        Object object = this.SCAN_LOCK;
        synchronized (object) {
            this.resourceIterator = null;
            this.priorityResourceIterator.clear();
            this.priorityResource2scanner.clear();
        }
        this.notifyFinished(set);
    }

    private void notifyFinished(Set<FileTaskScanner> set) {
        if (null != set) {
            for (FileTaskScanner fileTaskScanner : set) {
                fileTaskScanner.notifyFinish();
            }
        }
        this.preparedScanners.clear();
    }

    private boolean getNext(ScanItem scanItem) {
        scanItem.resource = this.priorityResourceIterator.poll();
        scanItem.scanners = this.preparedScanners;
        if (null != scanItem.resource) {
            scanItem.scanners = this.priorityResource2scanner.get(scanItem.resource);
            if (null == scanItem.scanners) {
                scanItem.scanners = this.preparedScanners;
            }
        } else if (null != this.resourceIterator && this.resourceIterator.hasNext()) {
            scanItem.resource = this.resourceIterator.next();
        }
        return null != scanItem.resource;
    }

    private boolean hasNext() {
        return this.priorityResourceIterator.size() > 0 || null != this.resourceIterator && this.resourceIterator.hasNext();
    }

    private static class ScanItem {
        FileObject resource;
        Collection<FileTaskScanner> scanners;

        private ScanItem() {
        }
    }
}

