/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.util.NbBundle;

class JPDAWatchImpl
extends AbstractVariable
implements JPDAWatch {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;
    private Reference<Object> nodeRef;

    JPDAWatchImpl(JPDADebuggerImpl jPDADebuggerImpl, Watch watch, PrimitiveValue primitiveValue, Object object) {
        super(jPDADebuggerImpl, primitiveValue, "" + watch + (primitiveValue instanceof ObjectReference ? "^" : ""));
        this.debugger = jPDADebuggerImpl;
        this.watch = watch;
        this.nodeRef = new WeakReference<Object>(object);
    }

    JPDAWatchImpl(JPDADebuggerImpl jPDADebuggerImpl, Watch watch, Exception exception, Object object) {
        super(jPDADebuggerImpl, null, "" + watch);
        Throwable throwable;
        this.debugger = jPDADebuggerImpl;
        this.watch = watch;
        this.exceptionDescription = exception.getLocalizedMessage();
        if (this.exceptionDescription == null) {
            this.exceptionDescription = exception.getMessage();
        }
        if ((throwable = exception.getCause()) != null && throwable instanceof ApplicationException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            this.exceptionDescription = this.exceptionDescription + " \n" + stringWriter.toString();
        }
        this.nodeRef = new WeakReference<Object>(object);
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String string) {
        this.watch.setExpression(string);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    protected void setInnerValue(Value value) {
        super.setInnerValue(value);
        this.exceptionDescription = null;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        LocalVariable localVariable;
        CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
        if (callStackFrameImpl == null) {
            throw new InvalidExpressionException("No curent frame.");
        }
        try {
            localVariable = callStackFrameImpl.getLocalVariable(this.getExpression());
        }
        catch (AbsentInformationException absentInformationException) {
            localVariable = null;
        }
        if (localVariable != null) {
            if (localVariable instanceof Local) {
                ((Local)localVariable).setValue(value);
            } else {
                ((ObjectLocalVariable)localVariable).setValue(value);
            }
            return;
        }
        ReferenceType referenceType = null;
        try {
            referenceType = callStackFrameImpl.getStackFrame().location().declaringType();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidExpressionException((Throwable)invalidStackFrameException);
        }
        Field field = referenceType.fieldByName(this.getExpression());
        if (field == null) {
            throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
        }
        if (field.isStatic()) {
            if (referenceType instanceof ClassType) {
                try {
                    ((ClassType)referenceType).setValue(field, value);
                }
                catch (InvalidTypeException invalidTypeException) {
                    throw new InvalidExpressionException((Throwable)invalidTypeException);
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    throw new InvalidExpressionException((Throwable)classNotLoadedException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidExpressionException((Throwable)illegalArgumentException);
                }
            }
            throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
        }
        try {
            ObjectReference objectReference = callStackFrameImpl.getStackFrame().thisObject();
            if (objectReference == null) {
                throw new InvalidExpressionException("no instance context.");
            }
            objectReference.setValue(field, value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidExpressionException((Throwable)illegalArgumentException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidExpressionException((Throwable)invalidStackFrameException);
        }
    }

    public String getToStringValue() throws InvalidExpressionException {
        return AbstractObjectVariable.getToStringValue(this.getInnerValue(), this.getDebugger(), 0);
    }

    void setException(String string) {
        this.setInnerValue(null);
        this.exceptionDescription = string;
    }

    boolean isPrimitive() {
        return !(this.getInnerValue() instanceof ObjectReference);
    }

    public JPDAWatchImpl clone() {
        JPDAWatchImpl jPDAWatchImpl = this.exceptionDescription == null ? new JPDAWatchImpl(this.getDebugger(), this.watch, (PrimitiveValue)this.getJDIValue(), this.nodeRef.get()) : new JPDAWatchImpl(this.getDebugger(), this.watch, new Exception(this.exceptionDescription), this.nodeRef.get());
        return jPDAWatchImpl;
    }
}

