/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ThreadsCache;

public class JPDAThreadGroupImpl
implements JPDAThreadGroup {
    private ThreadGroupReference tgr;
    private JPDADebuggerImpl debugger;
    private String name;

    public JPDAThreadGroupImpl(ThreadGroupReference threadGroupReference, JPDADebuggerImpl jPDADebuggerImpl) {
        this.tgr = threadGroupReference;
        this.debugger = jPDADebuggerImpl;
        this.name = "";
        try {
            this.name = threadGroupReference.name();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    public JPDAThreadGroup getParentThreadGroup() {
        ThreadGroupReference threadGroupReference = null;
        try {
            threadGroupReference = this.tgr.parent();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        if (threadGroupReference == null) {
            return null;
        }
        return this.debugger.getThreadGroup(threadGroupReference);
    }

    public JPDAThread[] getThreads() {
        ThreadsCache threadsCache = this.debugger.getThreadsCache();
        if (threadsCache == null) {
            return new JPDAThread[0];
        }
        List<ThreadReference> list = threadsCache.getThreads(this.tgr);
        int n = list.size();
        JPDAThread[] jPDAThreadArray = new JPDAThread[n];
        for (int i = 0; i < n; ++i) {
            jPDAThreadArray[i] = this.debugger.getThread(list.get(i));
        }
        return jPDAThreadArray;
    }

    public JPDAThreadGroup[] getThreadGroups() {
        ThreadsCache threadsCache = this.debugger.getThreadsCache();
        if (threadsCache == null) {
            return new JPDAThreadGroup[0];
        }
        List<ThreadGroupReference> list = threadsCache.getGroups(this.tgr);
        int n = list.size();
        JPDAThreadGroup[] jPDAThreadGroupArray = new JPDAThreadGroup[n];
        for (int i = 0; i < n; ++i) {
            jPDAThreadGroupArray[i] = this.debugger.getThreadGroup(list.get(i));
        }
        return jPDAThreadGroupArray;
    }

    public String getName() {
        return this.name;
    }

    public void resume() {
        ThreadsCache threadsCache = this.debugger.getThreadsCache();
        if (threadsCache == null) {
            return;
        }
        this.notifyToBeResumed(threadsCache);
        this.tgr.resume();
    }

    public void suspend() {
        ThreadsCache threadsCache = this.debugger.getThreadsCache();
        if (threadsCache == null) {
            return;
        }
        this.tgr.suspend();
        this.notifySuspended(threadsCache);
    }

    void notifyToBeResumed(ThreadsCache threadsCache) {
        Object object;
        List<ThreadReference> list = threadsCache.getThreads(this.tgr);
        for (ThreadReference object22 : list) {
            object = (JPDAThreadImpl)this.debugger.getThread(object22);
            ((JPDAThreadImpl)object).notifyToBeResumed();
        }
        List<ThreadGroupReference> list2 = threadsCache.getGroups(this.tgr);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (ThreadGroupReference)iterator.next();
            JPDAThreadGroupImpl jPDAThreadGroupImpl = (JPDAThreadGroupImpl)this.debugger.getThreadGroup((ThreadGroupReference)object);
            jPDAThreadGroupImpl.notifyToBeResumed(threadsCache);
        }
    }

    void notifySuspended(ThreadsCache threadsCache) {
        Object object;
        List<ThreadReference> list = threadsCache.getThreads(this.tgr);
        for (ThreadReference object22 : list) {
            object = (JPDAThreadImpl)this.debugger.getThread(object22);
            ((JPDAThreadImpl)object).notifySuspended();
        }
        List<ThreadGroupReference> list2 = threadsCache.getGroups(this.tgr);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (ThreadGroupReference)iterator.next();
            JPDAThreadGroupImpl jPDAThreadGroupImpl = (JPDAThreadGroupImpl)this.debugger.getThreadGroup((ThreadGroupReference)object);
            jPDAThreadGroupImpl.notifySuspended(threadsCache);
        }
    }
}

