/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class CallStackTreeModel
implements TreeModel {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(99) >= 0;
    private JPDADebuggerImpl debugger;
    private Collection<ModelListener> listeners = new HashSet<ModelListener>();
    private Listener listener;

    public CallStackTreeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object.equals("Root") || object instanceof JPDAThread) {
            JPDAThread jPDAThread = object.equals("Root") ? this.debugger.getCurrentThread() : (JPDAThread)object;
            if (jPDAThread == null) {
                return new String[]{"No current thread"};
            }
            try {
                Object[] objectArray = jPDAThread.getCallStack(n, n2);
                return objectArray;
            }
            catch (AbsentInformationException absentInformationException) {
                if (absentInformationException.getCause() instanceof IncompatibleThreadStateException) {
                    return new String[]{"Thread is running"};
                }
                return new String[]{"No call stack information available."};
            }
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object.equals("Root") || object instanceof JPDAThread) {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(object);
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof CallStackFrame) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(modelListener);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection<ModelListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(modelListener);
            if (this.listeners.size() == 0) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged() {
        ModelListener[] modelListenerArray;
        ModelEvent.TreeChanged treeChanged = this.listeners;
        synchronized (treeChanged) {
            modelListenerArray = this.listeners.toArray(new ModelListener[0]);
        }
        treeChanged = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < modelListenerArray.length; ++i) {
            modelListenerArray[i].modelChanged((ModelEvent)treeChanged);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        private WeakReference<CallStackTreeModel> model;
        private RequestProcessor.Task task;

        public Listener(CallStackTreeModel callStackTreeModel, JPDADebugger jPDADebugger) {
            this.debugger = jPDADebugger;
            this.model = new WeakReference<CallStackTreeModel>(callStackTreeModel);
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)this);
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)jPDADebugger.getCurrentThread();
            if (jPDAThreadImpl != null) {
                jPDAThreadImpl.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jPDAThreadImpl));
            }
        }

        private CallStackTreeModel getModel() {
            CallStackTreeModel callStackTreeModel = (CallStackTreeModel)this.model.get();
            if (callStackTreeModel == null) {
                this.destroy();
            }
            return callStackTreeModel;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("CSTM cancel old task " + this.task);
                }
                this.task = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            boolean bl = false;
            String string = propertyChangeEvent.getPropertyName();
            if (string == "currentThread" && (object = (JPDAThreadImpl)this.debugger.getCurrentThread()) != null) {
                ((JPDAThreadImpl)object).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)object));
                bl = true;
            }
            if (string == "suspended" && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && propertyChangeEvent.getSource() == this.debugger.getCurrentThread()) {
                bl = true;
            }
            if (string == "state") {
                if (this.debugger.getState() == 3) {
                    bl = true;
                }
            }
            if (bl) {
                object = this;
                synchronized (object) {
                    if (this.task == null) {
                        this.task = RequestProcessor.getDefault().create((Runnable)new Refresher());
                    }
                    this.task.schedule(200);
                }
            }
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            public void run() {
                CallStackTreeModel callStackTreeModel;
                int n = Listener.this.debugger.getState();
                Listener.this.debugger;
                if (n == 3 && (callStackTreeModel = Listener.this.getModel()) != null) {
                    callStackTreeModel.fireTreeChanged();
                }
            }
        }
    }
}

