/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.MethodChooser;
import org.netbeans.modules.debugger.jpda.actions.StepIntoNextMethod;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;

public class StepIntoActionProvider
extends JPDADebuggerActionProvider {
    public static final String SS_STEP_OUT = "SS_ACTION_STEPOUT";
    public static final String ACTION_SMART_STEP_INTO = "smartStepInto";
    private StepIntoNextMethod stepInto;
    private MethodChooser currentMethodChooser;

    public StepIntoActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        this.stepInto = new StepIntoNextMethod(contextProvider);
        this.setProviderToDisableOnLazyAction(this);
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_INTO));
    }

    public void doAction(Object object) {
        this.runAction(object);
    }

    public void postAction(final Object object, final Runnable runnable) {
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StepIntoActionProvider.this.runAction(object);
                    Object var2_1 = null;
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    runnable.run();
                    throw throwable;
                }
            }
        });
    }

    public void runAction(Object object) {
        if (ActionsManager.ACTION_STEP_INTO.equals(object) && this.doMethodSelection()) {
            return;
        }
        this.stepInto.runAction();
    }

    protected void checkEnabled(int n) {
        Iterator iterator = this.getActions().iterator();
        while (iterator.hasNext()) {
            this.setEnabled(iterator.next(), n == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doMethodSelection() {
        final String[] stringArray = this;
        synchronized (this) {
            if (this.currentMethodChooser != null) {
                this.currentMethodChooser.doStepIntoCurrentSelection();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            stringArray = new String[1];
            final String[] stringArray2 = new String[1];
            final int[] nArray = new int[1];
            final int[] nArray2 = new int[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        EditorContext editorContext = EditorContextBridge.getContext();
                        stringArray[0] = editorContext.getSelectedMethodName();
                        nArray[0] = editorContext.getCurrentLineNumber();
                        nArray2[0] = EditorContextBridge.getCurrentOffset();
                        stringArray2[0] = editorContext.getCurrentURL();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            int n = nArray[0];
            int n2 = nArray2[0];
            String string = stringArray2[0];
            if (n < 0 || string == null || !string.endsWith(".java")) {
                return false;
            }
            String string2 = this.debugger.getCurrentThread().getClassName();
            VirtualMachine virtualMachine = this.debugger.getVirtualMachine();
            if (virtualMachine == null) {
                return false;
            }
            List<ReferenceType> list = virtualMachine.classesByName(string2);
            if (list.isEmpty()) return false;
            MethodChooser methodChooser = new MethodChooser(this.debugger, string, list.get(0), n, n2);
            boolean bl = methodChooser.run();
            if (!bl || !methodChooser.isInSelectMode()) return bl;
            String[] stringArray3 = this;
            synchronized (this) {
                this.currentMethodChooser = methodChooser;
                methodChooser.setReleaseListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionPerformed(ActionEvent actionEvent) {
                        3 var2_2 = this;
                        synchronized (var2_2) {
                            StepIntoActionProvider.this.currentMethodChooser = null;
                        }
                    }
                });
                // ** MonitorExit[var13_16] (shouldn't be in output)
                return bl;
            }
        }
    }
}

