/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.ClassTypeList;
import org.netbeans.modules.debugger.jpda.DeadlockDetectorImpl;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.JSR45DebuggerEngineProvider;
import org.netbeans.modules.debugger.jpda.Java6Methods;
import org.netbeans.modules.debugger.jpda.JavaEngineProvider;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.ThreadsCollectorImpl;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsEngineListener;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException2;
import org.netbeans.modules.debugger.jpda.expr.Evaluator;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.Expression2;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.expr.TreeEvaluator;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.LocalsTreeModel;
import org.netbeans.modules.debugger.jpda.models.ObjectTranslation;
import org.netbeans.modules.debugger.jpda.models.ThreadsCache;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.DelegatingSessionProvider;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDADebuggerImpl
extends JPDADebugger {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda");
    private static final boolean SINGLE_THREAD_STEPPING = !Boolean.getBoolean("netbeans.debugger.multiThreadStepping");
    private VirtualMachine virtualMachine = null;
    private final Object virtualMachineLock = new Object();
    private Exception exception;
    private int state = 0;
    private final Object stateLock = new Object();
    private Operator operator;
    private PropertyChangeSupport pcs;
    public PropertyChangeSupport varChangeSupport = new PropertyChangeSupport((Object)this);
    private PropertyChangeSupport threadsChangeSupport = new PropertyChangeSupport((Object)this);
    private JPDAThreadImpl currentThread;
    private CallStackFrame currentCallStackFrame;
    private final Object currentThreadAndFrameLock = new Object();
    private int suspend = SINGLE_THREAD_STEPPING ? 1 : 2;
    public final Object LOCK = new Object();
    private final Object LOCK2 = new Object();
    private boolean starting;
    private AbstractDICookie attachingCookie;
    private JavaEngineProvider javaEngineProvider;
    private Set<String> languages;
    private String lastStratumn;
    private ContextProvider lookupProvider;
    private ObjectTranslation threadsTranslation;
    private ObjectTranslation localsTranslation;
    private ExpressionPool expressionPool;
    private ThreadsCache threadsCache;
    private DeadlockDetector deadlockDetector;
    private ThreadsCollectorImpl threadsCollector;
    private final Object threadsCollectorLock = new Object();
    private StackFrame altCSF = null;
    private boolean doContinue = true;
    private Boolean singleThreadStepResumeDecision = null;
    private Boolean stepInterruptByBptResumeDecision = null;
    private Boolean canBeModified;
    private Object canBeModifiedLock = new Object();
    private SmartSteppingFilter smartSteppingFilter;
    CompoundSmartSteppingListener compoundSmartSteppingListener;
    private InvalidExpressionException methodCallsUnsupportedExc;
    private boolean finishing;
    private static final Pattern jvmVersionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(_\\d+)?(-\\w+)?");
    private static Method tcGenericSignatureMethod;
    private static Method lvGenericSignatureMethod;
    private SourcePath engineContext;
    private LocalsTreeModel localsTreeModel;
    private Set<JSR45DebuggerEngineProvider> jsr45EngineProviders;

    public JPDADebuggerImpl(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.pcs = new PropertyChangeSupport((Object)this);
        List list = contextProvider.lookup(null, DebuggerEngineProvider.class);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!(list.get(i) instanceof JavaEngineProvider)) continue;
            this.javaEngineProvider = (JavaEngineProvider)((Object)list.get(i));
        }
        if (this.javaEngineProvider == null) {
            throw new IllegalArgumentException("JavaEngineProvider have to be used to start JPDADebugger!");
        }
        this.languages = new HashSet<String>();
        this.languages.add("Java");
        this.threadsTranslation = ObjectTranslation.createThreadTranslation(this);
        this.localsTranslation = ObjectTranslation.createLocalsTranslation(this);
        this.expressionPool = new ExpressionPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuspend() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.suspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspend(int n) {
        int n2;
        Object object = this.stateLock;
        synchronized (object) {
            if (n == this.suspend) {
                return;
            }
            n2 = this.suspend;
            this.suspend = n;
        }
        this.firePropertyChange("suspend", new Integer(n2), new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPDAThread getCurrentThread() {
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            return this.currentThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallStackFrame getCurrentCallStackFrame() {
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            if (this.currentCallStackFrame != null) {
                try {
                    if (!this.currentCallStackFrame.getThread().isSuspended()) {
                        this.currentCallStackFrame = null;
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    this.currentCallStackFrame = null;
                }
            }
            if (this.currentCallStackFrame == null && this.currentThread != null) {
                try {
                    this.currentCallStackFrame = this.currentThread.getCallStack(0, 1)[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.currentCallStackFrame;
        }
    }

    public Variable evaluate(String string) throws InvalidExpressionException {
        Value value = this.evaluateIn(string);
        return this.getLocalsTreeModel().getVariable(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitRunning() throws DebuggerStartException {
        Object object = this.LOCK2;
        synchronized (object) {
            int n = this.getState();
            if (n == 4) {
                if (this.exception != null) {
                    throw new DebuggerStartException((Throwable)this.exception);
                }
                return;
            }
            if (!this.starting && n != 1 || this.exception != null) {
                return;
            }
            try {
                this.LOCK2.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new DebuggerStartException((Throwable)interruptedException);
            }
            if (this.exception != null) {
                throw new DebuggerStartException((Throwable)this.exception);
            }
            return;
        }
    }

    public boolean canPopFrames() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        return virtualMachine.canPopFrames();
    }

    public boolean canFixClasses() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        return virtualMachine.canRedefineClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixClasses(Map<String, byte[]> map) {
        Object object = this.LOCK;
        synchronized (object) {
            CallStackFrame callStackFrame;
            String string;
            HashMap<ReferenceType, byte[]> hashMap = new HashMap<ReferenceType, byte[]>();
            Iterator<String> iterator = map.keySet().iterator();
            VirtualMachine virtualMachine = this.getVirtualMachine();
            if (virtualMachine == null) {
                return;
            }
            while (iterator.hasNext()) {
                string = iterator.next();
                callStackFrame = virtualMachine.classesByName(string);
                int n = callStackFrame.size();
                for (int i = 0; i < n; ++i) {
                    hashMap.put(callStackFrame.get(i), map.get(string));
                }
            }
            virtualMachine.redefineClasses(hashMap);
            this.fixBreakpoints();
            string = this.getCurrentThread();
            if (string != null && string.isSuspended()) {
                try {
                    if (string.getStackDepth() < 2) {
                        return;
                    }
                    try {
                        callStackFrame = string.getCallStack(0, 1)[0];
                    }
                    catch (AbsentInformationException absentInformationException) {
                        return;
                    }
                    if (callStackFrame.isObsolete() && ((CallStackFrameImpl)callStackFrame).canPop()) {
                        callStackFrame.popFrame();
                        this.setState(2);
                        this.updateCurrentCallStackFrame((JPDAThread)string);
                        this.setState(3);
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    // empty catch block
                }
            }
        }
    }

    public void fixBreakpoints() {
        Session session = this.getSession();
        DebuggerEngine debuggerEngine = session.getEngineForLanguage("Java");
        BreakpointsEngineListener breakpointsEngineListener = null;
        List list = debuggerEngine.lookup(null, LazyActionsManagerListener.class);
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof BreakpointsEngineListener)) continue;
            breakpointsEngineListener = (BreakpointsEngineListener)e;
            break;
        }
        EditorContextBridge.getContext().disposeTimeStamp((Object)this);
        EditorContextBridge.getContext().createTimeStamp((Object)this);
        breakpointsEngineListener.fixBreakpointImpls();
    }

    public Session getSession() {
        return (Session)this.lookupProvider.lookupFirst(null, Session.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBeModified() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        Object object = this.canBeModifiedLock;
        synchronized (object) {
            if (this.canBeModified == null) {
                try {
                    Method method = VirtualMachine.class.getMethod("canBeModified", new Class[0]);
                    Object object2 = method.invoke((Object)virtualMachine, new Object[0]);
                    this.canBeModified = (Boolean)object2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.canBeModified = Boolean.TRUE;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.canBeModified = Boolean.TRUE;
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.canBeModified = Boolean.TRUE;
                }
            }
            return this.canBeModified;
        }
    }

    public SmartSteppingFilter getSmartSteppingFilter() {
        if (this.smartSteppingFilter == null) {
            this.smartSteppingFilter = (SmartSteppingFilter)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
            this.smartSteppingFilter.addExclusionPatterns((Set)Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters").getCollection("enabled", (Collection)Collections.EMPTY_SET));
        }
        return this.smartSteppingFilter;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.lookupProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }

    boolean stopHere(JPDAThread jPDAThread) {
        return this.getCompoundSmartSteppingListener().stopHere(this.lookupProvider, jPDAThread, this.getSmartSteppingFilter());
    }

    public void fireBreakpointEvent(JPDABreakpoint jPDABreakpoint, JPDABreakpointEvent jPDABreakpointEvent) {
        super.fireBreakpointEvent(jPDABreakpoint, jPDABreakpointEvent);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popFrames(ThreadReference threadReference, StackFrame stackFrame) {
        Object object = this.LOCK;
        synchronized (object) {
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getThread(threadReference);
            this.setState(2);
            try {
                jPDAThreadImpl.popFrames(stackFrame);
                this.updateCurrentCallStackFrame(jPDAThreadImpl);
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                ErrorManager.getDefault().notify((Throwable)incompatibleThreadStateException);
            }
            finally {
                this.setState(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(Exception exception) {
        Object object = this.LOCK2;
        synchronized (object) {
            this.exception = exception;
            this.starting = false;
            this.LOCK2.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentThread(JPDAThread jPDAThread) {
        JPDAThreadImpl jPDAThreadImpl;
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            jPDAThreadImpl = this.currentThread;
            this.currentThread = (JPDAThreadImpl)jPDAThread;
        }
        object = this.updateCurrentCallStackFrameNoFire(jPDAThread);
        if (jPDAThread != jPDAThreadImpl) {
            this.firePropertyChange("currentThread", jPDAThreadImpl, jPDAThread);
        }
        if (object != null) {
            this.firePropertyChange((PropertyChangeEvent)object);
        }
        this.setState(jPDAThread.isSuspended() ? 3 : 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeEvent setCurrentThreadNoFire(JPDAThread jPDAThread) {
        JPDAThreadImpl jPDAThreadImpl;
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            jPDAThreadImpl = this.currentThread;
            this.currentThread = (JPDAThreadImpl)jPDAThread;
        }
        object = null;
        if (jPDAThread != jPDAThreadImpl) {
            object = new PropertyChangeEvent((Object)this, "currentThread", jPDAThreadImpl, jPDAThread);
        }
        PropertyChangeEvent propertyChangeEvent = this.updateCurrentCallStackFrameNoFire(jPDAThread);
        if (object == null) {
            object = propertyChangeEvent;
        } else if (propertyChangeEvent != null) {
            ((PropertyChangeEvent)object).setPropagationId(propertyChangeEvent);
        }
        return object;
    }

    public void setCurrentCallStackFrame(CallStackFrame callStackFrame) {
        CallStackFrame callStackFrame2 = this.setCurrentCallStackFrameNoFire(callStackFrame);
        if (callStackFrame2 == callStackFrame) {
            return;
        }
        this.firePropertyChange("currentCallStackFrame", callStackFrame2, callStackFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallStackFrame setCurrentCallStackFrameNoFire(CallStackFrame callStackFrame) {
        CallStackFrame callStackFrame2;
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            if (callStackFrame == this.currentCallStackFrame) {
                return callStackFrame;
            }
            callStackFrame2 = this.currentCallStackFrame;
            this.currentCallStackFrame = callStackFrame;
        }
        return callStackFrame2;
    }

    public Value evaluateIn(String string) throws InvalidExpressionException {
        Expression expression = null;
        try {
            expression = Expression.parse(string, "1.5.0");
            return this.evaluateIn(expression);
        }
        catch (ParseException parseException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException(parseException.getMessage());
            invalidExpressionException.initCause((Throwable)parseException);
            throw invalidExpressionException;
        }
    }

    public void setAltCSF(StackFrame stackFrame) {
        this.altCSF = stackFrame;
    }

    public StackFrame getAltCSF() {
        return this.altCSF;
    }

    public Value evaluateIn(Expression expression) throws InvalidExpressionException {
        Object object = this.LOCK;
        synchronized (object) {
            block17: {
                CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.getCurrentCallStackFrame();
                if (callStackFrameImpl != null) {
                    JPDAThread jPDAThread = callStackFrameImpl.getThread();
                    try {
                        Value value = null;
                        boolean bl = false;
                        try {
                            value = this.evaluateIn(expression, callStackFrameImpl.getStackFrame(), callStackFrameImpl.getFrameDepth());
                            bl = true;
                        }
                        catch (InvalidStackFrameException invalidStackFrameException) {
                            // empty catch block
                        }
                        if (!bl) break block17;
                        try {
                            callStackFrameImpl.getThread();
                        }
                        catch (InvalidStackFrameException invalidStackFrameException) {
                            int n = callStackFrameImpl.getFrameDepth();
                            try {
                                CallStackFrame callStackFrame = jPDAThread.getCallStack(n, n + 1)[0];
                                this.setCurrentCallStackFrameNoFire(callStackFrame);
                            }
                            catch (AbsentInformationException absentInformationException) {
                                this.setCurrentCallStackFrame(null);
                            }
                        }
                        return value;
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        return null;
                    }
                }
            }
            if (this.altCSF != null) {
                try {
                    if (this.altCSF.thread().isSuspended()) {
                        return this.evaluateIn(expression, this.altCSF, 0);
                    }
                    this.altCSF = null;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    this.altCSF = null;
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    return null;
                }
            }
            throw new InvalidExpressionException(NbBundle.getMessage(JPDADebuggerImpl.class, (String)"MSG_NoCurrentContextStackFrame"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value evaluateIn(Expression expression, StackFrame stackFrame, int n) throws InvalidExpressionException {
        Object object = this.LOCK;
        synchronized (object) {
            if (stackFrame == null) {
                throw new InvalidExpressionException(NbBundle.getMessage(JPDADebuggerImpl.class, (String)"MSG_NoCurrentContext"));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add("java.lang.*");
            try {
                boolean bl;
                arrayList.addAll(Arrays.asList(EditorContextBridge.getContext().getImports(this.getEngineContext().getURL(stackFrame, "Java"))));
                final ThreadReference threadReference = stackFrame.thread();
                final List[] listArray = new List[]{null};
                final JPDAThreadImpl[] jPDAThreadImplArray = new JPDAThreadImpl[]{null};
                boolean bl2 = bl = !Boolean.getBoolean("debugger.evaluatorOld");
                if (bl) {
                    Expression2 expression2 = Expression2.parse(expression.getExpression(), expression.getLanguage());
                    EvaluationContext evaluationContext = new EvaluationContext(threadReference, stackFrame, n, arrayList, arrayList2, this.methodCallsUnsupportedExc == null, new Runnable(){

                        public void run() {
                            if (listArray[0] == null) {
                                JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)JPDADebuggerImpl.this.getThread(threadReference);
                                try {
                                    jPDAThreadImpl.notifyMethodInvoking();
                                }
                                catch (PropertyVetoException propertyVetoException) {
                                    throw new RuntimeException((Throwable)new InvalidExpressionException(propertyVetoException.getMessage()));
                                }
                                listArray[0] = JPDADebuggerImpl.this.disableAllBreakpoints();
                                jPDAThreadImplArray[0] = jPDAThreadImpl;
                            }
                        }
                    }, this);
                    TreeEvaluator treeEvaluator = expression2.evaluator(evaluationContext);
                    try {
                        Value value = treeEvaluator.evaluate();
                        return value;
                    }
                    finally {
                        if (this.methodCallsUnsupportedExc == null && !evaluationContext.canInvokeMethods()) {
                            this.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
                        }
                        if (listArray[0] != null) {
                            this.enableAllBreakpoints(listArray[0]);
                        }
                        if (jPDAThreadImplArray[0] != null) {
                            jPDAThreadImplArray[0].notifyMethodInvokeDone();
                        }
                    }
                }
                EvaluationContext evaluationContext = new EvaluationContext(threadReference, stackFrame, n, arrayList, arrayList2, this.methodCallsUnsupportedExc == null, new Runnable(){

                    public void run() {
                        if (listArray[0] == null) {
                            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)JPDADebuggerImpl.this.getThread(threadReference);
                            try {
                                jPDAThreadImpl.notifyMethodInvoking();
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                throw new RuntimeException((Throwable)new InvalidExpressionException(propertyVetoException.getMessage()));
                            }
                            listArray[0] = JPDADebuggerImpl.this.disableAllBreakpoints();
                            jPDAThreadImplArray[0] = jPDAThreadImpl;
                        }
                    }
                }, this);
                Evaluator evaluator = expression.evaluator(evaluationContext);
                try {
                    Value value = evaluator.evaluate();
                    return value;
                }
                finally {
                    if (this.methodCallsUnsupportedExc == null && !evaluationContext.canInvokeMethods()) {
                        this.methodCallsUnsupportedExc = new InvalidExpressionException((Throwable)new UnsupportedOperationException());
                    }
                    if (listArray[0] != null) {
                        this.enableAllBreakpoints(listArray[0]);
                    }
                    if (jPDAThreadImplArray[0] != null) {
                        jPDAThreadImplArray[0].notifyMethodInvokeDone();
                    }
                }
            }
            catch (EvaluationException evaluationException) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)evaluationException);
                invalidExpressionException.initCause((Throwable)evaluationException);
                throw invalidExpressionException;
            }
            catch (EvaluationException2 evaluationException2) {
                InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)evaluationException2);
                invalidExpressionException.initCause((Throwable)evaluationException2);
                throw invalidExpressionException;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                IllegalStateException illegalStateException = new IllegalStateException(incompatibleThreadStateException.getLocalizedMessage());
                illegalStateException.initCause(incompatibleThreadStateException);
                throw illegalStateException;
            }
            catch (InternalException internalException) {
                IllegalStateException illegalStateException = new IllegalStateException(internalException.getLocalizedMessage());
                illegalStateException.initCause(internalException);
                throw illegalStateException;
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable = runtimeException.getCause();
                if (throwable instanceof InvalidExpressionException) {
                    throw (InvalidExpressionException)throwable;
                }
                throw runtimeException;
            }
        }
    }

    public Value invokeMethod(ObjectReference objectReference, com.sun.jdi.Method method, Value[] valueArray) throws InvalidExpressionException {
        return this.invokeMethod(null, objectReference, method, valueArray, 0);
    }

    public Value invokeMethod(ObjectReference objectReference, com.sun.jdi.Method method, Value[] valueArray, int n) throws InvalidExpressionException {
        return this.invokeMethod(null, objectReference, method, valueArray, n);
    }

    public Value invokeMethod(JPDAThreadImpl jPDAThreadImpl, ObjectReference objectReference, com.sun.jdi.Method method, Value[] valueArray) throws InvalidExpressionException {
        return this.invokeMethod(jPDAThreadImpl, objectReference, method, valueArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Value invokeMethod(JPDAThreadImpl jPDAThreadImpl, ObjectReference objectReference, com.sun.jdi.Method method, Value[] valueArray, int n) throws InvalidExpressionException {
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            if (jPDAThreadImpl == null && this.currentThread == null) {
                throw new InvalidExpressionException(NbBundle.getMessage(JPDADebuggerImpl.class, (String)"MSG_NoCurrentContext"));
            }
        }
        object = this.LOCK;
        synchronized (object) {
            if (this.methodCallsUnsupportedExc != null) {
                throw this.methodCallsUnsupportedExc;
            }
            boolean bl = false;
            JPDAThread jPDAThread = null;
            CallStackFrameImpl callStackFrameImpl = null;
            List<EventRequest> list = null;
            try {
                Value value;
                ThreadReference threadReference;
                callStackFrameImpl = (CallStackFrameImpl)this.getCurrentCallStackFrame();
                if (callStackFrameImpl != null) {
                    try {
                        jPDAThread = callStackFrameImpl.getThread();
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        // empty catch block
                    }
                }
                if (jPDAThreadImpl == null) {
                    threadReference = this.getEvaluationThread();
                    jPDAThreadImpl = (JPDAThreadImpl)this.getThread(threadReference);
                } else {
                    threadReference = jPDAThreadImpl.getThreadReference();
                }
                try {
                    jPDAThreadImpl.notifyMethodInvoking();
                    bl = true;
                }
                catch (PropertyVetoException propertyVetoException) {
                    throw new InvalidExpressionException(propertyVetoException.getMessage());
                }
                list = this.disableAllBreakpoints();
                try {
                    Value value2 = TreeEvaluator.invokeVirtual(objectReference, method, threadReference, Arrays.asList(valueArray), this);
                    if (n > 0 && n < Integer.MAX_VALUE && value2 instanceof StringReference) {
                        value2 = this.cutLength((StringReference)value2, n, threadReference);
                    }
                    value = value2;
                }
                catch (InternalException internalException) {
                    try {
                        InvalidExpressionException invalidExpressionException = new InvalidExpressionException(internalException.getLocalizedMessage());
                        invalidExpressionException.initCause((Throwable)internalException);
                        throw invalidExpressionException;
                    }
                    catch (InvalidExpressionException invalidExpressionException) {
                        if (invalidExpressionException.getTargetException() instanceof UnsupportedOperationException) {
                            this.methodCallsUnsupportedExc = invalidExpressionException;
                        }
                        throw invalidExpressionException;
                    }
                }
                return value;
            }
            finally {
                if (list != null) {
                    this.enableAllBreakpoints(list);
                }
                if (bl) {
                    jPDAThreadImpl.notifyMethodInvokeDone();
                }
                if (jPDAThread != null) {
                    try {
                        callStackFrameImpl.getThread();
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        int n2 = callStackFrameImpl.getFrameDepth();
                        try {
                            CallStackFrame callStackFrame = jPDAThread.getCallStack(n2, n2 + 1)[0];
                            this.setCurrentCallStackFrameNoFire(callStackFrame);
                        }
                        catch (AbsentInformationException absentInformationException) {
                            this.setCurrentCallStackFrame(null);
                        }
                    }
                }
            }
        }
    }

    private Value cutLength(StringReference stringReference, int n, ThreadReference threadReference) throws InvalidExpressionException {
        com.sun.jdi.Method method;
        List<Value> list;
        com.sun.jdi.Method method2 = ((ClassType)stringReference.type()).concreteMethodByName("length", "()I");
        IntegerValue integerValue = (IntegerValue)TreeEvaluator.invokeVirtual(stringReference, method2, threadReference, list = Collections.emptyList(), this);
        if (integerValue.value() > n && (method = ((ClassType)stringReference.type()).concreteMethodByName("substring", "(II)Ljava/lang/String;")) != null) {
            stringReference = (StringReference)TreeEvaluator.invokeVirtual(stringReference, method, threadReference, Arrays.asList(stringReference.virtualMachine().mirrorOf(0), stringReference.virtualMachine().mirrorOf(n)), this);
        }
        return stringReference;
    }

    public static String getGenericSignature(TypeComponent typeComponent) {
        if (tcGenericSignatureMethod == null) {
            return null;
        }
        try {
            return (String)tcGenericSignatureMethod.invoke((Object)typeComponent, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    public static String getGenericSignature(LocalVariable localVariable) {
        if (lvGenericSignatureMethod == null) {
            return null;
        }
        try {
            return (String)lvGenericSignatureMethod.invoke((Object)localVariable, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine getVirtualMachine() {
        Object object = this.virtualMachineLock;
        synchronized (object) {
            return this.virtualMachine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operator getOperator() {
        Object object = this.virtualMachineLock;
        synchronized (object) {
            return this.operator;
        }
    }

    public void setStarting() {
        this.setState(1);
    }

    public synchronized void setAttaching(AbstractDICookie abstractDICookie) {
        this.attachingCookie = abstractDICookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(VirtualMachine virtualMachine, Operator operator) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Start - JPDADebuggerImpl.setRunning ()");
            JPDAUtils.printFeatures(logger, virtualMachine);
        }
        Object object = this.LOCK2;
        synchronized (object) {
            this.starting = true;
        }
        object = this.virtualMachineLock;
        synchronized (object) {
            this.virtualMachine = virtualMachine;
            this.operator = operator;
        }
        object = this.canBeModifiedLock;
        synchronized (object) {
            this.canBeModified = null;
        }
        this.initGenericsSupport();
        EditorContextBridge.getContext().createTimeStamp((Object)this);
        object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.threadsCache != null) {
                this.threadsCache.setVirtualMachine(virtualMachine);
            }
        }
        this.setState(2);
        object = this.virtualMachineLock;
        synchronized (object) {
            virtualMachine = this.virtualMachine;
        }
        if (virtualMachine != null) {
            try {
                this.notifyToBeResumedAll();
                object = this.LOCK;
                synchronized (object) {
                    virtualMachine.resume();
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
        logger.fine("   JPDADebuggerImpl.setRunning () finished, VM resumed.");
        object = this.LOCK2;
        synchronized (object) {
            this.starting = false;
            this.LOCK2.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoppedState(ThreadReference threadReference) {
        PropertyChangeEvent propertyChangeEvent;
        Object object = this.LOCK;
        synchronized (object) {
            JPDAThread jPDAThread = this.getCurrentThread();
            JPDAThread jPDAThread2 = this.getThread(threadReference);
            if (jPDAThread != null && jPDAThread != jPDAThread2 && jPDAThread.isSuspended()) {
                return;
            }
            this.checkJSR45Languages(jPDAThread2);
            propertyChangeEvent = this.setCurrentThreadNoFire(jPDAThread2);
            PropertyChangeEvent propertyChangeEvent2 = this.setStateNoFire(3);
            if (propertyChangeEvent == null) {
                propertyChangeEvent = propertyChangeEvent2;
            } else if (propertyChangeEvent2 != null) {
                PropertyChangeEvent propertyChangeEvent3 = propertyChangeEvent;
                while (propertyChangeEvent3.getPropagationId() != null) {
                    propertyChangeEvent3 = (PropertyChangeEvent)propertyChangeEvent3.getPropagationId();
                }
                propertyChangeEvent3.setPropagationId(propertyChangeEvent2);
            }
        }
        if (propertyChangeEvent != null) {
            do {
                this.firePropertyChange(propertyChangeEvent);
            } while ((propertyChangeEvent = (PropertyChangeEvent)propertyChangeEvent.getPropagationId()) != null);
        }
    }

    public void setRunningState() {
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoppedStateNoContinue(ThreadReference threadReference) {
        PropertyChangeEvent propertyChangeEvent;
        Object object = this.LOCK;
        synchronized (object) {
            propertyChangeEvent = this.setStateNoFire(2);
            JPDAThread jPDAThread = this.getThread(threadReference);
            this.checkJSR45Languages(jPDAThread);
            PropertyChangeEvent propertyChangeEvent2 = this.setCurrentThreadNoFire(jPDAThread);
            if (propertyChangeEvent == null) {
                propertyChangeEvent = propertyChangeEvent2;
            } else if (propertyChangeEvent2 != null) {
                propertyChangeEvent.setPropagationId(propertyChangeEvent2);
            }
            propertyChangeEvent2 = this.setStateNoFire(3);
            if (propertyChangeEvent == null) {
                propertyChangeEvent = propertyChangeEvent2;
            } else if (propertyChangeEvent2 != null) {
                PropertyChangeEvent propertyChangeEvent3 = propertyChangeEvent;
                while (propertyChangeEvent3.getPropagationId() != null) {
                    propertyChangeEvent3 = (PropertyChangeEvent)propertyChangeEvent3.getPropagationId();
                }
                propertyChangeEvent3.setPropagationId(propertyChangeEvent2);
            }
            this.doContinue = false;
        }
        if (propertyChangeEvent != null) {
            do {
                this.firePropertyChange(propertyChangeEvent);
            } while ((propertyChangeEvent = (PropertyChangeEvent)propertyChangeEvent.getPropagationId()) != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        try {
            Object object;
            JPDADebuggerImpl jPDADebuggerImpl = this;
            synchronized (jPDADebuggerImpl) {
                block37: {
                    if (!this.finishing) break block37;
                    return;
                }
                this.finishing = true;
            }
            logger.fine("StartActionProvider.finish ()");
            if (this.getState() == 4) {
                return;
            }
            jPDADebuggerImpl = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
            Operator operator = this.getOperator();
            if (operator != null) {
                operator.stop();
            }
            Object object2 = this;
            synchronized (object2) {
                if (this.attachingCookie != null && this.attachingCookie instanceof ListeningDICookie) {
                    object = (ListeningDICookie)this.attachingCookie;
                    try {
                        object.getListeningConnector().stopListening(object.getArgs());
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            try {
                this.waitRunning();
            }
            catch (DebuggerStartException debuggerStartException) {
                // empty catch block
            }
            object = this.virtualMachineLock;
            synchronized (object) {
                object2 = this.virtualMachine;
            }
            if (object2 != null) {
                try {
                    if (jPDADebuggerImpl instanceof AttachingDICookie) {
                        logger.fine(" StartActionProvider.finish() VM dispose");
                        object2.dispose();
                    } else {
                        logger.fine(" StartActionProvider.finish() VM exit");
                        object2.exit(0);
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    logger.fine(" StartActionProvider.finish() VM exception " + vMDisconnectedException);
                }
            }
            object = this.virtualMachineLock;
            synchronized (object) {
                this.virtualMachine = null;
            }
            this.setState(4);
            if (this.jsr45EngineProviders != null) {
                for (JSR45DebuggerEngineProvider jSR45DebuggerEngineProvider : this.jsr45EngineProviders) {
                    jSR45DebuggerEngineProvider.getDesctuctor().killEngine();
                }
                this.jsr45EngineProviders = null;
            }
            this.javaEngineProvider.getDestructor().killEngine();
            logger.fine(" StartActionProvider.finish() end.");
            object = this.LOCK2;
            synchronized (object) {
                this.starting = false;
                this.LOCK2.notifyAll();
            }
            EditorContextBridge.getContext().disposeTimeStamp((Object)this);
        }
        finally {
            this.finishing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        VirtualMachine virtualMachine;
        Object object = this.virtualMachineLock;
        synchronized (object) {
            virtualMachine = this.virtualMachine;
        }
        object = this.LOCK;
        synchronized (object) {
            if (virtualMachine != null) {
                logger.fine("VM suspend");
                virtualMachine.suspend();
                List<ThreadReference> list = virtualMachine.allThreads();
                for (ThreadReference threadReference : list) {
                    while (threadReference.suspendCount() > 1) {
                        threadReference.resume();
                    }
                }
            }
            this.setState(3);
        }
        this.notifySuspendAll();
    }

    public void notifySuspendAll() {
        Collection collection = this.threadsTranslation.getTranslated();
        for (Object e : collection) {
            boolean bl;
            if (!(e instanceof JPDAThreadImpl)) continue;
            int n = ((JPDAThreadImpl)e).getState();
            boolean bl2 = bl = n == 5 || n == -1 || n == 0;
            if (!bl) {
                try {
                    ((JPDAThreadImpl)e).notifySuspended();
                }
                catch (ObjectCollectedException objectCollectedException) {
                    bl = true;
                }
            }
            if (!bl) continue;
            this.threadsTranslation.remove(((JPDAThreadImpl)e).getThreadReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.doContinue) {
                this.doContinue = true;
                return;
            }
        }
        if (this.operator.flushStaledEvents()) {
            return;
        }
        this.setState(2);
        this.notifyToBeResumedAll();
        Object object2 = this.virtualMachineLock;
        synchronized (object2) {
            object = this.virtualMachine;
        }
        object2 = this.LOCK;
        synchronized (object2) {
            if (object != null) {
                logger.fine("VM resume");
                object.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean currentThreadToBeResumed() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.doContinue) {
                this.doContinue = true;
                return false;
            }
        }
        if (this.operator.flushStaledEvents()) {
            return false;
        }
        this.setState(2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeCurrentThread() {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.doContinue) {
                this.doContinue = true;
                return;
            }
        }
        if (this.operator.flushStaledEvents()) {
            return;
        }
        this.setState(2);
        this.currentThread.resume();
    }

    public void notifyToBeResumedAll() {
        Collection collection = this.threadsTranslation.getTranslated();
        for (Object e : collection) {
            boolean bl;
            if (!(e instanceof JPDAThreadImpl)) continue;
            int n = ((JPDAThreadImpl)e).getState();
            boolean bl2 = bl = n == 5 || n == -1 || n == 0;
            if (!bl) {
                ((JPDAThreadImpl)e).notifyToBeResumed();
                continue;
            }
            this.threadsTranslation.remove(((JPDAThreadImpl)e).getThreadReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadsCache getThreadsCache() {
        Object object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.threadsCache == null) {
                this.threadsCache = new ThreadsCache(this);
                this.threadsCache.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        String string = propertyChangeEvent.getPropertyName();
                        if ("threadStarted".equals(string)) {
                            JPDADebuggerImpl.this.firePropertyChange("threadStarted", null, JPDADebuggerImpl.this.getThread((ThreadReference)propertyChangeEvent.getNewValue()));
                        }
                        if ("threadDied".equals(string)) {
                            JPDADebuggerImpl.this.firePropertyChange("threadDied", JPDADebuggerImpl.this.getThread((ThreadReference)propertyChangeEvent.getOldValue()), null);
                        }
                        if ("groupAdded".equals(string)) {
                            JPDADebuggerImpl.this.firePropertyChange("threadGroupAdded", null, JPDADebuggerImpl.this.getThreadGroup((ThreadGroupReference)propertyChangeEvent.getNewValue()));
                        }
                    }
                });
            }
            return this.threadsCache;
        }
    }

    List<JPDAThread> getAllThreads() {
        ThreadsCache threadsCache = this.getThreadsCache();
        if (threadsCache == null) {
            return Collections.emptyList();
        }
        List<ThreadReference> list = threadsCache.getAllThreads();
        int n = list.size();
        ArrayList<JPDAThread> arrayList = new ArrayList<JPDAThread>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getThread(list.get(i)));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public JPDAThreadGroup[] getTopLevelThreadGroups() {
        ThreadsCache threadsCache = this.getThreadsCache();
        if (threadsCache == null) {
            return new JPDAThreadGroup[0];
        }
        List<ThreadGroupReference> list = threadsCache.getTopLevelThreadGroups();
        JPDAThreadGroup[] jPDAThreadGroupArray = new JPDAThreadGroup[list.size()];
        for (int i = 0; i < jPDAThreadGroupArray.length; ++i) {
            jPDAThreadGroupArray[i] = this.getThreadGroup(list.get(i));
        }
        return jPDAThreadGroupArray;
    }

    public JPDAThread getThread(ThreadReference threadReference) {
        return (JPDAThread)this.threadsTranslation.translate(threadReference);
    }

    public JPDAThread getExistingThread(ThreadReference threadReference) {
        return (JPDAThread)this.threadsTranslation.translateExisting(threadReference);
    }

    public JPDAThreadGroup getThreadGroup(ThreadGroupReference threadGroupReference) {
        return (JPDAThreadGroup)this.threadsTranslation.translate(threadGroupReference);
    }

    public Variable getLocalVariable(LocalVariable localVariable, Value value) {
        return (Variable)this.localsTranslation.translate(localVariable, value);
    }

    public JPDAClassType getClassType(ReferenceType referenceType) {
        return (JPDAClassType)this.localsTranslation.translate(referenceType);
    }

    public Variable getVariable(Value value) {
        return this.getLocalsTreeModel().getVariable(value);
    }

    public ExpressionPool getExpressionPool() {
        return this.expressionPool;
    }

    synchronized void setSingleThreadStepResumeDecision(Boolean bl) {
        this.singleThreadStepResumeDecision = bl;
    }

    synchronized Boolean getSingleThreadStepResumeDecision() {
        return this.singleThreadStepResumeDecision;
    }

    public synchronized void setStepInterruptByBptResumeDecision(Boolean bl) {
        this.stepInterruptByBptResumeDecision = bl;
    }

    public synchronized Boolean getStepInterruptByBptResumeDecision() {
        return this.stepInterruptByBptResumeDecision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGenericsSupport() {
        tcGenericSignatureMethod = null;
        if (Bootstrap.virtualMachineManager().minorInterfaceVersion() >= 5) {
            VirtualMachine virtualMachine;
            Object object = this.virtualMachineLock;
            synchronized (object) {
                virtualMachine = this.virtualMachine;
            }
            if (virtualMachine == null) {
                return;
            }
            try {
                int n;
                object = jvmVersionPattern.matcher(virtualMachine.version());
                if (((Matcher)object).matches() && (n = Integer.parseInt(((Matcher)object).group(2))) >= 5) {
                    try {
                        tcGenericSignatureMethod = TypeComponent.class.getMethod("genericSignature", new Class[0]);
                        lvGenericSignatureMethod = LocalVariable.class.getMethod("genericSignature", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeEvent setStateNoFire(int n) {
        int n2;
        Object object = this.stateLock;
        synchronized (object) {
            if (n == this.state) {
                return null;
            }
            n2 = this.state;
            this.state = n;
        }
        System.setProperty("org.openide.awt.SwingBrowserImpl.do-not-block-awt", String.valueOf(n != 4));
        return new PropertyChangeEvent((Object)this, "state", new Integer(n2), new Integer(n));
    }

    private void setState(int n) {
        PropertyChangeEvent propertyChangeEvent = this.setStateNoFire(n);
        if (propertyChangeEvent != null) {
            this.firePropertyChange(propertyChangeEvent);
        }
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.pcs.firePropertyChange(propertyChangeEvent);
    }

    public synchronized SourcePath getEngineContext() {
        if (this.engineContext == null) {
            this.engineContext = (SourcePath)this.lookupProvider.lookupFirst(null, SourcePath.class);
        }
        return this.engineContext;
    }

    private LocalsTreeModel getLocalsTreeModel() {
        if (this.localsTreeModel == null) {
            this.localsTreeModel = (LocalsTreeModel)this.lookupProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.localsTreeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadReference getEvaluationThread() {
        Object object = this.currentThreadAndFrameLock;
        synchronized (object) {
            if (this.currentThread != null) {
                return this.currentThread.getThreadReference();
            }
        }
        List<ThreadReference> list = this.virtualMachineLock;
        synchronized (list) {
            object = this.virtualMachine;
        }
        if (object == null) {
            return null;
        }
        list = object.allThreads();
        if (list.size() < 1) {
            return null;
        }
        int n = list.size();
        ThreadReference threadReference = null;
        for (int i = 0; i < n; ++i) {
            ThreadReference threadReference2 = list.get(i);
            if (!threadReference2.isSuspended()) continue;
            threadReference = threadReference2;
            if (!threadReference2.name().equals("Finalizer")) continue;
            return threadReference2;
        }
        return threadReference;
    }

    private void updateCurrentCallStackFrame(JPDAThread jPDAThread) {
        if (jPDAThread == null || jPDAThread.getStackDepth() < 1) {
            this.setCurrentCallStackFrame(null);
        } else {
            try {
                this.setCurrentCallStackFrame(jPDAThread.getCallStack(0, 1)[0]);
            }
            catch (AbsentInformationException absentInformationException) {
                this.setCurrentCallStackFrame(null);
            }
        }
    }

    private PropertyChangeEvent updateCurrentCallStackFrameNoFire(JPDAThread jPDAThread) {
        CallStackFrame callStackFrame;
        CallStackFrame callStackFrame2;
        if (jPDAThread == null || jPDAThread.getStackDepth() < 1) {
            callStackFrame2 = null;
            callStackFrame = this.setCurrentCallStackFrameNoFire(null);
        } else {
            try {
                callStackFrame2 = jPDAThread.getCallStack(0, 1)[0];
                callStackFrame = this.setCurrentCallStackFrameNoFire(callStackFrame2);
            }
            catch (AbsentInformationException absentInformationException) {
                callStackFrame2 = null;
                callStackFrame = this.setCurrentCallStackFrameNoFire(null);
            }
        }
        if (callStackFrame == callStackFrame2) {
            return null;
        }
        return new PropertyChangeEvent((Object)this, "currentCallStackFrame", callStackFrame, callStackFrame2);
    }

    private List<EventRequest> disableAllBreakpoints() {
        logger.fine("disableAllBreakpoints() start.");
        ArrayList<EventRequest> arrayList = new ArrayList<EventRequest>();
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            return arrayList;
        }
        EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
        arrayList.addAll(eventRequestManager.accessWatchpointRequests());
        arrayList.addAll(eventRequestManager.breakpointRequests());
        arrayList.addAll(eventRequestManager.classPrepareRequests());
        arrayList.addAll(eventRequestManager.classUnloadRequests());
        arrayList.addAll(eventRequestManager.exceptionRequests());
        arrayList.addAll(eventRequestManager.methodEntryRequests());
        arrayList.addAll(eventRequestManager.methodExitRequests());
        arrayList.addAll(eventRequestManager.modificationWatchpointRequests());
        arrayList.addAll(eventRequestManager.threadDeathRequests());
        arrayList.addAll(eventRequestManager.threadStartRequests());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (!((EventRequest)arrayList.get(i)).isEnabled()) {
                arrayList.remove(i);
                continue;
            }
            ((EventRequest)arrayList.get(i)).disable();
        }
        this.operator.breakpointsDisabled();
        logger.fine("disableAllBreakpoints() end.");
        return arrayList;
    }

    private void enableAllBreakpoints(List<EventRequest> list) {
        logger.fine("enableAllBreakpoints() start.");
        this.operator.breakpointsEnabled();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                list.get(i).enable();
                continue;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                continue;
            }
            catch (InvalidRequestStateException invalidRequestStateException) {
                // empty catch block
            }
        }
        logger.fine("enableAllBreakpoints() end.");
    }

    private void checkJSR45Languages(JPDAThread jPDAThread) {
        if (jPDAThread.getStackDepth() > 0) {
            try {
                String string;
                CallStackFrame callStackFrame = jPDAThread.getCallStack(0, 1)[0];
                List list = callStackFrame.getAvailableStrata();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (this.languages.contains(list.get(i))) continue;
                    string = (String)list.get(i);
                    DebuggerManager.getDebuggerManager().startDebugging(this.createJSR45DI(string));
                    this.languages.add(string);
                }
                string = callStackFrame.getDefaultStratum();
                if (string != null && !string.equals(this.lastStratumn)) {
                    this.javaEngineProvider.getSession().setCurrentLanguage(string);
                }
                this.lastStratumn = string;
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
    }

    private DebuggerInfo createJSR45DI(String string) {
        if (this.jsr45EngineProviders == null) {
            this.jsr45EngineProviders = new HashSet<JSR45DebuggerEngineProvider>(1);
        }
        JSR45DebuggerEngineProvider jSR45DebuggerEngineProvider = new JSR45DebuggerEngineProvider(string);
        this.jsr45EngineProviders.add(jSR45DebuggerEngineProvider);
        return DebuggerInfo.create((String)("netbeans-jpda-JSR45DICookie-" + string), (Object[])new Object[]{new DelegatingSessionProvider(){

            public Session getSession(DebuggerInfo debuggerInfo) {
                return JPDADebuggerImpl.this.javaEngineProvider.getSession();
            }
        }, jSR45DebuggerEngineProvider});
    }

    public JPDAStep createJPDAStep(int n, int n2) {
        Session session = (Session)this.lookupProvider.lookupFirst(null, Session.class);
        return new JPDAStepImpl(this, session, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPDAClassType> getAllClasses() {
        List<ReferenceType> list;
        Object object = this.virtualMachineLock;
        synchronized (object) {
            if (this.virtualMachine == null) {
                list = Collections.emptyList();
            } else {
                try {
                    list = this.virtualMachine.allClasses();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    list = Collections.emptyList();
                }
            }
        }
        return new ClassTypeList(this, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPDAClassType> getClassesByName(String string) {
        List<ReferenceType> list;
        Object object = this.virtualMachineLock;
        synchronized (object) {
            if (this.virtualMachine == null) {
                list = Collections.emptyList();
            } else {
                try {
                    list = this.virtualMachine.classesByName(string);
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    list = Collections.emptyList();
                }
            }
        }
        return new ClassTypeList(this, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getInstanceCounts(List<JPDAClassType> list) throws UnsupportedOperationException {
        if (Java6Methods.isJDK6()) {
            VirtualMachine virtualMachine;
            ArrayList<ReferenceType> arrayList = this.virtualMachineLock;
            synchronized (arrayList) {
                virtualMachine = this.virtualMachine;
            }
            if (virtualMachine == null) {
                return new long[list.size()];
            }
            try {
                virtualMachine.version();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                return new long[list.size()];
            }
            if (list instanceof ClassTypeList) {
                arrayList = (ClassTypeList)list;
                return Java6Methods.instanceCounts(virtualMachine, ((ClassTypeList)((Object)arrayList)).getTypes());
            }
            arrayList = new ArrayList<ReferenceType>(list.size());
            for (JPDAClassType jPDAClassType : list) {
                arrayList.add(((JPDAClassTypeImpl)jPDAClassType).getType());
            }
            return Java6Methods.instanceCounts(virtualMachine, arrayList);
        }
        throw new UnsupportedOperationException("Not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGetInstanceInfo() {
        Object object = this.virtualMachineLock;
        synchronized (object) {
            return this.virtualMachine != null && JPDADebuggerImpl.canGetInstanceInfo(this.virtualMachine);
        }
    }

    private static boolean canGetInstanceInfo(VirtualMachine virtualMachine) {
        if (Java6Methods.isJDK6()) {
            try {
                Method method = VirtualMachine.class.getMethod("canGetInstanceInfo", new Class[0]);
                Object object = method.invoke((Object)virtualMachine, new Object[0]);
                return Boolean.TRUE.equals(object);
            }
            catch (Exception exception) {
                Logger.getLogger(JPDADebuggerImpl.class.getName()).log(Level.INFO, "", exception);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadsCollectorImpl getThreadsCollector() {
        Object object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.threadsCollector == null) {
                this.threadsCollector = new ThreadsCollectorImpl(this);
            }
            return this.threadsCollector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeadlockDetector getDeadlockDetector() {
        Object object = this.threadsCollectorLock;
        synchronized (object) {
            if (this.deadlockDetector == null) {
                this.deadlockDetector = new DeadlockDetectorImpl(this);
            }
            return this.deadlockDetector;
        }
    }
}

