/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.AstPath;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.SemanticAnalysisVisitor;
import org.netbeans.modules.groovy.editor.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.parser.GroovyParserResult;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovySemanticAnalyzer
implements SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationInfo compilationInfo) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        GroovyParserResult groovyParserResult = AstUtilities.getParseResult(compilationInfo);
        if (groovyParserResult == null) {
            return;
        }
        ModuleNode moduleNode = AstUtilities.getRoot(compilationInfo);
        if (moduleNode == null) {
            return;
        }
        HashMap<OffsetRange, Set<Object>> hashMap = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        AstPath astPath = new AstPath();
        astPath.descend(moduleNode);
        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        if (baseDocument == null) {
            return;
        }
        SemanticAnalysisVisitor semanticAnalysisVisitor = new SemanticAnalysisVisitor(moduleNode, baseDocument);
        hashMap.putAll(semanticAnalysisVisitor.annotate());
        astPath.ascend();
        if (this.isCancelled()) {
            return;
        }
        if (hashMap.size() > 0) {
            if (groovyParserResult.getTranslatedSource() != null) {
                HashMap hashMap2 = new HashMap(2 * hashMap.size());
                for (Map.Entry entry : hashMap.entrySet()) {
                    OffsetRange offsetRange = LexUtilities.getLexerOffsets(compilationInfo, (OffsetRange)entry.getKey());
                    if (offsetRange == OffsetRange.NONE) continue;
                    hashMap2.put(offsetRange, entry.getValue());
                }
                hashMap = hashMap2;
            }
            this.semanticHighlights = hashMap;
        } else {
            this.semanticHighlights = null;
        }
    }
}

