/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.parser;

import groovy.lang.GroovyClassLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.AstNodeAdapter;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.GroovyCompilerErrorID;
import org.netbeans.modules.groovy.editor.GroovyUtils;
import org.netbeans.modules.groovy.editor.elements.AstRootElement;
import org.netbeans.modules.groovy.editor.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.parser.GroovyError;
import org.netbeans.modules.groovy.editor.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.parser.GroovyPositionManager;
import org.netbeans.modules.groovy.editor.parser.NbCompilationUnit;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.PositionManager;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

class GroovyParser
implements Parser {
    private final PositionManager positions = this.createPositionManager();
    private final Logger LOG = Logger.getLogger(GroovyParser.class.getName());
    private boolean waitJavaScanFinished = true;

    public void parseFiles(Parser.Job job) {
        ParseListener parseListener = job.listener;
        SourceFileReader sourceFileReader = job.reader;
        for (ParserFile parserFile : job.files) {
            CharSequence charSequence;
            ParseEvent parseEvent = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, null);
            parseListener.started(parseEvent);
            GroovyParserResult groovyParserResult = null;
            try {
                charSequence = sourceFileReader.read(parserFile);
                String string = GroovyParser.asString(charSequence);
                int n = sourceFileReader.getCaretOffset(parserFile);
                Context context = new Context(parserFile, parseListener, string, n, AstUtilities.getBaseDocument(parserFile.getFileObject(), true));
                groovyParserResult = this.parseBuffer(context, Sanitize.NONE);
            }
            catch (IOException iOException) {
                parseListener.exception((Exception)iOException);
                groovyParserResult = this.createParseResult(parserFile, null, null, null);
            }
            charSequence = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, (ParserResult)groovyParserResult);
            parseListener.finished((ParseEvent)charSequence);
        }
    }

    public PositionManager getPositionManager() {
        return this.positions;
    }

    void setWaitJavaScanFinished(boolean bl) {
        this.waitJavaScanFinished = bl;
    }

    protected GroovyParserResult createParseResult(ParserFile parserFile, AstRootElement astRootElement, ParserResult.AstTreeNode astTreeNode, ErrorCollector errorCollector) {
        GroovyParserResult groovyParserResult = new GroovyParserResult(this, parserFile, astRootElement, astTreeNode, errorCollector);
        return groovyParserResult;
    }

    private boolean sanitizeSource(Context context, Sanitize sanitize) {
        if (sanitize == Sanitize.MISSING_END) {
            context.sanitizedSource = context.source + "}";
            int n = context.source.length();
            context.sanitizedRange = new OffsetRange(n, n + 1);
            context.sanitizedContents = "";
            return true;
        }
        int n = context.caretOffset;
        if (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.ERROR_LINE) {
            n = context.errorOffset;
        }
        if (n == -1) {
            return false;
        }
        String string = context.source;
        if (n > string.length()) {
            return false;
        }
        try {
            if ((GroovyUtils.isRowEmpty(string, n) || GroovyUtils.isRowWhite(string, n)) && (n = GroovyUtils.getRowStart(string, n) - 1) < 0) {
                n = 0;
            }
            if (!GroovyUtils.isRowEmpty(string, n) && !GroovyUtils.isRowWhite(string, n)) {
                if (sanitize == Sanitize.EDITED_LINE || sanitize == Sanitize.ERROR_LINE) {
                    Object object;
                    TokenSequence<? extends GroovyTokenId> tokenSequence;
                    if (sanitize == Sanitize.ERROR_LINE && (tokenSequence = LexUtilities.getPositionedSequence(context.document, n)) != null && (object = LexUtilities.findPreviousNonWsNonComment(tokenSequence)).id() == GroovyTokenId.DOT) {
                        int n2 = tokenSequence.offset();
                        int n3 = n2 + 1;
                        StringBuilder stringBuilder = new StringBuilder(string.length());
                        stringBuilder.append(string.substring(0, n2));
                        stringBuilder.append(' ');
                        if (n3 < string.length()) {
                            stringBuilder.append(string.substring(n3, string.length()));
                        }
                        assert (stringBuilder.length() == string.length());
                        context.sanitizedRange = new OffsetRange(n2, n3);
                        context.sanitizedSource = stringBuilder.toString();
                        context.sanitizedContents = string.substring(n2, n3);
                        return true;
                    }
                    int n4 = GroovyUtils.getRowLastNonWhite(string, n);
                    if (n4 != -1) {
                        object = new StringBuilder(string.length());
                        int n5 = GroovyUtils.getRowStart(string, n);
                        if (++n4 >= n5 + 2) {
                            ((StringBuilder)object).append(string.substring(0, n5));
                            ((StringBuilder)object).append("//");
                            int n6 = n5 + 2;
                            if (n6 < string.length()) {
                                ((StringBuilder)object).append(string.substring(n6, string.length()));
                            }
                        } else {
                            ((StringBuilder)object).append(string.substring(0, n5));
                            ((StringBuilder)object).append(" ");
                            int n7 = n5 + 1;
                            if (n7 < string.length()) {
                                ((StringBuilder)object).append(string.substring(n7, string.length()));
                            }
                        }
                        assert (((StringBuilder)object).length() == string.length());
                        context.sanitizedRange = new OffsetRange(n5, n4);
                        context.sanitizedSource = ((StringBuilder)object).toString();
                        context.sanitizedContents = string.substring(n5, n4);
                        return true;
                    }
                } else {
                    int n8;
                    assert (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.EDITED_DOT);
                    int n9 = GroovyUtils.getRowStart(string, n);
                    for (n8 = n - 1; n8 >= n9 && n8 < string.length() && Character.isWhitespace(string.charAt(n8)); --n8) {
                    }
                    if (n8 > n9) {
                        StringBuilder stringBuilder = new StringBuilder(string.length());
                        String string2 = string.substring(n9, n8 + 1);
                        int n10 = 0;
                        int n11 = n8 + 1;
                        if (string2.endsWith(".") || string2.endsWith("(")) {
                            n10 = 1;
                        } else if (string2.endsWith(",")) {
                            n10 = 1;
                        } else if (string2.endsWith(", ")) {
                            n10 = 2;
                        } else if (string2.endsWith(",)")) {
                            n10 = 1;
                            --n11;
                        } else if (string2.endsWith(", )")) {
                            n10 = 1;
                            n11 -= 2;
                        }
                        if (n10 == 0) {
                            return false;
                        }
                        int n12 = n11 - n10;
                        stringBuilder.append(string.substring(0, n12));
                        for (int i = 0; i < n10; ++i) {
                            stringBuilder.append(' ');
                        }
                        if (n11 < string.length()) {
                            stringBuilder.append(string.substring(n11, string.length()));
                        }
                        assert (stringBuilder.length() == string.length());
                        context.sanitizedRange = new OffsetRange(n12, n11);
                        context.sanitizedSource = stringBuilder.toString();
                        context.sanitizedContents = string.substring(n12, n11);
                        return true;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return false;
    }

    private GroovyParserResult sanitize(Context context, Sanitize sanitize) {
        switch (sanitize) {
            case NEVER: {
                return this.createParseResult(context.file, null, null, null);
            }
            case NONE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_DOT);
                }
            }
            case EDITED_DOT: {
                if (context.errorOffset != -1 && context.errorOffset != context.caretOffset) {
                    return this.parseBuffer(context, Sanitize.ERROR_DOT);
                }
            }
            case ERROR_DOT: {
                if (context.errorOffset != -1) {
                    return this.parseBuffer(context, Sanitize.ERROR_LINE);
                }
            }
            case ERROR_LINE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_LINE);
                }
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.MISSING_END);
            }
        }
        return this.createParseResult(context.file, null, null, null);
    }

    GroovyParserResult parseBuffer(Context context, Sanitize sanitize) {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        FileObject fileObject;
        boolean bl;
        boolean bl2 = false;
        String string = context.source;
        if (sanitize != Sanitize.NONE && sanitize != Sanitize.NEVER) {
            bl = this.sanitizeSource(context, sanitize);
            if (bl) {
                assert (context.sanitizedSource != null);
                bl2 = true;
                string = context.sanitizedSource;
            } else {
                return this.sanitize(context, sanitize);
            }
        }
        bl = bl2;
        if (sanitize == Sanitize.NONE) {
            context.errorOffset = -1;
        }
        String string2 = "";
        if (context.file != null && context.file.getFileObject() != null) {
            string2 = context.file.getFileObject().getNameExt();
        }
        ClassPath classPath = (fileObject = context.file.getFileObject()) == null ? ClassPathSupport.createClassPath((URL[])new URL[0]) : ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        ClassPath classPath2 = fileObject == null ? ClassPathSupport.createClassPath((URL[])new URL[0]) : ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        ClassPath classPath3 = fileObject == null ? ClassPathSupport.createClassPath((URL[])new URL[0]) : ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        ClassPath classPath4 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath, classPath2, classPath3});
        ClassLoader classLoader = classPath4.getClassLoader(true);
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(classLoader, compilerConfiguration);
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[0]), (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[0]), (ClassPath)classPath3);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        NbCompilationUnit nbCompilationUnit = new NbCompilationUnit(compilerConfiguration, null, groovyClassLoader, javaSource, this.waitJavaScanFinished);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        nbCompilationUnit.addSource(string2, byteArrayInputStream);
        try {
            nbCompilationUnit.compile(7);
        }
        catch (Throwable throwable) {
            int n = -1;
            object4 = throwable.getMessage();
            object3 = throwable.getLocalizedMessage();
            object22 = nbCompilationUnit.getErrorCollector();
            if (((ErrorCollector)object22).hasErrors() && (object = ((ErrorCollector)object22).getLastError()) instanceof SyntaxErrorMessage) {
                int n2;
                SyntaxException syntaxException = ((SyntaxErrorMessage)object).getCause();
                int n3 = syntaxException.getStartLine();
                if (n3 < 1) {
                    n3 = 1;
                }
                if ((n2 = syntaxException.getStartColumn()) < 1) {
                    n2 = 1;
                }
                n = AstUtilities.getOffset(context.document, n3, n2);
                object4 = syntaxException.getMessage();
                object3 = syntaxException.getLocalizedMessage();
            }
            if (n >= string.length() && (n = string.length() - 1) < 0) {
                n = 0;
            }
            this.LOG.log(Level.FINEST, "Comp-Ex, errorMessage    : {0}", object4);
            this.LOG.log(Level.FINEST, "Comp-Ex, localizedMessage: {0}", object3);
        }
        CompileUnit compileUnit = nbCompilationUnit.getAST();
        List list = compileUnit.getModules();
        object4 = null;
        for (Object object22 : list) {
            if (!string2.equals(((ModuleNode)object22).getContext().getName())) continue;
            object4 = object22;
        }
        this.handleErrorCollector(nbCompilationUnit.getErrorCollector(), context, (ModuleNode)object4, bl, sanitize);
        if (object4 != null) {
            context.sanitized = sanitize;
            object3 = new AstRootElement(context.file.getFileObject(), (ModuleNode)object4);
            object22 = new AstNodeAdapter(null, (ASTNode)object4, context.document);
            object = this.createParseResult(context.file, (AstRootElement)object3, (ParserResult.AstTreeNode)object22, nbCompilationUnit.getErrorCollector());
            ((GroovyParserResult)((Object)object)).setSanitized(context.sanitized, context.sanitizedRange, context.sanitizedContents);
            return object;
        }
        return this.sanitize(context, sanitize);
    }

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    private PositionManager createPositionManager() {
        return new GroovyPositionManager();
    }

    private static void notifyError(Context context, String string, Severity severity, String string2, String string3, int n, Sanitize sanitize) {
        GroovyParser.notifyError(context, string, severity, string2, string3, n, n, sanitize);
    }

    private static void notifyError(Context context, String string, Severity severity, String string2, String string3, int n, int n2, Sanitize sanitize) {
        Logger logger = Logger.getLogger(GroovyParser.class.getName());
        logger.log(Level.FINEST, "---------------------------------------------------");
        logger.log(Level.FINEST, "key         : {0}\n", string);
        logger.log(Level.FINEST, "description : {0}\n", string2);
        logger.log(Level.FINEST, "displayName : {0}\n", string3);
        logger.log(Level.FINEST, "startOffset : {0}\n", n);
        logger.log(Level.FINEST, "endOffset   : {0}\n", n2);
        if (string2 == null) {
            logger.log(Level.FINEST, "dropping error");
            return;
        }
        if (string == null) {
            string = string2;
        }
        if (string3 == null) {
            string3 = string2;
        }
        GroovyError groovyError = new GroovyError(string, string3, string2, context.file.getFileObject(), n, n2, severity, GroovyParser.getIdForErrorMessage(string2));
        context.listener.error((Error)groovyError);
        if (sanitize == Sanitize.NONE) {
            context.errorOffset = n;
        }
    }

    static GroovyCompilerErrorID getIdForErrorMessage(String string) {
        String string2 = "unable to resolve class ";
        if (string != null && string.startsWith(string2)) {
            return GroovyCompilerErrorID.CLASS_NOT_FOUND;
        }
        return GroovyCompilerErrorID.UNDEFINED;
    }

    private void handleErrorCollector(ErrorCollector errorCollector, Context context, ModuleNode moduleNode, boolean bl, Sanitize sanitize) {
        List list;
        this.LOG.log(Level.FINEST, "handleErrorCollector()");
        if (!bl && errorCollector != null && (list = errorCollector.getErrors()) != null) {
            for (Object e : list) {
                Object object;
                this.LOG.log(Level.FINEST, "Error found in collector: {0}", e);
                if (e instanceof SyntaxErrorMessage) {
                    String string;
                    object = ((SyntaxErrorMessage)e).getCause();
                    String string2 = ((SyntaxException)object).getSourceLocator();
                    String string3 = string = moduleNode != null ? moduleNode.getContext().getName() : context.file.getNameExt();
                    if (string2 == null || string == null || !string2.equals(string)) continue;
                    int n = ((SyntaxException)object).getStartLine();
                    int n2 = ((SyntaxException)object).getStartColumn();
                    int n3 = ((SyntaxException)object).getLine();
                    int n4 = ((SyntaxException)object).getEndColumn();
                    int n5 = AstUtilities.getOffset(context.document, n > 0 ? n : 1, n2 > 0 ? n2 : 1);
                    int n6 = AstUtilities.getOffset(context.document, n3 > 0 ? n3 : 1, n4 > 0 ? n4 : 1);
                    GroovyParser.notifyError(context, null, Severity.ERROR, ((SyntaxException)object).getMessage(), null, n5, n6, sanitize);
                    continue;
                }
                if (e instanceof SimpleMessage) {
                    object = ((SimpleMessage)e).getMessage();
                    GroovyParser.notifyError(context, null, Severity.ERROR, (String)object, null, -1, sanitize);
                    continue;
                }
                GroovyParser.notifyError(context, null, Severity.ERROR, "Error", null, -1, sanitize);
            }
        }
    }

    public static final class Context {
        private final ParserFile file;
        private final ParseListener listener;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;
        private BaseDocument document;

        public Context(ParserFile parserFile, ParseListener parseListener, String string, int n, BaseDocument baseDocument) {
            this.file = parserFile;
            this.listener = parseListener;
            this.source = string;
            this.caretOffset = n;
            this.document = baseDocument;
        }

        public String toString() {
            return "GroovyParser.Context(" + this.file.toString() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sanitize {
        NEVER,
        NONE,
        EDITED_DOT,
        ERROR_DOT,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_END;

    }
}

