/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.groovy.editor.actions.FixImportsHelper;
import org.netbeans.modules.groovy.editor.actions.ImportChooserInnerPanel;
import org.netbeans.modules.groovy.editor.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.parser.SourceUtils;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixImportsAction
extends BaseAction
implements Runnable {
    private final Logger LOG = Logger.getLogger(FixImportsAction.class.getName());
    Document doc = null;
    private FixImportsHelper helper = new FixImportsHelper();

    public FixImportsAction() {
        super(NbBundle.getMessage(FixImportsAction.class, (String)"fix-groovy-imports"), 0);
    }

    public boolean isEnabled() {
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        this.LOG.log(Level.FINEST, "actionPerformed(final JTextComponent comp)");
        assert (jTextComponent != null);
        this.doc = jTextComponent.getDocument();
        if (this.doc != null) {
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    @Override
    public void run() {
        List<FixImportsHelper.ImportCandidate> list;
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)this.doc);
        if (dataObject == null) {
            this.LOG.log(Level.FINEST, "Could not get DataObject for document");
            return;
        }
        final ArrayList arrayList = new ArrayList();
        FileObject fileObject = dataObject.getPrimaryFile();
        try {
            SourceUtils.runUserActionTask(fileObject, new CancellableTask<GroovyParserResult>(){

                public void run(GroovyParserResult groovyParserResult) throws Exception {
                    if (groovyParserResult != null) {
                        ErrorCollector errorCollector = groovyParserResult.getErrorCollector();
                        if (errorCollector == null) {
                            FixImportsAction.this.LOG.log(Level.FINEST, "Could not get error collector");
                            return;
                        }
                        List list = errorCollector.getErrors();
                        if (list == null) {
                            FixImportsAction.this.LOG.log(Level.FINEST, "Could not get list of errors");
                            return;
                        }
                        for (Object e : list) {
                            SyntaxException syntaxException;
                            if (!(e instanceof SyntaxErrorMessage) || (syntaxException = ((SyntaxErrorMessage)e).getCause()) == null) continue;
                            FixImportsAction.this.helper;
                            String string = FixImportsHelper.getMissingClassName(syntaxException.getMessage());
                            if (string == null || arrayList.contains(string)) continue;
                            arrayList.add(string);
                        }
                    }
                }

                public void cancel() {
                }
            });
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        HashMap<String, List> hashMap = new HashMap<String, List>();
        for (Object object2 : arrayList) {
            list = this.helper.getImportCandidate(fileObject, (String)object2);
            if (list.isEmpty()) {
                return;
            }
            int n = list.size();
            if (n == 1) {
                this.helper.doImport(fileObject, list.get(0).getFqnName());
                continue;
            }
            this.LOG.log(Level.FINEST, "Adding to multipleCandidates: " + (String)object2);
            hashMap.put((String)object2, list);
        }
        Object object = null;
        if (!hashMap.isEmpty()) {
            this.LOG.log(Level.FINEST, "multipleCandidates.size(): " + hashMap.size());
            object = this.presentChooser(hashMap);
        }
        if (object != null && !object.isEmpty()) {
            Object object2;
            this.LOG.log(Level.FINEST, "listToFix.size(): " + object.size());
            object2 = object.iterator();
            while (object2.hasNext()) {
                list = (String)object2.next();
                this.helper.doImport(fileObject, (String)((Object)list));
            }
        }
    }

    private List<String> presentChooser(Map<String, List> map) {
        this.LOG.log(Level.FINEST, "presentChooser()");
        List<String> list = new ArrayList<String>();
        ImportChooserInnerPanel importChooserInnerPanel = new ImportChooserInnerPanel();
        importChooserInnerPanel.initPanel(map);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)importChooserInnerPanel, NbBundle.getMessage(FixImportsAction.class, (String)"FixImportsDialogTitle"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.setVisible(false);
        dialog.dispose();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            list = importChooserInnerPanel.getSelections();
        }
        return list;
    }
}

