/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.AstPath;
import org.netbeans.modules.groovy.editor.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.lexer.LexUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeVisitor
extends ClassCodeVisitorSupport {
    protected final SourceUnit sourceUnit;
    protected final AstPath path;
    protected final ASTNode leaf;
    protected final BaseDocument doc;
    protected final int cursorOffset;
    private ClassNode guessedType;
    private boolean leafReached = false;

    public TypeVisitor(SourceUnit sourceUnit, AstPath astPath, BaseDocument baseDocument, int n) {
        this.sourceUnit = sourceUnit;
        this.path = astPath;
        this.leaf = astPath.leaf();
        this.doc = baseDocument;
        this.cursorOffset = n;
    }

    public ClassNode getGuessedType() {
        return this.guessedType;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void collect() {
        Object object;
        this.guessedType = null;
        this.leafReached = false;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getPositionedSequence(this.doc, this.cursorOffset);
        if (tokenSequence == null) {
            return;
        }
        Token token = tokenSequence.token();
        if (token == null) {
            return;
        }
        if (!this.isValidToken((Token<? extends GroovyTokenId>)token)) {
            return;
        }
        if (this.leaf instanceof Variable) {
            object = (Variable)((Object)this.leaf);
            for (ASTNode aSTNode : this.path) {
                VariableScope variableScope;
                Object object2;
                if (aSTNode instanceof ClosureExpression) {
                    object2 = ((ClosureExpression)aSTNode).getVariableScope();
                    if (object2 == null || ((VariableScope)object2).getDeclaredVariable(object.getName()) == null) continue;
                    this.visitClosureExpression((ClosureExpression)aSTNode);
                    return;
                }
                if (aSTNode instanceof MethodNode) {
                    object2 = (MethodNode)aSTNode;
                    variableScope = ((MethodNode)object2).getVariableScope();
                    if (variableScope == null || variableScope.getDeclaredVariable(object.getName()) == null) continue;
                    this.visitParameters(((MethodNode)object2).getParameters(), (Variable)object);
                    super.visitMethod((MethodNode)object2);
                    return;
                }
                if (aSTNode instanceof ConstructorNode) {
                    object2 = (ConstructorNode)aSTNode;
                    variableScope = ((MethodNode)object2).getVariableScope();
                    if (variableScope == null || variableScope.getDeclaredVariable(object.getName()) == null) continue;
                    this.visitParameters(((MethodNode)object2).getParameters(), (Variable)object);
                    super.visitConstructor((ConstructorNode)object2);
                    return;
                }
                if (aSTNode instanceof ForStatement) {
                    object2 = ((ForStatement)aSTNode).getVariableScope();
                    if (object2 == null || ((VariableScope)object2).getDeclaredVariable(object.getName()) == null) continue;
                    this.visitForLoop((ForStatement)aSTNode);
                    return;
                }
                if (aSTNode instanceof BlockStatement) {
                    object2 = ((BlockStatement)aSTNode).getVariableScope();
                    if (object2 == null || ((VariableScope)object2).getDeclaredVariable(object.getName()) == null) continue;
                    this.visitBlockStatement((BlockStatement)aSTNode);
                    return;
                }
                if (!(aSTNode instanceof ClosureListExpression) || (object2 = ((ClosureListExpression)aSTNode).getVariableScope()) == null || ((VariableScope)object2).getDeclaredVariable(object.getName()) == null) continue;
                this.visitClosureListExpression((ClosureListExpression)aSTNode);
                return;
            }
        }
        object = (ModuleNode)this.path.root();
        for (ASTNode aSTNode : ((ModuleNode)object).getClasses()) {
            this.visitClass((ClassNode)aSTNode);
        }
    }

    protected boolean isValidToken(Token<? extends GroovyTokenId> token) {
        return true;
    }

    protected void visitParameters(Parameter[] parameterArray, Variable variable) {
    }

    @Override
    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        Expression expression = binaryExpression.getLeftExpression();
        if (expression instanceof VariableExpression) {
            if (expression == this.leaf) {
                this.leafReached = true;
            }
            if (!this.leafReached && binaryExpression.getOperation().isA(100) && TypeVisitor.sameVariableName(this.leaf, expression)) {
                Expression expression2 = binaryExpression.getRightExpression();
                if (expression2 instanceof ConstantExpression && !expression2.getText().equals("null")) {
                    this.guessedType = ((ConstantExpression)expression2).getType();
                } else if (expression2 instanceof ConstructorCallExpression) {
                    this.guessedType = ((ConstructorCallExpression)expression2).getType();
                }
            }
        }
        super.visitBinaryExpression(binaryExpression);
    }

    private static boolean sameVariableName(ASTNode aSTNode, ASTNode aSTNode2) {
        return aSTNode instanceof VariableExpression && aSTNode2 instanceof VariableExpression && ((VariableExpression)aSTNode).getName().equals(((VariableExpression)aSTNode2).getName());
    }
}

