/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import javax.lang.model.element.ExecutableElement;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;

public class Methods {
    public static boolean isSameMethod(ExecutableElement executableElement, MethodCallExpression methodCallExpression) {
        ConstantExpression constantExpression = (ConstantExpression)methodCallExpression.getMethod();
        return executableElement.getSimpleName().contentEquals(constantExpression.getText()) && Methods.getParameterCount(methodCallExpression) == executableElement.getParameters().size();
    }

    public static boolean isSameMethod(MethodNode methodNode, MethodCallExpression methodCallExpression) {
        return methodNode.getName().equals(methodCallExpression.getMethodAsString()) && Methods.getParameterCount(methodCallExpression) == methodNode.getParameters().length;
    }

    public static boolean isSameMethod(MethodNode methodNode, MethodNode methodNode2) {
        return methodNode.getName().equals(methodNode2.getName()) && methodNode.getParameters().length == methodNode2.getParameters().length;
    }

    public static boolean isSameMethod(MethodCallExpression methodCallExpression, MethodCallExpression methodCallExpression2) {
        String string = methodCallExpression.getMethodAsString();
        if (string != null && string.equals(methodCallExpression2.getMethodAsString())) {
            int n = Methods.getParameterCount(methodCallExpression);
            int n2 = Methods.getParameterCount(methodCallExpression2);
            if (n >= 0 && n == n2) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSameConstructor(ConstructorNode constructorNode, ConstructorCallExpression constructorCallExpression) {
        return constructorNode.getDeclaringClass().getNameWithoutPackage().equals(constructorCallExpression.getType().getNameWithoutPackage()) && Methods.getParameterCount(constructorCallExpression) == constructorNode.getParameters().length;
    }

    public static boolean isSameConstuctor(ConstructorCallExpression constructorCallExpression, ConstructorCallExpression constructorCallExpression2) {
        String string = constructorCallExpression.getType().getNameWithoutPackage();
        if (string != null && string.equals(constructorCallExpression2.getType().getNameWithoutPackage())) {
            int n = Methods.getParameterCount(constructorCallExpression);
            int n2 = Methods.getParameterCount(constructorCallExpression2);
            if (n >= 0 && n == n2) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSameConstructor(ConstructorNode constructorNode, ConstructorNode constructorNode2) {
        return Methods.isSameMethod((MethodNode)constructorNode, constructorNode2);
    }

    private static int getParameterCount(MethodCallExpression methodCallExpression) {
        Expression expression = methodCallExpression.getArguments();
        if (expression instanceof ArgumentListExpression) {
            return ((ArgumentListExpression)expression).getExpressions().size();
        }
        if (expression instanceof NamedArgumentListExpression) {
            return 1;
        }
        return -1;
    }

    private static int getParameterCount(ConstructorCallExpression constructorCallExpression) {
        Expression expression = constructorCallExpression.getArguments();
        if (expression instanceof ArgumentListExpression) {
            return ((ArgumentListExpression)expression).getExpressions().size();
        }
        if (expression instanceof NamedArgumentListExpression) {
            return 1;
        }
        return -1;
    }
}

