/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import javax.swing.text.BadLocationException;

public class GroovyUtils {
    private GroovyUtils() {
    }

    public static String getLineCommentPrefix() {
        return "//";
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$';
    }

    public static boolean isRowWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            for (n2 = n; n2 < string.length() && (c = string.charAt(n2)) != '\n'; ++n2) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            for (n2 = n - 1; n2 >= 0 && (c = string.charAt(n2)) != '\n'; --n2) {
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw GroovyUtils.getBadLocationException(indexOutOfBoundsException, string, n);
        }
    }

    public static boolean isRowEmpty(String string, int n) throws BadLocationException {
        try {
            char c;
            if (n < string.length() && (c = string.charAt(n)) != '\n' && (c != '\r' || n != string.length() - 1 && string.charAt(n + 1) != '\n')) {
                return false;
            }
            return n == 0 || string.charAt(n - 1) == '\n';
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw GroovyUtils.getBadLocationException(indexOutOfBoundsException, string, n);
        }
    }

    public static int getRowLastNonWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            for (n2 = n; n2 < string.length() && (c = string.charAt(n2)) != '\n' && (c != '\r' || n2 != string.length() - 1 && string.charAt(n2 + 1) != '\n'); ++n2) {
            }
            --n2;
            while (n2 >= 0) {
                c = string.charAt(n2);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return n2;
                }
                --n2;
            }
            return -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw GroovyUtils.getBadLocationException(indexOutOfBoundsException, string, n);
        }
    }

    public static int getRowFirstNonWhite(String string, int n) throws BadLocationException {
        try {
            char c;
            int n2;
            if (n2 < string.length()) {
                for (n2 = n - 1; n2 >= 0 && (c = string.charAt(n2)) != '\n'; --n2) {
                }
                ++n2;
            }
            while (n2 < string.length()) {
                c = string.charAt(n2);
                if (c == '\n') {
                    return -1;
                }
                if (!Character.isWhitespace(c)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw GroovyUtils.getBadLocationException(indexOutOfBoundsException, string, n);
        }
    }

    public static int getRowStart(String string, int n) throws BadLocationException {
        try {
            for (int i = n - 1; i >= 0; --i) {
                char c = string.charAt(i);
                if (c != '\n') continue;
                return i + 1;
            }
            return 0;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw GroovyUtils.getBadLocationException(indexOutOfBoundsException, string, n);
        }
    }

    static BadLocationException getBadLocationException(IndexOutOfBoundsException indexOutOfBoundsException, String string, int n) {
        BadLocationException badLocationException = new BadLocationException(n + " out of " + string.length(), n);
        badLocationException.initCause(indexOutOfBoundsException);
        return badLocationException;
    }
}

