/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.AbstractGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBean;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.codegen.model.RelatedEntityResource;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.Inflector;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityResourcesGenerator
extends AbstractGenerator {
    public static final String RESOURCE_FOLDER = "service";
    public static final String CONVERTER_FOLDER = "converter";
    public static final String RESOURCE_SUFFIX = "Resource";
    public static final String CONVERTER_SUFFIX = "Converter";
    private static final String DEFAULT_TEMPLATE = "Templates/WebServices/DefaultResource.java";
    private static final String URI_RESOLVER_TEMPLATE = "Templates/WebServices/UriResolver.java";
    private static final String URI_RESOLVER = "UriResolver";
    private static final String PERSISTENCE_SERVICE_TEMPLATE = "Templates/WebServices/PersistenceService.java";
    private static final String PERSISTENCE_SERVICE_NOJTA_TEMPLATE = "Templates/WebServices/PersistenceServiceNoJTA.java";
    private static final String PERSISTENCE_SERVICE = "PersistenceService";
    private static final String DEFAULT_PU_FIELD = "DEFAULT_PU";
    private static final String[] CONTAINER_IMPORTS = new String[]{"javax.ws.rs.Path", "javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.Produces", "javax.ws.rs.Consumes", "javax.ws.rs.PathParam", "javax.ws.rs.QueryParam", "javax.ws.rs.DefaultValue", "javax.ws.rs.core.Response", "javax.ws.rs.core.Context", "javax.ws.rs.core.UriInfo", "com.sun.jersey.api.core.ResourceContext", "javax.persistence.EntityManager"};
    private static final String[] ITEM_IMPORTS = new String[]{"javax.ws.rs.Path", "javax.ws.rs.GET", "javax.ws.rs.PUT", "javax.ws.rs.DELETE", "javax.ws.rs.Produces", "javax.ws.rs.Consumes", "javax.ws.rs.QueryParam", "javax.ws.rs.DefaultValue", "javax.ws.rs.core.Context", "javax.ws.rs.core.UriInfo", "com.sun.jersey.api.core.ResourceContext", "javax.ws.rs.WebApplicationException", "javax.persistence.NoResultException", "javax.persistence.EntityManager"};
    private static final String[] CONTAINER_CONVERTER_IMPORTS = new String[]{"javax.xml.bind.annotation.XmlRootElement", "javax.xml.bind.annotation.XmlElement", "javax.xml.bind.annotation.XmlTransient", "javax.xml.bind.annotation.XmlAttribute", "java.util.ArrayList"};
    private static final String[] ITEM_CONVERTER_IMPORTS = new String[]{"javax.xml.bind.annotation.XmlRootElement", "javax.xml.bind.annotation.XmlElement", "javax.xml.bind.annotation.XmlTransient", "javax.xml.bind.annotation.XmlAttribute", "javax.ws.rs.core.UriBuilder", "javax.persistence.EntityManager"};
    private static final String mimeTypes = "{\"" + Constants.MimeType.XML.value() + "\", \"" + Constants.MimeType.JSON.value() + "\"}";
    protected PersistenceHelper.PersistenceUnit persistenceUnit;
    protected String targetPackageName;
    protected FileObject targetFolder;
    protected String packageName;
    protected FileObject resourceFolder;
    protected String resourcePackageName;
    protected FileObject converterFolder;
    protected String converterPackageName;
    protected EntityResourceBeanModel model;
    protected Project project;
    protected boolean injectEntityManager = false;
    private static final String GET_ENTITY_MANAGER_STMT = "EntityManager em = PersistenceService.getInstance().getEntityManager();";

    public void initialize(EntityResourceBeanModel entityResourceBeanModel, Project project, FileObject fileObject, String string, PersistenceHelper.PersistenceUnit persistenceUnit) {
        this.initialize(entityResourceBeanModel, project, fileObject, string, null, null, persistenceUnit);
    }

    public void initialize(EntityResourceBeanModel entityResourceBeanModel, String string, String string2) {
        this.initialize(entityResourceBeanModel, null, null, null, string, string2, null);
    }

    public void initialize(EntityResourceBeanModel entityResourceBeanModel, Project project, FileObject fileObject, String string, String string2, String string3, PersistenceHelper.PersistenceUnit persistenceUnit) {
        this.model = entityResourceBeanModel;
        this.project = project;
        this.persistenceUnit = persistenceUnit;
        this.targetFolder = fileObject;
        this.targetPackageName = string;
        this.resourcePackageName = string2 == null ? string + "." + RESOURCE_FOLDER : string2;
        this.converterPackageName = string3 == null ? string + "." + CONVERTER_FOLDER : string3;
        this.packageName = this.packageName;
    }

    private String toFilePath(String string) {
        return string.replace(".", "/");
    }

    private FileObject getSourceRootFolder(FileObject fileObject, String string) {
        String[] stringArray = string.split("\\.");
        FileObject fileObject2 = fileObject;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            String string2 = stringArray[i];
            if (string2.length() == 0) {
                return fileObject2;
            }
            if (fileObject2 == null || !stringArray[i].equals(fileObject2.getNameExt())) {
                throw new IllegalArgumentException("Unmatched folder: " + fileObject.getPath() + " and package name: " + string);
            }
            fileObject2 = fileObject2.getParent();
        }
        return fileObject2;
    }

    public Collection<String> previewClasses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection<EntityResourceBean> collection = this.model.getResourceBeans();
        for (EntityResourceBean entityResourceBean : collection) {
            arrayList.add(this.getResourceType(entityResourceBean));
            arrayList.add(this.getConverterType(entityResourceBean));
        }
        if (!this.injectEntityManager) {
            arrayList.add(this.getPersistenceServiceClassType());
        }
        arrayList.add(this.getUriResolverClassType());
        return Utils.sortKeys(arrayList);
    }

    @Override
    public Set<FileObject> generate(ProgressHandle progressHandle) throws IOException {
        if (progressHandle != null) {
            this.initProgressReporting(progressHandle);
        }
        this.createFolders();
        if (!this.injectEntityManager) {
            this.generatePersistenceService();
        }
        new PersistenceHelper(this.project).configure(this.model.getBuilder().getAllEntityNames(), !RestUtils.hasJTASupport(this.project));
        this.configurePersistence();
        this.generateUriResolver();
        HashMap<EntityResourceBean, JavaSource> hashMap = new HashMap<EntityResourceBean, JavaSource>();
        HashMap<EntityResourceBean, JavaSource> hashMap2 = new HashMap<EntityResourceBean, JavaSource>();
        Collection<EntityResourceBean> collection = this.model.getResourceBeans();
        for (EntityResourceBean entityResourceBean : collection) {
            hashMap.put(entityResourceBean, this.generateResourceBean(entityResourceBean));
            hashMap2.put(entityResourceBean, this.generateConverter(entityResourceBean));
        }
        for (EntityResourceBean entityResourceBean : collection) {
            this.modifyResourceBean((JavaSource)hashMap.get(entityResourceBean), entityResourceBean);
            this.modifyConverter((JavaSource)hashMap2.get(entityResourceBean), entityResourceBean);
        }
        this.finishProgressReporting();
        return new HashSet<FileObject>();
    }

    private void createFolders() {
        FileObject fileObject = this.getSourceRootFolder(this.targetFolder, this.targetPackageName);
        File file = FileUtil.toFile((FileObject)fileObject);
        try {
            String string = this.toFilePath(this.resourcePackageName);
            this.resourceFolder = fileObject.getFileObject(string);
            if (this.resourceFolder == null) {
                this.resourceFolder = FileUtil.createFolder((File)new File(file, string));
            }
            String string2 = this.toFilePath(this.converterPackageName);
            this.converterFolder = fileObject.getFileObject(string2);
            if (this.converterFolder == null) {
                this.converterFolder = FileUtil.createFolder((File)new File(file, string2));
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void generatePersistenceService() throws IOException {
        this.reportProgress(this.getPersistenceServiceClassType(), false);
        String string = null;
        string = RestUtils.hasJTASupport(this.project) ? PERSISTENCE_SERVICE_TEMPLATE : PERSISTENCE_SERVICE_NOJTA_TEMPLATE;
        JavaSource javaSource = JavaSourceHelper.createJavaSource(string, this.resourceFolder, this.getResourcePackageName(), PERSISTENCE_SERVICE);
        if (javaSource == null) {
            return;
        }
        this.reportProgress(this.getPersistenceServiceClassType(), true);
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.replaceFieldValue(workingCopy, JavaSourceHelper.getField((CompilationController)workingCopy, EntityResourcesGenerator.DEFAULT_PU_FIELD), EntityResourcesGenerator.this.persistenceUnit.getName());
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected void configurePersistence() {
    }

    private void generateUriResolver() {
        this.reportProgress(this.getUriResolverClassType(), false);
        JavaSource javaSource = JavaSourceHelper.createJavaSource(URI_RESOLVER_TEMPLATE, this.converterFolder, this.getConverterPackageName(), URI_RESOLVER);
        this.reportProgress(this.getUriResolverClassType(), true);
    }

    private JavaSource generateResourceBean(EntityResourceBean entityResourceBean) {
        this.reportProgress(this.getResourceType(entityResourceBean), false);
        return JavaSourceHelper.createJavaSource(DEFAULT_TEMPLATE, this.resourceFolder, this.getResourcePackageName(), this.getResourceName(entityResourceBean));
    }

    private JavaSource generateConverter(EntityResourceBean entityResourceBean) {
        this.reportProgress(this.getConverterType(entityResourceBean), false);
        return JavaSourceHelper.createJavaSource(DEFAULT_TEMPLATE, this.converterFolder, this.getConverterPackageName(), this.getConverterName(entityResourceBean));
    }

    private void modifyResourceBean(JavaSource javaSource, EntityResourceBean entityResourceBean) {
        this.reportProgress(this.getResourceType(entityResourceBean), true);
        if (entityResourceBean.isContainer()) {
            this.modifyContainerResourceBean(javaSource, entityResourceBean);
        } else {
            this.modifyItemResourceBean(javaSource, entityResourceBean);
        }
    }

    private void modifyContainerResourceBean(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, EntityResourcesGenerator.this.getContainerResourceImports(entityResourceBean));
                    String[] stringArray = EntityResourcesGenerator.this.combineStringArrays(new String[]{"Path"}, EntityResourcesGenerator.this.getAdditionalContainerResourceAnnotations());
                    Object[] objectArray = EntityResourcesGenerator.this.combineObjectArrays(new Object[]{entityResourceBean.getUriTemplate()}, EntityResourcesGenerator.this.getAdditionalContainerResourceAnnotationAttrs());
                    JavaSourceHelper.addClassAnnotation(workingCopy, stringArray, objectArray);
                    ClassTree classTree2 = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    classTree2 = EntityResourcesGenerator.this.addResourceBeanFields(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addResourceBeanAccessors(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addContainerGetMethod(workingCopy, classTree2, entityResourceBean, mimeTypes);
                    classTree2 = EntityResourcesGenerator.this.addContainerPostMethod(workingCopy, classTree2, entityResourceBean, mimeTypes);
                    for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
                        classTree2 = EntityResourcesGenerator.this.addContainerGetResourceMethod(workingCopy, classTree2, entityResourceBean, relatedEntityResource);
                    }
                    classTree2 = EntityResourcesGenerator.this.addGetEntitiesMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addCreateEntityMethod(workingCopy, classTree2, entityResourceBean);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected String[] getAdditionalContainerResourceAnnotations() {
        return null;
    }

    protected Object[] getAdditionalContainerResourceAnnotationAttrs() {
        return null;
    }

    private void modifyItemResourceBean(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, EntityResourcesGenerator.this.getItemResourceImports(entityResourceBean));
                    String[] stringArray = EntityResourcesGenerator.this.getAdditionalItemResourceAnnotations();
                    Object[] objectArray = EntityResourcesGenerator.this.getAdditionalItemResourceAnnotationAttrs();
                    if (stringArray != null) {
                        JavaSourceHelper.addClassAnnotation(workingCopy, stringArray, objectArray);
                    }
                    ClassTree classTree2 = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    classTree2 = EntityResourcesGenerator.this.addResourceBeanFields(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addResourceBeanAccessors(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addItemGetMethod(workingCopy, classTree2, entityResourceBean, mimeTypes);
                    classTree2 = EntityResourcesGenerator.this.addItemPutMethod(workingCopy, classTree2, entityResourceBean, mimeTypes);
                    classTree2 = EntityResourcesGenerator.this.addItemDeleteMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addGetEntityMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addUpdateEntityMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addDeleteEntityMethod(workingCopy, classTree2, entityResourceBean);
                    for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
                        classTree2 = EntityResourcesGenerator.this.addItemGetResourceMethod(workingCopy, classTree2, entityResourceBean, relatedEntityResource);
                    }
                    for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
                        classTree2 = EntityResourcesGenerator.this.addSubresourceClass(workingCopy, classTree2, entityResourceBean, relatedEntityResource);
                    }
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    protected String[] getAdditionalItemResourceAnnotations() {
        return null;
    }

    protected Object[] getAdditionalItemResourceAnnotationAttrs() {
        return null;
    }

    private void modifyConverter(JavaSource javaSource, EntityResourceBean entityResourceBean) {
        this.reportProgress(this.getConverterType(entityResourceBean), true);
        if (entityResourceBean.isContainer()) {
            this.modifyContainerConverter(javaSource, entityResourceBean);
        } else {
            this.modifyItemConverter(javaSource, entityResourceBean);
        }
    }

    private void modifyContainerConverter(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, CONTAINER_CONVERTER_IMPORTS);
                    ClassTree classTree2 = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    JavaSourceHelper.addClassAnnotation(workingCopy, new String[]{"XmlRootElement"}, new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", EntityResourcesGenerator.this.getConverterXMLName(entityResourceBean))});
                    classTree2 = EntityResourcesGenerator.this.addConverterFields(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addConverterConstructor(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addGetItemsMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addSetItemsMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addGetUriMethod(workingCopy, classTree2);
                    classTree2 = EntityResourcesGenerator.this.addContainerConverterGetEntitiesMethod(workingCopy, classTree2, entityResourceBean);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void modifyItemConverterDefaultConstructor(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(workingCopy, new String[]{EntityResourcesGenerator.this.getEntityClassType(entityResourceBean)});
                    String string = "{ entity = new $CLASS$(); }";
                    string = string.replace("$CLASS$", EntityResourcesGenerator.this.getEntityClassName(entityResourceBean));
                    JavaSourceHelper.replaceMethodBody(workingCopy, JavaSourceHelper.getDefaultConstructor((CompilationController)workingCopy), string);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void modifyItemConverter(JavaSource javaSource, final EntityResourceBean entityResourceBean) {
        this.modifyItemConverterDefaultConstructor(javaSource, entityResourceBean);
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    ClassTree classTree;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    String[] stringArray = EntityResourcesGenerator.this.getItemConverterImports(entityResourceBean);
                    JavaSourceHelper.addImports(workingCopy, stringArray);
                    ClassTree classTree2 = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                    JavaSourceHelper.addClassAnnotation(workingCopy, new String[]{"XmlRootElement"}, new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "name", EntityResourcesGenerator.this.getConverterXMLName(entityResourceBean))});
                    classTree2 = EntityResourcesGenerator.this.addConverterFields(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addConverterConstructor(workingCopy, classTree2, entityResourceBean);
                    for (EntityClassInfo.FieldInfo fieldInfo : entityResourceBean.getEntityClassInfo().getFieldInfos()) {
                        classTree2 = EntityResourcesGenerator.this.addGetterMethod(workingCopy, classTree2, fieldInfo);
                        classTree2 = EntityResourcesGenerator.this.addSetterMethod(workingCopy, classTree2, fieldInfo, entityResourceBean);
                    }
                    classTree2 = EntityResourcesGenerator.this.addGetUriMethod(workingCopy, classTree2);
                    classTree2 = EntityResourcesGenerator.this.addSetUriMethod(workingCopy, classTree2);
                    classTree2 = EntityResourcesGenerator.this.addItemConverterGetEntityMethod(workingCopy, classTree2, entityResourceBean);
                    classTree2 = EntityResourcesGenerator.this.addItemConverterResolveEntityMethod(workingCopy, classTree2, entityResourceBean);
                    workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                }
            });
            modificationResult.commit();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private String[] getContainerResourceImports(EntityResourceBean entityResourceBean) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(CONTAINER_IMPORTS));
        HashSet<String> hashSet = new HashSet<String>();
        EntityResourceBean entityResourceBean2 = this.getItemSubResource(entityResourceBean);
        for (RelatedEntityResource relatedEntityResource : entityResourceBean2.getSubResources()) {
            hashSet.add(this.getEntityClassType(relatedEntityResource.getResourceBean()));
        }
        arrayList.addAll(hashSet);
        arrayList.add(this.getConverterType(entityResourceBean));
        arrayList.add(this.getConverterType(this.getItemConverterBean(entityResourceBean)));
        if (this.injectEntityManager) {
            arrayList.add("javax.persistence.PersistenceContext");
        }
        arrayList.addAll(this.getAdditionalContainerResourceImports(entityResourceBean));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected List<String> getAdditionalContainerResourceImports(EntityResourceBean entityResourceBean) {
        return Collections.emptyList();
    }

    private Collection<String> getRelatedClasses(EntityResourceBean entityResourceBean) {
        HashSet<String> hashSet = new HashSet<String>();
        for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSuperResources()) {
            hashSet.add(this.getEntityClassType(relatedEntityResource.getResourceBean()));
        }
        for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
            EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
            if (entityResourceBean2.isContainer()) {
                hashSet.add("java.util.Collection");
                continue;
            }
            String string = this.getIdFieldType(entityResourceBean2);
            if (string.startsWith("java.lang.")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private String[] getItemResourceImports(EntityResourceBean entityResourceBean) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(ITEM_IMPORTS));
        arrayList.addAll(this.getRelatedClasses(entityResourceBean));
        arrayList.add(this.getConverterType(entityResourceBean));
        if (this.injectEntityManager) {
            arrayList.add("javax.persistence.PersistenceContext");
        }
        arrayList.addAll(this.getAdditionalItemResourceImports(entityResourceBean));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected List<String> getAdditionalItemResourceImports(EntityResourceBean entityResourceBean) {
        return Collections.emptyList();
    }

    private EntityResourceBean getItemConverterBean(EntityResourceBean entityResourceBean) {
        return this.model.getItemResourceBean(entityResourceBean.getEntityClassInfo());
    }

    private String[] getItemConverterImports(EntityResourceBean entityResourceBean) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(ITEM_CONVERTER_IMPORTS));
        arrayList.add(this.getEntityClassType(entityResourceBean));
        arrayList.addAll(this.getRelatedClasses(entityResourceBean));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private ClassTree addResourceBeanFields(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String[] stringArray;
        ClassTree classTree2 = classTree;
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        if (!entityResourceBean.isContainer()) {
            stringArray = this.getIdFieldIdArray(entityResourceBean, false, null);
            Object[] objectArray = this.getIdFieldTypeArray(entityResourceBean, false, null);
            for (int i = 0; i < stringArray.length; ++i) {
                classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, stringArray[i], (String)objectArray[i]);
            }
        }
        if (this.injectEntityManager) {
            classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, new String[]{"PersistenceContext"}, new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "unitName", this.persistenceUnit.getName())}, "em", "javax.persistence.EntityManager");
        }
        stringArray = new String[]{"Context"};
        stringArray = stringArray;
        classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, stringArray, null, "resourceContext", "com.sun.jersey.api.core.ResourceContext");
        classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, stringArray, null, "uriInfo", "javax.ws.rs.core.UriInfo");
        return classTree2;
    }

    private ClassTree addResourceBeanAccessors(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        if (!entityResourceBean.isContainer()) {
            String[] stringArray = this.getIdFieldIdArray(entityResourceBean, false, null);
            Object[] objectArray = this.getIdFieldTypeArray(entityResourceBean, false, null);
            for (int i = 0; i < stringArray.length; ++i) {
                classTree = this.addAccessorMethods(workingCopy, classTree, stringArray[i], objectArray[i]);
            }
        }
        return classTree;
    }

    protected ClassTree addAccessorMethods(WorkingCopy workingCopy, ClassTree classTree, String string, Object object) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string2 = "set" + this.capitalizeFirstLetter(string);
        String string3 = "{ this." + string + " = " + string + ";}";
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        classTree = JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, string2, "void", stringArray, objectArray, null, null, string3, null);
        return classTree;
    }

    private ClassTree addContainerGetMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, String string) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string2 = Constants.HttpMethodType.GET.prefix();
        String[] stringArray = this.combineStringArrays(new String[]{"GET", "Produces"}, this.getAdditionalContainerGetMethodAnnotations());
        Object[] objectArray = this.combineObjectArrays(new Object[]{null, JavaSourceHelper.createIdentifierTree(workingCopy, string)}, this.getAdditionalContainerGetMethodAnnotationAttrs());
        String string3 = this.getConverterType(entityResourceBean);
        String[] stringArray2 = new String[]{"start", "max", "expandLevel", "query"};
        String string4 = Integer.TYPE.getName();
        Object[] objectArray2 = new String[]{string4, string4, string4, String.class.getSimpleName()};
        String[][] stringArrayArray = new String[][]{{"QueryParam", "DefaultValue"}, {"QueryParam", "DefaultValue"}, {"QueryParam", "DefaultValue"}, {"QueryParam", "DefaultValue"}};
        Object[][] objectArrayArray = new Object[][]{{"start", "0"}, {"max", "10"}, {"expandLevel", "1"}, {"query", "SELECT e FROM " + this.getEntityClassName(entityResourceBean) + " e"}};
        String string5 = "{";
        if (!this.injectEntityManager) {
            string5 = string5 + "PersistenceService persistenceSvc = PersistenceService.getInstance();try {persistenceSvc.beginTx();";
        }
        string5 = string5 + "return new $CONVERTER$(getEntities(start, max, query), uriInfo.getAbsolutePath(), expandLevel);";
        if (!this.injectEntityManager) {
            string5 = string5 + "} finally {persistenceSvc.commitTx();persistenceSvc.close();}";
        }
        string5 = string5 + "}";
        string5 = string5.replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        String string6 = "Get method for retrieving a collection of $CLASS$ instance in XML format.\n\n@return an instance of $CONVERTER$";
        string6 = string6.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string2, string3, stringArray2, objectArray2, (Object[])stringArrayArray, (Object[])objectArrayArray, string5, string6);
    }

    protected String[] getAdditionalContainerGetMethodAnnotations() {
        return null;
    }

    protected Object[] getAdditionalContainerGetMethodAnnotationAttrs() {
        return null;
    }

    private ClassTree addContainerPostMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, String string) {
        String string2 = Constants.HttpMethodType.POST.prefix();
        String[] stringArray = this.combineStringArrays(new String[]{"POST", "Consumes"}, this.getAdditionalContainerPostMethodAnnotations());
        Object[] objectArray = this.combineObjectArrays(new Object[]{null, JavaSourceHelper.createIdentifierTree(workingCopy, string)}, this.getAdditionalContainerPostMethodAnnotationAttrs());
        String string3 = "javax.ws.rs.core.Response";
        String[] stringArray2 = new String[]{"data"};
        Object[] objectArray2 = new Object[]{this.getItemConverterName(entityResourceBean)};
        String string4 = "{";
        if (!this.injectEntityManager) {
            string4 = string4 + "PersistenceService persistenceSvc = PersistenceService.getInstance();try {persistenceSvc.beginTx();EntityManager em = persistenceSvc.getEntityManager();";
        }
        string4 = string4 + this.getEntityClassName(entityResourceBean) + " entity = data.resolveEntity(em);" + "createEntity(data.resolveEntity(em));";
        if (!this.injectEntityManager) {
            string4 = string4 + "persistenceSvc.commitTx();";
        }
        string4 = string4 + "return Response.created(uriInfo.getAbsolutePath().resolve($ID_TO_URI$ + \"/\")).build();";
        if (!this.injectEntityManager) {
            string4 = string4 + "} finally {persistenceSvc.close();}";
        }
        string4 = string4 + "}";
        string4 = string4.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$ID_TO_URI$", this.getIdFieldToUriStmt(entityResourceBean));
        String string5 = "Post method for creating an instance of $CLASS$ using XML as the input format.\n\n@param data an $CONVERTER$ entity that is deserialized from an XML stream\n@return an instance of $CONVERTER$";
        string5 = string5.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$CONVERTER$", this.getItemConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, Constants.PUBLIC, stringArray, objectArray, string2, string3, stringArray2, objectArray2, null, null, string4, string5);
    }

    protected String[] getAdditionalContainerPostMethodAnnotations() {
        return null;
    }

    protected Object[] getAdditionalContainerPostMethodAnnotationAttrs() {
        return null;
    }

    private ClassTree addContainerGetResourceMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, RelatedEntityResource relatedEntityResource) {
        EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"Path"};
        Object[] objectArray = new String[]{entityResourceBean2.getUriTemplate()};
        String string = this.getResourceType(entityResourceBean2);
        String string2 = this.getResourceName(entityResourceBean2);
        String string3 = "get" + string2;
        String[] stringArray2 = this.getIdFieldIdArray(entityResourceBean2, false, null);
        Object[] objectArray2 = this.getIdFieldTypeArray(entityResourceBean2, false, null);
        Object[] objectArray3 = this.getIdFieldUriParamArray(entityResourceBean2, false, null);
        Object[] objectArray4 = this.getIdFieldNameArray(entityResourceBean2, false, null);
        String string4 = "{$CLASS$ resource = resourceContext.getResource($CLASS$.class);";
        string4 = string4.replace("$CLASS$", this.getResourceName(entityResourceBean2));
        for (int i = 0; i < stringArray2.length; ++i) {
            String string5 = stringArray2[i];
            string4 = string4 + "resource.set" + this.capitalizeFirstLetter(string5) + "(" + string5 + ");";
        }
        string4 = string4 + "return resource;}";
        String string6 = "Returns a dynamic instance of $RESOURCE$ used for entity navigation.\n\n@return an instance of $RESOURCE$";
        string6 = string6.replace("$RESOURCE$", this.getResourceName(entityResourceBean2));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string3, string, stringArray2, objectArray2, objectArray3, objectArray4, string4, string6);
    }

    private ClassTree addGetEntitiesMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getEntityClassType(entityResourceBean)});
        String string = "{";
        if (!this.injectEntityManager) {
            string = string + GET_ENTITY_MANAGER_STMT;
        }
        string = string + "return em.createQuery(query).setFirstResult(start).setMaxResults(max).getResultList();}";
        String[] stringArray = new String[]{"start", "max", "query"};
        Object[] objectArray = new Object[]{"int", "int", "String"};
        string = string.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        String string2 = "Returns all the entities associated with this resource.\n\n@return a collection of $CLASS$ instances";
        string2 = string2.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "getEntities", tree, stringArray, objectArray, null, null, string, string2);
    }

    private ClassTree addCreateEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        String string = "void";
        String[] stringArray = new String[]{"entity"};
        Object[] objectArray = new Object[]{this.getEntityClassType(entityResourceBean)};
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        String string2 = "{";
        if (fieldInfo.isGeneratedValue()) {
            string2 = string2 + "entity." + this.getSetterName(fieldInfo) + "(null);";
        }
        if (!this.injectEntityManager) {
            string2 = string2 + GET_ENTITY_MANAGER_STMT;
        }
        string2 = string2 + "em.persist(entity);";
        string2 = string2 + this.getCreateRelationshipsSubText(this.getItemSubResource(entityResourceBean)) + "}";
        String string3 = "Persist the given entity.\n\n@param entity the entity to persist";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "createEntity", string, stringArray, objectArray, null, null, string2, string3);
    }

    private String getCreateRelationshipsSubText(EntityResourceBean entityResourceBean) {
        String string = "$CLASS$ $FIELD$ = entity.$GETTER$();if ($FIELD$ != null) {$FIELD$.$REVERSE_SETTER$(entity);}";
        String string2 = "$CLASS$ $FIELD$ = entity.$GETTER$();if ($FIELD$ != null) {$FIELD$.$REVERSE_GETTER$().add(entity);}";
        String string3 = "for ($CLASS$ value : entity.$GETTER$()) {$ENTITY_CLASS$ oldEntity = value.$REVERSE_GETTER$();value.$REVERSE_SETTER$(entity);if (oldEntity != null) {oldEntity.$GETTER$().remove(entity);}}";
        String string4 = "for ($CLASS$ value : entity.$GETTER$()) {value.$REVERSE_GETTER$().add(entity);}";
        String string5 = "";
        for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
            EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getReverseFieldInfo();
            if (fieldInfo == null) continue;
            EntityClassInfo.FieldInfo fieldInfo2 = relatedEntityResource.getFieldInfo();
            String string6 = "";
            if (fieldInfo2.isOneToOne()) {
                string6 = string.replace("$CLASS$", fieldInfo2.getSimpleTypeName()).replace("$FIELD$", fieldInfo2.getName()).replace("$GETTER$", this.getGetterName(fieldInfo2)).replace("$REVERSE_SETTER$", this.getSetterName(fieldInfo));
            } else if (fieldInfo2.isManyToOne()) {
                string6 = string2.replace("$CLASS$", fieldInfo2.getSimpleTypeName()).replace("$FIELD$", fieldInfo2.getName()).replace("$GETTER$", this.getGetterName(fieldInfo2)).replace("$REVERSE_GETTER$", this.getGetterName(fieldInfo));
            } else if (fieldInfo2.isOneToMany()) {
                string6 = string3.replace("$CLASS$", fieldInfo2.getSimpleTypeArgName()).replace("$GETTER$", this.getGetterName(fieldInfo2)).replace("$ENTITY_CLASS$", this.getEntityClassName(entityResourceBean)).replace("$REVERSE_GETTER$", this.getGetterName(fieldInfo)).replace("$REVERSE_SETTER$", this.getSetterName(fieldInfo));
            } else if (fieldInfo2.isManyToMany()) {
                string6 = string4.replace("$CLASS$", fieldInfo2.getSimpleTypeArgName()).replace("$GETTER$", this.getGetterName(fieldInfo2)).replace("$REVERSE_GETTER$", this.getGetterName(fieldInfo));
            }
            string5 = string5 + string6;
        }
        return string5;
    }

    private ClassTree addItemGetMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, String string) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string2 = Constants.HttpMethodType.GET.prefix();
        String[] stringArray = this.combineStringArrays(new String[]{"GET", "Produces"}, this.getAdditionalItemGetMethodAnnotations());
        Object[] objectArray = this.combineObjectArrays(new Object[]{null, JavaSourceHelper.createIdentifierTree(workingCopy, string)}, this.getAdditionalItemGetMethodAnnotationAttrs());
        String string3 = this.getConverterType(entityResourceBean);
        String[] stringArray2 = new String[]{"expandLevel"};
        Object[] objectArray2 = new String[]{Integer.TYPE.getName()};
        String[][] stringArrayArray = new String[][]{{"QueryParam", "DefaultValue"}};
        Object[][] objectArrayArray = new Object[][]{{"expandLevel", "1"}};
        String string4 = "{";
        if (!this.injectEntityManager) {
            string4 = string4 + "PersistenceService persistenceSvc = PersistenceService.getInstance();try {persistenceSvc.beginTx();";
        }
        string4 = string4 + "return  new $CONVERTER$(getEntity(), uriInfo.getAbsolutePath(), expandLevel);";
        if (!this.injectEntityManager) {
            string4 = string4 + "} finally {PersistenceService.getInstance().close();}";
        }
        string4 = string4 + "}";
        string4 = string4.replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        String string5 = "Get method for retrieving an instance of $CLASS identified by id in XML format.\n\n@param id identifier for the entity\n@return an instance of $CONVERTER$";
        string5 = string5.replace("$CLASS", this.getEntityClassName(entityResourceBean)).replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string2, string3, stringArray2, objectArray2, (Object[])stringArrayArray, (Object[])objectArrayArray, string4, string5);
    }

    protected String[] getAdditionalItemGetMethodAnnotations() {
        return null;
    }

    protected Object[] getAdditionalItemGetMethodAnnotationAttrs() {
        return null;
    }

    private ClassTree addItemPutMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, String string) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string2 = Constants.HttpMethodType.PUT.prefix();
        String[] stringArray = this.combineStringArrays(new String[]{"PUT", "Consumes"}, this.getAdditionalItemPutMethodAnnotations());
        Object[] objectArray = this.combineObjectArrays(new Object[]{null, JavaSourceHelper.createIdentifierTree(workingCopy, string)}, this.getAdditionalItemPutMethodAnnotationAttrs());
        String[] stringArray2 = new String[]{"data"};
        Object[] objectArray2 = new String[]{this.getConverterType(entityResourceBean)};
        String string3 = "{";
        if (!this.injectEntityManager) {
            string3 = string3 + "PersistenceService persistenceSvc = PersistenceService.getInstance();try {persistenceSvc.beginTx();EntityManager em = persistenceSvc.getEntityManager();";
        }
        string3 = string3 + "updateEntity(getEntity(), data.resolveEntity(em));";
        if (!this.injectEntityManager) {
            string3 = string3 + "persistenceSvc.commitTx();} finally {persistenceSvc.close();}";
        }
        string3 = string3 + "}";
        String string4 = "Put method for updating an instance of $CLASS identified by id using XML as the input format.\n\n@param id identifier for the entity\n@param data an $CONVERTER$ entity that is deserialized from a XML stream\n";
        string4 = string4.replace("$CLASS", this.getEntityClassName(entityResourceBean)).replace("$CONVERTER$", this.getConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string2, "void", stringArray2, objectArray2, null, null, string3, string4);
    }

    protected String[] getAdditionalItemPutMethodAnnotations() {
        return null;
    }

    protected Object[] getAdditionalItemPutMethodAnnotationAttrs() {
        return null;
    }

    private ClassTree addItemDeleteMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string = "void";
        String[] stringArray = this.combineStringArrays(new String[]{"DELETE"}, this.getAdditionalItemDeleteMethodAnnotations());
        Object[] objectArray = this.combineObjectArrays(new Object[]{null}, this.getAdditionalItemDeleteMethodAnnotationAttrs());
        String string2 = "{";
        if (!this.injectEntityManager) {
            string2 = string2 + "PersistenceService persistenceSvc = PersistenceService.getInstance();try {persistenceSvc.beginTx();";
        }
        string2 = string2 + "deleteEntity(getEntity());";
        if (!this.injectEntityManager) {
            string2 = string2 + "persistenceSvc.commitTx();} finally {persistenceSvc.close();}";
        }
        string2 = string2 + "}";
        string2 = string2.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        String string3 = "Delete method for deleting an instance of $CLASS identified by id.\n\n@param id identifier for the entity\n";
        string3 = string3.replace("$CLASS", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, Constants.HttpMethodType.DELETE.prefix(), string, null, null, null, null, string2, string3);
    }

    protected String[] getAdditionalItemDeleteMethodAnnotations() {
        return null;
    }

    protected Object[] getAdditionalItemDeleteMethodAnnotationAttrs() {
        return null;
    }

    private ClassTree addSubresourceClass(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, RelatedEntityResource relatedEntityResource) {
        EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
        EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getFieldInfo();
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        String string = this.getResourceName(entityResourceBean2);
        String string2 = entityResourceBean.getEntityClassInfo().getName();
        String string3 = this.capitalizeFirstLetter(fieldInfo.getName()) + RESOURCE_SUFFIX + "Sub";
        ClassTree classTree2 = JavaSourceHelper.createInnerClass(workingCopy, modifierArray, string3, string);
        classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, new Modifier[]{Modifier.PRIVATE}, null, null, "parent", string2);
        classTree2 = this.addAccessorMethods(workingCopy, classTree2, "parent", string2);
        String string4 = null;
        modifierArray = new Modifier[]{Modifier.PROTECTED};
        String string5 = null;
        Object object = null;
        String[] stringArray = new String[]{"Override"};
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String string6 = this.getGetterName(fieldInfo);
        String string7 = this.getEntityClassName(entityResourceBean2);
        if (entityResourceBean2.isItem()) {
            string5 = "getEntity";
            object = string7;
            string4 = "{$CLASS$ entity = parent.$GETTER$();if (entity == null) {throw new WebApplicationException(new Throwable(\"Resource for \" + uriInfo.getAbsolutePath() + \" does not exist.\"), 404);}return entity;}";
            string4 = string4.replace("$CLASS$", string7).replace("$GETTER$", string6);
        } else {
            string5 = "getEntities";
            object = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{string7});
            stringArray2 = new String[]{"start", "max", "query"};
            stringArray3 = new String[]{"int", "int", "String"};
            string4 = "{Collection<$CLASS$> result = new java.util.ArrayList<$CLASS$>();int index = 0;for ($CLASS$ e : parent.$GETTER$()) {if (index >= start && (index - start) < max) {result.add(e);}index++;}return result;}";
            string4 = string4.replace("$CLASS$", string7).replace("$GETTER$", string6);
        }
        classTree2 = JavaSourceHelper.addMethod(workingCopy, classTree2, modifierArray, stringArray, null, string5, object, stringArray2, stringArray3, null, null, string4, null);
        return workingCopy.getTreeMaker().addClassMember(classTree, (Tree)classTree2);
    }

    private ClassTree addItemGetResourceMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean, RelatedEntityResource relatedEntityResource) {
        EntityResourceBean entityResourceBean2 = relatedEntityResource.getResourceBean();
        EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getFieldInfo();
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = this.combineStringArrays(new String[]{"Path"}, this.getAdditionalItemGetResourceMethodAnnotations());
        String string = fieldInfo.getName() + "/";
        Object[] objectArray = this.combineObjectArrays(new String[]{string}, this.getAdditionalItemGetResourceMethodAnnotationAttrs());
        String string2 = this.getResourceType(entityResourceBean2);
        String string3 = this.getGetterName(fieldInfo) + RESOURCE_SUFFIX;
        String string4 = "{$CLASS$ resource = resourceContext.getResource($CLASS$.class);resource.setParent(getEntity());return resource;}";
        string4 = string4.replace("$CLASS$", this.capitalizeFirstLetter(fieldInfo.getName()) + RESOURCE_SUFFIX + "Sub");
        String string5 = "Returns a dynamic instance of $RESOURCE$ used for entity navigation.\n\n@param id identifier for the parent entity\n@return an instance of $RESOURCE$";
        string5 = string5.replace("$RESOURCE$", this.getResourceName(entityResourceBean2));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string3, string2, null, null, null, null, string4, string5);
    }

    protected String[] getAdditionalItemGetResourceMethodAnnotations() {
        return null;
    }

    protected Object[] getAdditionalItemGetResourceMethodAnnotationAttrs() {
        return null;
    }

    private ClassTree addGetEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        String string = "id";
        String string2 = "";
        String string3 = fieldInfo.getType();
        if (fieldInfo.isEmbeddedId()) {
            string2 = string3 + " id = new " + string3 + "(" + this.getIdFieldIdList(entityResourceBean) + ");";
        } else if (string3.equals("java.lang.Character")) {
            string = "id.charAt(0)";
        }
        String string4 = "{";
        if (!this.injectEntityManager) {
            string4 = string4 + GET_ENTITY_MANAGER_STMT;
        }
        string4 = string4 + "try {$NEW_ID_STMT$return ($CLASS$) em.createQuery(\"SELECT e FROM $CLASS$ e where e.$ID$ = :$ID$\").setParameter(\"$ID$\", $ID_STRING$).getSingleResult();} catch (NoResultException ex) {throw new WebApplicationException(new Throwable(\"Resource for \" + uriInfo.getAbsolutePath() + \" does not exist.\"), 404);}}";
        String string5 = this.getIdFieldName(entityResourceBean);
        string4 = string4.replace("$NEW_ID_STMT$", string2).replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$ID$", string5).replace("$ID_STRING$", string);
        String string6 = "Returns an instance of $CLASS$ identified by id.\n\n@param id identifier for the entity\n@return an instance of $CLASS$";
        string6 = string6.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "getEntity", this.getEntityClassType(entityResourceBean), null, null, null, null, string4, string6);
    }

    private ClassTree addUpdateEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        String string = this.getEntityClassType(entityResourceBean);
        String[] stringArray = new String[]{"entity", "newEntity"};
        Object[] objectArray = new Object[]{this.getEntityClassType(entityResourceBean), this.getEntityClassType(entityResourceBean)};
        String string2 = "{";
        if (!this.injectEntityManager) {
            string2 = string2 + GET_ENTITY_MANAGER_STMT;
        }
        string2 = string2 + this.getUpdateBeforeRelationshipsSubText(entityResourceBean);
        string2 = string2 + "entity = em.merge(newEntity);";
        string2 = string2 + this.getUpdateRelationshipsSubText(entityResourceBean) + "return entity;}";
        String string3 = "Updates entity using data from newEntity.\n\n@param entity the entity to update\n@param newEntity the entity containing the new data\n@return the updated entity";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "updateEntity", string, stringArray, objectArray, null, null, string2, string3);
    }

    private String getUpdateBeforeRelationshipsSubText(EntityResourceBean entityResourceBean) {
        String string = "";
        for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
            EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getFieldInfo();
            String string2 = "";
            if (fieldInfo.isOneToOne() || fieldInfo.isManyToOne()) {
                string2 = string2 + "$CLASS$ $FIELD$ = entity.$GETTER$();$CLASS$ $FIELD$New = newEntity.$GETTER$();";
                string2 = string2.replace("$CLASS$", fieldInfo.getSimpleTypeName()).replace("$FIELD$", fieldInfo.getName()).replace("$GETTER$", this.getGetterName(fieldInfo));
            } else if (fieldInfo.isOneToMany() || fieldInfo.isManyToMany()) {
                string2 = string2 + "$HOLDER$<$CLASS$> $FIELD$ = entity.$GETTER$();$HOLDER$<$CLASS$> $FIELD$New = newEntity.$GETTER$();";
                string2 = string2.replace("$HOLDER$", fieldInfo.getSimpleTypeName()).replace("$CLASS$", fieldInfo.getSimpleTypeArgName()).replace("$FIELD$", fieldInfo.getName()).replace("$GETTER$", this.getGetterName(fieldInfo));
            }
            string = string + string2;
        }
        return string;
    }

    private String getUpdateRelationshipsSubText(EntityResourceBean entityResourceBean) {
        String string = "if ($FIELD$ != null && !$FIELD$.equals($FIELD$New)) {$FIELD$.$REVERSE_SETTER$(null);}if ($FIELD$New != null && !$FIELD$New.equals($FIELD$)) {$FIELD$New.$REVERSE_SETTER$(entity);}";
        String string2 = "if ($FIELD$ != null && !$FIELD$.equals($FIELD$New)) {$FIELD$.$REVERSE_GETTER$().remove(entity);}if ($FIELD$New != null && !$FIELD$New.equals($FIELD$)) {$FIELD$New.$REVERSE_GETTER$().add(entity);}";
        String string3 = "for ($CLASS$ value : $FIELD$) {if (!$FIELD$New.contains(value)) {throw new WebApplicationException(new Throwable(\"Cannot remove items from $FIELD$\"));}}for ($CLASS$ value : $FIELD$New) {if (!$FIELD$.contains(value)) {$ENTITY_CLASS$ oldEntity = value.$REVERSE_GETTER$();value.$REVERSE_SETTER$(entity);if (oldEntity != null && !oldEntity.equals(entity)) {oldEntity.$GETTER$().remove(value);}}}";
        String string4 = "for ($CLASS$ value : $FIELD$) {if (!$FIELD$New.contains(value)) {value.$REVERSE_GETTER$().remove(entity);}}for ($CLASS$ value : $FIELD$New) {if (!$FIELD$.contains(value)) {value.$REVERSE_GETTER$().add(entity);}}";
        String string5 = "";
        for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
            EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getReverseFieldInfo();
            if (fieldInfo == null) continue;
            EntityClassInfo.FieldInfo fieldInfo2 = relatedEntityResource.getFieldInfo();
            String string6 = "";
            if (fieldInfo2.isOneToOne()) {
                string6 = string.replace("$FIELD$", fieldInfo2.getName()).replace("$REVERSE_SETTER$", this.getSetterName(fieldInfo));
            } else if (fieldInfo2.isManyToOne()) {
                string6 = string2.replace("$FIELD$", fieldInfo2.getName()).replace("$REVERSE_GETTER$", this.getGetterName(fieldInfo));
            } else if (fieldInfo2.isOneToMany()) {
                string6 = string3.replace("$CLASS$", fieldInfo2.getSimpleTypeArgName()).replace("$FIELD$", fieldInfo2.getName()).replace("$GETTER$", this.getGetterName(fieldInfo2)).replace("$ENTITY_CLASS$", this.getEntityClassName(entityResourceBean)).replace("$REVERSE_GETTER$", this.getGetterName(fieldInfo)).replace("$REVERSE_SETTER$", this.getSetterName(fieldInfo));
            } else if (fieldInfo2.isManyToMany()) {
                string6 = string4.replace("$CLASS$", fieldInfo2.getSimpleTypeArgName()).replace("$FIELD$", fieldInfo2.getName()).replace("$GETTER$", this.getGetterName(fieldInfo2)).replace("$REVERSE_GETTER$", this.getGetterName(fieldInfo));
            }
            string5 = string5 + string6;
        }
        return string5;
    }

    private ClassTree addDeleteEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        String string = "deleteEntity";
        String string2 = "void";
        String[] stringArray = new String[]{"entity"};
        Object[] objectArray = new Object[]{this.getEntityClassType(entityResourceBean)};
        String string3 = "{";
        if (!this.injectEntityManager) {
            string3 = string3 + GET_ENTITY_MANAGER_STMT;
        }
        string3 = string3 + this.getDeleteRelationshipsSubText(entityResourceBean);
        string3 = string3 + "em.remove(entity);}";
        String string4 = "Deletes the entity.\n\n@param entity the entity to deletle\n";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, string, string2, stringArray, objectArray, null, null, string3, string4);
    }

    private String getDeleteRelationshipsSubText(EntityResourceBean entityResourceBean) {
        String string = "$CLASS$ $FIELD$ = entity.$GETTER$();if ($FIELD$ != null) {$FIELD$.$REVERSE_SETTER$(null);}";
        String string2 = "$CLASS$ $FIELD$ = entity.$GETTER$();if ($FIELD$ != null) {$FIELD$.$REVERSE_GETTER$().remove(entity);}";
        String string3 = "if (!entity.$GETTER$().isEmpty()) {throw new WebApplicationException(new Throwable(\"Cannot delete entity because $FIELD$ is not empty.\"));}";
        String string4 = "for ($CLASS$ value : entity.$GETTER$()) {value.$REVERSE_GETTER$().remove(entity);}";
        String string5 = "";
        for (RelatedEntityResource relatedEntityResource : entityResourceBean.getSubResources()) {
            EntityClassInfo.FieldInfo fieldInfo = relatedEntityResource.getReverseFieldInfo();
            if (fieldInfo == null) continue;
            EntityClassInfo.FieldInfo fieldInfo2 = relatedEntityResource.getFieldInfo();
            String string6 = "";
            if (fieldInfo2.isOneToOne()) {
                string6 = string.replace("$CLASS$", fieldInfo2.getSimpleTypeName()).replace("$FIELD$", fieldInfo2.getName()).replace("$GETTER$", this.getGetterName(fieldInfo2)).replace("$REVERSE_SETTER$", this.getSetterName(fieldInfo));
            } else if (fieldInfo2.isManyToOne()) {
                string6 = string2.replace("$CLASS$", fieldInfo2.getSimpleTypeName()).replace("$FIELD$", fieldInfo2.getName()).replace("$GETTER$", this.getGetterName(fieldInfo2)).replace("$REVERSE_GETTER$", this.getGetterName(fieldInfo));
            } else if (fieldInfo2.isOneToMany()) {
                string6 = string3.replace("$GETTER$", this.getGetterName(fieldInfo2)).replace("$FIELD$", fieldInfo2.getName());
            } else if (fieldInfo2.isManyToMany()) {
                string6 = string4.replace("$CLASS$", fieldInfo2.getSimpleTypeArgName()).replace("$GETTER$", this.getGetterName(fieldInfo2)).replace("$REVERSE_GETTER$", this.getGetterName(fieldInfo));
            }
            string5 = string5 + string6;
        }
        return string5;
    }

    private ClassTree addConverterFields(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE};
        ClassTree classTree2 = classTree;
        classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, "expandLevel", Integer.TYPE.getName());
        classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, "uri", "java.net.URI");
        if (entityResourceBean.isItem()) {
            classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, "entity", this.getEntityClassType(entityResourceBean));
        } else {
            Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getItemConverterType(entityResourceBean)});
            classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, "items", tree);
            tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getEntityClassType(entityResourceBean)});
            classTree2 = JavaSourceHelper.addField(workingCopy, classTree2, modifierArray, null, null, "entities", tree);
        }
        return classTree2;
    }

    private ClassTree addConverterConstructor(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String[] stringArray = null;
        Object[] objectArray = null;
        String string = null;
        String string2 = null;
        String string3 = this.getConverterName(entityResourceBean);
        if (entityResourceBean.isItem()) {
            objectArray = new String[]{this.getEntityClassType(entityResourceBean), "java.net.URI", Integer.TYPE.getName(), Boolean.TYPE.getName()};
            stringArray = new String[]{"entity", "uri", "expandLevel", "isUriExtendable"};
            string = "{this.entity = entity;this.uri = (isUriExtendable) ? UriBuilder.fromUri(uri).path(" + this.getIdFieldToUriStmt(entityResourceBean.getEntityClassInfo().getIdFieldInfo()) + " + \"/\").build() : uri;" + "this.expandLevel = expandLevel;";
            for (EntityClassInfo.FieldInfo fieldInfo : entityResourceBean.getEntityClassInfo().getFieldInfos()) {
                if (!fieldInfo.isRelationship()) continue;
                string = string + this.getGetterName(fieldInfo) + "();";
            }
            string = string + "}";
            string2 = "Creates a new instance of " + string3 + ".\n\n" + "@param entity associated entity\n" + "@param uri associated uri\n" + "@param expandLevel indicates the number of levels the entity graph should be expanded" + "@param isUriExtendable indicates whether the uri can be extended";
            classTree = JavaSourceHelper.addConstructor(workingCopy, classTree, new Modifier[]{Modifier.PUBLIC}, stringArray, objectArray, string, string2);
            stringArray = new String[]{"entity", "uri", "expandLevel"};
            string = "{this(entity, uri, expandLevel, false);}";
            string2 = "Creates a new instance of " + string3 + ".\n\n" + "@param entity associated entity\n" + "@param uri associated uri\n" + "@param expandLevel indicates the number of levels the entity graph should be expanded";
        } else {
            stringArray = new String[]{"entities", "uri", "expandLevel"};
            Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getEntityClassType(entityResourceBean)});
            objectArray = new Object[]{tree, "java.net.URI", Integer.TYPE.getName()};
            string = "{this.entities = entities; this.uri = uri; this.expandLevel = expandLevel;get" + this.getItemName(entityResourceBean) + "();" + "}";
            string2 = "Creates a new instance of " + string3 + ".\n\n" + "@param entities associated entities\n" + "@param uri associated uri\n" + "@param expandLevel indicates the number of levels the entity graph should be expanded";
        }
        return JavaSourceHelper.addConstructor(workingCopy, classTree, new Modifier[]{Modifier.PUBLIC}, stringArray, objectArray, string, string2);
    }

    private ClassTree addGetItemsMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"XmlElement"};
        String string = "get" + this.getItemName(entityResourceBean);
        Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getItemConverterType(entityResourceBean)});
        String string2 = this.getItemConverterName(entityResourceBean);
        String string3 = "{ if (items == null) {items = new ArrayList<$ITEM_CONVERTER$>();}if (entities != null) {for ($CLASS$ entity : entities) {items.add(new $ITEM_CONVERTER$(entity, uri, expandLevel, true));}}return items;}";
        string3 = string3.replace("$CLASS$", this.getEntityClassName(entityResourceBean)).replace("$ITEM_CONVERTER$", string2);
        String string4 = "Returns a collection of $ITEM_CONVERTER$.\n\n@return a collection of $ITEM_CONVERTER$";
        string4 = string4.replace("$ITEM_CONVERTER$", string2);
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, null, string, tree, null, null, null, null, string3, string4);
    }

    private ClassTree addSetItemsMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String[] stringArray = new String[]{"items"};
        Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getItemConverterType(entityResourceBean)});
        String string = "set" + this.getItemName(entityResourceBean);
        String string2 = "{this.items = items;}";
        String string3 = "Sets a collection of $ITEM_CONVERTER$.\n\n@param a collection of $ITEM_CONVERTER$ to set";
        string3 = string3.replace("$ITEM_CONVERTER$", this.getItemConverterName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, Constants.PUBLIC, null, null, string, "void", stringArray, new Object[]{tree}, null, null, string2, string3);
    }

    private ClassTree addGetUriMethod(WorkingCopy workingCopy, ClassTree classTree) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"XmlAttribute"};
        String string = "java.net.URI";
        String string2 = "{return uri;}";
        String string3 = "Returns the URI associated with this converter.\n\n@return the uri";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, null, "getUri", string, null, null, null, null, string2, string3);
    }

    private ClassTree addSetUriMethod(WorkingCopy workingCopy, ClassTree classTree) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string = "void";
        String[] stringArray = new String[]{"uri"};
        Object[] objectArray = new Object[]{"java.net.URI"};
        String string2 = "{ this.uri = uri; }";
        String string3 = "Sets the URI for this reference converter.\n\n";
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, "setUri", string, stringArray, objectArray, null, null, string2, string3);
    }

    private ClassTree addContainerConverterGetEntitiesMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String[] stringArray = new String[]{"XmlTransient"};
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        Tree tree = JavaSourceHelper.createParameterizedTypeTree(workingCopy, "java.util.Collection", new String[]{this.getEntityClassType(entityResourceBean)});
        String string = this.getEntityClassName(entityResourceBean);
        String string2 = "{ entities = new ArrayList<$CLASS$>();if (items != null) { for ($ITEM_CONVERTER$ item : items) {entities.add(item.getEntity()); } }return entities;}";
        string2 = string2.replace("$CLASS$", string).replace("$ITEM_CONVERTER$", this.getItemConverterName(entityResourceBean));
        String string3 = "Returns a collection $CLASS$ entities.\n\n@return a collection of $CLASS$ entities";
        string3 = string3.replace("$CLASS$", string);
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, null, "getEntities", tree, null, null, null, null, string2, string3);
    }

    private ClassTree addGetterMethod(WorkingCopy workingCopy, ClassTree classTree, EntityClassInfo.FieldInfo fieldInfo) {
        Object object;
        String string = this.getGetterName(fieldInfo);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = new String[]{"XmlElement"};
        Object[] objectArray = null;
        Object object2 = null;
        String string2 = null;
        if (!fieldInfo.isRelationship()) {
            object2 = fieldInfo.getTypeArg() == null ? fieldInfo.getType() : JavaSourceHelper.createParameterizedTypeTree(workingCopy, fieldInfo.getType(), new String[]{fieldInfo.getTypeArg()});
            string2 = "{return (expandLevel > 0) ? entity.$GETTER$() : null;}";
            string2 = string2.replace("$GETTER$", string);
        } else if (fieldInfo.isOneToMany() || fieldInfo.isManyToMany()) {
            object = this.model.getContainerResourceBean(fieldInfo.getTypeArg());
            object2 = this.getConverterType((EntityResourceBean)object);
            string2 = "{if (expandLevel > 0) {if (entity.$GETTER$() != null) {return new $CONVERTER$(entity.$GETTER$(), uri.resolve(\"$FIELD$/\"), expandLevel - 1);}}return null;}";
            string2 = string2.replace("$CONVERTER$", this.getConverterName((EntityResourceBean)object)).replace("$GETTER$", this.getGetterName(fieldInfo)).replace("$FIELD$", fieldInfo.getName());
        } else {
            object = this.model.getItemResourceBean(fieldInfo.getType());
            object2 = this.getConverterType((EntityResourceBean)object);
            string2 = "{if (expandLevel > 0) {if (entity.$GETTER$() != null) {return new $ITEM_CONVERTER$(entity.$GETTER$(), uri.resolve(\"$FIELD$/\"), expandLevel - 1, false);}}return null;}";
            string2 = string2.replace("$ITEM_CONVERTER$", this.getItemConverterName((EntityResourceBean)object)).replace("$GETTER$", this.getGetterName(fieldInfo)).replace("$FIELD$", fieldInfo.getName());
        }
        object = "Getter for $FIELD$.\n\n@return value for $FIELD$";
        object = ((String)object).replace("$FIELD$", fieldInfo.getName());
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string, object2, null, null, null, null, string2, (String)object);
    }

    private ClassTree addSetterMethod(WorkingCopy workingCopy, ClassTree classTree, EntityClassInfo.FieldInfo fieldInfo, EntityResourceBean entityResourceBean) {
        Object object;
        String string = this.getSetterName(fieldInfo);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String[] stringArray = null;
        Object[] objectArray = null;
        String[] stringArray2 = new String[]{"value"};
        Object object2 = null;
        String string2 = null;
        if (!fieldInfo.isRelationship()) {
            object2 = fieldInfo.getTypeArg() == null ? fieldInfo.getType() : JavaSourceHelper.createParameterizedTypeTree(workingCopy, fieldInfo.getType(), new String[]{fieldInfo.getTypeArg()});
            string2 = "{ entity.$SETTER$(value); }";
            string2 = string2.replace("$SETTER$", string).replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        } else if (fieldInfo.isOneToMany() || fieldInfo.isManyToMany()) {
            object = this.model.getContainerResourceBean(fieldInfo.getTypeArg());
            String string3 = this.model.getItemResourceBean(fieldInfo.getTypeArg()).getName();
            object2 = this.getConverterType((EntityResourceBean)object);
            string2 = "{entity.$SETTER$((value != null) ? value.getEntities() : null);}";
            string2 = string2.replace("$CLASS$", string3).replace("$SETTER$", string);
        } else {
            object = this.model.getItemResourceBean(fieldInfo.getType());
            object2 = this.getConverterType((EntityResourceBean)object);
            string2 = "{entity.$SETTER$((value != null) ? value.getEntity() : null);}";
            string2 = string2.replace("$CLASS$", ((EntityResourceBean)object).getName()).replace("$SETTER$", string);
        }
        object = "Setter for $FIELD$.\n\n@param value the value to set";
        object = ((String)object).replace("$FIELD$", fieldInfo.getName());
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, objectArray, string, "void", stringArray2, new Object[]{object2}, null, null, string2, (String)object);
    }

    private ClassTree addItemConverterGetEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        String[] stringArray = new String[]{"XmlTransient"};
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string = "getEntity";
        String string2 = this.getEntityClassType(entityResourceBean);
        String string3 = this.getConverterName(entityResourceBean);
        String string4 = "{if (entity.$ID_GETTER$() == null) {$CLASS$ converter = UriResolver.getInstance().resolve($CLASS$.class, uri);if (converter != null) {entity = converter.getEntity();}}return entity;}";
        string4 = string4.replace("$CLASS$", this.getConverterName(entityResourceBean)).replace("$ID_GETTER$", this.getGetterName(entityResourceBean.getEntityClassInfo().getIdFieldInfo()));
        String string5 = "Returns the $CLASS$ entity.\n\n@return an entity";
        string5 = string5.replace("$CLASS$", this.getEntityClassName(entityResourceBean));
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, stringArray, null, string, string2, null, null, null, null, string4, string5);
    }

    private ClassTree addItemConverterResolveEntityMethod(WorkingCopy workingCopy, ClassTree classTree, EntityResourceBean entityResourceBean) {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        String string = "resolveEntity";
        String[] stringArray = new String[]{"em"};
        Object[] objectArray = new Object[]{"javax.persistence.EntityManager"};
        String string2 = this.getEntityClassType(entityResourceBean);
        Collection<EntityClassInfo.FieldInfo> collection = entityResourceBean.getEntityClassInfo().getFieldInfos();
        String string3 = "{";
        for (EntityClassInfo.FieldInfo object2 : collection) {
            String string4 = null;
            if (object2.isOneToOne() || object2.isManyToOne()) {
                string4 = "$CLASS$ $FIELD$ = entity.$GETTER$();if ($FIELD$ != null) {entity.$SETTER$(em.getReference($CLASS$.class, $FIELD$.$ID_GETTER$()));}";
                string4 = string4.replace("$CLASS$", object2.getSimpleTypeName()).replace("$FIELD$", object2.getName()).replace("$GETTER$", this.getGetterName(object2)).replace("$SETTER$", this.getSetterName(object2)).replace("$ID_GETTER$", this.getGetterName(this.getEntityClassInfo(object2.getType()).getIdFieldInfo()));
                string3 = string3 + string4;
                continue;
            }
            if (!object2.isManyToMany() && !object2.isOneToMany()) continue;
            string4 = "Collection<$CLASS$> $FIELD$ = entity.$GETTER$();Collection<$CLASS$> new$FIELD$ = new java.util.ArrayList<$CLASS$>();for ($CLASS$ item : $FIELD$) {new$FIELD$.add(em.getReference($CLASS$.class, item.$ID_GETTER$()));}entity.$SETTER$(new$FIELD$);";
            string4 = string4.replace("$CLASS$", object2.getSimpleTypeArgName()).replace("$FIELD$", object2.getName()).replace("$GETTER$", this.getGetterName(object2)).replace("$ID_GETTER$", this.getGetterName(this.getEntityClassInfo(object2.getTypeArg()).getIdFieldInfo())).replace("$SETTER$", this.getSetterName(object2));
            string3 = string3 + string4;
        }
        String string5 = this.getEntityClassName(entityResourceBean);
        string3 = string3 + "return entity;}";
        String string7 = "Returns the resolved $CLASS$ entity.\n\n@return an resolved entity";
        string7 = string7.replace("$CLASS$", string5);
        return JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, string, string2, stringArray, objectArray, null, null, string3, string7);
    }

    private EntityResourceBean getItemSubResource(EntityResourceBean entityResourceBean) {
        Collection<RelatedEntityResource> collection = entityResourceBean.getSubResources();
        return collection.iterator().next().getResourceBean();
    }

    private String getResourcePackageName() {
        return this.resourcePackageName;
    }

    private String getConverterPackageName() {
        return this.converterPackageName;
    }

    private String getResourceName(EntityResourceBean entityResourceBean) {
        return entityResourceBean.getName() + RESOURCE_SUFFIX;
    }

    private String getItemName(EntityResourceBean entityResourceBean) {
        if (!entityResourceBean.isContainer()) {
            return entityResourceBean.getName();
        }
        return entityResourceBean.getSubResources().iterator().next().getResourceBean().getName();
    }

    private String getConverterName(EntityResourceBean entityResourceBean) {
        return entityResourceBean.getName() + CONVERTER_SUFFIX;
    }

    private String getItemConverterName(EntityResourceBean entityResourceBean) {
        return this.getItemName(entityResourceBean) + CONVERTER_SUFFIX;
    }

    private String getConverterXMLName(EntityResourceBean entityResourceBean) {
        return this.lowerCaseFirstLetter(entityResourceBean.getName());
    }

    private String getConverterType(EntityResourceBean entityResourceBean) {
        return this.getConverterPackageName() + "." + entityResourceBean.getName() + CONVERTER_SUFFIX;
    }

    private String getItemConverterType(EntityResourceBean entityResourceBean) {
        return this.getConverterPackageName() + "." + this.getItemConverterName(entityResourceBean);
    }

    private String getResourceType(EntityResourceBean entityResourceBean) {
        return this.getResourcePackageName() + "." + entityResourceBean.getName() + RESOURCE_SUFFIX;
    }

    private String getGetterName(EntityClassInfo.FieldInfo fieldInfo) {
        return "get" + this.capitalizeFirstLetter(fieldInfo.getName());
    }

    private String getSetterName(EntityClassInfo.FieldInfo fieldInfo) {
        return "set" + this.capitalizeFirstLetter(fieldInfo.getName());
    }

    private String getIdFieldType(EntityResourceBean entityResourceBean) {
        String string = entityResourceBean.getEntityClassInfo().getIdFieldInfo().getType();
        if (string.equals("java.lang.Character")) {
            return "java.lang.String";
        }
        return string;
    }

    private String getIdFieldName(EntityResourceBean entityResourceBean) {
        return entityResourceBean.getEntityClassInfo().getIdFieldInfo().getName();
    }

    private String[] getIdFieldIdArray(EntityResourceBean entityResourceBean, boolean bl, String string) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            boolean bl2 = false;
            int n = bl ? collection.size() + 1 : collection.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "id" + (i + 1);
            }
            if (bl) {
                stringArray[n - 1] = string;
            }
            return stringArray;
        }
        if (!bl) {
            return new String[]{"id"};
        }
        return new String[]{"id", string};
    }

    private String[] getIdFieldNameArray(EntityResourceBean entityResourceBean, boolean bl, String string) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            int n = 0;
            int n2 = bl ? collection.size() + 1 : collection.size();
            String[] stringArray = new String[n2];
            for (EntityClassInfo.FieldInfo fieldInfo2 : collection) {
                stringArray[n++] = fieldInfo2.getName();
            }
            if (bl) {
                stringArray[n2 - 1] = string;
            }
            return stringArray;
        }
        if (!bl) {
            return new String[]{fieldInfo.getName()};
        }
        return new String[]{fieldInfo.getName(), string};
    }

    private Object[] getIdFieldTypeArray(EntityResourceBean entityResourceBean, boolean bl, Object object) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            int n = 0;
            int n2 = bl ? collection.size() + 1 : collection.size();
            Object[] objectArray = new Object[n2];
            for (EntityClassInfo.FieldInfo fieldInfo2 : collection) {
                objectArray[n++] = fieldInfo2.getType();
            }
            if (bl) {
                objectArray[n2 - 1] = object;
            }
            return objectArray;
        }
        String string = fieldInfo.getType();
        if (string.equals("java.lang.Character")) {
            string = "java.lang.String";
        }
        if (!bl) {
            return new Object[]{string};
        }
        return new Object[]{string, object};
    }

    private String[] getIdFieldUriParamArray(EntityResourceBean entityResourceBean, boolean bl, String string) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            int n = bl ? fieldInfo.getFieldInfos().size() + 1 : fieldInfo.getFieldInfos().size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "PathParam";
            }
            if (bl) {
                stringArray[n - 1] = string;
            }
            return stringArray;
        }
        if (!bl) {
            return new String[]{"PathParam"};
        }
        return new String[]{"PathParam", string};
    }

    private String getIdFieldIdList(EntityResourceBean entityResourceBean) {
        EntityClassInfo.FieldInfo fieldInfo = entityResourceBean.getEntityClassInfo().getIdFieldInfo();
        if (fieldInfo.isEmbeddedId()) {
            int n = fieldInfo.getFieldInfos().size();
            String string = "";
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    string = string + ", ";
                }
                string = string + "id" + i;
            }
            return string;
        }
        return "id";
    }

    private String getIdFieldToUriStmt(EntityResourceBean entityResourceBean) {
        return this.getIdFieldToUriStmt(entityResourceBean.getEntityClassInfo().getIdFieldInfo());
    }

    private String getIdFieldToUriStmt(EntityClassInfo.FieldInfo fieldInfo) {
        String string = this.getGetterName(fieldInfo);
        if (fieldInfo.isEmbeddedId()) {
            Collection<EntityClassInfo.FieldInfo> collection = fieldInfo.getFieldInfos();
            int n = collection.size();
            String string2 = "";
            int n2 = 0;
            for (EntityClassInfo.FieldInfo fieldInfo2 : collection) {
                if (n2++ > 0) {
                    string2 = string2 + " + \",\" + ";
                }
                string2 = string2 + "entity." + string + "()." + this.getGetterName(fieldInfo2) + "()";
            }
            return string2;
        }
        return "entity." + string + "()";
    }

    protected String getIdGetter(EntityResourceBean entityResourceBean) {
        return this.getGetterName(entityResourceBean.getEntityClassInfo().getIdFieldInfo());
    }

    protected String getIdSetter(EntityResourceBean entityResourceBean) {
        return this.getSetterName(entityResourceBean.getEntityClassInfo().getIdFieldInfo());
    }

    protected String getEntityClassName(EntityResourceBean entityResourceBean) {
        return entityResourceBean.getEntityClassInfo().getName();
    }

    protected String getEntityClassType(EntityResourceBean entityResourceBean) {
        return entityResourceBean.getEntityClassInfo().getType();
    }

    protected String getPersistenceServiceClassType() {
        return this.getResourcePackageName() + "." + PERSISTENCE_SERVICE;
    }

    protected String getUriResolverClassType() {
        return this.getConverterPackageName() + "." + URI_RESOLVER;
    }

    protected String capitalizeFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1, string.length());
    }

    protected String lowerCaseFirstLetter(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1, string.length());
    }

    protected String demodulize(String string) {
        return Inflector.getInstance().demodulize(string);
    }

    protected String getNullValue(EntityClassInfo.FieldInfo fieldInfo) {
        String string = fieldInfo.getSimpleTypeName();
        if (string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("byte") || string.equals("short") || string.equals("char")) {
            return "(" + fieldInfo.getSimpleTypeName() + ") 0";
        }
        if (string.equals("boolean")) {
            return "false";
        }
        return "null";
    }

    protected EntityClassInfo getEntityClassInfo(String string) {
        return this.model.getBuilder().getEntityClassInfo(string);
    }

    protected String[] combineStringArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray2 == null || stringArray2.length == 0) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    protected Object[] combineObjectArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray2 == null || objectArray2.length == 0) {
            return objectArray;
        }
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    @Override
    protected int getTotalWorkUnits() {
        int n = 0;
        for (EntityResourceBean entityResourceBean : this.model.getResourceBeans()) {
            n += 2;
            if (!entityResourceBean.isItem()) continue;
            ++n;
        }
        n = (n + 2) * 2;
        return n;
    }

    private void reportProgress(String string, boolean bl) {
        String string2 = null;
        string2 = !bl ? NbBundle.getMessage(EntityResourcesGenerator.class, (String)"MSG_CreatingClass", (Object)string) : NbBundle.getMessage(EntityResourcesGenerator.class, (String)"MSG_ModifyingClass", (Object)string);
        this.reportProgress(string2);
    }
}

