/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Map;
import java.util.Set;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmFileReferences {
    private static final CsmFileReferences EMPTY = new Empty();
    private static CsmFileReferences DEFAULT;

    public abstract void accept(CsmScope var1, Visitor var2);

    public abstract void accept(CsmScope var1, Visitor var2, Set<CsmReferenceKind> var3);

    protected CsmFileReferences() {
    }

    public static synchronized CsmFileReferences getDefault() {
        if (DEFAULT != null) {
            return DEFAULT;
        }
        DEFAULT = (CsmFileReferences)Lookup.getDefault().lookup(CsmFileReferences.class);
        return DEFAULT == null ? EMPTY : DEFAULT;
    }

    public static boolean isTemplateBased(CsmReferenceContext csmReferenceContext) {
        if (2 <= csmReferenceContext.size() && CsmFileReferences.isDereference(csmReferenceContext.getToken())) {
            CsmReference csmReference = csmReferenceContext.getReference(csmReferenceContext.size() - 2);
            if (csmReference != null) {
                if (CsmFileReferences.getDefault().isThis(csmReference)) {
                    return CsmFileReferences.hasTemplateBasedAncestors(CsmFileReferences.findContextClass(csmReferenceContext));
                }
                CsmObject csmObject = csmReference.getReferencedObject();
                if (CsmFileReferences.isTemplateParameterInvolved(csmObject)) {
                    return true;
                }
                return CsmFileReferences.hasTemplateBasedAncestors(CsmFileReferences.getType(csmObject));
            }
        } else {
            return CsmFileReferences.hasTemplateBasedAncestors(CsmFileReferences.findContextClass(csmReferenceContext));
        }
        return false;
    }

    private static CsmType getType(CsmObject csmObject) {
        if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            return ((CsmFunction)csmObject).getReturnType();
        }
        if (CsmKindUtilities.isVariable((CsmObject)csmObject)) {
            return ((CsmVariable)csmObject).getType();
        }
        if (CsmKindUtilities.isTypedef((CsmObject)csmObject)) {
            return ((CsmTypedef)csmObject).getType();
        }
        return null;
    }

    private static CsmClass findContextClass(CsmReferenceContext csmReferenceContext) {
        CsmObject csmObject = csmReferenceContext.getReference().getOwner();
        while (CsmKindUtilities.isScopeElement((CsmObject)csmObject)) {
            CsmFunction csmFunction;
            if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                return (CsmClass)csmObject;
            }
            if (CsmKindUtilities.isClassMember((CsmObject)csmObject)) {
                return ((CsmMember)csmObject).getContainingClass();
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject) ? CsmKindUtilities.isClassMember((CsmObject)(csmFunction = ((CsmFunctionDefinition)csmObject).getDeclaration())) : CsmKindUtilities.isVariableDefinition((CsmObject)csmObject) && CsmKindUtilities.isClassMember((CsmObject)(csmFunction = ((CsmVariableDefinition)csmObject).getDeclaration()))) {
                return ((CsmMember)csmFunction).getContainingClass();
            }
            csmObject = ((CsmScopeElement)csmObject).getScope();
        }
        return null;
    }

    private static boolean hasTemplateBasedAncestors(CsmType csmType) {
        CsmClassifier csmClassifier;
        if (csmType != null && CsmKindUtilities.isClass((CsmObject)(csmClassifier = csmType.getClassifier()))) {
            return CsmFileReferences.hasTemplateBasedAncestors((CsmClass)csmClassifier);
        }
        return false;
    }

    private static boolean hasTemplateBasedAncestors(CsmClass csmClass) {
        if (csmClass != null) {
            if (CsmFileReferences.isActualInstantiation(csmClass)) {
                return false;
            }
            for (CsmInheritance csmInheritance : csmClass.getBaseClasses()) {
                if (csmInheritance.getAncestorType().isTemplateBased()) {
                    return true;
                }
                CsmClassifier csmClassifier = csmInheritance.getClassifier();
                if (!(csmClassifier instanceof CsmClass) || !CsmFileReferences.hasTemplateBasedAncestors((CsmClass)csmClassifier)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isActualInstantiation(CsmClass csmClass) {
        if (CsmKindUtilities.isInstantiation((CsmObject)csmClass)) {
            CsmInstantiation csmInstantiation = (CsmInstantiation)csmClass;
            Map map = csmInstantiation.getMapping();
            for (CsmType csmType : map.values()) {
                if (!csmType.isTemplateBased()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isMacroBased(CsmReferenceContext csmReferenceContext) {
        CsmReference csmReference;
        if (2 <= csmReferenceContext.size() && CsmFileReferences.isDereference(csmReferenceContext.getToken()) && (csmReference = csmReferenceContext.getReference(csmReferenceContext.size() - 2)) != null && CsmKindUtilities.isMacro((CsmObject)csmReference.getReferencedObject())) {
            return true;
        }
        for (int i = csmReferenceContext.size() - 1; 0 < i; --i) {
            CsmReference csmReference2;
            if (csmReferenceContext.getToken(i) != CppTokenId.LPAREN || (csmReference2 = csmReferenceContext.getReference(i - 1)) == null || !CsmKindUtilities.isMacro((CsmObject)csmReference2.getReferencedObject())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAfterUnresolved(CsmReferenceContext csmReferenceContext) {
        CsmReference csmReference;
        return 2 <= csmReferenceContext.size() && CsmFileReferences.isDereference(csmReferenceContext.getToken()) && (csmReference = csmReferenceContext.getReference(csmReferenceContext.size() - 2)) != null && !CsmFileReferences.getDefault().isThis(csmReference) && csmReference.getReferencedObject() == null;
    }

    private static boolean isTemplateParameterInvolved(CsmObject csmObject) {
        if (CsmKindUtilities.isTemplateParameter((CsmObject)csmObject)) {
            return true;
        }
        CsmType csmType = CsmFileReferences.getType(csmObject);
        return csmType == null ? false : csmType.isTemplateBased();
    }

    public static boolean isDereference(CppTokenId cppTokenId) {
        if (cppTokenId == null) {
            return false;
        }
        switch (cppTokenId) {
            case DOT: 
            case DOTMBR: 
            case ARROW: 
            case ARROWMBR: 
            case SCOPE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBracket(CppTokenId cppTokenId) {
        if (cppTokenId == null) {
            return false;
        }
        switch (cppTokenId) {
            case LBRACE: 
            case LBRACKET: 
            case LPAREN: 
            case LT: {
                return true;
            }
        }
        return false;
    }

    protected boolean isThis(CsmReference csmReference) {
        return csmReference != null && "this".equals(csmReference.getText());
    }

    public static interface Visitor {
        public void visit(CsmReferenceContext var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Empty
    extends CsmFileReferences {
        Empty() {
        }

        @Override
        public void accept(CsmScope csmScope, Visitor visitor) {
        }

        @Override
        public void accept(CsmScope csmScope, Visitor visitor, Set<CsmReferenceKind> set) {
        }
    }
}

