/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.common.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.projects.common.CatalogWSDL;
import org.netbeans.modules.compapp.projects.common.ImplicitCatalogSupport;
import org.netbeans.modules.compapp.projects.common.ui.ImplicitReferenceDecorator;
import org.netbeans.modules.compapp.projects.common.ui.NamespaceReferenceCreator;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDataNode;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDecorator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitReferenceCreator
extends NamespaceReferenceCreator<Definitions> {
    private ExternalReferenceDecorator decorator;

    public ImplicitReferenceCreator(Definitions definitions, Model model) {
        super(definitions, model);
    }

    @Override
    protected String getTargetNamespace(Model model) {
        if (model instanceof WSDLModel) {
            return ((WSDLModel)model).getDefinitions().getTargetNamespace();
        }
        if (model instanceof SchemaModel) {
            return ((SchemaModel)model).getSchema().getTargetNamespace();
        }
        return null;
    }

    @Override
    protected Map getPrefixes(Model model) {
        WSDLModel wSDLModel = (WSDLModel)model;
        AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)wSDLModel.getDefinitions();
        return abstractDocumentComponent.getPrefixes();
    }

    @Override
    protected ExternalReferenceDecorator getNodeDecorator() {
        if (this.decorator == null) {
            this.decorator = new ImplicitReferenceDecorator(this);
        }
        return this.decorator;
    }

    @Override
    public boolean mustNamespaceDiffer() {
        return true;
    }

    @Override
    protected String referenceTypeName() {
        return "Select";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    public void applyChanges() throws IOException {
    }

    public List<NSReference> getSelectedNamespaces() {
        ArrayList<NSReference> arrayList = new ArrayList<NSReference>();
        List<Node> list = this.getSelectedNodes();
        for (Node node : list) {
            ExternalReferenceNode externalReferenceNode;
            Model model;
            if (!(node instanceof ExternalReferenceNode) || (model = (externalReferenceNode = (ExternalReferenceNode)node).getModel()) == null || model == ((Definitions)this.getModelComponent()).getModel()) continue;
            FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
            String string = externalReferenceNode.getNamespace();
            String string2 = this.getLocation(node);
            CatalogWSDL.EntryType entryType = CatalogWSDL.EntryType.WSDL;
            if (model instanceof WSDLModel) {
                entryType = CatalogWSDL.EntryType.WSDL;
            } else if (model instanceof SchemaModel) {
                entryType = CatalogWSDL.EntryType.XSD;
            }
            String string3 = "";
            if (externalReferenceNode instanceof ExternalReferenceDataNode) {
                string3 = ((ExternalReferenceDataNode)externalReferenceNode).getPrefix();
            }
            NSReference nSReference = new NSReference(entryType);
            nSReference.setNamespace(string);
            nSReference.setLocation(string2);
            nSReference.setPrefix(string3);
            nSReference.setFileObject(fileObject);
            arrayList.add(nSReference);
        }
        return arrayList;
    }

    public void addSelectedNamespacesToCatalog(Project project) {
        ImplicitCatalogSupport implicitCatalogSupport = ImplicitCatalogSupport.getInstance(project);
        List<NSReference> list = this.getSelectedNamespaces();
        for (NSReference nSReference : list) {
            try {
                implicitCatalogSupport.createImplicitCatalogEntry(nSReference.getNamesapce(), nSReference.getFileObject(), nSReference.getType());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected static WSDLModel getCatalogWSDLModel(Project project) {
        WSDLModel wSDLModel = null;
        try {
            FileObject fileObject = CatalogWSDL.getCatalogWSDLFile(project);
            ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
            wSDLModel = WSDLModelFactory.getDefault().getModel(modelSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return wSDLModel;
    }

    public static ImplicitReferenceCreator newInstance(Project project) {
        ImplicitReferenceCreator implicitReferenceCreator = null;
        WSDLModel wSDLModel = ImplicitReferenceCreator.getCatalogWSDLModel(project);
        implicitReferenceCreator = new ImplicitReferenceCreator(wSDLModel.getDefinitions(), (Model)wSDLModel);
        return implicitReferenceCreator;
    }

    public static Object showSelectionDialog(final ImplicitReferenceCreator implicitReferenceCreator, String string) {
        JComponent jComponent = implicitReferenceCreator.getComponent();
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jComponent, string, true, null);
        dialogDescriptor.setHelpCtx(implicitReferenceCreator.getHelpCtx());
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == implicitReferenceCreator && propertyChangeEvent.getPropertyName().equals("apply")) {
                    dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
                }
            }
        };
        implicitReferenceCreator.addPropertyChangeListener(propertyChangeListener);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION) || actionEvent.getSource().equals(DialogDescriptor.CANCEL_OPTION) || actionEvent.getSource().equals(DialogDescriptor.CLOSED_OPTION)) {
                    implicitReferenceCreator.removePropertyChangeListener(propertyChangeListener);
                }
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    try {
                        implicitReferenceCreator.apply();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        };
        dialogDescriptor.setButtonListener(actionListener);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
        dialog.setVisible(true);
        return dialogDescriptor.getValue();
    }

    public static class NSReference
    extends CatalogWSDL.Entry {
        private String mPrefix;
        private FileObject mRefFO;

        public NSReference(CatalogWSDL.EntryType entryType) {
            super(entryType);
        }

        public String getPrefix() {
            return this.mPrefix;
        }

        public void setPrefix(String string) {
            this.mPrefix = string;
        }

        public FileObject getFileObject() {
            return this.mRefFO;
        }

        public void setFileObject(FileObject fileObject) {
            this.mRefFO = fileObject;
        }
    }
}

