/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.common;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.compapp.projects.common.CatalogWSDL;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.catalogsupport.util.ProjectReferenceUtility;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModelFactory;
import org.netbeans.modules.xml.retriever.catalog.ProjectCatalogSupport;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ImplicitCatalogSupport
extends ProjectCatalogSupport {
    private static final Logger sLogger = Logger.getLogger(ImplicitCatalogSupport.class.getName());
    private Project mProject;
    private AntProjectHelper mAntPrjHelper;
    private ReferenceHelper mPrjRefHelper;
    private static String[] sourceTypes = new String[]{"xml", "java", "doc_root", "web_inf"};

    public ImplicitCatalogSupport(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper) {
        assert (project != null);
        this.mProject = project;
        this.mAntPrjHelper = antProjectHelper;
        this.mPrjRefHelper = referenceHelper;
    }

    protected ImplicitCatalogSupport(Project project) {
        this(project, null, null);
    }

    public static ImplicitCatalogSupport getInstance(Project project) {
        ImplicitCatalogSupport implicitCatalogSupport;
        Project project2 = project;
        if (project2 != null && (implicitCatalogSupport = (ImplicitCatalogSupport)((Object)project2.getLookup().lookup(ImplicitCatalogSupport.class))) != null) {
            return implicitCatalogSupport;
        }
        return new ImplicitCatalogSupport(project2);
    }

    public static ImplicitCatalogSupport getInstance(FileObject fileObject) {
        return ImplicitCatalogSupport.getInstance(FileOwnerQuery.getOwner((FileObject)fileObject));
    }

    protected DefaultProjectCatalogSupport getDefaultProjectCatalogSupport() {
        DefaultProjectCatalogSupport defaultProjectCatalogSupport;
        Project project = this.mProject;
        if (project != null && (defaultProjectCatalogSupport = (DefaultProjectCatalogSupport)project.getLookup().lookup(DefaultProjectCatalogSupport.class)) != null) {
            return defaultProjectCatalogSupport;
        }
        if (this.mAntPrjHelper != null) {
            return new DefaultProjectCatalogSupport(project, this.mAntPrjHelper, this.mPrjRefHelper);
        }
        return new DefaultProjectCatalogSupport(project);
    }

    public URI constructProjectProtocol(FileObject fileObject) {
        return this.getDefaultProjectCatalogSupport().constructProjectProtocol(fileObject);
    }

    public boolean isProjectProtocol(URI uRI) {
        return this.getDefaultProjectCatalogSupport().isProjectProtocol(uRI);
    }

    public FileObject resolveProjectProtocol(URI uRI) {
        return this.getDefaultProjectCatalogSupport().resolveProjectProtocol(uRI);
    }

    public URI createCatalogEntry(FileObject fileObject, FileObject fileObject2) throws CatalogModelException, IOException {
        if (fileObject == null) {
            return this.createCatalogEntry(fileObject2);
        }
        return this.getDefaultProjectCatalogSupport().createCatalogEntry(fileObject, fileObject2);
    }

    public boolean removeCatalogEntry(URI uRI) throws IOException {
        return this.getDefaultProjectCatalogSupport().removeCatalogEntry(uRI);
    }

    public URI createCatalogEntry(FileObject fileObject) throws CatalogModelException, IOException {
        assert (fileObject != null);
        CatalogWriteModel catalogWriteModel = CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(this.mProject.getProjectDirectory());
        assert (catalogWriteModel != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        URI uRI = null;
        URI uRI2 = null;
        uRI = this.generateSystemID(project, fileObject);
        uRI2 = this.generateURIReference(project, fileObject);
        if (uRI == null || uRI2 == null) {
            return null;
        }
        catalogWriteModel.addURI(uRI, uRI2);
        return uRI;
    }

    public URI createImplicitCatalogEntry(String string, FileObject fileObject, CatalogWSDL.EntryType entryType) throws CatalogModelException, IOException {
        URI uRI = this.createCatalogEntry(fileObject);
        String string2 = uRI.toASCIIString();
        CatalogWSDL.Entry entry = null;
        entry = CatalogWSDL.EntryType.WSDL.equals((Object)entryType) ? CatalogWSDL.Entry.createWSDLEntry(string, string2) : (CatalogWSDL.EntryType.XSD.equals((Object)entryType) ? CatalogWSDL.Entry.createXSDEntry(string, string2) : null);
        if (entry != null) {
            CatalogWSDL catalogWSDL = CatalogWSDL.loadCatalogWSDL(this.mProject);
            catalogWSDL.addEntry(entry);
            CatalogWSDL.saveCatalogWSDL(catalogWSDL, this.mProject);
        } else {
            sLogger.fine("#### NO ENTRY WAS ADDED IN CatalogWSDL for namespace " + string);
        }
        return uRI;
    }

    public boolean removeImplicitCatalogEntry(String string, CatalogWSDL.EntryType entryType) throws CatalogModelException, IOException {
        CatalogWSDL catalogWSDL = CatalogWSDL.loadCatalogWSDL(this.mProject);
        CatalogWSDL.Entry entry = catalogWSDL.getEntry(entryType, string, null);
        boolean bl = catalogWSDL.removeEntry(entry);
        CatalogWSDL.saveCatalogWSDL(catalogWSDL, this.mProject);
        return bl;
    }

    public FileObject resolveImplicitReference(String string, CatalogWSDL.EntryType entryType) throws CatalogModelException, IOException {
        FileObject fileObject = null;
        CatalogWSDL catalogWSDL = CatalogWSDL.loadCatalogWSDL(this.mProject);
        CatalogWSDL.Entry entry = null;
        if (entryType == null) {
            List<CatalogWSDL.Entry> list = catalogWSDL.getEntries(string);
            if (list.size() > 0) {
                entry = list.get(0);
            }
        } else {
            entry = catalogWSDL.getEntry(entryType, string, null);
        }
        if (entry != null) {
            fileObject = this.resolveImplicitReference(entry.getLocation());
        }
        return fileObject;
    }

    public FileObject resolveImplicitReference(String string) throws CatalogModelException, IOException {
        FileObject fileObject = null;
        if (string == null) {
            return fileObject;
        }
        try {
            URI uRI = new URI(string);
            CatalogWriteModel catalogWriteModel = CatalogWriteModelFactory.getInstance().getCatalogWriteModelForProject(this.mProject.getProjectDirectory());
            URI uRI2 = catalogWriteModel.searchURI(uRI);
            if (uRI2 != null) {
                fileObject = this.resolveProjectProtocol(uRI2);
                if (fileObject == null) {
                    fileObject = this.resolveRelativeReference(uRI2);
                }
                if (fileObject == null) {
                    sLogger.fine("Can not find file object for SystemId: " + uRI + " URIReference: " + uRI2 + "in catalog.xml");
                }
            } else {
                sLogger.fine("Can not find the URI reference for SystemId" + uRI + "in catalog.xml");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            sLogger.log(Level.FINE, uRISyntaxException.getMessage(), uRISyntaxException);
        }
        return fileObject;
    }

    public boolean supportsCrossProject() {
        return this.mAntPrjHelper != null;
    }

    public Set getProjectReferences() {
        SubprojectProvider subprojectProvider = (SubprojectProvider)this.mProject.getLookup().lookup(SubprojectProvider.class);
        return subprojectProvider.getSubprojects();
    }

    protected FileObject resolveRelativeReference(URI uRI) {
        File file = FileUtil.toFile((FileObject)this.mProject.getProjectDirectory());
        File file2 = new File(file.toURI().resolve(uRI));
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2));
        return fileObject;
    }

    protected URI generateURIReference(Project project, FileObject fileObject) {
        assert (project != null && fileObject != null);
        if (this.mProject != project) {
            if (!this.getProjectReferences().contains(project) && this.supportsCrossProject()) {
                ProjectReferenceUtility.addProjectReference((ReferenceHelper)this.mPrjRefHelper, (Project)project);
            }
            return this.constructProjectProtocol(fileObject);
        }
        try {
            String string = FileUtil.getRelativePath((FileObject)this.mProject.getProjectDirectory(), (FileObject)fileObject);
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            sLogger.log(Level.FINE, uRISyntaxException.getMessage(), uRISyntaxException);
            return null;
        }
    }

    protected URI generateSystemID(Project project, FileObject fileObject) {
        assert (project != null && fileObject != null);
        try {
            if (this.mProject != project) {
                FileObject fileObject2 = ImplicitCatalogSupport.getSourceFolder(project, fileObject);
                String string = ImplicitCatalogSupport.getUsableProjectName(project);
                String string2 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
                return new URI(string + "/" + string2);
            }
            FileObject fileObject3 = this.getSourceFolder(fileObject);
            if (fileObject3 == null) {
                throw new IllegalArgumentException(fileObject.getPath() + " is not in project source");
            }
            String string = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject);
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            sLogger.log(Level.FINE, uRISyntaxException.getMessage(), uRISyntaxException);
            return null;
        }
    }

    private static String getUsableProjectName(Project project) {
        return PropertyUtils.getUsablePropertyName((String)ProjectUtils.getInformation((Project)project).getName()).replace('.', '_');
    }

    private FileObject getSourceFolder(FileObject fileObject) {
        return ImplicitCatalogSupport.getSourceFolder(this.mProject, fileObject);
    }

    private static FileObject getSourceFolder(Project project, FileObject fileObject) {
        Sources sources = ProjectUtils.getSources((Project)project);
        assert (sources != null);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        for (String string : sourceTypes) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups(string);
            if (sourceGroupArray == null) continue;
            arrayList.addAll(Arrays.asList(sourceGroupArray));
        }
        assert (arrayList.size() > 0);
        for (SourceGroup sourceGroup : arrayList) {
            if (!FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject)) continue;
            return sourceGroup.getRootFolder();
        }
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("src/conf");
        if (fileObject2 != null && FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
            return fileObject2;
        }
        return null;
    }
}

