/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.base;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.compapp.projects.base.IcanproActionProvider;
import org.netbeans.modules.compapp.projects.base.queries.IcanproProjectEncodingQueryImpl;
import org.netbeans.modules.compapp.projects.base.spi.JbiArtifactProvider;
import org.netbeans.modules.compapp.projects.base.ui.IcanproCustomizerProvider;
import org.netbeans.modules.compapp.projects.base.ui.IcanproLogicalViewProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class IcanproProject
implements Project,
AntProjectListener {
    private static final Icon PROJECT_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/compapp/projects/base/ui/resources/icanproProjectIcon.gif"));
    public static final String SOURCES_TYPE_ICANPRO = "BIZPRO";
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private static final Logger LOG = Logger.getLogger(IcanproProject.class.getName());

    public IcanproProject(AntProjectHelper antProjectHelper) throws IOException {
        this.helper = antProjectHelper;
        this.eval = this.createEvaluator();
        AuxiliaryConfiguration auxiliaryConfiguration = antProjectHelper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(antProjectHelper, auxiliaryConfiguration, antProjectHelper.getStandardPropertyEvaluator());
        this.genFilesHelper = new GeneratedFilesHelper(antProjectHelper);
        this.lookup = this.createLookup(auxiliaryConfiguration);
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String toString() {
        return "IcanproProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        return this.helper.getStandardPropertyEvaluator();
    }

    public PropertyEvaluator evaluator() {
        return this.eval;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createLookup(AuxiliaryConfiguration auxiliaryConfiguration) {
        SubprojectProvider subprojectProvider = this.refHelper.createSubprojectProvider();
        FileBuiltQueryImplementation fileBuiltQueryImplementation = this.helper.createGlobFileBuiltQuery(this.helper.getStandardPropertyEvaluator(), new String[]{"${src.dir}/*.java"}, new String[]{"${build.classes.dir}/*.class"});
        final SourcesHelper sourcesHelper = new SourcesHelper(this.helper, this.evaluator());
        String string = NbBundle.getMessage(IcanproCustomizerProvider.class, (String)"LBL_Node_EJBModule");
        String string2 = NbBundle.getMessage(IcanproCustomizerProvider.class, (String)"LBL_Node_Sources");
        sourcesHelper.addPrincipalSourceRoot("${source.root}", string, null, null);
        sourcesHelper.addPrincipalSourceRoot("${src.dir}", string2, null, null);
        sourcesHelper.addTypedSourceRoot("${src.dir}", SOURCES_TYPE_ICANPRO, string2, null, null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                sourcesHelper.registerExternalRoots(0);
            }
        });
        return Lookups.fixed((Object[])new Object[]{new Info(), auxiliaryConfiguration, this.helper.createCacheDirectoryProvider(), this.helper, subprojectProvider, new IcanproActionProvider(this, this.helper, this.refHelper), new IcanproLogicalViewProvider(this, this.helper, this.evaluator(), subprojectProvider, this.refHelper), new IcanproCustomizerProvider(this, this.helper, this.refHelper), new JbiArtifactProviderImpl(), new ProjectXmlSavedHookImpl(), new ProjectOpenedHookImpl(), fileBuiltQueryImplementation, new RecommendedTemplatesImpl(), new IcanproProjectEncodingQueryImpl(this.evaluator()), this.refHelper, sourcesHelper.createSources(), this.helper.createSharabilityQuery(this.evaluator(), new String[]{"${source.root}"}, new String[]{"${build.dir}", "${dist.dir}"})});
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        if (antProjectEvent.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    String getBuildXmlName() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("buildfile");
        return string == null ? "build.xml" : string;
    }

    FileObject getSourceDirectory() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
        return this.helper.resolveFileObject(string);
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element element = IcanproProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-icanpro/1", "name");
                if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                    return ((Text)nodeList.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] TYPES = new String[]{"XML", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/CAPS/schema.xsd", "Templates/CAPS/untitled.bpel", "Templates/CAPS/untitled.wsdl"};

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private final class JbiArtifactProviderImpl
    implements JbiArtifactProvider {
        private JbiArtifactProviderImpl() {
        }

        public AntArtifact[] getBuildArtifacts() {
            return new AntArtifact[]{IcanproProject.this.helper.createSimpleAntArtifact("CAPS.asa:" + IcanproProject.this.helper.getStandardPropertyEvaluator().getProperty("com.sun.jbi.ui.devtool.jbi.setype.prefix"), "sedeployment.jar", IcanproProject.this.helper.getStandardPropertyEvaluator(), "dist_se", "clean")};
        }

        public String getJbiServiceAssemblyType() {
            return IcanproProject.this.helper.getStandardPropertyEvaluator().getProperty("com.sun.jbi.ui.devtool.jbi.setype.prefix");
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            String string;
            try {
                IcanproProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", IcanproProject.class.getResource("resources/build-impl.xsl"), true);
                IcanproProject.this.genFilesHelper.refreshBuildScript(IcanproProject.this.getBuildXmlName(), IcanproProject.class.getResource("resources/build.xsl"), true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            EditableProperties editableProperties = IcanproProject.this.helper.getProperties("nbproject/project.properties");
            if (editableProperties.getProperty("source.encoding") == null) {
                editableProperties.setProperty("source.encoding", FileEncodingQuery.getDefaultEncoding().name());
            }
            IcanproProject.this.helper.putProperties("nbproject/project.properties", editableProperties);
            if (IcanproLogicalViewProvider.hasBrokenLinks(IcanproProject.this.helper, IcanproProject.this.refHelper)) {
                // empty if block
            }
            if ((string = IcanproProject.this.eval.getProperty("source.encoding")) != null) {
                try {
                    Charset charset = Charset.forName(string);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    LOG.warning("Illegal charset: " + string + " in project: " + IcanproProject.this.getProjectDirectory());
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    LOG.warning("Unsupported charset: " + string + " in project: " + IcanproProject.this.getProjectDirectory());
                }
            }
        }

        protected void projectClosed() {
            try {
                ProjectManager.getDefault().saveProject((Project)IcanproProject.this);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
            IcanproProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", IcanproProject.class.getResource("resources/build-impl.xsl"), false);
            IcanproProject.this.genFilesHelper.refreshBuildScript(IcanproProject.this.getBuildXmlName(), IcanproProject.class.getResource("resources/build.xsl"), false);
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String string) {
            this.pcs.firePropertyChange(string, null, null);
        }

        public String getName() {
            return IcanproProject.this.getName();
        }

        public String getDisplayName() {
            return IcanproProject.this.getName();
        }

        public Icon getIcon() {
            return PROJECT_ICON;
        }

        public Project getProject() {
            return IcanproProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

