/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementScanner6;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementNode
extends AbstractNode
implements OffsetProvider {
    private Element element;
    private CompilationInfo info;

    public static Node getTree(CompilationInfo compilationInfo, Element element) {
        ArrayList arrayList = new ArrayList();
        new FindChildrenElementVisitor(compilationInfo).scan(element, arrayList);
        return (Node)arrayList.get(0);
    }

    public ElementNode(CompilationInfo compilationInfo, Element element, List<Node> list) {
        super((Children)(list.isEmpty() ? Children.LEAF : new NodeChilren(list)));
        this.element = element;
        this.info = compilationInfo;
        this.setDisplayName(element.getKind().toString() + ":" + element.toString());
        this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/element.png");
    }

    @Override
    public int getStart() {
        Tree tree = this.info.getTrees().getTree(this.element);
        if (tree != null) {
            return (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), tree);
        }
        return -1;
    }

    @Override
    public int getEnd() {
        Tree tree = this.info.getTrees().getTree(this.element);
        if (tree != null) {
            return (int)this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), tree);
        }
        return -1;
    }

    @Override
    public int getPreferredPosition() {
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindChildrenElementVisitor
    extends ElementScanner6<Void, List<Node>> {
        private CompilationInfo info;

        public FindChildrenElementVisitor(CompilationInfo compilationInfo) {
            this.info = compilationInfo;
        }

        @Override
        public Void visitPackage(PackageElement packageElement, List<Node> list) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            super.visitPackage(packageElement, arrayList);
            list.add((Node)new ElementNode(this.info, packageElement, arrayList));
            return null;
        }

        @Override
        public Void visitType(TypeElement typeElement, List<Node> list) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            super.visitType(typeElement, arrayList);
            list.add((Node)new ElementNode(this.info, typeElement, arrayList));
            return null;
        }

        @Override
        public Void visitVariable(VariableElement variableElement, List<Node> list) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            super.visitVariable(variableElement, arrayList);
            list.add((Node)new ElementNode(this.info, variableElement, arrayList));
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement executableElement, List<Node> list) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            super.visitExecutable(executableElement, arrayList);
            list.add((Node)new ElementNode(this.info, executableElement, arrayList));
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement typeParameterElement, List<Node> list) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            super.visitTypeParameter(typeParameterElement, arrayList);
            list.add((Node)new ElementNode(this.info, typeParameterElement, arrayList));
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NodeChilren
    extends Children.Keys<Node> {
        public NodeChilren(List<Node> list) {
            this.setKeys(list);
        }

        protected Node[] createNodes(Node node) {
            return new Node[]{node};
        }
    }
}

