/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.validation.action;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.soa.validation.core.QuickFix;
import org.netbeans.modules.soa.validation.core.QuickFixable;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.nodes.Node;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QuickFixAction
extends UI.IconAction {
    public QuickFixAction() {
        super(UI.i18n(QuickFixAction.class, (String)"CTL_Quick_Fix_Action"), UI.i18n(QuickFixAction.class, (String)"TLT_Quick_Fix_Action"), (Icon)UI.icon(QuickFixAction.class, (String)"quickfix"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        InputOutput inputOutput = IOProvider.getDefault().getIO(UI.i18n(QuickFixAction.class, (String)"LBL_Quick_Fix_Window"), false);
        OutputWriter outputWriter = inputOutput.getOut();
        try {
            outputWriter.reset();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        inputOutput.select();
        outputWriter.println(UI.i18n(QuickFixAction.class, (String)"MSG_Quick_Fix_started"));
        this.doQuickFix(this.getQuickFixes(UI.getSelectedNode()), outputWriter);
        outputWriter.println();
        outputWriter.print(UI.i18n(QuickFixAction.class, (String)"MSG_Quick_Fix_finished"));
    }

    private void doQuickFix(List<QuickFix> list, OutputWriter outputWriter) {
        if (list.size() == 0) {
            outputWriter.println();
            outputWriter.println(UI.i18n(QuickFixAction.class, (String)"MSG_Nothing_to_do"));
            return;
        }
        for (QuickFix quickFix : list) {
            String string = quickFix.doFix();
            if (string == null) continue;
            outputWriter.println();
            outputWriter.println(UI.i18n(QuickFixAction.class, (String)"MSG_Quick_Fix", (String)string));
        }
    }

    private List<QuickFix> getQuickFixes(Node node) {
        ArrayList<QuickFix> arrayList = new ArrayList<QuickFix>();
        if (node == null) {
            return arrayList;
        }
        Controller controller = (Controller)node.getLookup().lookup(Controller.class);
        if (controller == null) {
            return arrayList;
        }
        List<Validator.ResultItem> list = controller.getResult();
        for (Validator.ResultItem resultItem : list) {
            QuickFix quickFix;
            if (!(resultItem instanceof QuickFixable) || (quickFix = ((QuickFixable)resultItem).getQuickFix()) == null) continue;
            arrayList.add(quickFix);
        }
        return arrayList;
    }
}

