/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.designer.markup;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.xni.NamespaceContext;
import org.netbeans.modules.visualweb.api.designer.cssengine.CssProvider;
import org.netbeans.modules.visualweb.designer.html.HtmlTag;
import org.netbeans.modules.visualweb.designer.markup.MarkupServiceImpl;
import org.netbeans.modules.visualweb.designer.markup.RaveElement;
import org.netbeans.modules.visualweb.designer.markup.RaveRenderedDocument;
import org.netbeans.modules.visualweb.designer.markup.RaveSourceDocument;
import org.netbeans.modules.visualweb.designer.markup.RaveText;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractRaveDocument
extends DocumentImpl {
    private static final long serialVersionUID = 3979265845992305975L;

    public Element createElement(String string) throws DOMException {
        return this.createElementNS(NamespaceContext.XML_URI, string);
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        Element element = this.createSpecialElements(string, string2);
        if (element != null) {
            return element;
        }
        if (string == null && string2.indexOf(58) != -1) {
            string = NamespaceContext.XML_URI;
        }
        return this.createDefaultElement((CoreDocumentImpl)this, string, string2);
    }

    public Element createElementNS(String string, String string2, String string3) throws DOMException {
        Element element = this.createSpecialElements(string, string2);
        if (element != null) {
            return element;
        }
        return this.createDefaultElement((CoreDocumentImpl)this, string, string2, string3);
    }

    private Element createSpecialElements(String string, String string2) {
        char c = string2.charAt(0);
        switch (c) {
            case 's': {
                if (!string2.equals(HtmlTag.STYLE.name)) break;
                Element element = this.createStyleElement((CoreDocumentImpl)this, string, string2);
                CssProvider.getEngineService().addTransientStyleSheetNodeForDocument((Document)((Object)this), (Node)element);
                return element;
            }
            case 't': {
                if (!string2.equals(HtmlTag.TABLE.name)) break;
                return this.createTableElement((CoreDocumentImpl)this, string, string2);
            }
            case 'l': {
                if (!string2.equals(HtmlTag.LINK.name)) break;
                return this.createStylesheetLinkElement((CoreDocumentImpl)this, string, string2);
            }
        }
        return null;
    }

    public Text createTextNode(String string) {
        return this.createTextNode((CoreDocumentImpl)this, string);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        Node node2 = super.importNode(node, bl);
        this.duplicateXhtmlInfo(node, node2, bl);
        return node2;
    }

    private void duplicateXhtmlInfo(Node node, Node node2, boolean bl) {
        Object object;
        if (node instanceof Element && node.getOwnerDocument() instanceof RaveSourceDocument) {
            object = (Element)node;
            if (node2 instanceof RaveElement) {
                ((RaveElement)((Object)node2)).copyFrom((RaveElement)((Object)object));
            }
            if (node2 instanceof Element && node2.getOwnerDocument() instanceof RaveRenderedDocument) {
                MarkupServiceImpl.linkToSourceElement((Element)node2, (Element)object);
            }
        } else if (node instanceof Text && node.getOwnerDocument() instanceof RaveSourceDocument) {
            object = (Text)node;
            if (node2 instanceof RaveText) {
                ((RaveText)((Object)node2)).copyFrom((RaveText)((Object)object));
            }
            if (node2 instanceof Text && node2.getOwnerDocument() instanceof RaveRenderedDocument) {
                MarkupServiceImpl.linkToSourceText((Text)node2, (Text)object);
            }
        } else if (node instanceof Element && node.getOwnerDocument() instanceof RaveRenderedDocument && (object = MarkupServiceImpl.getSourceElement((Element)node)) instanceof RaveElement) {
            if (node2 instanceof RaveElement) {
                ((RaveElement)((Object)node2)).copyFrom((RaveElement)((Object)object));
            }
            if (node2 instanceof Element && node2.getOwnerDocument() instanceof RaveRenderedDocument) {
                MarkupServiceImpl.linkToSourceElement((Element)node2, (Element)object);
            }
        }
        if (bl) {
            object = node.getChildNodes();
            NodeList nodeList = node2.getChildNodes();
            int n = object.getLength();
            assert (nodeList.getLength() == n);
            for (int i = 0; i < n; ++i) {
                this.duplicateXhtmlInfo(object.item(i), nodeList.item(i), bl);
            }
        }
    }

    protected abstract Element createDefaultElement(CoreDocumentImpl var1, String var2, String var3);

    protected abstract Element createDefaultElement(CoreDocumentImpl var1, String var2, String var3, String var4);

    protected abstract Element createStyleElement(CoreDocumentImpl var1, String var2, String var3);

    protected abstract Element createTableElement(CoreDocumentImpl var1, String var2, String var3);

    protected abstract Element createStylesheetLinkElement(CoreDocumentImpl var1, String var2, String var3);

    protected abstract Text createTextNode(CoreDocumentImpl var1, String var2);

    public Attr createAttribute(String string) throws DOMException {
        if (this.errorChecking && !AbstractRaveDocument.isXMLName((String)string, (boolean)this.isXml11Version())) {
            String string2 = DOMMessageFormatter.formatMessage((String)"http://www.w3.org/dom/DOMTR", (String)"INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new Fix105085AttrImpl((CoreDocumentImpl)this, string);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return new Fix105085AttrNSImpl((CoreDocumentImpl)this, string, string2);
    }

    public Attr createAttributeNS(String string, String string2, String string3) throws DOMException {
        return new Fix105085AttrNSImpl((CoreDocumentImpl)this, string, string2, string3);
    }

    private boolean isXml11Version() {
        try {
            Field field = CoreDocumentImpl.class.getDeclaredField("xml11Version");
            field.setAccessible(true);
            return field.getBoolean((Object)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AbstractRaveDocument.log(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            AbstractRaveDocument.log(illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            AbstractRaveDocument.log(noSuchFieldException);
        }
        catch (SecurityException securityException) {
            AbstractRaveDocument.log(securityException);
        }
        return false;
    }

    private static void log(Exception exception) {
        Logger logger = AbstractRaveDocument.getLogger();
        logger.log(Level.INFO, null, exception);
    }

    private static Logger getLogger() {
        return Logger.getLogger(CoreDocumentImpl.class.getName());
    }

    private static class Fix105085AttrNSImpl
    extends AttrNSImpl {
        public Fix105085AttrNSImpl(CoreDocumentImpl coreDocumentImpl, String string, String string2) {
            super(coreDocumentImpl, string, string2);
        }

        public Fix105085AttrNSImpl(CoreDocumentImpl coreDocumentImpl, String string, String string2, String string3) {
            super(coreDocumentImpl, string, string2, string3);
        }

        public void setValue(String string) {
            super.setValue(string);
            textNode = null;
        }
    }

    private static class Fix105085AttrImpl
    extends AttrImpl {
        public Fix105085AttrImpl(CoreDocumentImpl coreDocumentImpl, String string) {
            super(coreDocumentImpl, string);
        }

        public void setValue(String string) {
            super.setValue(string);
            textNode = null;
        }
    }
}

