/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.UnsupportedCharsetException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.junit.output.Manager;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.TaskType;
import org.netbeans.modules.junit.output.TroubleParser;
import org.netbeans.modules.junit.output.XmlOutputParser;
import org.netbeans.modules.junit.output.antutils.AntProject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

final class JUnitOutputReader {
    private static final int MAX_REPORT_FILE_SIZE = 0x400000;
    private static final int PROGRESS_WORKUNITS = 32700;
    private static final int INITIAL_PROGRESS = 327;
    private static final String XML_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter";
    private final NumberFormat numberFormat = NumberFormat.getInstance();
    private boolean testListenerInfoAvailable = false;
    private int expectedOneSuiteTests = 0;
    private int executedOneSuiteTests = 0;
    private int expectedSuitesCount = 0;
    private int executedSuitesCount = 0;
    private boolean testsuiteStatsKnown = false;
    private final AntSession session;
    private final TaskType sessionType;
    private ProgressHandle progressHandle;
    private boolean isDeterminateProgress;
    private int lastProgress = 0;
    private MessageFormat progressStepFormatSuiteName;
    private MessageFormat progressStepFormatAnonymous;
    private boolean expectXmlReport;
    private final File antScript;
    private final long timeOfSessionStart;
    private final Logger LOG;
    private final Logger progressLogger;
    private RegexpUtils regexp = RegexpUtils.getInstance();
    private Report report;
    private Report.Testcase testcase;
    private Report.Trouble trouble;
    private TroubleParser troubleParser;
    private String suiteName;
    private StringBuilder xmlOutputBuffer;
    private boolean readingSuiteOutputSummary;
    private boolean lastHeaderBrief;
    private boolean waitingForIssueStatus;
    private final Manager manager = Manager.getInstance();
    private String classpath;
    private ClassPath platformSources;

    JUnitOutputReader(AntSession antSession, TaskType taskType, long l) {
        this.session = antSession;
        this.sessionType = taskType;
        this.antScript = antSession.getOriginatingScript();
        this.timeOfSessionStart = l;
        this.progressLogger = Logger.getLogger("org.netbeans.modules.junit.outputreader.progress");
        this.LOG = Logger.getLogger(this.getClass().getName());
    }

    void verboseMessageLogged(AntEvent antEvent) {
        String string;
        ClassPath classPath;
        String string2 = antEvent.getMessage();
        if (string2 == null) {
            this.LOG.finer("VERBOSE MSG: <null>");
            return;
        }
        if (this.LOG.isLoggable(Level.FINER)) {
            this.LOG.finer("VERBOSE MSG: \"" + string2 + '\"');
        }
        if (this.progressLogger.isLoggable(Level.FINEST)) {
            this.progressLogger.finest("VERBOSE: " + string2);
        }
        if (string2.startsWith("junit.framework.TestListener: ")) {
            if (this.report == null) {
                return;
            }
            this.testListenerInfoAvailable = true;
            String string3 = string2.substring("junit.framework.TestListener: ".length());
            if (string3.startsWith("tests to run: ")) {
                block35: {
                    String string4 = string3.substring("tests to run: ".length());
                    try {
                        int n = JUnitOutputReader.parseNonNegativeInteger(string4);
                        if (n > 0) {
                            this.expectedOneSuiteTests = n;
                            if (this.progressLogger.isLoggable(Level.FINER)) {
                                this.progressLogger.finer("expected # of tests in a suite: " + this.expectedOneSuiteTests);
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled || this.expectedOneSuiteTests == 0) break block35;
                        throw new AssertionError();
                    }
                }
                return;
            }
            int n = string3.indexOf(40);
            if (n == -1) {
                return;
            }
            String string5 = string3.substring(0, n);
            if (string5.equals("startTest")) {
                boolean bl = false;
                String string6 = string3.substring("startTest".length());
                if (string6.length() == 0) {
                    bl = true;
                } else {
                    char c = string6.charAt(0);
                    char c2 = string6.charAt(string6.length() - 1);
                    if (c == '(' && c2 == ')') {
                        this.testcase = new Report.Testcase();
                        this.testcase.name = string6.substring(1, string6.length() - 1);
                        this.testcase.timeMillis = -2;
                        bl = true;
                    } else if (!Character.isLetterOrDigit(c)) {
                        bl = true;
                    }
                }
                if (bl) {
                    this.progressLogger.finest("test started");
                }
                return;
            }
            if (string5.equals("endTest")) {
                boolean bl = false;
                String string7 = string3.substring("endTest".length());
                if (string7.length() == 0) {
                    bl = true;
                } else {
                    char c = string7.charAt(0);
                    char c3 = string7.charAt(string7.length() - 1);
                    if (c == '(' && c3 == ')') {
                        String string8 = string7.substring(1, string7.length() - 1);
                        if (string8.equals(this.testcase.name)) {
                            bl = true;
                        }
                    } else if (!Character.isLetterOrDigit(c)) {
                        bl = true;
                    }
                }
                if (bl) {
                    if (this.testcase != null) {
                        this.testcase.timeMillis = -1;
                        this.report.reportTest(this.testcase, Report.InfoSource.VERBOSE_MSG);
                        this.testcase = null;
                    }
                    ++this.executedOneSuiteTests;
                    if (this.expectedOneSuiteTests < this.executedOneSuiteTests) {
                        this.expectedOneSuiteTests = this.executedOneSuiteTests;
                    }
                    this.progressLogger.finest("test finished");
                    this.updateProgress();
                }
                return;
            }
            if (string5.equals("addFailure") || string5.equals("addError")) {
                int n2;
                String string9;
                String string10;
                if (this.testcase == null) {
                    return;
                }
                int n3 = string3.length() - 1;
                if (string3.charAt(n3) != ')') {
                    return;
                }
                String string11 = string3.substring(string5.length() + 1, n3);
                int n4 = string11.indexOf(44);
                String string12 = string10 = n4 == -1 ? string11 : string11.substring(0, n4);
                if (!string10.equals(this.testcase.name)) {
                    return;
                }
                this.testcase.trouble = new Report.Trouble(string5.equals("addError"));
                if (n4 != -1 && !(string9 = string11.substring(n2 = Character.isSpaceChar(string11.charAt(n4 + 1)) ? n4 + 2 : n4 + 1)).equals("null")) {
                    this.testcase.trouble.message = string9;
                }
            }
            return;
        }
        Matcher matcher = RegexpUtils.CLASSPATH_ARGS.matcher(string2);
        if (matcher.find()) {
            this.classpath = matcher.group(1);
        }
        if ((matcher = RegexpUtils.JAVA_EXECUTABLE.matcher(string2)).find() && (classPath = this.findPlatformSources(string = matcher.group(1))) != null) {
            this.platformSources = classPath;
        }
    }

    void messageLogged(AntEvent antEvent) {
        Object object;
        String string = antEvent.getMessage();
        if (string == null) {
            this.LOG.finer("NORMAL: <null>");
            return;
        }
        if (this.LOG.isLoggable(Level.FINER)) {
            this.LOG.finer("NORMAL: \"" + string + '\"');
        }
        if (this.progressLogger.isLoggable(Level.FINEST)) {
            this.progressLogger.finest("NORMAL:  " + string);
        }
        if (this.testListenerInfoAvailable && this.report != null && !this.report.isSuiteFinished() && this.testcase != null) {
            this.displayOutput(string, antEvent.getLogLevel() == 1);
            return;
        }
        if (this.waitingForIssueStatus) {
            assert (this.testcase != null);
            object = this.regexp.getTestcaseIssuePattern().matcher(string);
            if (((Matcher)object).matches()) {
                boolean bl = ((Matcher)object).group(1) == null;
                this.trouble = this.testcase.trouble = new Report.Trouble(bl);
                this.waitingForIssueStatus = false;
                return;
            }
            this.report.reportTest(this.testcase);
            this.waitingForIssueStatus = false;
        }
        if (this.xmlOutputBuffer != null) {
            this.xmlOutputBuffer.append(string).append('\n');
            if (string.equals("</testsuite>")) {
                this.closePreviousReport();
            }
            return;
        }
        if (this.readingSuiteOutputSummary) {
            if (string.startsWith("--------") && ((Matcher)(object = this.regexp.getOutputDelimPattern().matcher(string))).matches() && ((Matcher)object).group(1) == null) {
                this.readingSuiteOutputSummary = false;
            }
            return;
        }
        if (this.trouble != null) {
            if (this.troubleParser == null) {
                this.troubleParser = new TroubleParser(this.trouble, this.regexp);
            }
            if (this.troubleParser.processMessage(string)) {
                this.troubleParser = null;
                if (this.trouble.stackTrace != null && this.trouble.stackTrace.length != 0) {
                    this.report.setClasspathSourceRoots();
                }
                if (this.trouble.isFakeError()) {
                    this.trouble.error = false;
                    --this.report.errors;
                    ++this.report.failures;
                }
                this.report.reportTest(this.testcase);
                this.trouble = null;
                this.testcase = null;
            }
            return;
        }
        if (string.startsWith("Testcase: ")) {
            boolean bl;
            if (this.report == null) {
                return;
            }
            object = string.substring("Testcase: ".length());
            boolean bl2 = this.lastHeaderBrief ? this.tryParseBriefHeader((String)object) || !(this.lastHeaderBrief = !this.tryParsePlainHeader((String)object)) : (bl = this.tryParsePlainHeader((String)object) || (this.lastHeaderBrief = this.tryParseBriefHeader((String)object)));
            if (bl) {
                this.waitingForIssueStatus = !this.lastHeaderBrief;
            }
        } else if (string.startsWith("--------") && this.regexp.getOutputDelimPattern().matcher(string).matches()) {
            if (this.report == null) {
                return;
            }
            this.readingSuiteOutputSummary = true;
        } else if (this.expectXmlReport && string.startsWith("<?xml")) {
            object = this.regexp.getXmlDeclPattern().matcher(string.trim());
            if (((Matcher)object).matches()) {
                this.suiteStarted(null);
                this.xmlOutputBuffer = new StringBuilder(4096);
                this.xmlOutputBuffer.append(string);
            }
        } else if (string.startsWith("Testsuite: ")) {
            this.suiteName = string.substring("Testsuite: ".length());
            if (this.regexp.getFullJavaIdPattern().matcher(this.suiteName).matches()) {
                this.suiteStarted(this.suiteName);
                this.report.resultsDir = JUnitOutputReader.determineResultsDir(antEvent);
            }
        } else if (string.startsWith("Tests run: ")) {
            if (this.report == null) {
                return;
            }
            if (this.testsuiteStatsKnown) {
                return;
            }
            object = this.regexp.getSuiteStatsPattern().matcher(string);
            if (((Matcher)object).matches()) {
                block40: {
                    assert (this.report != null);
                    this.report.markSuiteFinished();
                    try {
                        this.report.totalTests = Integer.parseInt(((Matcher)object).group(1));
                        this.report.failures = Integer.parseInt(((Matcher)object).group(2));
                        this.report.errors = Integer.parseInt(((Matcher)object).group(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block40;
                        throw new AssertionError();
                    }
                }
                this.report.elapsedTimeMillis = this.parseTime(((Matcher)object).group(4));
            }
            this.testsuiteStatsKnown = true;
        } else if (this.suiteName != null && string.startsWith("Test ") && string.endsWith(" FAILED") && string.equals("Test " + this.suiteName + " FAILED")) {
            this.suiteName = null;
        } else if (!this.testListenerInfoAvailable) {
            this.displayOutput(string, antEvent.getLogLevel() == 1);
        }
    }

    private int parseTime(String string) {
        int n;
        try {
            double d = this.numberFormat.parse(string).doubleValue();
            n = Math.round((float)(d * 1000.0));
        }
        catch (ParseException parseException) {
            n = -1;
        }
        return n;
    }

    private static File determineResultsDir(AntEvent antEvent) {
        File file = null;
        String string = antEvent.getTaskName();
        if (string != null) {
            if (string.equals("junit")) {
                file = JUnitOutputReader.determineJunitTaskResultsDir(antEvent);
            } else if (string.equals("java")) {
                file = JUnitOutputReader.determineJavaTaskResultsDir(antEvent);
            }
        }
        if (file != null && file.exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    private static File determineJunitTaskResultsDir(AntEvent antEvent) {
        TaskStructure taskStructure = antEvent.getTaskStructure();
        if (taskStructure == null) {
            return null;
        }
        String string = null;
        boolean bl = false;
        for (TaskStructure taskStructure2 : taskStructure.getChildren()) {
            String string2;
            String string3;
            String string4 = taskStructure2.getName();
            if (string4.equals("batchtest") || string4.equals("test")) {
                string = taskStructure2.getAttribute("todir");
                continue;
            }
            if (!string4.equals("formatter") || bl || (string3 = taskStructure2.getAttribute("type")) == null || !"xml".equals(antEvent.evaluate(string3)) || (string2 = taskStructure2.getAttribute("usefile")) != null && !AntProject.toBoolean(antEvent.evaluate(string2))) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        File file = JUnitOutputReader.getFile(string, antEvent);
        return JUnitOutputReader.findAbsolutePath(file, taskStructure, antEvent);
    }

    private static File determineJavaTaskResultsDir(AntEvent antEvent) {
        TaskStructure taskStructure = antEvent.getTaskStructure();
        if (taskStructure == null) {
            return null;
        }
        String string = null;
        for (TaskStructure taskStructure2 : taskStructure.getChildren()) {
            String string2;
            int n;
            String string3 = taskStructure2.getName();
            if (!string3.equals("arg")) continue;
            String string4 = taskStructure2.getAttribute("value");
            if (string4 == null) {
                string4 = taskStructure2.getAttribute("line");
            }
            if (string4 == null || !(string4 = antEvent.evaluate(string4)).startsWith("formatter=") || (n = (string2 = string4.substring("formatter=".length())).indexOf(44)) == -1 || !string2.substring(0, n).equals(XML_FORMATTER_CLASS_NAME)) continue;
            String string5 = string2.substring(n + 1);
            int n2 = string5.lastIndexOf(File.separatorChar);
            if (n2 != -1) {
                string = string5.substring(0, n2);
                if (string.length() != 0) continue;
                string = null;
                continue;
            }
            string = ".";
        }
        if (string == null) {
            return null;
        }
        File file = string != "." ? new File(string) : null;
        return JUnitOutputReader.findAbsolutePath(file, taskStructure, antEvent);
    }

    private static File findAbsolutePath(File file, TaskStructure taskStructure, AntEvent antEvent) {
        String string;
        if (JUnitOutputReader.isAbsolute(file)) {
            return file;
        }
        String string2 = taskStructure.getAttribute("fork");
        if (string2 != null && AntProject.toBoolean(antEvent.evaluate(string2)) && JUnitOutputReader.isAbsolute(file = JUnitOutputReader.combine(JUnitOutputReader.getFile(string = taskStructure.getAttribute("dir"), antEvent), file))) {
            return file;
        }
        return JUnitOutputReader.combine(JUnitOutputReader.getBaseDir(antEvent), file);
    }

    private static File combine(File file, File file2) {
        if (file2 == null) {
            return file;
        }
        if (file == null) {
            return file2;
        }
        return new File(file, file2.getPath());
    }

    private static boolean isAbsolute(File file) {
        return file != null && file.isAbsolute();
    }

    private static File getFile(String string, AntEvent antEvent) {
        return string != null ? new File(antEvent.evaluate(string)) : null;
    }

    private static File getBaseDir(AntEvent antEvent) {
        return new File(antEvent.getProperty("basedir"));
    }

    private Report createReport(String string) {
        Report report = new Report(string);
        report.antScript = this.antScript;
        report.classpath = this.classpath;
        report.platformSources = this.platformSources;
        this.classpath = null;
        this.platformSources = null;
        return report;
    }

    private ClassPath findPlatformSources(String string) {
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            File file;
            FileObject fileObject = javaPlatformArray[i].findTool("java");
            if (fileObject == null || !(file = FileUtil.toFile((FileObject)fileObject)).getAbsolutePath().startsWith(string)) continue;
            return javaPlatformArray[i].getSourceFolders();
        }
        return null;
    }

    void testTaskStarted(int n, boolean bl) {
        boolean bl2;
        if (this.progressLogger.isLoggable(Level.FINER)) {
            this.progressLogger.finer("EXPECTED # OF SUITES: " + n);
        }
        this.expectXmlReport = bl;
        boolean bl3 = bl2 = n > 0;
        if (this.progressHandle == null) {
            this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"MSG_ProgressMessage"));
            if (bl2) {
                this.expectedSuitesCount = n;
                this.progressHandle.start(32700);
                this.progressHandle.progress(327);
                this.lastProgress = 327;
            } else {
                this.progressHandle.start();
            }
        } else if (bl2) {
            if (!this.isDeterminateProgress) {
                this.progressHandle.switchToDeterminate(32700);
            }
            if (this.progressLogger.isLoggable(Level.FINER)) {
                this.progressLogger.finer("                    - total # of suites: " + (this.expectedSuitesCount + n));
            }
            this.expectedSuitesCount += n;
            this.expectedOneSuiteTests = 0;
            this.executedOneSuiteTests = 0;
            this.updateProgress();
        } else if (this.isDeterminateProgress) {
            this.progressHandle.switchToIndeterminate();
            this.lastProgress = 0;
        }
        this.isDeterminateProgress = bl2;
        this.manager.testStarted(this.session, this.sessionType);
    }

    void testTaskFinished() {
        this.closePreviousReport();
        this.progressLogger.finer("ACTUAL # OF SUITES: " + this.executedSuitesCount);
        this.expectedSuitesCount = this.executedSuitesCount;
        if (this.isDeterminateProgress) {
            this.progressHandle.progress(32700);
        }
    }

    private void updateProgress() {
        this.updateProgress(null);
    }

    private void updateProgress(String string) {
        assert (this.progressHandle != null);
        int n = this.getProcessedWorkunits();
        if (this.progressLogger.isLoggable(Level.FINER)) {
            this.progressLogger.finer("------ Progress: " + String.format("%3d%%", 100 * n / 32700));
        }
        if (n < 327) {
            n = 327;
        }
        if (n != this.lastProgress) {
            if (n < this.lastProgress) {
                this.progressHandle.switchToIndeterminate();
                this.progressHandle.switchToDeterminate(32700);
            }
            this.lastProgress = n;
            if (string != null) {
                this.progressHandle.progress(string, n);
            } else {
                this.progressHandle.progress(n);
            }
        } else if (string != null) {
            this.progressHandle.progress(string);
        }
    }

    private String getProgressStepMessage(String string) {
        String string2;
        if (this.isDeterminateProgress) {
            Object[] objectArray;
            MessageFormat messageFormat;
            if (string != null) {
                if (this.progressStepFormatSuiteName == null) {
                    this.progressStepFormatSuiteName = new MessageFormat(NbBundle.getMessage(this.getClass(), (String)"MSG_ProgressStepMessage"));
                }
                messageFormat = this.progressStepFormatSuiteName;
                objectArray = new Object[]{string, this.executedSuitesCount + 1, this.expectedSuitesCount};
            } else {
                if (this.progressStepFormatAnonymous == null) {
                    this.progressStepFormatAnonymous = new MessageFormat(NbBundle.getMessage(this.getClass(), (String)"MSG_ProgressStepMessageAnonymous"));
                }
                messageFormat = this.progressStepFormatAnonymous;
                objectArray = new Object[]{this.executedSuitesCount + 1, this.expectedSuitesCount};
            }
            string2 = messageFormat.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
        } else {
            string2 = string != null ? string : "";
        }
        return string2;
    }

    private int getProcessedWorkunits() {
        try {
            if (this.progressLogger.isLoggable(Level.FINEST)) {
                this.progressLogger.finest("--- Suites: " + this.executedSuitesCount + " / " + this.expectedSuitesCount);
                this.progressLogger.finest("--- Tests:  " + this.executedOneSuiteTests + " / " + this.expectedOneSuiteTests);
            }
            int n = this.executedSuitesCount * 32700 / this.expectedSuitesCount;
            if (this.expectedOneSuiteTests > 0) {
                n += this.executedOneSuiteTests * 32700 / (this.expectedSuitesCount * this.expectedOneSuiteTests);
            }
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildFinished(AntEvent antEvent) {
        try {
            this.buildFinished(antEvent.getException());
            if (this.report != null) {
                this.closePreviousReport(true);
            }
            this.manager.sessionFinished(this.session, this.sessionType);
        }
        finally {
            this.progressHandle.finish();
        }
    }

    private Report suiteStarted(String string) {
        this.closePreviousReport();
        this.report = this.createReport(string);
        String string2 = this.getProgressStepMessage(string);
        this.expectedOneSuiteTests = 0;
        this.executedOneSuiteTests = 0;
        if (this.expectedSuitesCount <= this.executedSuitesCount) {
            this.expectedSuitesCount = this.executedSuitesCount + 1;
        }
        if (this.executedSuitesCount != 0) {
            this.updateProgress(string2);
        } else {
            this.progressHandle.progress(string2);
        }
        this.manager.displaySuiteRunning(this.session, this.sessionType, string);
        return this.report;
    }

    private void suiteFinished(Report report, boolean bl) {
        if (this.progressLogger.isLoggable(Level.FINER)) {
            this.progressLogger.finer("actual # of tests in a suite: " + this.executedOneSuiteTests);
        }
        ++this.executedSuitesCount;
        this.manager.displayReport(this.session, this.sessionType, report);
    }

    private void buildFinished(Throwable throwable) {
    }

    private void displayOutput(String string, boolean bl) {
        this.manager.displayOutput(this.session, this.sessionType, string, bl);
    }

    private boolean tryParsePlainHeader(String string) {
        assert (this.report != null);
        Matcher matcher = this.regexp.getTestcaseHeaderPlainPattern().matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            this.testcase = this.report.findTest(string2);
            this.testcase.className = null;
            this.testcase.timeMillis = this.parseTime(string3);
            this.trouble = null;
            this.troubleParser = null;
            return true;
        }
        return false;
    }

    private boolean tryParseBriefHeader(String string) {
        assert (this.report != null);
        Matcher matcher = this.regexp.getTestcaseHeaderBriefPattern().matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            boolean bl = matcher.group(3) == null;
            this.testcase = this.report.findTest(string2);
            this.testcase.className = string3;
            this.testcase.timeMillis = -1;
            this.trouble = this.testcase.trouble = new Report.Trouble(bl);
            return true;
        }
        return false;
    }

    private void closePreviousReport() {
        this.closePreviousReport(false);
    }

    private void closePreviousReport(boolean bl) {
        if (this.xmlOutputBuffer != null) {
            try {
                String string = this.xmlOutputBuffer.toString();
                this.xmlOutputBuffer = null;
                Report report = XmlOutputParser.parseXmlOutput(new StringReader(string));
                this.report.update(report);
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                assert (false);
            }
        } else if (this.report != null) {
            if (bl) {
                if (this.testcase != null) {
                    this.report.reportTest(this.testcase, Report.InfoSource.VERBOSE_MSG);
                    this.testcase = null;
                }
            } else {
                Report report;
                File file;
                if (this.waitingForIssueStatus) {
                    assert (this.testcase != null);
                    this.report.reportTest(this.testcase);
                }
                if (this.report.resultsDir != null && (file = this.findReportFile()) != null && this.isValidReportFile(file) && (report = JUnitOutputReader.parseReportFile(file)) != null) {
                    this.report.update(report);
                }
            }
            this.suiteFinished(this.report, bl);
        }
        this.xmlOutputBuffer = null;
        this.readingSuiteOutputSummary = false;
        this.testcase = null;
        this.trouble = null;
        this.troubleParser = null;
        this.report = null;
        this.testsuiteStatsKnown = false;
    }

    private File findReportFile() {
        File file = new File(this.report.resultsDir, "TEST-" + this.report.suiteClassName + ".xml");
        return file.isFile() ? file : null;
    }

    private boolean isValidReportFile(File file) {
        Level level;
        if (!file.canRead()) {
            return false;
        }
        long l = file.lastModified();
        long l2 = l - this.timeOfSessionStart;
        Logger logger = Logger.getLogger("org.netbeans.modules.junit.outputreader.timestamps");
        if (logger.isLoggable(level = Level.FINER)) {
            logger.log(level, "Report file: " + file.getPath());
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(this.timeOfSessionStart);
            logger.log(level, "Session start:    " + String.format("%1$tT.%2$03d", gregorianCalendar, gregorianCalendar.get(14)));
            gregorianCalendar.setTimeInMillis(l);
            logger.log(level, "Report timestamp: " + String.format("%1$tT.%2$03d", gregorianCalendar, gregorianCalendar.get(14)));
        }
        if (l2 >= 0L) {
            return true;
        }
        return -l2 <= this.timeOfSessionStart % 1000L;
    }

    private static Report parseReportFile(File file) {
        Report report;
        block6: {
            long l = file.length();
            if (l < 0L || l > 0x400000L) {
                return null;
            }
            report = null;
            try {
                report = XmlOutputParser.parseXmlOutput(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                report.markSuiteFinished();
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                assert (false);
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                int n = 1;
                ErrorManager errorManager = ErrorManager.getDefault();
                if (!errorManager.isLoggable(n)) break block6;
                errorManager.notify(n, errorManager.annotate((Throwable)iOException, "I/O exception while reading JUnit XML report file from JUnit: "));
            }
        }
        return report;
    }

    private static int parseNonNegativeInteger(String string) throws NumberFormatException {
        int n = string.length();
        if (n == 0 || n > 8) {
            throw new NumberFormatException();
        }
        char c = string.charAt(0);
        if (c < '0' || c > '9') {
            throw new NumberFormatException();
        }
        int n2 = c - 48;
        if (n > 1) {
            for (char c2 : string.substring(1).toCharArray()) {
                if (c2 < '0' || c2 > '9') {
                    throw new NumberFormatException();
                }
                n2 = 10 * n2 + (c2 - 48);
            }
        }
        return n2;
    }
}

